/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.internal.PluginProviderFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.ScriptImplementFactory;
import kd.sdk.kingscript.types.AlwaysHasExecutableMemberProxyObject;
import kd.sdk.kingscript.types.MapMemberProxyObject;
import kd.sdk.kingscript.types.ScriptExecutable;
import kd.sdk.kingscript.types.ScriptValue;

public final class ScriptExtensionFactory {
    private static Log log = LogFactory.getLog(ScriptExtensionFactory.class);

    public static Object ofKingScriptDeclared(String caseName, Supplier<KingScriptEngine> engineSupplier) {
        List<MixtureProxy> mixtureProxyList = ScriptExtensionFactory.createMixtureProxyList(caseName, engineSupplier);
        if (mixtureProxyList.isEmpty()) {
            return AlwaysHasExecutableMemberProxyObject.INSTANCE;
        }
        ScriptValue sv = mixtureProxyList.get(0).getCachedMixture();
        if (mixtureProxyList.size() == 1) {
            return new MapMemberProxyObject(sv.toMap());
        }
        HashMap<String, ScriptExecutable> combined = new HashMap<String, ScriptExecutable>(sv.getMemberKeys().size());
        for (String key : sv.getMemberKeys()) {
            combined.put(key, arguments -> {
                ScriptValue ret = null;
                for (MixtureProxy plugin : mixtureProxyList) {
                    ret = plugin.getCachedMixture().getMember(key).execute((Object[])arguments);
                }
                return ret;
            });
        }
        return new MapMemberProxyObject(combined);
    }

    private static List<MixtureProxy> createMixtureProxyList(String caseName, Supplier<KingScriptEngine> engineSupplier) {
        List<Class<?>> pluginClasses = PluginProviderFactory.getPluginProvider().getPluginClasses(caseName, null);
        ArrayList<MixtureProxy> mixtureProxyList = new ArrayList<MixtureProxy>(pluginClasses.size());
        for (Class<?> cls : pluginClasses) {
            try {
                MixtureProxy mixtureProxy = (MixtureProxy)ScriptImplementFactory.newInstance(cls, (String)"ext", scriptPath -> ScriptExtensionFactory.getEngineAutoDebugWithDefaultNonDebugEngine(scriptPath, engineSupplier)).getKey();
                mixtureProxyList.add(mixtureProxy);
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
        return mixtureProxyList;
    }

    private static KingScriptEngine getEngineAutoDebugWithDefaultNonDebugEngine(String scriptPath, Supplier<KingScriptEngine> defaultNonDebugEngine) {
        try {
            Method getEngineAutoDebugWithDefaultNonDebugEngine = Class.forName("kd.sdk.bos.launch.ProjectInitializer").getMethod("getEngineAutoDebugWithDefaultNonDebugEngine", String.class, Supplier.class);
            return (KingScriptEngine)getEngineAutoDebugWithDefaultNonDebugEngine.invoke(null, scriptPath, defaultNonDebugEngine);
        }
        catch (Throwable e) {
            ScriptExtensionFactory.dealException("getEngineAutoDebugWithDefaultNonDebugEngine", e, true);
            return null;
        }
    }

    private static void dealException(String action, Throwable e, boolean throwIt) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        log.error(String.format("KingScript engine " + action + " error: %s", ScriptExtensionFactory.getExceptionStackTraceMessage(e)));
        if (e instanceof ScriptException) {
            throw (ScriptException)e;
        }
        throw new KDException(e, BosErrorCode.bOS, new Object[]{String.format("KingScript engine " + action + " error: %s", e.getMessage())});
    }

    private static String getExceptionStackTraceMessage(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

