/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class EntityOperateTypes {
    private static final Map<String, String> types = new HashMap<String, String>();

    public static void register(String type, String className) {
        types.put(type, className);
    }

    public static IEntityOperateService createEntityOperate(String operateKey) {
        String typeName = types.get(operateKey);
        if (typeName == null || StringUtils.isBlank((CharSequence)typeName)) {
            OperationType opType = OperationTypeCache.LoadSingle((String)operateKey);
            if (opType == null || StringUtils.isBlank((CharSequence)opType.getOpServiceClass())) {
                throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{String.format(ResManager.loadKDString((String)"%s \u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u4f53\u670d\u52a1\u5b9e\u73b0\u7c7b\uff01", (String)"EntityOperateTypes_0", (String)"bos-mservice-operation", (Object[])new Object[0]), operateKey)});
            }
            EntityOperateTypes.register(operateKey, opType.getOpServiceClass());
            typeName = types.get(operateKey);
        }
        Class cls = TypesContainer.getOrRegister((String)typeName);
        IEntityOperateService op = (IEntityOperateService)TypesContainer.createInstance((Class)cls);
        return op;
    }

    static {
        types.put("draft", "kd.bos.service.operation.Draft");
        types.put("enable", "kd.bos.service.operation.Enable");
        types.put("disable", "kd.bos.service.operation.Disable");
        types.put("save", "kd.bos.service.operation.Save");
        types.put("saveandnew", "kd.bos.service.operation.SaveAndNew");
        types.put("submit", "kd.bos.service.operation.Submit");
        types.put("unsubmit", "kd.bos.service.operation.UnSubmit");
        types.put("audit", "kd.bos.service.operation.Audit");
        types.put("unaudit", "kd.bos.service.operation.UnAudit");
        types.put("load", "kd.bos.service.operation.Load");
        types.put("delete", "kd.bos.service.operation.Delete");
        types.put("statusconvert", "kd.bos.service.operation.StatusConvert");
        types.put("donothing", "kd.bos.service.operation.Donothing");
        types.put("submitandnew", "kd.bos.service.operation.SubmitAndNew");
        types.put("invalid", "kd.bos.service.operation.Invalid");
        types.put("valid", "kd.bos.service.operation.Valid");
        types.put("pushandsave", "kd.bos.service.operation.PushAndSave");
        types.put("deleteentry", "kd.bos.service.operation.DeleteEntry");
    }
}

