/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IModifierProperty;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.service.operation.StatusConvertOperateService;

public class RowStatusConvert
extends StatusConvertOperateService {
    private Set<String> validEntityKeys = new HashSet<String>();
    private ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
    private Set<String> selectedRowIds = new HashSet<String>();
    private List<ExtendedDataEntity> validExtendedDataRows = new ArrayList<ExtendedDataEntity>();

    @Override
    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntites) {
        String str;
        super.initialize(entityType, operationKey, dataEntites);
        Map parameter = (Map)this.operateMetaMap.get("parameter");
        if (parameter != null) {
            String val;
            this.statusFieldKey = (String)parameter.get("statusProp");
            if (StringUtils.isNotBlank((CharSequence)this.statusFieldKey)) {
                this.statusProperty = (BillStatusProp)this.billEntityType.findProperty(this.statusFieldKey);
            }
            if (StringUtils.isNotBlank((CharSequence)(val = (String)parameter.get("value")))) {
                this.billStatus = val;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(str = this.getOption().getVariableValue("bos_listselectedrowcollection", "")))) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)str, ListSelectedRowCollection.class);
            this.selectedRows.addAll((Collection)rows);
        }
        this.validEntityKeys.clear();
        this.validEntityKeys.add(this.getBillEntityType().getName());
        if (this.statusProperty != null) {
            if (this.statusProperty.getParent() instanceof SubEntryType) {
                this.validEntityKeys.add(this.statusProperty.getParent().getParent().getName());
                this.validEntityKeys.add(this.statusProperty.getParent().getName());
            } else if (this.statusProperty.getParent() instanceof EntryType) {
                this.validEntityKeys.add(this.statusProperty.getParent().getName());
            }
        }
        for (ListSelectedRow row : this.selectedRows) {
            Object[] entryId = this.getSelectedRowId(row);
            this.selectedRowIds.add(StringUtils.join((Object[])entryId, (String)","));
        }
    }

    @Override
    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        Map entityMap = this.billEntityType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            IModifyTimeProperty modifyTimeProperty;
            EntityType type = (EntityType)entry.getValue();
            IModifierProperty modifierProperty = type.getModifierProperty();
            if (modifierProperty != null) {
                fieldKeys.add(modifierProperty.getName());
            }
            if ((modifyTimeProperty = type.getModifyTimeProperty()) == null) continue;
            fieldKeys.add(modifyTimeProperty.getName());
        }
    }

    @Override
    protected void addValidExtendedDataRows(List<ExtendedDataEntity> validExtendedDataRows) {
        ExtendedDataEntity[] rows;
        if (this.statusProperty == null) {
            super.addValidExtendedDataRows(validExtendedDataRows);
            return;
        }
        this.validExtendedDataRows.clear();
        EntityType entityType = (EntityType)this.statusProperty.getParent();
        HashSet<String> errRowIndexs = new HashSet<String>();
        ValidateResultCollection validateResultCollection = this.getOperationResult().getValidateResult();
        int resultCount = validateResultCollection.getValidateErrors().size();
        for (int i = resultCount - 1; i >= 0; --i) {
            ValidateResult validateResult = (ValidateResult)validateResultCollection.getValidateErrors().get(i);
            int errorCount = validateResult.getAllErrorInfo().size();
            for (int j = errorCount - 1; j >= 0; --j) {
                OperateErrorInfo errorInfo = (OperateErrorInfo)validateResult.getAllErrorInfo().get(j);
                if (!this.isSelectedRow(entityType, errorInfo, this.selectedRowIds)) {
                    validateResult.getAllErrorInfo().remove(j);
                    continue;
                }
                Object[] indexs = this.getErrorRowIndex(errorInfo);
                String str = StringUtils.join((Object[])indexs, (String)",");
                errRowIndexs.add(str);
            }
            if (!validateResult.getAllErrorInfo().isEmpty()) continue;
            validateResultCollection.getValidateErrors().remove(i);
        }
        if (validateResultCollection.getValidateErrors().isEmpty()) {
            this.getOperationResult().setSuccess(true);
            this.getOperationResult().setMessage(null);
        }
        for (ExtendedDataEntity row : rows = this.getExtendDataEntitySet().FindByEntityKey(entityType.getName())) {
            if (!this.isSelectedRow(entityType, row, this.selectedRowIds) || !this.isValidRow(entityType, row, errRowIndexs)) continue;
            this.validExtendedDataRows.add(row);
        }
        validExtendedDataRows.addAll(this.validExtendedDataRows);
    }

    @Override
    protected DynamicObject[] getSuccessObjs(List<ExtendedDataEntity> validExtendedDataRows) {
        HashSet<Integer> dataIndexs = new HashSet<Integer>(validExtendedDataRows.size());
        for (ExtendedDataEntity row : validExtendedDataRows) {
            dataIndexs.add(row.getDataEntityIndex());
        }
        ExtendedDataEntity[] headExtendDataEntitys = this.getExtendDataEntitySet().FindByEntityKey(this.getBillEntityType().getName());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (ExtendedDataEntity dataEntity : headExtendDataEntitys) {
            if (!dataIndexs.contains(dataEntity.getDataEntityIndex())) continue;
            list.add(dataEntity.getDataEntity());
        }
        DynamicObject[] successObjs = new DynamicObject[list.size()];
        successObjs = list.toArray(successObjs);
        return successObjs;
    }

    @Override
    protected void updateBillStatus(DynamicObject[] dataEntities) {
        String newStatusValue = this.billStatus;
        if (StringUtils.isBlank((CharSequence)this.statusFieldKey) || this.statusProperty == null || StringUtils.isBlank((CharSequence)newStatusValue)) {
            return;
        }
        if (this.validExtendedDataRows.isEmpty()) {
            return;
        }
        DynamicObject[] rows = new DynamicObject[this.validExtendedDataRows.size()];
        for (int i = 0; i < this.validExtendedDataRows.size(); ++i) {
            rows[i] = this.validExtendedDataRows.get(i).getDataEntity();
        }
        this.setStatus(rows, newStatusValue);
        this.setOperator(rows, newStatusValue);
    }

    private boolean isSelectedRow(EntityType entityType, OperateErrorInfo errorInfo, Set<String> selectedRowIds) {
        if (selectedRowIds.isEmpty()) {
            return true;
        }
        Object errEntityType = null;
        for (errEntityType = StringUtils.isBlank((CharSequence)errorInfo.getEntityKey()) || StringUtils.equalsIgnoreCase((CharSequence)errorInfo.getEntityKey(), (CharSequence)this.getBillEntityType().getName()) ? this.getBillEntityType() : (EntityType)this.getBillEntityType().getAllEntities().get(errorInfo.getEntityKey()); errEntityType != null && !this.validEntityKeys.contains(errEntityType.getName()); errEntityType = (EntityType)errEntityType.getParent()) {
        }
        if (errEntityType == null) {
            return true;
        }
        ExtendedDataEntity row = this.getErrorRow((EntityType)errEntityType, errorInfo);
        return this.isSelectedRow((EntityType)errEntityType, row, selectedRowIds);
    }

    private boolean isSelectedRow(EntityType entityType, ExtendedDataEntity row, Set<String> selectedRowIds) {
        Object[] detailIds;
        if (selectedRowIds.isEmpty()) {
            return true;
        }
        Object id = null;
        Object entryId = null;
        Object detailId = null;
        String joinIds = "";
        if (entityType instanceof SubEntryType) {
            DynamicObject entryRow = (DynamicObject)row.getDataEntity().getParent();
            DynamicObject billObj = (DynamicObject)entryRow.getParent();
            id = billObj.getPkValue();
            entryId = entryRow.getPkValue();
            detailId = row.getDataEntity().getPkValue();
            joinIds = String.format("%s,%s,%s", id, entryId, detailId);
        } else if (entityType instanceof EntryType) {
            DynamicObject billObj = (DynamicObject)row.getDataEntity().getParent();
            id = billObj.getPkValue();
            entryId = row.getDataEntity().getPkValue();
            joinIds = String.format("%s,%s", id, entryId);
        } else {
            id = row.getBillPkId();
            joinIds = String.valueOf(id);
        }
        if (selectedRowIds.contains(String.valueOf(id))) {
            return true;
        }
        Object[] entryIds = new Object[]{id, entryId};
        if (selectedRowIds.contains(StringUtils.join((Object[])entryIds, (String)","))) {
            return true;
        }
        if (entryId != null && detailId != null && selectedRowIds.contains(StringUtils.join((Object[])(detailIds = new Object[]{id, entryId, detailId}), (String)","))) {
            return true;
        }
        for (String selectedRowId : selectedRowIds) {
            if (selectedRowId.indexOf(joinIds) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isValidRow(EntityType entityType, ExtendedDataEntity row, Set<String> errRowIndexs) {
        if (errRowIndexs.isEmpty()) {
            return true;
        }
        int dataIndex = row.getDataEntityIndex();
        if (errRowIndexs.contains(String.valueOf(dataIndex))) {
            return false;
        }
        int rowIndex = row.getRowIndex();
        int subRowIndex = row.getSubRowIndex();
        Object[] rowIndexs = new Object[]{dataIndex, rowIndex};
        if (errRowIndexs.contains(StringUtils.join((Object[])rowIndexs, (String)","))) {
            return false;
        }
        Object[] subRowIndexs = new Object[]{dataIndex, rowIndex, subRowIndex};
        return !errRowIndexs.contains(StringUtils.join((Object[])subRowIndexs, (String)","));
    }

    private ExtendedDataEntity getErrorRow(EntityType errEntityType, OperateErrorInfo errorInfo) {
        ExtendedDataEntity[] rows;
        for (ExtendedDataEntity row : rows = this.getExtendDataEntitySet().FindByEntityKey(errEntityType.getName())) {
            if (!(errEntityType instanceof MainEntityType ? errorInfo.getDataEntityIndex() == row.getDataEntityIndex() : (errEntityType instanceof SubEntryType ? errorInfo.getDataEntityIndex() == row.getDataEntityIndex() && errorInfo.getRowIndex() == row.getRowIndex() && errorInfo.getSubRowIndex() == row.getSubRowIndex() : errEntityType instanceof EntryType && errorInfo.getDataEntityIndex() == row.getDataEntityIndex() && errorInfo.getRowIndex() == row.getRowIndex()))) continue;
            return row;
        }
        return null;
    }

    private Object[] getSelectedRowId(ListSelectedRow row) {
        if (StringUtils.isBlank((CharSequence)row.getEntryEntityKey())) {
            return new Object[]{row.getPrimaryKeyValue()};
        }
        EntityType entityType = null;
        for (entityType = StringUtils.isNotBlank((CharSequence)row.getSubEntryEntityKey()) ? (EntityType)this.getBillEntityType().getAllEntities().get(row.getSubEntryEntityKey()) : (EntityType)this.getBillEntityType().getAllEntities().get(row.getEntryEntityKey()); entityType != null && !this.validEntityKeys.contains(entityType.getName()); entityType = (EntityType)entityType.getParent()) {
        }
        if (entityType == null || entityType instanceof MainEntityType) {
            return new Object[]{row.getPrimaryKeyValue()};
        }
        if (entityType instanceof SubEntryType) {
            return new Object[]{row.getPrimaryKeyValue(), row.getEntryPrimaryKeyValue(), row.getSubEntryPrimaryKeyValue()};
        }
        return new Object[]{row.getPrimaryKeyValue(), row.getEntryPrimaryKeyValue()};
    }

    private Object[] getErrorRowIndex(OperateErrorInfo errorInfo) {
        if (errorInfo == null || errorInfo.getLevel() == null || errorInfo.getLevel() == ErrorLevel.Warning) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)errorInfo.getEntityKey()) || StringUtils.equalsIgnoreCase((CharSequence)errorInfo.getEntityKey(), (CharSequence)this.getBillEntityType().getName())) {
            return new Object[]{errorInfo.getDataEntityIndex()};
        }
        EntityType entityType = (EntityType)this.getBillEntityType().getAllEntities().get(errorInfo.getEntityKey());
        if (entityType == null || entityType instanceof MainEntityType) {
            return new Object[]{errorInfo.getDataEntityIndex()};
        }
        while (entityType != null && !this.validEntityKeys.contains(entityType.getName())) {
            entityType = (EntityType)entityType.getParent();
        }
        if (entityType == null || entityType instanceof MainEntityType) {
            return new Object[]{errorInfo.getDataEntityIndex()};
        }
        if (entityType instanceof SubEntryType) {
            return new Object[]{errorInfo.getDataEntityIndex(), errorInfo.getRowIndex(), errorInfo.getSubRowIndex()};
        }
        return new Object[]{errorInfo.getDataEntityIndex(), errorInfo.getRowIndex()};
    }
}

