/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.service.operation.StatusConvertOperateService;
import kd.bos.service.operation.plugin.MasterIdSetValuePlugin;
import kd.bos.service.operation.plugin.MulilangTextSetValuePlugin;
import kd.bos.service.operation.plugin.UpdateEntrySummaryPlugin;
import kd.bos.service.operation.validate.DataVersionChangeValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class Submit
extends StatusConvertOperateService {
    private static Log log = LogFactory.getLog(Submit.class);
    private DataVersionChangeValidator validator;

    @Override
    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntites) {
        if (entityType instanceof BillEntityType) {
            super.initialize(entityType, operationKey, dataEntites);
            if (this.statusProperty != null && dataEntites != null && dataEntites.length > 0 && dataEntites[0].getDataEntityType().getProperties().containsKey((Object)this.statusProperty.getName())) {
                HashMap<Object, DynamicObject> pkMapping = new HashMap<Object, DynamicObject>();
                for (DynamicObject obj : dataEntites) {
                    boolean isNull;
                    ISimpleProperty primaryKey;
                    if (ObjectUtils.isEmpty((Object)obj) || ObjectUtils.isEmpty((Object)obj.getPkValue()) || !((primaryKey = obj.getDataEntityType().getPrimaryKey()) instanceof PKFieldProp) || (isNull = ((PKFieldProp)primaryKey).getValueComparator().compareValue(obj.getPkValue()))) continue;
                    pkMapping.put(obj.getPkValue(), obj);
                }
                String pkPropName = dataEntites[0].getDataEntityType().getPrimaryKey().getName();
                if (pkMapping.size() > 0) {
                    DynamicObject[] fromDb;
                    QFilter[] filters = new QFilter[]{new QFilter(pkPropName, "in", (Object)pkMapping.keySet().toArray())};
                    for (DynamicObject dbData : fromDb = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)(pkPropName + "," + this.statusProperty.getName()), (QFilter[])filters)) {
                        this.statusProperty.setValue(pkMapping.get(dbData.getPkValue()), this.statusProperty.getValue((Object)dbData));
                    }
                }
            }
        }
        if (entityType instanceof BasedataEntityType) {
            MasterIdSetValuePlugin plugin = new MasterIdSetValuePlugin();
            plugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)plugin);
        }
        RefObject opValue = new RefObject();
        this.getOption().tryGetVariableValue("mulilangtext.emptyfill.enable", opValue);
        if (Boolean.parseBoolean((String)opValue.getValue())) {
            MulilangTextSetValuePlugin langPlugin = new MulilangTextSetValuePlugin();
            langPlugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)langPlugin);
        }
        boolean updateEntrySummaryEnable = Boolean.parseBoolean(this.getOption().getVariableValue("updateEntrySummaryEnable", String.valueOf(false)));
        if (entityType instanceof BillEntityType && updateEntrySummaryEnable) {
            UpdateEntrySummaryPlugin updateSummaryPlugin = new UpdateEntrySummaryPlugin();
            updateSummaryPlugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)updateSummaryPlugin);
        }
    }

    @Override
    protected void preparePropertys(Object[] ids, List<String> fieldKeys) {
        super.preparePropertys(ids, fieldKeys);
    }

    @Override
    protected void addDefaultValidator(List<AbstractValidator> validators) {
        Object checkVersion;
        super.addDefaultValidator(validators);
        Object params = this.operateMetaMap.get("parameter");
        if (params instanceof Map && (checkVersion = ((Map)params).get("checkFormDataVersion")) instanceof Boolean && ((Boolean)checkVersion).booleanValue()) {
            String operateType = (String)this.operateMetaMap.get("type");
            DataVersionChangeValidator changedValidator = new DataVersionChangeValidator();
            changedValidator.setEntityKey(this.billEntityType.getName());
            changedValidator.setOperateKey(this.operationKey);
            changedValidator.setOperationName(this.getOpName());
            changedValidator.setOperateType(operateType);
            validators.add(changedValidator);
            this.validator = changedValidator;
        }
    }

    @Override
    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        DBRoute rt = new DBRoute(this.getBillEntityType().getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])objs, (IDataEntityType)this.subEntityType);
        super.beforeCallOperationTransaction(objs);
    }

    @Override
    protected void afterUpdateBillStatus(DynamicObject[] objs) {
        super.afterUpdateBillStatus(objs);
    }

    @Override
    protected void executeOperate(DynamicObject[] objs) {
        super.executeOperate(objs);
    }

    @Override
    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] objects = super.callOperation(objs);
        return objects;
    }

    @Override
    protected OperationResult getSubOpResult(Map<String, Object> operateMetaMap, DynamicObject[] dataEntities) {
        if (this.getOption() == null) {
            return null;
        }
        OperateOption option = this.getOption();
        Boolean isOpenServiceSaveBeforeSubmit = Boolean.parseBoolean(option.getVariableValue("bos_opensubmitwithsave", "false"));
        if (isOpenServiceSaveBeforeSubmit.booleanValue()) {
            Map saveOpSetting;
            OperationResult saveOpResult = null;
            Map parameter = (Map)operateMetaMap.get("parameter");
            if (parameter != null && parameter.get("saveOp") != null && !CollectionUtils.isEmpty((Map)(saveOpSetting = (Map)parameter.get("saveOp")))) {
                String opKey = saveOpSetting.get("key").toString();
                List<String> saveOps = this.makeSaveOps();
                if (saveOps == null || saveOps.isEmpty()) {
                    return null;
                }
                if (!saveOps.contains(opKey)) {
                    opKey = saveOps.get(0);
                }
                if (saveOpSetting.get("isSave") != null) {
                    Boolean isSave = (Boolean)saveOpSetting.get("isSave");
                    if (isSave.booleanValue() && !StringUtils.isBlank((CharSequence)opKey)) {
                        OperationServiceImpl operationService = new OperationServiceImpl();
                        saveOpResult = operationService.localInvokeOperation(opKey, dataEntities, this.getOption());
                    }
                } else if (!StringUtils.isBlank((CharSequence)opKey)) {
                    OperationServiceImpl operationService = new OperationServiceImpl();
                    saveOpResult = operationService.localInvokeOperation(opKey, dataEntities, this.getOption());
                }
            }
            return saveOpResult;
        }
        return super.getSubOpResult(operateMetaMap, dataEntities);
    }

    private List<String> makeSaveOps() {
        if (this.getBillEntityType() == null) {
            return null;
        }
        List operates = EntityMetadataCache.getDataEntityOperate((String)this.getBillEntityType().getName());
        ArrayList<String> saveOps = new ArrayList<String>();
        for (Map operate : operates) {
            Object opType = operate.get("type");
            if (!"save".equals(opType)) continue;
            saveOps.add((String)operate.get("key"));
        }
        return saveOps;
    }

    @Override
    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        this.persistAttachments(objs);
        super.callOperationTransaction(objs);
    }

    @Override
    protected void release() {
        super.release();
        if (this.validator != null) {
            if (!this.validator.getCheckedDatas().isEmpty()) {
                this.getOperationResult().getCustomData().put("dataChangValidator.completed", "true");
            }
            this.validator.release();
        }
    }

    @Override
    protected void rollback(DynamicObject[] objs, Exception ex) {
        super.rollback(objs, ex);
    }

    @Override
    protected void updateBillSysField(DynamicObject[] objs) {
        super.updateBillSysField(objs);
        this.updateModifier(objs);
    }
}

