/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.StatusConvertOperateService;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class UnSubmit
extends StatusConvertOperateService {
    private static Log log = LogFactory.getLog(UnSubmit.class);
    public static final String JOIDSINBIZDB = "joIdsInBizDB";
    public static final String INPROCESSPKS = "inProcess";
    public static final String ABANDONPKS = "abandonPks";

    @Override
    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntites) {
        super.initialize(entityType, operationKey, dataEntites);
    }

    @Override
    protected void preparePropertys(Object[] ids, List<String> fieldKeys) {
        super.preparePropertys(ids, fieldKeys);
    }

    @Override
    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
    }

    @Override
    protected void afterUpdateBillStatus(DynamicObject[] objs) {
        super.afterUpdateBillStatus(objs);
    }

    @Override
    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        Map variablesMap = this.getOption().getVariables();
        String isFromWf = (String)variablesMap.get("WF");
        if (isFromWf != null && !isFromWf.isEmpty()) {
            super.callOperationTransaction(objs);
        } else {
            Map variable = this.getOption().getVariables();
            String inProcessPks = (String)variable.get(INPROCESSPKS);
            log.info("inprocessPks:" + inProcessPks);
            if (inProcessPks != null && !"".equals(inProcessPks.trim())) {
                this.getOption().removeVariable(INPROCESSPKS);
                String[] inProcessPksArr = inProcessPks.split(",");
                List<String> inProPks = Arrays.asList(inProcessPksArr);
                ArrayList<DynamicObject> wfUnsubmitObjs = new ArrayList<DynamicObject>(16);
                for (DynamicObject obj : objs) {
                    String pk = String.valueOf(obj.getPkValue());
                    if (!inProPks.contains(pk)) continue;
                    wfUnsubmitObjs.add(obj);
                }
                String operateName = String.valueOf(this.operateMetaMap.get("key"));
                HashMap<String, String> params = new HashMap<String, String>(16);
                String abandonPks = (String)variable.get(ABANDONPKS);
                if (abandonPks != null && !"".equals(abandonPks.trim())) {
                    params.put(ABANDONPKS, abandonPks);
                }
                WorkflowServiceHelper.billUnsubmit((DynamicObject[])wfUnsubmitObjs.toArray(new DynamicObject[0]), (String)operateName, params);
            }
            super.callOperationTransaction(objs);
        }
    }

    @Override
    protected void executeOperate(DynamicObject[] objs) {
        super.executeOperate(objs);
        this.wfDeleteUnuseJobs(objs);
    }

    private void wfDeleteUnuseJobs(DynamicObject[] objs) {
        Map variable = this.getOption().getVariables();
        String joIdsInBizDB = (String)variable.get(JOIDSINBIZDB);
        if (joIdsInBizDB != null && !"".equals(joIdsInBizDB.trim())) {
            String[] jobIds = joIdsInBizDB.split(",");
            DBRoute dbRoute = DBRoute.of((String)objs[0].getDataEntityType().getDBRouteKey());
            boolean existTable = DB.exitsTable((DBRoute)dbRoute, (String)"t_wf_jobrecord");
            if (!existTable) {
                return;
            }
            StringBuilder deleteJobs = new StringBuilder("(");
            int i = 0;
            for (String jobId : jobIds) {
                if (jobId == null || "".equals(jobId.trim())) continue;
                deleteJobs.append(jobId).append(',');
                if (++i % 1000 != 0) continue;
                String deleteSql = "delete from t_wf_jobrecord where fid in " + deleteJobs.substring(0, deleteJobs.length() - 1) + ")";
                DB.execute((DBRoute)dbRoute, (String)deleteSql);
                deleteJobs = new StringBuilder("(");
            }
            if (deleteJobs.length() > 1) {
                String deleteSql = "delete from t_wf_jobrecord where fid in " + deleteJobs.substring(0, deleteJobs.length() - 1) + ")";
                DB.execute((DBRoute)dbRoute, (String)deleteSql);
            }
        }
    }

    @Override
    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] objects = super.callOperation(objs);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void release() {
        super.release();
        Map variable = this.getOption().getVariables();
        String joIdsInBizDB = (String)variable.get(JOIDSINBIZDB);
        try {
            if (joIdsInBizDB != null && !"".equals(joIdsInBizDB.trim())) {
                String[] jobIds = joIdsInBizDB.split(",");
                DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy(true, true));
                StringBuilder sb = new StringBuilder();
                String key = sb.append(Instance.getClusterName()).append('.').append(RequestContext.get().getAccountId()).append(".wf.").append("withdrawDeleteBizJobIds").append('.').append(this.billEntityType.getName()).toString();
                disCache.removeSetValues(key, jobIds);
            }
        }
        catch (Exception e) {
            log.info("\u6e05\u9664\u5de5\u4f5c\u6d41\u64a4\u56de\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.getOption().removeVariable(JOIDSINBIZDB);
            log.info("\u6e05\u9664jobs\uff1a" + joIdsInBizDB);
        }
    }

    @Override
    protected void rollback(DynamicObject[] objs, Exception ex) {
        super.rollback(objs, ex);
    }
}

