/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.plugin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.MasterIdUniqueValidator;
import kd.bos.servicehelper.DBServiceHelper;

public class MasterIdSetValuePlugin
extends AbstractOperationServicePlugIn {
    private boolean isMasterBasedata = false;
    private boolean isBizBasedata = false;
    private BasedataEntityType mainType = null;
    private IDataEntityProperty masteridProp = null;

    private void initVars() {
        if (this.billEntityType instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)((BasedataEntityType)this.billEntityType).getMasteridPropName())) {
            this.mainType = (BasedataEntityType)this.billEntityType;
            this.masteridProp = this.mainType.findProperty(this.mainType.getMasteridPropName());
            if (this.masteridProp != null) {
                if (this.masteridProp instanceof MasterBasedataProp) {
                    this.isBizBasedata = true;
                } else {
                    this.isMasterBasedata = true;
                }
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        if (this.billEntityType instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)((BasedataEntityType)this.billEntityType).getMasteridPropName())) {
            e.getFieldKeys().add(((BasedataEntityType)this.billEntityType).getMasteridPropName());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.initVars();
        if (this.isBizBasedata) {
            MasterIdUniqueValidator masteridValidator = new MasterIdUniqueValidator();
            masteridValidator.setMainType((BasedataEntityType)this.billEntityType);
            String operateType = (String)this.operateMeta.get("type");
            String operateName = (String)((Map)this.operateMeta.get("name")).get(Locale.getDefault().toString());
            masteridValidator.setOperateKey((String)this.operateMeta.get("key"));
            masteridValidator.setOperateType(operateType);
            masteridValidator.setOperationName(operateName);
            e.addValidator((AbstractValidator)masteridValidator);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (e.getValidExtDataEntities().isEmpty()) {
            return;
        }
        DynamicObject[] objs = new DynamicObject[e.getValidExtDataEntities().size()];
        for (int i = 0; i < e.getValidExtDataEntities().size(); ++i) {
            objs[i] = ((ExtendedDataEntity)e.getValidExtDataEntities().get(i)).getDataEntity();
        }
        if (this.isMasterBasedata) {
            this.autoSetMasterId(objs);
        } else if (this.isBizBasedata) {
            this.autoSetPrimaryKey(objs);
        }
    }

    private void autoSetMasterId(DynamicObject[] objs) {
        if (this.masteridProp != null && this.masteridProp instanceof IValidatorHanlder) {
            PKFieldProp pkProp = (PKFieldProp)this.mainType.getPrimaryKey();
            for (DynamicObject obj : objs) {
                Object masterid = this.masteridProp.getValue((Object)obj);
                if (masterid instanceof DynamicObject) {
                    masterid = ((DynamicObject)masterid).getPkValue();
                }
                if (!((IValidatorHanlder)this.masteridProp).getValueComparator().compareValue(masterid)) continue;
                Object pk = pkProp.getValue((Object)obj);
                if (!pkProp.getValueComparator().compareValue(pk)) {
                    this.masteridProp.setValue((Object)obj, pk);
                    continue;
                }
                pk = pkProp instanceof VarcharProp ? DBServiceHelper.genStringId() : Long.valueOf(DBServiceHelper.genGlobalLongId());
                pkProp.setValue((Object)obj, pk);
                this.masteridProp.setValue((Object)obj, pk);
            }
        }
    }

    private void autoSetPrimaryKey(DynamicObject[] objs) {
        if (!(this.masteridProp instanceof MasterBasedataProp)) {
            this.autoSetMasterId(objs);
            return;
        }
        MasterBasedataProp masterProp = (MasterBasedataProp)this.masteridProp;
        BasedataEntityType refType = (BasedataEntityType)masterProp.getComplexType();
        if (refType == null) {
            return;
        }
        PKFieldProp pkProp = (PKFieldProp)this.mainType.getPrimaryKey();
        HashMap<Object, DynamicObject> dctByMasterId = new HashMap<Object, DynamicObject>();
        for (DynamicObject dynamicObject : objs) {
            Object masterid;
            if (!this.isNewBizBasedata(dynamicObject, pkProp)) continue;
            DynamicObject masterObj = (DynamicObject)masterProp.getValue((Object)dynamicObject);
            Object object = masterid = masterObj != null ? masterObj.getPkValue() : null;
            if (masterProp.getValueComparator().compareValue(masterid) || dctByMasterId.containsKey(masterid)) continue;
            dctByMasterId.put(masterid, dynamicObject);
        }
        if (dctByMasterId.isEmpty()) {
            return;
        }
        QFilter qFilter = dctByMasterId.size() == 1 ? new QFilter(pkProp.getName(), "=", dctByMasterId.keySet().iterator().next()) : new QFilter(pkProp.getName(), "in", (Object)dctByMasterId.keySet().toArray());
        ORM orm = ORM.create();
        Throwable throwable = null;
        try (DataSet ds = orm.queryDataSet("kd.bos.service.operation.plugin.MasterIdSetValuePlugin.autoSetPrimaryKey()", this.mainType.getName(), pkProp.getName(), new QFilter[]{qFilter});){
            Iterator rows = ds.iterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                Object masterId = row.get(pkProp.getName());
                if (!dctByMasterId.containsKey(masterId)) continue;
                dctByMasterId.remove(masterId);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (dctByMasterId.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.mainType.getMainOrg()) || StringUtils.isBlank((CharSequence)refType.getMainOrg())) {
            for (Map.Entry entry : dctByMasterId.entrySet()) {
                pkProp.setValue(entry.getValue(), entry.getKey());
            }
        } else {
            HashMap<Object, Long> masteridToOrgids = new HashMap<Object, Long>();
            if (refType.getProperties().containsKey((Object)refType.getMainOrg())) {
                OrgProp orgProp = (OrgProp)refType.findProperty(refType.getMainOrg());
                for (Map.Entry item : dctByMasterId.entrySet()) {
                    DynamicObject masterObj = (DynamicObject)masterProp.getValue(item.getValue());
                    masteridToOrgids.put(item.getKey(), (Long)orgProp.getRefIdProp().getValue((Object)masterObj));
                }
            } else {
                qFilter = dctByMasterId.size() == 1 ? new QFilter("id", "=", dctByMasterId.keySet().iterator().next()) : new QFilter("id", "in", (Object)dctByMasterId.keySet().toArray());
                DataSet dataSet = orm.queryDataSet("kd.bos.service.operation.plugin.MasterIdSetValuePlugin.autoSetPrimaryKey()", refType.getName(), "id," + refType.getMainOrg(), new QFilter[]{qFilter});
                Object object = null;
                try {
                    for (Row row : dataSet) {
                        masteridToOrgids.put(row.get("id"), row.getLong(refType.getMainOrg()));
                    }
                }
                catch (Throwable rows) {
                    object = rows;
                    throw rows;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable rows) {
                                ((Throwable)object).addSuppressed(rows);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            OrgProp orgProp = (OrgProp)this.mainType.findProperty(this.mainType.getMainOrg());
            for (Map.Entry item : dctByMasterId.entrySet()) {
                Long orgId = (Long)orgProp.getRefIdProp().getValue(item.getValue());
                if (Long.compare(orgId, (Long)masteridToOrgids.get(item.getKey())) != 0) continue;
                pkProp.setValue(item.getValue(), item.getKey());
            }
        }
    }

    private boolean isNewBizBasedata(DynamicObject obj, PKFieldProp pkProp) {
        if (obj.getDataEntityState().getFromDatabase()) {
            return false;
        }
        Object pk = obj.getPkValue();
        if (!pkProp.getValueComparator().compareValue(pk)) {
            return false;
        }
        DynamicObject masterObj = (DynamicObject)this.masteridProp.getValue((Object)obj);
        return masterObj != null;
    }
}

