/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.lang.STConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;

public class MulilangTextSetValuePlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(MulilangTextSetValuePlugin.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        List<EnabledLang> enabledLangs = this.getEnableLangs();
        if (enabledLangs.isEmpty()) {
            return;
        }
        boolean sc2tc = false;
        boolean existZH = false;
        boolean existTW = false;
        for (EnabledLang lang : enabledLangs) {
            if (Lang.zh_CN.toString().equals(lang.getNumber())) {
                existZH = true;
            } else if (Lang.zh_TW.toString().equals(lang.getNumber())) {
                existTW = true;
            }
            if (!(sc2tc = existZH && existTW)) continue;
            break;
        }
        DynamicObjectType dt = datas[0].getDynamicObjectType();
        ArrayList<LocaleValuePair> pairs = new ArrayList<LocaleValuePair>(16);
        for (DynamicObject obj : datas) {
            this.collectSimplePair(obj, dt, enabledLangs, sc2tc, pairs);
        }
        for (LocaleValuePair pair : pairs) {
            pair.fill();
        }
    }

    private void collectSimplePair(DynamicObject object, DynamicObjectType dt, List<EnabledLang> enabledLangs, boolean sc2tc, List<LocaleValuePair> pairs) {
        List dirtyProps = dt.getDirtyProperties((Object)object);
        for (IDataEntityProperty dirtyProp : dirtyProps) {
            if (!(dirtyProp instanceof MuliLangTextProp) || dirtyProp.isDbIgnore()) continue;
            LocaleValuePair pair = new LocaleValuePair((MuliLangTextProp)dirtyProp, object, enabledLangs);
            pair.setSc2tc(sc2tc);
            pairs.add(pair);
        }
        DataEntityPropertyCollection props = dt.getProperties();
        List collections = props.getCollectionProperties(true);
        for (ICollectionProperty collectProp : collections) {
            DynamicObjectCollection collecObj = (DynamicObjectCollection)collectProp.getValue((Object)object);
            if (collecObj.isEmpty()) continue;
            DynamicObjectType colType = collecObj.getDynamicObjectType();
            for (DynamicObject row : collecObj) {
                this.collectSimplePair(row, colType, enabledLangs, sc2tc, pairs);
            }
        }
    }

    private List<EnabledLang> getEnableLangs() {
        List<Object> enableLangs = null;
        try {
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            enableLangs = new ArrayList<EnabledLang>();
            String chosenLangs = System.getProperty("mulilangtext.emptyfill.langs", "");
            List langs = service.getMultiLangEnabledLang();
            if (StringUtils.isBlank((CharSequence)chosenLangs)) {
                enableLangs.addAll(langs);
            } else {
                HashSet blacks = new HashSet();
                Collections.addAll(blacks, chosenLangs.split(","));
                for (EnabledLang lang : langs) {
                    if (!blacks.contains(lang.getNumber())) continue;
                    enableLangs.add(lang);
                }
            }
            enableLangs = service.getMultiLangEnabledLang();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u542f\u7528\u8bed\u8a00\u5931\u8d25", (Throwable)e);
            enableLangs = new ArrayList();
        }
        return enableLangs;
    }

    static class LocaleValuePair {
        private MuliLangTextProp prop;
        private DynamicObject obj;
        private List<EnabledLang> enabledLangs = new ArrayList<EnabledLang>();
        private boolean sc2tc = false;

        public LocaleValuePair(MuliLangTextProp prop, DynamicObject obj, List<EnabledLang> enabledLangs) {
            this.prop = prop;
            this.obj = obj;
            this.enabledLangs = enabledLangs;
        }

        public void setSc2tc(boolean sc2tc) {
            this.sc2tc = sc2tc;
        }

        public void fill() {
            Object value = this.prop.getValue((Object)this.obj);
            if (!(value instanceof ILocaleString)) {
                return;
            }
            ILocaleString localeString = (ILocaleString)value;
            String glang = (String)localeString.getItem("GLang");
            if (StringUtils.isBlank((CharSequence)glang)) {
                return;
            }
            this.fillEmptyValue(localeString, glang);
        }

        private void fillEmptyValue(ILocaleString currenValue, String glValue) {
            String cnValue;
            LocaleString localeString = new LocaleString();
            localeString.putAll((Map)currenValue);
            boolean needFillTW = false;
            boolean changed = false;
            for (EnabledLang enabledLang : this.enabledLangs) {
                if (StringUtils.equalsIgnoreCase((CharSequence)enabledLang.getNumber(), (CharSequence)Lang.get().toString()) || !StringUtils.isBlank((CharSequence)((CharSequence)currenValue.getItem(enabledLang.getNumber())))) continue;
                if (Lang.zh_TW.toString().equals(enabledLang.getNumber())) {
                    needFillTW = true;
                    continue;
                }
                localeString.setItem(enabledLang.getNumber(), (Object)glValue);
                changed = true;
            }
            if (needFillTW && this.sc2tc && StringUtils.isNotBlank((CharSequence)(cnValue = (String)localeString.getItem(Lang.zh_CN.toString())))) {
                localeString.setItem(Lang.zh_TW.toString(), (Object)STConverter.sc2tc((String)cnValue));
                changed = true;
            }
            if (changed) {
                this.prop.setValue((Object)this.obj, (Object)localeString);
            }
        }
    }
}

