/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillLayoutSchemeService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class BillLayoutRequiredValidator
extends AbstractValidator {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private Map<Long, Map<String, Map<String, IDataEntityProperty>>> mustInputFlds = null;
    private Map<BillLayoutParameter, BillLayoutSchemeAssignEntity> layoutSchemeAssignEntities = new HashMap<BillLayoutParameter, BillLayoutSchemeAssignEntity>(16);
    private static final Map<String, String> ENABLE_LANG_NUMBE2_NAME = new HashMap<String, String>(5);

    public static Map<String, String> getEnableLangs() {
        if (ENABLE_LANG_NUMBE2_NAME.isEmpty()) {
            List enabledLangs = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : enabledLangs) {
                String enableNumber = enabledLang.getNumber();
                ENABLE_LANG_NUMBE2_NAME.put(enableNumber, enabledLang.getName());
            }
        }
        return ENABLE_LANG_NUMBE2_NAME;
    }

    public String getEntityKey() {
        return this.validateContext.getBillEntityType().getName();
    }

    public Set<String> preparePropertys() {
        Map<Long, Map<String, Map<String, IDataEntityProperty>>> flds = this.getMustInputFlds();
        if (flds == null || flds.isEmpty()) {
            return super.preparePropertys();
        }
        HashSet<String> fldKeys = new HashSet<String>();
        for (Map.Entry<Long, Map<String, Map<String, IDataEntityProperty>>> billType : flds.entrySet()) {
            for (Map.Entry<String, Map<String, IDataEntityProperty>> entity : billType.getValue().entrySet()) {
                for (Map.Entry<String, IDataEntityProperty> prop : entity.getValue().entrySet()) {
                    fldKeys.add(prop.getValue().getName());
                }
            }
        }
        return fldKeys;
    }

    public void validate() {
        if (!this.validateContext.isCheckMustInput()) {
            return;
        }
        Map<Long, Map<String, Map<String, IDataEntityProperty>>> allFlds = this.getMustInputFlds();
        if (allFlds == null || allFlds.isEmpty()) {
            return;
        }
        BillEntityType mainType = (BillEntityType)this.validateContext.getBillEntityType();
        for (ExtendedDataEntity headDataEntity : this.dataEntities) {
            this.validateSingleBill(mainType, allFlds, headDataEntity);
        }
    }

    private void validateSingleBill(BillEntityType mainType, Map<Long, Map<String, Map<String, IDataEntityProperty>>> allFlds, ExtendedDataEntity headDataEntity) {
        DynamicObject mainOrgObj;
        DynamicObject billTypeObj;
        long billTypeId = 0L;
        if (StringUtils.isNotBlank((CharSequence)mainType.getBillType()) && (billTypeObj = (DynamicObject)headDataEntity.getValue(mainType.getBillType())) != null && billTypeObj.getPkValue() != null) {
            billTypeId = (Long)billTypeObj.getPkValue();
        }
        long orgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)mainType.getMainOrg()) && (mainOrgObj = (DynamicObject)headDataEntity.getValue(mainType.getMainOrg())) != null && mainOrgObj.getPkValue() != null) {
            orgId = (Long)mainOrgObj.getPkValue();
        }
        String orgFunc = "";
        MainOrgProp mainOrgProp = mainType.getMainOrgProperty();
        if (mainOrgProp != null) {
            orgFunc = mainOrgProp.getOrgFunc();
        }
        BillLayoutParameter parameter = new BillLayoutParameter(orgFunc, orgId, billTypeId);
        long schemeId = 0L;
        BillLayoutSchemeAssignEntity schemeAssign = null;
        if (this.layoutSchemeAssignEntities.containsKey(parameter)) {
            schemeAssign = this.layoutSchemeAssignEntities.get(parameter);
        } else {
            schemeAssign = BillLayoutSchemeService.getLayoutScheme((String)mainType.getName(), (BillLayoutParameter)parameter);
            this.layoutSchemeAssignEntities.put(parameter, schemeAssign);
        }
        if (schemeAssign != null) {
            schemeId = schemeAssign.getId();
        }
        if (schemeId == 0L || !allFlds.containsKey(schemeId)) {
            return;
        }
        Map<String, Map<String, IDataEntityProperty>> entityFlds = allFlds.get(schemeId);
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entity : entityFlds.entrySet()) {
            ExtendedDataEntity[] entityRows;
            for (ExtendedDataEntity entityRow : entityRows = this.validateContext.getExtendedDataEntitySet().FindByEntityKey(entity.getKey())) {
                if (entityRow.getDataEntityIndex() != headDataEntity.getDataEntityIndex()) continue;
                for (Map.Entry<String, IDataEntityProperty> prop : entity.getValue().entrySet()) {
                    this.validateFldValue(entityRow, prop.getValue());
                }
            }
        }
    }

    private void validateFldValue(ExtendedDataEntity dataEntity, IDataEntityProperty prop) {
        Object basedataValue;
        if (!(prop instanceof IValidatorHanlder)) {
            return;
        }
        Object fldValue = null;
        fldValue = prop instanceof BasedataProp || prop instanceof RefBillProp ? ((basedataValue = dataEntity.getValue(prop.getName())) != null ? ((DynamicObject)basedataValue).getPkValue() : null) : dataEntity.getValue(prop.getName());
        if (prop instanceof MuliLangTextProp && fldValue instanceof OrmLocaleValue) {
            OrmLocaleValue fldLocalValue = (OrmLocaleValue)fldValue;
            List mustInputLan = this.validateContext.getMustInputLang();
            StringBuilder fldMustLanStr = new StringBuilder();
            for (int i = 0; i < mustInputLan.size(); ++i) {
                String lan = (String)mustInputLan.get(i);
                if (fldLocalValue.get((Object)lan) != null) continue;
                fldMustLanStr.append(ENABLE_LANG_NUMBE2_NAME.get(lan));
                if (i >= mustInputLan.size() - 1) continue;
                fldMustLanStr.append(" ");
            }
            if (StringUtils.isNotBlank((CharSequence)fldMustLanStr)) {
                String content = this.buildErrMessage(dataEntity, prop, fldMustLanStr.toString());
                this.addMessage(dataEntity, content, this.getErrorLevl());
                return;
            }
        }
        if (((IValidatorHanlder)prop).getValueComparator().compareValue(fldValue)) {
            String content = this.buildErrMessage(dataEntity, prop);
            this.addMessage(dataEntity, content, this.getErrorLevl());
        }
    }

    private Map<Long, Map<String, Map<String, IDataEntityProperty>>> getMustInputFlds() {
        BillLayoutSchemeAssignEntity[] schemeAssigns;
        if (this.mustInputFlds != null) {
            return this.mustInputFlds;
        }
        if (this.validateContext == null || this.validateContext.getBillEntityType() == null) {
            return null;
        }
        MainEntityType mainType = this.validateContext.getBillEntityType();
        if (!(mainType instanceof BillEntityType)) {
            return null;
        }
        this.mustInputFlds = new HashMap<Long, Map<String, Map<String, IDataEntityProperty>>>(16);
        for (BillLayoutSchemeAssignEntity schemeAssign : schemeAssigns = BillLayoutSchemeService.getLayoutSchemeAssignEntityFromCache((String)mainType.getName())) {
            Long schemeId = schemeAssign.getId();
            List<DifferentialControlInfo> list = this.loadDifferentialControlInfosFromCache(mainType.getName(), schemeId);
            this.mustInputFlds.put(schemeId, new HashMap());
            for (DifferentialControlInfo control : list) {
                IDataEntityProperty prop;
                if (!Boolean.TRUE.equals(control.isMustInput()) || (prop = mainType.findProperty(StringUtils.isBlank((CharSequence)control.getEntityFieldKey()) ? control.getFieldKey() : control.getEntityFieldKey())) == null) continue;
                List fldValidators = new ArrayList(0);
                if (prop instanceof IValidatorHanlder) {
                    fldValidators = ((IValidatorHanlder)prop).getValidators();
                }
                boolean mustInput = false;
                for (AbstractValidator v : fldValidators) {
                    if (!(v instanceof RequiredValidator)) continue;
                    mustInput = true;
                    break;
                }
                if (mustInput) continue;
                if (!this.mustInputFlds.get(schemeId).containsKey(prop.getParent().getName())) {
                    this.mustInputFlds.get(schemeId).put(prop.getParent().getName(), new HashMap());
                }
                this.mustInputFlds.get(schemeId).get(prop.getParent().getName()).put(prop.getName(), prop);
            }
        }
        return this.mustInputFlds;
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity, IDataEntityProperty prop) {
        String fieldName;
        LocaleString propDisplayName = prop.getDisplayName();
        String string = fieldName = propDisplayName == null ? prop.getName() : propDisplayName.toString();
        if (prop.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)prop.getParent();
            if (prop instanceof EntryProp) {
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u3002", (String)"BillLayoutRequiredValidator_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName);
            }
            return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u3002", (String)"BillLayoutRequiredValidator_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName);
        }
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"BillLayoutRequiredValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fieldName);
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity, IDataEntityProperty prop, String mustInputLan) {
        String fieldName;
        LocaleString propDisplayName = prop.getDisplayName();
        String string = fieldName = propDisplayName == null ? prop.getName() : propDisplayName.toString();
        if (prop.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)prop.getParent();
            if (prop instanceof EntryProp) {
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c", (String)"BillLayoutRequiredValidator_8", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName, mustInputLan);
            }
            return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c\u3002", (String)"BillLayoutRequiredValidator_9", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName, mustInputLan);
        }
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"BillLayoutRequiredValidator_10", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fieldName, mustInputLan);
    }

    private List<DifferentialControlInfo> loadDifferentialControlInfosFromCache(String entityId, Long layoutSchemeId) {
        try {
            Class<?> flexMeta = Class.forName("kd.bos.metadata.billlayout.BillLayoutReader");
            Method loadDifferentialControlInfosFromCache = flexMeta.getMethod("loadDifferentialControlInfosFromCache", String.class, Long.TYPE);
            try {
                Object ret = loadDifferentialControlInfosFromCache.invoke(null, entityId, layoutSchemeId);
                return (List)ret;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.getMessage()});
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.getMessage()});
        }
    }

    static {
        BillLayoutRequiredValidator.getEnableLangs();
    }
}

