/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ThreadLocals;

public class DataVersionChangeValidator
extends AbstractValidator
implements AutoCloseable {
    private static final String PROJECTNAME = "bos-mservice-operation";
    private static final String NETGROUPID = "DataVersion";
    private static final String OPERATIONKEY = "checkdataversion";
    private static final Log log = LogFactory.getLog(DataVersionChangeValidator.class);
    public static final String CUSTOMPARAMKEY_CHECKED = "dataChangValidator.completed";
    private List<String> lockedDatas = new ArrayList<String>(10);

    public void validate() {
        boolean globalEnable;
        String tenantId = RequestContext.get().getTenantId();
        String globalStr = SystemPropertyUtils.getProptyByTenant((String)"bosop.checkdataversion.enable", (String)tenantId);
        boolean bl = globalEnable = StringUtils.isBlank((CharSequence)globalStr) || "true".equals(globalStr);
        if (!globalEnable) {
            return;
        }
        boolean enable = Boolean.parseBoolean(this.getOption().getVariableValue("bos_checkFormDataVersion", "false"));
        if (!enable) {
            return;
        }
        this.doCheck();
    }

    private void doCheck() {
        DynamicObject[] dbData;
        MainEntityType mainEntityType = this.getValidateContext().getSubEntityType();
        if (mainEntityType == null || !BillEntityType.class.isAssignableFrom(mainEntityType.getClass())) {
            return;
        }
        BillEntityType billEntityType = (BillEntityType)mainEntityType;
        String billStatusKey = billEntityType.getBillStatus();
        IModifyTimeProperty modifyTimeProp = billEntityType.getModifyTimeProperty();
        ISimpleProperty pkProp = billEntityType.getPrimaryKey();
        if (StringUtils.isBlank((CharSequence)billStatusKey) || modifyTimeProp == null || pkProp == null || !IValidatorHanlder.class.isAssignableFrom(pkProp.getClass())) {
            return;
        }
        DynamicProperty billStatusProp = billEntityType.getProperty(billStatusKey);
        IValidatorHanlder pkValidatorHandler = (IValidatorHanlder)pkProp;
        ExtendedDataEntity[] headEntity = this.getValidateContext().getExtendedDataEntitySet().FindByEntityKey(this.getValidateContext().getEntityNumber());
        HashMap<Object, ExtendedDataEntity> unSafeData = new HashMap<Object, ExtendedDataEntity>();
        HashMap<String, ExtendedDataEntity> index = new HashMap<String, ExtendedDataEntity>(10);
        for (ExtendedDataEntity data : headEntity) {
            Object pk = data.getBillPkId();
            if (pkValidatorHandler.getValueComparator().compareValue(pk) || !this.isFromDataBase(data)) continue;
            unSafeData.put(pk, data);
            index.put(pk.toString(), data);
        }
        if (unSafeData.isEmpty()) {
            return;
        }
        Map<String, DataMutexResult> mutexResultMap = this.require(this.getOption(), unSafeData);
        for (Map.Entry<String, DataMutexResult> it : mutexResultMap.entrySet()) {
            ExtendedDataEntity data;
            if (it.getValue().isSuccess()) continue;
            data = (ExtendedDataEntity)index.get(it.getKey());
            this.addErrorMessage(data, it.getValue().getMessage());
            unSafeData.remove(data.getBillPkId());
        }
        if (unSafeData.isEmpty()) {
            return;
        }
        unSafeData.forEach((k, v) -> this.lockedDatas.add(k.toString()));
        String selectField = String.join((CharSequence)",", pkProp.getName(), billStatusKey, modifyTimeProp.getName());
        QFilter[] filters = new QFilter[]{new QFilter(pkProp.getName(), "in", new ArrayList(unSafeData.keySet()))};
        for (DynamicObject it : dbData = BusinessDataServiceHelper.load((String)billEntityType.getName(), (String)selectField, (QFilter[])filters)) {
            DynamicObject left;
            Object pkValue = it.get(pkProp.getName());
            ExtendedDataEntity unsafe = (ExtendedDataEntity)unSafeData.get(pkValue);
            if (unsafe == null || DataVersionChangeValidator.compareTo((left = unsafe.getDataEntity()).get(billStatusKey), it.get(billStatusKey)) && DataVersionChangeValidator.compareDate(left.get(modifyTimeProp.getName()), it.get(modifyTimeProp.getName()))) continue;
            this.addErrorMessage(unsafe, this.buildErrorMsg());
            unSafeData.remove(pkValue);
        }
    }

    private boolean isFromDataBase(ExtendedDataEntity dataObj) {
        DynamicObject parentObj = dataObj.getDataEntity();
        while (parentObj.getParent() != null) {
            parentObj = (DynamicObject)parentObj.getParent();
        }
        return parentObj.getDataEntityState().getFromDatabase();
    }

    public List<String> getCheckedDatas() {
        return this.lockedDatas;
    }

    private Map<String, DataMutexResult> require(OperateOption option, Map<Object, ExtendedDataEntity> datas) {
        boolean isStrict = true;
        boolean autoClearDirtyLock = false;
        long maxLockTime = 600L;
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(datas.size());
        String entityNumber = this.getValidateContext().getBillEntityType().getAlias();
        Set<String> existLockPks = ThreadDataLockManager.getInstance().loadAll(entityNumber);
        for (Map.Entry<Object, ExtendedDataEntity> it : datas.entrySet()) {
            String objId;
            Long idLong;
            String idStr;
            if (it.getKey() == null || (!(it.getKey() instanceof Long) ? (idStr = String.valueOf(it.getKey())).trim().length() == 0 : (idLong = (Long)it.getKey()) == 0L) || existLockPks.contains(objId = String.valueOf(it.getKey()))) continue;
            String billNo = it.getValue().getBillNo();
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put("dataObjId", objId);
            requireParam.put("dataObjNumber", billNo);
            requireParam.put("groupId", NETGROUPID);
            requireParam.put("entityKey", entityNumber);
            requireParam.put("operationKey", OPERATIONKEY);
            requireParam.put("isStrict", isStrict);
            requireParam.put("autoclearlostlock", autoClearDirtyLock);
            requireParam.put("maxlocktime_s", maxLockTime);
            mutexRequireList.add(requireParam);
        }
        return DataVersionChangeValidator.batchRequireMutex(NETGROUPID, entityNumber, mutexRequireList);
    }

    private static Map<String, DataMutexResult> batchRequireMutex(String groupId, String entityNumber, List<Map<String, Object>> mutexRequireList) {
        if (mutexRequireList.isEmpty()) {
            return new HashMap<String, DataMutexResult>(0);
        }
        HashMap<String, DataMutexResult> dataMutexResults = new HashMap<String, DataMutexResult>(mutexRequireList.size());
        try (DataMutex dataMutex = DataMutex.create();
             EntityTraceSpan span = EntityTracer.create((String)"DataVersionChangeValidator", (String)"batchRequireMutex");){
            try {
                Map<String, Boolean> mutexResult = DataVersionChangeValidator.doRequireMutex(dataMutex, mutexRequireList);
                if (span.isRealtime()) {
                    span.addLocaleTag("mutexRequireList", mutexRequireList);
                    span.addLocaleTag("mutexResult", mutexResult);
                }
                ThreadDataLockManager lockManager = ThreadDataLockManager.getInstance();
                for (Map.Entry<String, Boolean> mutexItem : mutexResult.entrySet()) {
                    String objId = mutexItem.getKey();
                    Boolean ret = mutexItem.getValue();
                    DataMutexResult dataMutexResult = new DataMutexResult(objId, ret);
                    dataMutexResults.put(objId, dataMutexResult);
                    if (ret.booleanValue()) {
                        lockManager.add(entityNumber, Arrays.asList(objId));
                        continue;
                    }
                    Map lockInfo = dataMutex.getLockInfo(objId, groupId, entityNumber);
                    dataMutexResult.setMessage(ResManager.loadKDString((String)"\u5176\u5b83\u7ebf\u7a0b\u6b63\u5728\u64cd\u4f5c\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataVersionChangeValidator_3", (String)PROJECTNAME, (Object[])new Object[0]));
                }
            }
            catch (KDException e) {
                for (Map<String, Object> lockData : mutexRequireList) {
                    Object idValue = lockData.get("dataObjId");
                    if (dataMutexResults.containsKey(String.valueOf(idValue))) continue;
                    DataMutexResult dataMutexResult = new DataMutexResult(String.valueOf(idValue), false);
                    dataMutexResults.put(String.valueOf(idValue), dataMutexResult);
                    StringBuilder sb = new StringBuilder();
                    sb.append(e.getMessage());
                    sb.append("\uff0c");
                    sb.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataVersionChangeValidator_1", (String)PROJECTNAME, (Object[])new Object[0]));
                    dataMutexResult.setMessage(sb.toString());
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7248\u672c\u6821\u9a8c\u7533\u8bf7\u9501\u51fa\u9519;err:", (String)"DataVersionChangeValidator_2", (String)PROJECTNAME, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        return dataMutexResults;
    }

    private static Map<String, Boolean> doRequireMutex(DataMutex dataMutex, List<Map<String, Object>> mutexRequireList) {
        HashMap<String, Boolean> mutexResult = null;
        int maxRequireCount = 5;
        Boolean isIgnoreModify = (Boolean)mutexRequireList.get(0).get("ignoreModify");
        for (int requireCount = 0; requireCount < maxRequireCount; ++requireCount) {
            mutexResult = dataMutex.batchrequire(mutexRequireList);
            if (isIgnoreModify == null || !isIgnoreModify.booleanValue() || mutexRequireList.size() > 1 || mutexResult == null || mutexResult.size() != 1 || ((Boolean)mutexResult.entrySet().iterator().next().getValue()).booleanValue()) break;
            DataVersionChangeValidator.sleep(200L);
        }
        if (mutexResult == null) {
            mutexResult = new HashMap<String, Boolean>(mutexRequireList.size());
            for (Map<String, Object> item : mutexRequireList) {
                String objId = (String)item.get("dataObjId");
                if (objId == null) continue;
                mutexResult.put(objId, false);
            }
        }
        return mutexResult;
    }

    private static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String buildErrorMsg() {
        return ResManager.loadKDString((String)"\u53d1\u73b0\u5f53\u524d\u9875\u9762\u6709\u6570\u636e\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DataChangedValidator_0", (String)PROJECTNAME, (Object[])new Object[0]);
    }

    private static boolean compareTo(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass() && !o1.getClass().isAssignableFrom(o2.getClass()) && !o2.getClass().isAssignableFrom(o1.getClass())) {
            return false;
        }
        return o1.equals(o2);
    }

    private static boolean compareDate(Object date1, Object date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        if (date1 instanceof Date && date2 instanceof Date) {
            long right;
            long left = ((Date)date1).getTime();
            return Math.abs(left - (right = ((Date)date2).getTime())) <= 1000L;
        }
        return false;
    }

    public static Function<DynamicObject, Boolean> getBillStatusValidator() {
        return new Function<DynamicObject, Boolean>(){

            @Override
            public Boolean apply(DynamicObject object) {
                return this.check(object);
            }

            private boolean check(DynamicObject dynamicObject) {
                boolean globalEnable;
                String tenantId = RequestContext.get().getTenantId();
                String globalStr = SystemPropertyUtils.getProptyByTenant((String)"bosop.checkdataversion.enable", (String)tenantId);
                boolean bl = globalEnable = StringUtils.isBlank((CharSequence)globalStr) || "true".equals(globalStr);
                if (!globalEnable) {
                    return true;
                }
                IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
                if (dataEntityType == null || !BillEntityType.class.isAssignableFrom(dataEntityType.getClass())) {
                    return true;
                }
                BillEntityType billEntityType = (BillEntityType)dataEntityType;
                String billStatusKey = billEntityType.getBillStatus();
                IModifyTimeProperty modifyTimeProp = billEntityType.getModifyTimeProperty();
                ISimpleProperty pkProp = billEntityType.getPrimaryKey();
                if (StringUtils.isBlank((CharSequence)billStatusKey) || billEntityType.getProperty(billStatusKey) == null || modifyTimeProp == null || pkProp == null || !IValidatorHanlder.class.isAssignableFrom(pkProp.getClass())) {
                    return true;
                }
                if (!dynamicObject.getDataEntityState().getFromDatabase() || ((IValidatorHanlder)pkProp).getValueComparator().compareValue(dynamicObject.getPkValue())) {
                    return true;
                }
                String selectField = String.join((CharSequence)",", pkProp.getName(), billStatusKey, modifyTimeProp.getName());
                QFilter[] filters = new QFilter[]{new QFilter(pkProp.getName(), "=", dynamicObject.getPkValue())};
                try (EntityTraceSpan span = EntityTracer.create((String)"datachangevalidator", (String)"valid");){
                    DynamicObject[] dbData = BusinessDataServiceHelper.load((String)billEntityType.getName(), (String)selectField, (QFilter[])filters);
                    if (dbData.length == 0) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    Object objStatus = dynamicObject.get(billStatusKey);
                    Object dbStatus = dbData[0].get(billStatusKey);
                    Object objModify = dynamicObject.get(modifyTimeProp.getName());
                    Date dbModify = dbData[0].getDate(modifyTimeProp.getName());
                    span.addLocaleTag("objStatus", objStatus);
                    span.addLocaleTag("dbStatus", dbStatus);
                    span.addLocaleTag("objModify", objModify);
                    span.addLocaleTag("dbModify", (Object)dbModify);
                    if (!DataVersionChangeValidator.compareTo(objStatus, dbStatus) || !DataVersionChangeValidator.compareDate(objModify, dbModify)) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                return true;
            }
        };
    }

    @Override
    public void close() throws Exception {
        if (this.lockedDatas.isEmpty()) {
            return;
        }
        DataVersionChangeValidator.releaseLock(this.getValidateContext().getBillEntityType().getAlias(), this.lockedDatas);
        this.lockedDatas.clear();
    }

    public static void releaseLock(String mainTableName, List<String> pks) {
        if (StringUtils.isBlank((CharSequence)mainTableName) || pks == null || pks.isEmpty()) {
            return;
        }
        ArrayList mutexRequireList = new ArrayList(pks.size());
        String entityKey = mainTableName;
        for (String mutexLock : pks) {
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put("dataObjId", mutexLock);
            requireParam.put("groupId", NETGROUPID);
            requireParam.put("entityKey", entityKey);
            requireParam.put("operationKey", OPERATIONKEY);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResult = dataMutex.batchRelease(mutexRequireList);
            ArrayList<String> failIds = new ArrayList<String>();
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                boolean releaseRet = (Boolean)releaseItem.getValue();
                String objId = (String)releaseItem.getKey();
                if (!releaseRet) {
                    failIds.add(objId);
                    continue;
                }
                ThreadDataLockManager.getInstance().removeByPks(entityKey, Arrays.asList(objId));
            }
            if (!failIds.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to release the data object mutex, a total of ").append(failIds.size()).append(" failures: ");
                sb.append((String)failIds.get(0));
                for (int i = 1; i < failIds.size() && i < 100; ++i) {
                    sb.append(",").append((String)failIds.get(i));
                }
                log.info(sb.toString());
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\u3002", (String)"DataVersionChangeValidator_4", (String)PROJECTNAME, (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    public void release() {
        try {
            this.close();
        }
        catch (Exception e) {
            log.error("DataVersionChangeValidator.release error", (Throwable)e);
        }
    }

    static class ThreadDataLockManager
    implements AutoCloseable {
        private static ThreadLocal<ThreadDataLockManager> threadLocal = ThreadLocals.create();
        private Map<String, Map<String, AtomicInteger>> lockRecords = new ConcurrentHashMap<String, Map<String, AtomicInteger>>();

        public static ThreadDataLockManager getInstance() {
            if (threadLocal.get() == null) {
                threadLocal.set(new ThreadDataLockManager());
            }
            return threadLocal.get();
        }

        public List<String> getNotExistPks(String mainTableName, List<String> pks) {
            Map<String, AtomicInteger> data = this.lockRecords.get(mainTableName);
            if (data == null) {
                data = new HashMap<String, AtomicInteger>(pks.size());
                this.lockRecords.put(mainTableName, data);
                return pks;
            }
            ArrayList<String> keys = new ArrayList<String>(pks);
            if (!data.isEmpty()) {
                keys.removeAll(data.keySet());
            }
            return keys;
        }

        public Set<String> loadAll(String mainTableName) {
            Map<String, AtomicInteger> data = this.lockRecords.get(mainTableName);
            if (data == null || data.isEmpty()) {
                return new HashSet<String>(1);
            }
            return data.keySet();
        }

        public void add(String mainTableName, List<String> pks) {
            Map<String, AtomicInteger> data = this.lockRecords.get(mainTableName);
            if (data == null) {
                data = new HashMap<String, AtomicInteger>(pks.size());
                this.lockRecords.put(mainTableName, data);
                for (String pk : pks) {
                    data.put(pk, new AtomicInteger(1));
                }
            } else {
                for (String pk : pks) {
                    AtomicInteger count = data.getOrDefault(pk, new AtomicInteger(0));
                    count.incrementAndGet();
                    data.put(pk, count);
                }
            }
        }

        public void remove(String mainTableName) {
            this.lockRecords.remove(mainTableName);
        }

        public void removeByPks(String mainTableName, List<String> pks) {
            Map<String, AtomicInteger> data = this.lockRecords.get(mainTableName);
            if (data != null) {
                for (String pk : pks) {
                    data.remove(pk);
                }
                if (data.isEmpty()) {
                    this.lockRecords.remove(mainTableName);
                }
            }
        }

        @Override
        public void close() throws Exception {
            if (this.lockRecords.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Map<String, AtomicInteger>> it : this.lockRecords.entrySet()) {
                try {
                    DataVersionChangeValidator.releaseLock(it.getKey(), new ArrayList<String>(it.getValue().keySet()));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }
}

