/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.validate.FieldChecker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.utils.LogPrintUtil;
import kd.bos.utils.SecurityTypeEnum;

public class FunctionPermValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(FunctionPermValidator.class);
    private boolean skipCheckDataPerm = false;
    private boolean hasEnableOldDataRule = false;
    private long userId = 0L;
    private String bizAppId = null;
    private String displayName = null;
    private String entityNum = null;
    private String dataRulePermItemId = null;
    private boolean ignoreCheckApp = false;
    private static final String PERMTYPE_FUNPERM = "funperm";
    private static final String PERMTYPE_DATARULE = "datarule";
    private List<ExtendedDataEntity> scriptCheckList = new ArrayList<ExtendedDataEntity>(8);
    private List<Object> pkIds = new ArrayList<Object>(8);
    private Map<Object, ExtendedDataEntity> pkIdAndDyObjMap = new HashMap<Object, ExtendedDataEntity>(8);
    private String dataRuleScript = null;
    private String express = null;
    private BOSExpression expr = null;
    private boolean needCalcExpr = true;
    private boolean subEntityEmptyData = false;
    private ExtendedDataEntity[] mainDataEntities = null;
    public static final String CUSTOMPARAM_DATARULE_EXTDATAENTSET = "DataRule_CustParam_ExtendDataEntitySet";
    private boolean existMulPropDataRuleAtNotViewPerm = false;
    private String notSupportMsg_notViewPerm_mulBdDataRule = "";
    private static final String ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD = "ERR_DATARULE_NOT_SUPPORTED_NOTVIEW_MULBD";

    public Set<String> preparePropertys() {
        Set fldKeys = super.preparePropertys();
        this.needCalcExpr = false;
        boolean isHasRight = Boolean.parseBoolean(this.getOption().getVariableValue("ishasright", String.valueOf(false)));
        if (!isHasRight && StringUtils.isNotBlank((CharSequence)this.validateContext.getDimFldKey())) {
            fldKeys.add(this.validateContext.getDimFldKey());
        }
        if (!isHasRight && StringUtils.isNotBlank((CharSequence)this.validateContext.getDimAssistFldKey())) {
            fldKeys.add(this.validateContext.getDimAssistFldKey());
        }
        return fldKeys;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        MainEntityType mainType = this.validateContext.getSubEntityType();
        if (this.skipAnonymousValidate(mainType)) {
            return;
        }
        this.userId = RequestContext.get().getCurrUserId();
        this.bizAppId = this.getOption().getVariableValue("currbizappid", null);
        this.displayName = mainType.getDisplayName().getLocaleValue();
        this.displayName = StringUtils.isBlank((CharSequence)this.displayName) ? mainType.getName() : this.displayName;
        this.entityNum = mainType.getName();
        this.mainDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(this.entityNum);
        this.ignoreCheckApp = Boolean.parseBoolean(this.getOption().getVariableValue("PERM_IGNORE_CHECKAPP", String.valueOf(false)));
        this.skipCheckDataPerm = false;
        if (this.getOption().containsVariable("skipCheckDataPermission")) {
            this.skipCheckDataPerm = Boolean.parseBoolean(this.getOption().getVariableValue("skipCheckDataPermission"));
        }
        this.hasEnableOldDataRule = FunctionPermValidator.hasEnableOldDataRule();
        if (!this.skipCheckDataPerm && !this.hasEnableOldDataRule) {
            String opPermItemId;
            ExtendedDataEntity[] billDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(this.entityNum);
            if (billDataEntities == null || billDataEntities.length == 0) {
                return;
            }
            for (ExtendedDataEntity dataEntity : billDataEntities) {
                Object pkId = dataEntity.getBillPkId();
                boolean isValidPkId = false;
                if (pkId instanceof Long) {
                    Long pkIdLong = (Long)pkId;
                    isValidPkId = pkId != null && pkIdLong != 0L;
                } else if (pkId instanceof String) {
                    String pkIdStr = (String)pkId;
                    boolean bl = isValidPkId = pkId != null && StringUtils.isNotBlank((CharSequence)pkIdStr);
                }
                if (this.needCalcExpr || !isValidPkId) {
                    this.scriptCheckList.add(dataEntity);
                    continue;
                }
                this.pkIds.add(pkId);
                this.pkIdAndDyObjMap.put(pkId, dataEntity);
            }
            ExtendedDataEntity firstDataEntity = billDataEntities[0];
            this.dataRulePermItemId = opPermItemId = this.getOperatePermItemId();
            String operateKey = this.getOperateKey();
            if ("save".equals(operateKey) && StringUtils.isEmpty((CharSequence)opPermItemId)) {
                boolean fromDataBase = firstDataEntity.getDataEntity().getDataEntityState().getFromDatabase();
                this.dataRulePermItemId = fromDataBase ? "4715a0df000000ac" : "47156aff000000ac";
            }
            if (!CollectionUtils.isEmpty(this.scriptCheckList)) {
                block26: {
                    HashMap<String, ExtendedDataEntitySet> customParam = new HashMap<String, ExtendedDataEntitySet>();
                    customParam.put(CUSTOMPARAM_DATARULE_EXTDATAENTSET, this.getExtendedDataEntitySet());
                    customParam.putAll(this.getOption().getVariables());
                    PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                    try {
                        this.dataRuleScript = permissionService.getDataRuleScript(Long.valueOf(this.userId), this.bizAppId, this.entityNum, this.dataRulePermItemId, customParam);
                    }
                    catch (KDException e) {
                        ErrorCode errorCode = e.getErrorCode();
                        if (errorCode != null && ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD.equals(errorCode.getCode())) {
                            this.existMulPropDataRuleAtNotViewPerm = true;
                            this.notSupportMsg_notViewPerm_mulBdDataRule = errorCode.getMessage();
                        }
                        if (this.existMulPropDataRuleAtNotViewPerm) break block26;
                        throw e;
                    }
                }
                if (this.expr == null) {
                    this.express = this.dataRuleScript;
                    this.expr = new BOSExpression(this.express);
                    if (this.expr.isError()) {
                        throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
                    }
                }
                FieldChecker fieldChecker = new FieldChecker(this.getValidateContext().getSubEntityType());
                fieldChecker.check((Collection)this.expr.getVars());
                if (fieldChecker.isNotExistsFields()) {
                    throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728", (String)"FunctionPermValidator_10", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])fieldChecker.getNotExistsFields().toArray(), (String)","))));
                }
                if (fieldChecker.isOverEntry()) {
                    throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6765\u81ea\u4e8e\u591a\u4e2a\u5355\u636e\u4f53(%s)", (String)"FunctionPermValidator_11", (String)"bos-mservice-operation", (Object[])new Object[0]), fieldChecker.getOverEntryNames("+"))));
                }
                Set subEntrys = fieldChecker.getSubEntrys();
                Set entrys = fieldChecker.getEntrys();
                if (!subEntrys.isEmpty()) {
                    this.entityKey = ((SubEntryType)subEntrys.iterator().next()).getName();
                    ExtendedDataEntity[] subArray = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                    if (subArray == null || subArray.length == 0) {
                        this.subEntityEmptyData = true;
                        if (!entrys.isEmpty()) {
                            this.entityKey = ((EntryType)entrys.iterator().next()).getName();
                            ExtendedDataEntity[] array = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                            if (array == null || array.length == 0) {
                                this.entityKey = mainType.getName();
                            }
                        }
                    }
                } else if (!entrys.isEmpty()) {
                    this.entityKey = ((EntryType)entrys.iterator().next()).getName();
                    ExtendedDataEntity[] array = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                    if (array == null || array.length == 0) {
                        this.subEntityEmptyData = true;
                        this.entityKey = mainType.getName();
                    }
                } else {
                    this.entityKey = mainType.getName();
                }
            }
        }
    }

    public void validate() {
        MainEntityType mainType = this.validateContext.getSubEntityType();
        if (this.skipAnonymousValidate(mainType)) {
            return;
        }
        String permissionItemId = this.getOperatePermItemId();
        String operateType = this.getOperateType();
        boolean isHasRight = Boolean.parseBoolean(this.getOption().getVariableValue("ishasright", String.valueOf(false)));
        if (isHasRight || !mainType.getPermissionControlType().isControlFunction()) {
            this.checkDataRulePermission();
            return;
        }
        Set permissionItems = EntityMetadataCache.getPermissionItems((String)mainType.getName());
        if (permissionItems == null || permissionItems.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)permissionItemId)) {
            return;
        }
        String checkPermAppId = this.bizAppId;
        if (this.ignoreCheckApp) {
            checkPermAppId = "";
        }
        if ((StringUtils.isBlank((CharSequence)this.validateContext.getDimFldKey()) || mainType.findProperty(this.validateContext.getDimFldKey()) == null) && (StringUtils.isBlank((CharSequence)this.validateContext.getDimAssistFldKey()) || mainType.findProperty(this.validateContext.getDimAssistFldKey()) == null)) {
            int hasRight = PermissionServiceHelper.checkPermission((long)this.userId, (String)"DIM_ORG", (long)0L, (String)checkPermAppId, (String)mainType.getName(), (String)permissionItemId);
            if (hasRight != 1) {
                String msg = this.getNoPermMsg(PERMTYPE_FUNPERM, permissionItemId);
                for (ExtendedDataEntity dataEntity : this.mainDataEntities) {
                    this.addFatalErrorMessage(dataEntity, msg);
                }
                LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, mainType));
            } else {
                this.checkDataRulePermission();
            }
            return;
        }
        ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
        HashMap<String, ExtendedDataEntity> idMap = new HashMap<String, ExtendedDataEntity>(16);
        CheckDimObjParam dimObjParam = null;
        for (ExtendedDataEntity extendedDataEntity : this.mainDataEntities) {
            Long dimAssistFldValue;
            String errorMsg;
            if (extendedDataEntity == null) continue;
            Object billPkId = extendedDataEntity.getBillPkId();
            String strBillPkId = "";
            strBillPkId = billPkId == null || billPkId.equals("") || billPkId.equals(0L) ? String.valueOf(extendedDataEntity.getDataEntityIndex()) : billPkId.toString();
            idMap.put(strBillPkId, extendedDataEntity);
            dimObjParam = new CheckDimObjParam();
            if (StringUtils.isNotBlank((CharSequence)this.validateContext.getDimFldKey())) {
                Long dimFldValue;
                Object dimFldObj = extendedDataEntity.getDataEntity().get(this.validateContext.getDimFldKey());
                if (dimFldObj instanceof DynamicObject) {
                    DynamicObject dimFldDObj = (DynamicObject)dimFldObj;
                    dimFldValue = dimFldDObj == null ? -1L : Long.parseLong(dimFldDObj.getPkValue().toString());
                } else if (dimFldObj instanceof Long) {
                    dimFldValue = (Long)dimFldObj;
                } else if (dimFldObj == null) {
                    dimFldValue = -1L;
                } else {
                    errorMsg = ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u4e3b\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f\uff08\u5e94\u4e3aLong\u6216DynamicObject\uff09\u3002", (String)"FunctionPermValidator_12", (String)"bos-mservice-operation", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                    LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(errorMsg, mainType));
                    continue;
                }
                if (dimFldValue != -1L) {
                    dimObjParam.setDimensionOrg(dimFldValue.longValue());
                    dimObjParam.setId((Object)strBillPkId);
                    dimObjParamList.add(dimObjParam);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)this.validateContext.getDimAssistFldKey())) continue;
            Object dimAssistFldObj = extendedDataEntity.getDataEntity().get(this.validateContext.getDimAssistFldKey());
            if (dimAssistFldObj instanceof DynamicObject) {
                DynamicObject dimAssistFldDObj = (DynamicObject)dimAssistFldObj;
                dimAssistFldValue = dimAssistFldDObj == null ? -1L : Long.parseLong(dimAssistFldDObj.getPkValue().toString());
            } else if (dimAssistFldObj instanceof Long) {
                dimAssistFldValue = (Long)dimAssistFldObj;
            } else if (dimAssistFldObj == null) {
                dimAssistFldValue = -1L;
            } else {
                errorMsg = ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u8f85\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f\uff08\u5e94\u4e3aLong\u6216DynamicObject\uff09\u3002", (String)"FunctionPermValidator_13", (String)"bos-mservice-operation", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(errorMsg, mainType));
                continue;
            }
            if (dimAssistFldValue == -1L) continue;
            dimObjParam.setAssistDimensionOrg(dimAssistFldValue.longValue());
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        List resultList = permissionService.checkPermissionBatch(Long.valueOf(this.userId), checkPermAppId, mainType.getName(), permissionItemId, dimObjParamList);
        if (resultList == null) {
            String msg = this.getNoPermMsg(PERMTYPE_FUNPERM, permissionItemId);
            for (ExtendedDataEntity dataEntity : this.mainDataEntities) {
                this.addFatalErrorMessage(dataEntity, msg);
            }
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, mainType));
            return;
        }
        for (CheckDimObjParam checkDimObjParam : resultList) {
            String content = this.getNoPermMsg(PERMTYPE_FUNPERM, permissionItemId);
            try {
                LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(content, mainType));
            }
            catch (Exception e) {
                log.error(content);
            }
            this.addFatalErrorMessage((ExtendedDataEntity)idMap.get(checkDimObjParam.getId().toString()), content);
        }
        if (resultList != null && resultList.isEmpty()) {
            this.checkDataRulePermission();
        }
    }

    private String getNoPermMsg(String permType, String permItemId) {
        String permItemName;
        String opName = this.getOperationName();
        if (opName == null) {
            opName = "";
        }
        if (this.displayName == null) {
            this.displayName = "";
        }
        if ((permItemName = this.getPermItemName(permItemId)) == null) {
            permItemName = permItemId;
        }
        String formatStr = "";
        if (!PERMTYPE_FUNPERM.equals(permType) && !PERMTYPE_DATARULE.equals(permType)) {
            return "invalid permtype!";
        }
        String msg = "";
        if (opName.equals(permItemName)) {
            if (permType.equals(PERMTYPE_FUNPERM)) {
                formatStr = ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"FunctionPermValidator_9", (String)"bos-mservice-operation", (Object[])new Object[0]);
            } else if (permType.equals(PERMTYPE_DATARULE)) {
                formatStr = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u3010%1$s\u3011\u3010%2$s\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\u3002", (String)"MODIFY_NOE_DRPERM2", (String)"bos-mservice-operation", (Object[])new Object[0]);
            }
            msg = String.format(formatStr, this.displayName, permItemName);
        } else {
            if (PERMTYPE_FUNPERM.equals(permType)) {
                formatStr = ResManager.loadKDString((String)"\u4e0d\u80fd%1$s\u3002\u65e0\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u6743\u9650\u3002", (String)"FunctionPermValidator_8", (String)"bos-mservice-operation", (Object[])new Object[0]);
            } else if (PERMTYPE_DATARULE.equals(permType)) {
                formatStr = ResManager.loadKDString((String)"\u4e0d\u80fd%1$s\u3002\u60a8\u6ca1\u6709\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\u3002", (String)"MODIFY_NOE_DRPERM", (String)"bos-mservice-operation", (Object[])new Object[0]);
            }
            msg = String.format(formatStr, opName, this.displayName, permItemName);
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDataRulePermission() {
        if (this.skipCheckDataPerm || this.hasEnableOldDataRule) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.scriptCheckList)) {
            void var5_8;
            HashSet<DynamicObject> notValidMainDataEntitySet = new HashSet<DynamicObject>();
            HashSet<DynamicObject> validMainDataEntitySet = new HashSet<DynamicObject>();
            ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
            int n = extendedDataEntityArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[var5_8];
                if (this.existMulPropDataRuleAtNotViewPerm) {
                    this.addFatalErrorMessage(dataEntity, this.notSupportMsg_notViewPerm_mulBdDataRule);
                } else {
                    EntityType entityType;
                    EntityType mainType = entityType = (EntityType)dataEntity.getDataEntity().getDataEntityType();
                    DynamicObject mainDynamicObject = dataEntity.getDataEntity();
                    while (mainType.getParent() != null) {
                        mainType = (EntityType)mainType.getParent();
                        mainDynamicObject = (DynamicObject)mainDynamicObject.getParent();
                    }
                    boolean validateResult = false;
                    if (StringUtils.isEmpty((CharSequence)this.dataRuleScript)) {
                        validateResult = true;
                    } else if ("1=1".equals(this.dataRuleScript)) {
                        validateResult = true;
                    } else if ("1!=1".equals(this.dataRuleScript)) {
                        validateResult = false;
                    } else {
                        RowDataModel rowModel = new RowDataModel(entityType.getName(), (MainEntityType)mainType);
                        ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, this.getValidateContext());
                        expContext.getRowDataModel().setRowContext((Object)dataEntity.getDataEntity(), dataEntity.getRowIndex());
                        Object exprValue = null;
                        exprValue = this.subEntityEmptyData && mainType.getName().equals(this.entityNum) ? Boolean.FALSE : CalcExprParser.getExpressionValue((BOSExpression)this.expr, (ExpressionContext)expContext, (FunctionManage)this.getValidateContext().getFuncLib());
                        validateResult = exprValue != null ? (Boolean)exprValue : false;
                    }
                    if (validateResult) {
                        validMainDataEntitySet.add(mainDynamicObject);
                        notValidMainDataEntitySet.remove(mainDynamicObject);
                    } else if (!validMainDataEntitySet.contains(mainDynamicObject)) {
                        notValidMainDataEntitySet.add(mainDynamicObject);
                    }
                }
                ++var5_8;
            }
            ExtendedDataEntity[] mainDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(this.entityNum);
            for (ExtendedDataEntity mainDataEntity : mainDataEntities) {
                if (!notValidMainDataEntitySet.contains(mainDataEntity.getDataEntity())) continue;
                this.addFatalErrorMessage(mainDataEntity, this.getNoPermMsg(PERMTYPE_DATARULE, this.dataRulePermItemId));
            }
        }
        if (!CollectionUtils.isEmpty(this.pkIds)) {
            Map dbCheckResultMap;
            block22: {
                QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", this.pkIds)};
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                dbCheckResultMap = null;
                try {
                    dbCheckResultMap = permissionService.matchDataRule(this.userId, this.bizAppId, this.entityNum, this.dataRulePermItemId, qfilters, new HashMap(8));
                }
                catch (KDException e) {
                    ErrorCode errorCode = e.getErrorCode();
                    if (errorCode != null && ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD.equals(errorCode.getCode())) {
                        this.existMulPropDataRuleAtNotViewPerm = true;
                        this.notSupportMsg_notViewPerm_mulBdDataRule = errorCode.getMessage();
                    }
                    if (this.existMulPropDataRuleAtNotViewPerm) break block22;
                    throw e;
                }
            }
            for (Object e : this.pkIds) {
                Boolean checkBool;
                ExtendedDataEntity dataEntity = this.pkIdAndDyObjMap.get(e);
                if (this.existMulPropDataRuleAtNotViewPerm) {
                    this.addFatalErrorMessage(dataEntity, this.notSupportMsg_notViewPerm_mulBdDataRule);
                    continue;
                }
                if (dbCheckResultMap == null || !Boolean.FALSE.equals(checkBool = (Boolean)dbCheckResultMap.get(e))) continue;
                this.addFatalErrorMessage(dataEntity, this.getNoPermMsg(PERMTYPE_DATARULE, this.dataRulePermItemId));
            }
        }
    }

    private String getPermItemName(String permItemId) {
        String permItemName = "";
        if (StringUtils.isNotEmpty((CharSequence)permItemId)) {
            DynamicObject permItemDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem");
            permItemName = null == permItemDyn ? permItemId : permItemDyn.getString("name");
        }
        return permItemName;
    }

    private static boolean hasEnableOldDataRule() {
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"perm_olddataruleenable");
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    private String getOperatePermItemId() {
        String permissionEntityId = this.getOption().getVariableValue("permissionentityid", "");
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)(StringUtils.isNotBlank((CharSequence)permissionEntityId) ? permissionEntityId : this.entityNum), (String)this.getOperateKey());
        if (operateMetaMap == null) {
            return null;
        }
        return (String)operateMetaMap.get("permission");
    }

    private AppLogInfo buildLogInfo(String msg, MainEntityType mainType) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appId = "";
        String appNumber = this.getOption().getVariableValue("appnumber", "");
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            appNumber = mainType.getAppId();
        }
        if (StringUtils.isNotBlank((CharSequence)appNumber) && !StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(mainType.getName());
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(this.getOperateKey(), this.getOperationName());
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private boolean skipAnonymousValidate(MainEntityType mainType) {
        return mainType.getPermissionControlType().isAnonymousUserControl() && RequestContext.get().getUserId().equalsIgnoreCase("-1");
    }

    private String buildSyntaxErrMessage(String errContext) {
        return String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c\u6570\u636e\u89c4\u5219\u7684\u8868\u8fbe\u5f0f(%3$s)\uff1a%4$s", (String)"FunctionPermValidator_1", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), this.express, errContext);
    }
}

