/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;

class MutexThreadRecorder {
    private static final String THREAD_MUTEX_RECORD = "thread_op_mutex_records.";

    private MutexThreadRecorder() {
    }

    public static boolean isExist(String entityNumber, String billId) {
        Map<String, Set<String>> mutexRecords = MutexThreadRecorder.loadMutexRecords(entityNumber);
        Set<String> ops = mutexRecords.get(billId);
        return ops != null && !ops.isEmpty();
    }

    public static void record(String entityNumber, String billId, String opKey) {
        Map<String, Set<String>> mutexRecords = MutexThreadRecorder.loadMutexRecords(entityNumber);
        Set<String> ops = mutexRecords.get(billId);
        if (ops == null) {
            ops = new HashSet<String>(1);
            mutexRecords.put(billId, ops);
        }
        ops.add(opKey);
    }

    public static void release(String entityNumber, String billId, String opKey) {
        Map<String, Set<String>> mutexRecords = MutexThreadRecorder.loadMutexRecords(entityNumber);
        Set<String> ops = mutexRecords.get(billId);
        if (ops != null) {
            ops.remove(opKey);
            if (ops.isEmpty()) {
                mutexRecords.remove(billId);
            }
        }
    }

    private static Map<String, Set<String>> loadMutexRecords(String entityNumber) {
        String threadVarName = MutexThreadRecorder.buildThreadVarName(entityNumber);
        return (Map)ThreadCache.get((Object)threadVarName, (CacheLoader)new CacheLoader<Map<String, Set<String>>>(){

            public Map<String, Set<String>> load() {
                return new HashMap<String, Set<String>>(10);
            }
        });
    }

    private static String buildThreadVarName(String entityNumber) {
        return THREAD_MUTEX_RECORD + entityNumber;
    }
}

