/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.validate.FieldChecker;
import kd.bos.servicehelper.QueryServiceHelper;

public class SpecialDataPermValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(SpecialDataPermValidator.class);
    private List<ExtendedDataEntity> scriptCheckList = new ArrayList<ExtendedDataEntity>(8);
    private List<Object> pkIds = new ArrayList<Object>(8);
    private String appId = null;
    private Map<Object, ExtendedDataEntity> pkIdAndDyObjMap = new HashMap<Object, ExtendedDataEntity>(8);
    private StringBuilder errorInfo = new StringBuilder();
    private String entityNum = null;
    private String opKey = null;
    private String dataRuleScript = null;
    private boolean skipSpecDataPerm = false;
    private String express = null;
    private BOSExpression expr = null;
    private boolean needCalcExpr = true;
    private boolean subEntityEmptyData = false;

    public Set<String> preparePropertys() {
        this.needCalcExpr = false;
        return super.preparePropertys();
    }

    public void initializeConfiguration() {
        ExtendedDataEntity[] billDataEntities;
        super.initializeConfiguration();
        this.skipSpecDataPerm = Boolean.parseBoolean(this.getOption().getVariableValue("skipCheckSpecialDataPermission", String.valueOf(false)));
        if (this.skipSpecDataPerm) {
            return;
        }
        if (!this.validateContext.isControlFunction()) {
            log.info("this.validateContext.isControlFunction() is false, skip SpecialDataPerm Check.");
            return;
        }
        this.appId = this.getOption().getVariableValue("SpecialDataPerm_CurrentAppId", null);
        this.entityNum = this.validateContext.getEntityNumber();
        this.opKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : billDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(this.entityNum)) {
            Object pkId = dataEntity.getBillPkId();
            boolean isValidPkId = false;
            if (pkId instanceof Long) {
                Long pkIdLong = (Long)pkId;
                isValidPkId = pkId != null && pkIdLong != 0L;
            } else if (pkId instanceof String) {
                String pkIdStr = (String)pkId;
                boolean bl = isValidPkId = pkId != null && StringUtils.isNotBlank((CharSequence)pkIdStr);
            }
            if (this.needCalcExpr || !isValidPkId) {
                this.scriptCheckList.add(dataEntity);
                continue;
            }
            this.pkIds.add(pkId);
            this.pkIdAndDyObjMap.put(pkId, dataEntity);
        }
        MainEntityType mainType = this.validateContext.getSubEntityType();
        if (!CollectionUtils.isEmpty(this.scriptCheckList)) {
            PermissionService permServ = (PermissionService)ServiceFactory.getService(PermissionService.class);
            this.dataRuleScript = permServ.getSpecialDataPermScript(this.appId, this.entityNum, this.opKey, this.errorInfo);
            if (this.expr == null) {
                this.express = this.dataRuleScript;
                this.expr = new BOSExpression(this.express);
                if (this.expr.isError()) {
                    throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
                }
            }
            FieldChecker fieldChecker = new FieldChecker(this.getValidateContext().getSubEntityType());
            fieldChecker.check((Collection)this.expr.getVars());
            if (fieldChecker.isNotExistsFields()) {
                throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728", (String)"SpecialDataPermValidator_1", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])fieldChecker.getNotExistsFields().toArray(), (String)","))));
            }
            if (fieldChecker.isOverEntry()) {
                throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6765\u81ea\u4e8e\u591a\u4e2a\u5355\u636e\u4f53(%s)", (String)"SpecialDataPermValidator_2", (String)"bos-mservice-operation", (Object[])new Object[0]), fieldChecker.getOverEntryNames("+"))));
            }
            Set subEntrys = fieldChecker.getSubEntrys();
            Set entrys = fieldChecker.getEntrys();
            if (!subEntrys.isEmpty()) {
                this.entityKey = ((SubEntryType)subEntrys.iterator().next()).getName();
                ExtendedDataEntity[] subArray = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                if (subArray == null || subArray.length == 0) {
                    this.subEntityEmptyData = true;
                    if (!entrys.isEmpty()) {
                        this.entityKey = ((EntryType)entrys.iterator().next()).getName();
                        ExtendedDataEntity[] array = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                        if (array == null || array.length == 0) {
                            this.entityKey = mainType.getName();
                        }
                    }
                }
            } else if (!entrys.isEmpty()) {
                this.entityKey = ((EntryType)entrys.iterator().next()).getName();
                ExtendedDataEntity[] array = this.getExtendedDataEntitySet().FindByEntityKey(this.entityKey);
                if (array == null || array.length == 0) {
                    this.subEntityEmptyData = true;
                    this.entityKey = mainType.getName();
                }
            } else {
                this.entityKey = mainType.getName();
            }
        }
    }

    public void validate() {
        if (this.skipSpecDataPerm) {
            return;
        }
        if (!this.validateContext.isControlFunction()) {
            return;
        }
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.scriptCheckList)) {
            ExtendedDataEntity[] mainDataEntities;
            HashSet<DynamicObject> notValidMainDataEntitySet = new HashSet<DynamicObject>();
            HashSet<DynamicObject> validMainDataEntitySet = new HashSet<DynamicObject>();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                EntityType entityType;
                EntityType mainType = entityType = (EntityType)dataEntity.getDataEntity().getDataEntityType();
                DynamicObject mainDynamicObject = dataEntity.getDataEntity();
                while (mainType.getParent() != null) {
                    mainType = (EntityType)mainType.getParent();
                    mainDynamicObject = (DynamicObject)mainDynamicObject.getParent();
                }
                boolean validateResult = false;
                if (StringUtils.isEmpty((CharSequence)this.dataRuleScript)) {
                    validateResult = true;
                } else if ("1=1".equals(this.dataRuleScript)) {
                    validateResult = true;
                } else if ("1!=1".equals(this.dataRuleScript)) {
                    validateResult = false;
                } else {
                    RowDataModel rowModel = new RowDataModel(entityType.getName(), (MainEntityType)mainType);
                    ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, this.getValidateContext());
                    expContext.getRowDataModel().setRowContext((Object)dataEntity.getDataEntity(), dataEntity.getRowIndex());
                    Object exprValue = null;
                    exprValue = this.subEntityEmptyData && mainType.getName().equals(this.entityNum) ? Boolean.FALSE : CalcExprParser.getExpressionValue((BOSExpression)this.expr, (ExpressionContext)expContext, (FunctionManage)this.getValidateContext().getFuncLib());
                    validateResult = exprValue != null ? (Boolean)exprValue : false;
                }
                if (validateResult) {
                    validMainDataEntitySet.add(mainDynamicObject);
                    notValidMainDataEntitySet.remove(mainDynamicObject);
                    continue;
                }
                if (validMainDataEntitySet.contains(mainDynamicObject)) continue;
                notValidMainDataEntitySet.add(mainDynamicObject);
            }
            for (ExtendedDataEntity mainDataEntity : mainDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(this.entityNum)) {
                if (!notValidMainDataEntitySet.contains(mainDataEntity.getDataEntity())) continue;
                this.addFatalErrorMessage(mainDataEntity, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7279\u6b8a\u6570\u636e\u6743\u9650(%s)\u3002", (String)"SpecialDataPermValidator_0", (String)"bos-mservice-operation", (Object[])new Object[]{this.errorInfo}));
            }
        }
        if (!CollectionUtils.isEmpty(this.pkIds)) {
            this.errorInfo = new StringBuilder();
            PermissionService permServ = (PermissionService)ServiceFactory.getService(PermissionService.class);
            QFilter specialDataPermFilter = permServ.getOperationRuleFilter(this.appId, this.entityNum, this.opKey, this.errorInfo);
            if (specialDataPermFilter != null) {
                ArrayList<QFilter> allFilterList = new ArrayList<QFilter>();
                allFilterList.add(specialDataPermFilter);
                allFilterList.add(new QFilter("id", "in", this.pkIds));
                DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entityNum, (String)"id", (QFilter[])allFilterList.toArray(new QFilter[0]));
                for (DynamicObject dObj : doc) {
                    Object pkId;
                    if (dObj == null || (pkId = dObj.get("id")) == null) continue;
                    this.pkIdAndDyObjMap.remove(pkId);
                }
                for (ExtendedDataEntity extDataEntity : this.pkIdAndDyObjMap.values()) {
                    this.addFatalErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7279\u6b8a\u6570\u636e\u6743\u9650(%s)\u3002", (String)"SpecialDataPermValidator_0", (String)"bos-mservice-operation", (Object[])new Object[]{this.errorInfo}));
                }
            }
        }
    }

    private String buildSyntaxErrMessage(String errContext) {
        return String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c\u201c%3$s\u201d\u7684\u8868\u8fbe\u5f0f(%4$s)\uff1a%5$s", (String)"SpecialDataPermValidator_4", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), this.errorInfo, this.express, errContext);
    }
}

