/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.entity.validate.ValidatePriorityComparator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.lang.Lang;
import kd.bos.param.ParameterReader;
import kd.bos.service.operation.validate.FunctionPermValidator;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ValidationService {
    private static final String SPAN_TYPE_NAME = "opvalidate";
    private ValidateContext permessionEntityValidateContext;
    private List<AbstractValidator> validators = new ArrayList<AbstractValidator>();
    private boolean splitPage;
    private static Map<String, String> mapperMap = new HashMap<String, String>();
    private OperateLog operateLog = OperateLog.get((boolean)false);
    private String entityId;

    public ValidationService() {
    }

    public ValidationService(String entityId) {
        this();
        this.entityId = entityId;
    }

    public List<AbstractValidator> getValidators() {
        return this.validators;
    }

    public boolean isSplitPage() {
        return this.splitPage;
    }

    public void setSplitPage(boolean splitPage) {
        this.splitPage = splitPage;
    }

    public ValidateContext getPermessionEntityValidateContext() {
        return this.permessionEntityValidateContext;
    }

    public void setPermessionEntityValidateContext(ValidateContext permessionEntityValidateContext) {
        this.permessionEntityValidateContext = permessionEntityValidateContext;
    }

    public OperateLog getOperateLog() {
        return this.operateLog;
    }

    public void setOperateLog(OperateLog operateLog) {
        this.operateLog = operateLog;
    }

    public List<AbstractValidator> buildValidators(List<Map<String, Object>> validationMeta, String operateType, String operateKey, String operateName) {
        ArrayList<AbstractValidator> list = new ArrayList<AbstractValidator>();
        for (Map<String, Object> validatorMap : validationMeta) {
            if (!((Boolean)validatorMap.get("enabled")).booleanValue()) continue;
            if ("RefOtherOpValidate".equals(validatorMap.get("ruleType")) && !"save".equals(operateType)) {
                Map refOpMeta;
                String opKey = (String)validatorMap.get("operationKey");
                if (!StringUtils.isNotBlank((CharSequence)this.entityId) || !StringUtils.isNotBlank((CharSequence)opKey) || (refOpMeta = EntityMetadataCache.getDataEntityOperate((String)this.entityId, (String)opKey)).size() <= 0) continue;
                List refValidateMeta = (List)refOpMeta.get("validations");
                String refOpType = (String)refOpMeta.get("type");
                if (refValidateMeta.size() <= 0) continue;
                String operationName = (String)((Map)refOpMeta.get("name")).get(Lang.get().name());
                list.addAll(this.buildValidators(refValidateMeta, refOpType, opKey, operationName));
                continue;
            }
            String validatorClass = (String)validatorMap.get("class");
            if (StringUtils.isBlank((CharSequence)(validatorClass = this.mapperValidatorCalss(validatorClass)))) continue;
            AbstractValidator validator = (AbstractValidator)TypesContainer.createInstance((String)validatorClass);
            validator.setValidation(validatorMap);
            validator.setOperateKey(operateKey);
            validator.setOperationName(operateName);
            validator.setOperateType(operateType);
            Object levelId = validatorMap.get("levelId");
            String errorLevelStr = levelId != null ? levelId.toString() : "";
            ErrorLevel errorLevel = ErrorLevel.values()[Integer.parseInt(errorLevelStr)];
            validator.setErrorLevel(errorLevel);
            if (!validator.getValidateResult().isSuccess()) continue;
            list.add(validator);
        }
        return list;
    }

    private String mapperValidatorCalss(String srcClass) {
        String target = mapperMap.get(srcClass);
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            return target;
        }
        return srcClass;
    }

    public void addValidator(AbstractValidator validator) {
        this.validators.add(validator);
    }

    public void addAllValidator(List<AbstractValidator> validators) {
        this.validators.addAll(validators);
    }

    public ValidateResultCollection validate(ValidateContext validateContext) {
        if (this.validators.isEmpty()) {
            return new ValidateResultCollection();
        }
        String entityNumber = validateContext.getEntityNumber();
        String operateKey = validateContext.getOperateKey();
        String operateName = validateContext.getOperateName();
        String operateType = validateContext.getOperateType();
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ValidationService.validate");){
            String mustLanStr;
            this.validators.sort((Comparator<AbstractValidator>)new ValidatePriorityComparator());
            for (AbstractValidator validator : this.validators) {
                if (StringUtils.isBlank((CharSequence)validator.getOperationName())) {
                    validator.setOperationName(operateName);
                }
                if (StringUtils.isBlank((CharSequence)validator.getOperateType())) {
                    validator.setOperateType(operateType);
                }
                if (StringUtils.isBlank((CharSequence)validator.getOperateKey())) {
                    validator.setOperateKey(operateKey);
                }
                if (!StringUtils.isBlank((CharSequence)validator.getEntityKey())) continue;
                validator.setEntityKey(entityNumber);
            }
            DynamicObject billParam = ParameterReader.getBillParameter((String)validateContext.getEntityNumber());
            if (billParam != null && StringUtils.isNotBlank((CharSequence)(mustLanStr = billParam.getString("mul_lan_input_setting")))) {
                String[] mustLang = mustLanStr.split(",");
                ArrayList<String> mustLanList = new ArrayList<String>(5);
                for (String lan : mustLang) {
                    if (StringUtils.isEmpty((CharSequence)lan)) continue;
                    mustLanList.add(lan);
                }
                validateContext.setMustInputLang(mustLanList);
            }
            ValidateResultCollection validateResultCollection = this.validate(validateContext, this.validators);
            return validateResultCollection;
        }
    }

    private ValidateResultCollection validate(ValidateContext validateContext, List<AbstractValidator> validators) {
        this.getOperateLog().beginMothed("ValidationService.validate(validateContext, validators)", null);
        this.getOperateLog().beginMothed("ValidationService.setValidateContext(validateContext, validators)", null);
        ValidateResultCollection validateResults = validateContext.getValidateResults();
        if (validateResults == null) {
            validateResults = new ValidateResultCollection();
            validateContext.setValidateResults(validateResults);
        }
        for (AbstractValidator validator : validators) {
            if (validator instanceof FunctionPermValidator) {
                ValidationService.setValidateContext(this.permessionEntityValidateContext != null ? this.permessionEntityValidateContext : validateContext, validator);
                continue;
            }
            ValidationService.setValidateContext(validateContext, validator);
        }
        this.getOperateLog().endMothed("ValidationService.setValidateContext(validateContext, validators)", null);
        this.getOperateLog().beginMothed("ValidationService.doVaidate(validator, validateResults)", null);
        boolean ignoreInteraction = Boolean.parseBoolean(validateContext.getOption().getVariableValue("ignoreinteraction", String.valueOf(false)));
        boolean ignoreWarn = Boolean.parseBoolean(validateContext.getOption().getVariableValue("ignorewarn", String.valueOf(false)));
        for (AbstractValidator validator : validators) {
            if ((ignoreInteraction || ignoreWarn) && validator.getErrorLevl() == ErrorLevel.Warning) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)(validator.getClass().getName() + "validate"));
            Throwable throwable = null;
            try {
                if (span.isRealtime()) {
                    span.addLocaleTag("validation", (Object)validator.getValidation());
                }
                this.doVaidate(validator, validateResults);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        this.getOperateLog().endMothed("ValidationService.doVaidate(validator, validateResults)", null);
        this.getOperateLog().endMothed("ValidationService.validate(validateContext, validators)", null);
        return validateResults;
    }

    static void setValidateContext(ValidateContext validateContext, AbstractValidator validator) {
        ExtendedDataEntitySet entitySet = validateContext.getExtendedDataEntitySet();
        validator.setValidateContext(validateContext);
        validator.setExtendedDataEntitySet(entitySet);
        validator.initializeConfiguration();
        if (StringUtils.isBlank((CharSequence)validator.getEntityKey())) {
            return;
        }
        ExtendedDataEntity[] array = entitySet.FindByEntityKey(validator.getEntityKey());
        BOSExpression preConditin = validator.getPreConditionExpr();
        if (array != null && preConditin != null && preConditin.getExpr() != null) {
            RowDataModel rowModel = new RowDataModel(validator.getEntityKey(), validateContext.getSubEntityType());
            ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, validateContext);
            ArrayList<ExtendedDataEntity> passRows = new ArrayList<ExtendedDataEntity>();
            for (ExtendedDataEntity row : array) {
                expContext.getRowDataModel().setRowContext((Object)row.getDataEntity(), row.getRowIndex());
                Object pass = CalcExprParser.getExpressionValue((BOSExpression)preConditin, (ExpressionContext)expContext, (FunctionManage)validateContext.getFuncLib());
                if (pass == null || !((Boolean)pass).booleanValue()) continue;
                passRows.add(row);
            }
            array = passRows.toArray(new ExtendedDataEntity[passRows.size()]);
        }
        if (array == null || array.length == 0) {
            return;
        }
        validator.setDataEntities(array);
        validator.initialize();
    }

    private void doVaidate(AbstractValidator validator, ValidateResultCollection validateResults) {
        if (validator.getDataEntities() == null || validator.getDataEntities().length == 0) {
            return;
        }
        if (this.isSplitPage() && !validator.isSupportSplitPageMode()) {
            return;
        }
        String validateName = String.format("%s.validate()", validator.getClass().getName());
        this.getOperateLog().beginMothed(validateName, null);
        validator.validate();
        ValidateResult res = validator.getValidateResult();
        if (!res.isSuccess()) {
            boolean isExist = false;
            ArrayList<String> errMsgs = new ArrayList<String>();
            for (ValidateResult rs : validateResults.getValidateErrors()) {
                for (OperateErrorInfo operInfo : rs.getAllErrorInfo()) {
                    String errMsg = operInfo.getMessage();
                    errMsgs.add(errMsg);
                }
            }
            for (OperateErrorInfo operInfo : res.getAllErrorInfo()) {
                String errMsg = operInfo.getMessage();
                if (!errMsgs.contains(errMsg)) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                validateResults.addValidateError(validator.getOperationName(), res);
            }
        }
        this.getOperateLog().endMothed(validateName, null);
    }

    static {
        mapperMap.put("kd.bos.service.operation.validate.InProcessValidator", "kd.bos.workflow.facade.validate.InProcessValidator");
    }
}

