/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IModelCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.DataModelCacheRepository;
import kd.bos.entity.datamodel.EntryFilterHandler;
import kd.bos.entity.datamodel.IDataModelRepository;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;

class DataModelLocalRepository
implements IDataModelRepository {
    private DynamicObject dataEntity;
    private AbstractFormDataModel model;
    private DataModelCacheRepository cacheRepository;
    private EntryFilterHandler entryFilterHandler;

    public DataModelLocalRepository(AbstractFormDataModel model, DynamicObject dataEntity) {
        this.model = model;
        this.dataEntity = dataEntity;
        this.entryFilterHandler = new EntryFilterHandler(this.model);
    }

    public DataModelLocalRepository(AbstractFormDataModel model, DynamicObject dataEntity, DataModelCacheRepository cacheRepository) {
        this(model, dataEntity);
        this.cacheRepository = cacheRepository;
    }

    private DataModelCacheRepository getCacheRepository() {
        if (this.cacheRepository == null) {
            this.cacheRepository = new DataModelCacheRepository(this.model);
        }
        return this.cacheRepository;
    }

    private IModelCache getCache() {
        return this.getCacheRepository().getCache();
    }

    public void updateCache(String pageId) {
        IModelCache cache = this.getCache();
        if (this.model.getDataEntityType().getProperties().size() > 0) {
            cache.storeAll(this.dataEntity);
            cache.setRemovedItemFlag(this.dataEntity.getDataEntityState().getRemovedItems());
        }
    }

    public void updateEntryCache(String pageId, DynamicObjectCollection coll) {
        IModelCache cache = this.getCache();
        cache.storeEntry(coll);
    }

    public void addNewRows(String entryName, DynamicObject[] entryRows) {
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(entryName)) {
            DynamicObjectCollection cols = this.getEntry(entryName);
            if (cols == null) {
                return;
            }
            for (DynamicObject entryRow : entryRows) {
                cols.add((Object)entryRow);
                this.entryFilterHandler.appendRK(entryName, entryRow.getInt("seq") - 1);
            }
        } else {
            this.getCacheRepository().addNewRows(entryName, entryRows);
        }
    }

    public void insertEntryRow(EntryProp prop, int row, DynamicObject entity) {
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(prop.getName())) {
            this.insertEntryRowsLocalHandle(prop, row, new DynamicObject[]{entity});
            this.entryFilterHandler.insertRkBefore(prop.getName(), row);
        } else {
            this.getCacheRepository().insertEntryRow(prop, row, entity);
        }
    }

    public void insertEntryRow(String entryKey, int row, DynamicObject[] entity) {
        EntryProp prop = (EntryProp)this.model.getProperty(entryKey);
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(prop.getName())) {
            this.insertEntryRowsLocalHandle(prop, row, entity);
            this.entryFilterHandler.insertRkBefore(prop.getName(), row);
        } else {
            this.getCacheRepository().insertEntryRow(prop.getName(), row, entity);
        }
    }

    public void appendEntryRows(EntryProp prop, int row, DynamicObject[] entryRows) {
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(prop.getName())) {
            this.insertEntryRowsLocalHandle(prop, row, entryRows);
            int[] rows = new int[entryRows.length];
            for (int i = 0; i < entryRows.length; ++i) {
                rows[i] = entryRows[i].getInt("seq") - 1;
            }
            this.entryFilterHandler.insertRkAfter(prop.getName(), rows);
        } else {
            this.getCacheRepository().appendEntryRows(prop, row, entryRows);
        }
    }

    private void insertEntryRowsTableCacheHandle(EntryProp prop, int row, DynamicObject[] entryRows) {
        for (DynamicObject entity : entryRows) {
            DynamicObjectCollection cols = this.getEntry(prop.getName());
            DynamicProperty seqProp = cols.getDynamicObjectType().getProperty("seq");
            boolean success = false;
            for (int index = row; index >= 0; --index) {
                int seq;
                if (index >= cols.size() || (seq = ((Integer)seqProp.getValueFast(cols.get(index))).intValue()) != row + 1) continue;
                cols.add(index, entity);
                success = true;
                break;
            }
            if (success) continue;
            cols.add((Object)entity);
        }
    }

    private void insertEntryRowsLocalHandle(EntryProp prop, int row, DynamicObject[] entryRows) {
        for (DynamicObject entity : entryRows) {
            DynamicObjectCollection cols = this.getEntry(prop.getName());
            int start = cols.getStartRowIndex();
            cols.add(row - start, entity);
            this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
        }
    }

    public void moveEntryBlockRows(EntryProp prop, int startIndex, int len, int toIndex) {
        int i;
        DynamicObjectCollection cols = this.getEntry(prop.getName());
        ArrayList<Object> rows = new ArrayList<Object>(len);
        for (i = 0; i < len; ++i) {
            rows.add(cols.get(startIndex + i));
        }
        for (i = startIndex; i < startIndex + len; ++i) {
            cols.remove(i);
            cols.add(toIndex, (DynamicObject)rows.get(i - startIndex));
        }
        int start = cols.getStartRowIndex();
        this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
        ((DynamicObject)cols.getParent()).getLastDirty().set(prop.getOrdinal(), true);
    }

    public void moveEntryBlockRows(EntryProp prop, int[] formIndexs, int toIndex) {
        int i;
        DynamicObjectCollection cols = this.getEntry(prop.getName());
        Boolean removedFlag = ((DynamicObject)cols.getParent()).getDataEntityState().getRemovedItems();
        ArrayList<Object> rows = new ArrayList<Object>(formIndexs.length);
        for (i = 0; i < formIndexs.length; ++i) {
            rows.add(cols.get(formIndexs[i]));
        }
        for (i = formIndexs.length - 1; i >= 0; --i) {
            cols.remove(formIndexs[i]);
            if (formIndexs[i] > toIndex) continue;
            --toIndex;
        }
        for (i = formIndexs.length - 1; i >= 0; --i) {
            cols.add(toIndex + 1, (DynamicObject)rows.get(i));
        }
        int start = cols.getStartRowIndex();
        this.reSetSubEntrySeqAfterDelete(start, cols, (IDataEntityType)cols.getDynamicObjectType());
        ((DynamicObject)cols.getParent()).getDataEntityState().setRemovedItems(removedFlag);
    }

    public void swapEntryRow(String entryName, int rowIndex1, int rowIndex2) {
        DynamicObjectCollection col = this.getEntry(entryName);
        int start = col.getStartRowIndex();
        DynamicObject row1 = (DynamicObject)col.get(rowIndex1 - start);
        DynamicObject row2 = (DynamicObject)col.get(rowIndex2 - start);
        col.set(rowIndex1 - start, (Object)row2);
        col.set(rowIndex2 - start, (Object)row1);
        row1.set("seq", (Object)(rowIndex2 + 1));
        row2.set("seq", (Object)(rowIndex1 + 1));
    }

    public DynamicObject getDataEntityByField(IDataEntityProperty prop, int rowIndex, int parentRowIndex) {
        IDataEntityType parent4;
        IDataEntityType parent1 = prop.getParent();
        IDataEntityType parent2 = parent1 != null ? parent1.getParent() : null;
        IDataEntityType parent3 = parent2 != null ? parent2.getParent() : null;
        IDataEntityType iDataEntityType = parent4 = parent3 != null ? parent3.getParent() : null;
        if (parent1 instanceof MainEntityType) {
            return this.dataEntity;
        }
        if (parent2 instanceof MainEntityType) {
            String entryName = prop.getParent().getName();
            return this.getEntryRow(entryName, rowIndex);
        }
        if (parent3 instanceof MainEntityType) {
            DynamicObject entryRow;
            IDataEntityType entryType = parent2;
            IDataEntityType subEntryType = parent1;
            String entryTypeName = null;
            if (entryType != null && StringUtils.isNotEmpty((CharSequence)entryType.getName())) {
                entryTypeName = entryType.getName();
            }
            String subEntryTypeName = null;
            if (entryType != null && StringUtils.isNotEmpty((CharSequence)subEntryType.getName())) {
                subEntryTypeName = subEntryType.getName();
            }
            if (parentRowIndex < 0) {
                parentRowIndex = this.model.getEntryCurrentRowIndex(entryTypeName);
            }
            if ((entryRow = this.getEntryRow(entryTypeName, parentRowIndex)) == null) {
                return null;
            }
            IDataEntityProperty subEntryProp = this.model.getProperty(subEntryTypeName);
            DynamicObjectCollection subEntryRows = (DynamicObjectCollection)subEntryProp.getValueFast((Object)entryRow);
            int subEntryRowIndex = rowIndex;
            if (subEntryRows.size() <= subEntryRowIndex || subEntryRowIndex < 0) {
                return null;
            }
            return (DynamicObject)subEntryRows.get(subEntryRowIndex);
        }
        if (parent4 instanceof MainEntityType) {
            int subEntryRowIndex;
            IDataEntityType entryType = parent3;
            IDataEntityType subEntryType = parent2;
            IDataEntityType linkEntryType = parent1;
            String entryTypeName = null;
            if (entryType != null && StringUtils.isNotEmpty((CharSequence)entryType.getName())) {
                entryTypeName = entryType.getName();
            }
            String subEntryTypeName = null;
            if (entryType != null && StringUtils.isNotEmpty((CharSequence)subEntryType.getName())) {
                subEntryTypeName = subEntryType.getName();
            }
            int entryRowIndex = this.model.getEntryCurrentRowIndex(entryTypeName);
            if (entryTypeName == null) {
                return null;
            }
            DynamicObject entryRow = this.getEntryRow(entryTypeName, entryRowIndex);
            if (entryRow == null) {
                return null;
            }
            DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection(subEntryTypeName);
            int n = subEntryRowIndex = parentRowIndex >= 0 ? parentRowIndex : this.model.getEntryCurrentRowIndex(subEntryTypeName);
            if (subEntryRows.size() <= subEntryRowIndex || subEntryRowIndex < 0) {
                return null;
            }
            DynamicObject subEntryRow = (DynamicObject)subEntryRows.get(subEntryRowIndex);
            DynamicObjectCollection linkEntryRows = subEntryRow.getDynamicObjectCollection(linkEntryType.getName());
            int linkEntryRowIndex = rowIndex;
            if (linkEntryRows.size() <= linkEntryRowIndex || linkEntryRowIndex < 0) {
                return null;
            }
            return (DynamicObject)linkEntryRows.get(linkEntryRowIndex);
        }
        return null;
    }

    public int getEntryRowCount(String entryKey) {
        if (this.getCacheRepository().isTableCacheAndSpiltPage(entryKey)) {
            return this.getCacheRepository().getEntryRowCount(entryKey);
        }
        DynamicObjectCollection col = this.getEntry(entryKey);
        if (col == null) {
            return 0;
        }
        return col.getRowCount();
    }

    public DynamicObject getAll() {
        return this.dataEntity;
    }

    public void deleteEntryRow(String entryKey, int rowIndex) {
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(entryKey)) {
            DynamicObjectCollection collection = this.getEntry(entryKey);
            if (collection == null || collection.size() == 0) {
                return;
            }
            int start = collection.getStartRowIndex();
            collection.remove(rowIndex - start);
            this.entryFilterHandler.removeRK(entryKey, new int[]{rowIndex});
            this.reSetSubEntrySeqAfterDelete(start, collection, (IDataEntityType)collection.getDynamicObjectType());
            this.setRemovedItemFlag(true);
        } else {
            this.getCacheRepository().deleteEntryRow(entryKey, rowIndex);
        }
    }

    public void deleteEntryRows(String entryKey, int[] rows) {
        if (!this.getCacheRepository().isTableCacheAndSpiltPage(entryKey)) {
            DynamicObjectCollection col = this.getEntry(entryKey);
            int[] sorted_rows = Arrays.copyOf(rows, rows.length);
            Arrays.sort(sorted_rows);
            int start = col.getStartRowIndex();
            for (int i = rows.length - 1; i >= 0; --i) {
                col.remove(sorted_rows[i] - start);
            }
            this.entryFilterHandler.removeRK(entryKey, rows);
            this.reSetSubEntrySeqAfterDelete(start, col, (IDataEntityType)col.getDynamicObjectType());
            if (rows.length > 0) {
                this.setRemovedItemFlag(true);
            }
        } else {
            this.getCacheRepository().deleteEntryRows(entryKey, rows);
        }
    }

    private List<DynamicObject> reSetSubEntrySeqAfterDelete(int start, DynamicObjectCollection cols, IDataEntityType itemType) {
        IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast(cols.get(i), (Object)(start + i + 1));
            }
        }
        return cols;
    }

    public void deleteEntryData(String entryKey) {
        if (this.getCacheRepository().isTableCacheAndSpiltPage(entryKey)) {
            this.getCacheRepository().deleteEntryData(entryKey);
            DynamicObjectCollection col = this.getEntry(entryKey);
            col.clear();
        } else {
            DynamicObjectCollection col = this.getEntry(entryKey);
            col.clear();
            this.entryFilterHandler.clearFilterRKList(entryKey);
            this.setRemovedItemFlag(true);
        }
    }

    public DynamicObject getEntryRow(String entryKey, int rowIndex) {
        if (entryKey == null) {
            return null;
        }
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop.getParent() instanceof EntryType) {
            int parentIndex;
            String parentName = prop.getParent().getName();
            DynamicObject parentRow = this.getEntryRow(parentName, parentIndex = this.model.getEntryCurrentRowIndex(parentName));
            if (parentRow == null) {
                return null;
            }
            DynamicObjectCollection coll = (DynamicObjectCollection)prop.getValueFast((Object)parentRow);
            int start = coll.getStartRowIndex();
            return (DynamicObject)coll.get(rowIndex - start);
        }
        if (prop instanceof EntryProp) {
            if (this.getCacheRepository().isTableCacheAndSpiltPage(prop.getName()) && !this.getCacheRepository().isInBatch1(prop.getName(), rowIndex)) {
                return this.getCacheRepository().getEntryRow(entryKey, rowIndex);
            }
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)this.dataEntity);
            int start = cols.getStartRowIndex();
            if ((rowIndex -= start) >= cols.size() || rowIndex < 0) {
                return null;
            }
            return (DynamicObject)cols.get(rowIndex);
        }
        return null;
    }

    public DynamicObject getEntryRow(String entryKey, int rowIndex, int parentRowIndex) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop.getParent() instanceof EntryType) {
            DynamicObject parentRow;
            String parentName = prop.getParent().getName();
            if (parentRowIndex == -1) {
                parentRowIndex = this.model.getEntryCurrentRowIndex(parentName);
            }
            if ((parentRow = this.getEntryRow(parentName, parentRowIndex)) == null) {
                return null;
            }
            DynamicObjectCollection coll = (DynamicObjectCollection)prop.getValueFast((Object)parentRow);
            int start = coll.getStartRowIndex();
            return (DynamicObject)coll.get(rowIndex - start);
        }
        if (prop instanceof EntryProp) {
            if (this.getCacheRepository().isTableCacheAndSpiltPage(prop.getName()) && !this.getCacheRepository().isInBatch1(prop.getName(), rowIndex)) {
                return this.getCacheRepository().getEntryRow(entryKey, rowIndex);
            }
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)this.dataEntity);
            int start = cols.getStartRowIndex();
            if ((rowIndex -= start) >= cols.size() || rowIndex < 0) {
                return null;
            }
            return (DynamicObject)cols.get(rowIndex);
        }
        return null;
    }

    public DynamicObjectCollection getEntry(String entryKey) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop.getParent() instanceof EntryType) {
            int parentIndex;
            String parentName = prop.getParent().getName();
            DynamicObject parentRow = this.getEntryRow(parentName, parentIndex = this.model.getEntryCurrentRowIndex(parentName));
            if (parentRow == null) {
                return null;
            }
            return (DynamicObjectCollection)prop.getValueFast((Object)parentRow);
        }
        return (DynamicObjectCollection)prop.getValueFast((Object)this.dataEntity);
    }

    public DynamicObject getRootEntity() {
        return this.dataEntity;
    }

    public DynamicObject[] getEntry(String entryKey, int startRowIndex, int endRowIndex) {
        Object ret;
        if (this.getCacheRepository().isTableCacheAndSpiltPage(entryKey) && !this.getCacheRepository().isInBatch1(entryKey, endRowIndex - 1)) {
            return this.getCacheRepository().getEntry(entryKey, startRowIndex, endRowIndex);
        }
        DynamicObjectCollection cols = this.getEntry(entryKey);
        if (cols == null || cols.getRowCount() == 0 || cols.size() == 0 && cols.getStartRowIndex() > 0) {
            return new DynamicObject[0];
        }
        int startRow = startRowIndex - cols.getStartRowIndex();
        int endRow = endRowIndex - cols.getStartRowIndex();
        if (startRow == 0 && endRow == cols.size()) {
            ret = cols;
        } else {
            if (endRow > cols.size()) {
                endRow = cols.size();
            }
            ret = cols.subList(startRow, endRow);
        }
        return ret.toArray(new DynamicObject[ret.size()]);
    }

    public void setRemovedItemFlag(Boolean b) {
        this.dataEntity.getDataEntityState().setRemovedItems(b);
    }

    public void release() {
        this.dataEntity = null;
    }

    public void cacheExpireAfter(int timeout) {
    }

    public boolean isExistDataEntity() {
        return this.dataEntity != null;
    }

    public void filterEntry(String entryKey, EntryQueryParam queryParam) {
        if (this.getCacheRepository().isTableCache()) {
            this.getCacheRepository().filterEntry(entryKey, queryParam);
        } else {
            this.entryFilterHandler.filterEntry(entryKey, queryParam, this.getEntry(entryKey));
        }
    }

    public int getFilterEntryRowCount(String entryKey) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().getFilterEntryRowCount(entryKey);
        }
        if (this.model.isFilterAndSortModel(entryKey)) {
            return this.entryFilterHandler.getFilterEntryRowCount(entryKey, this.getEntry(entryKey));
        }
        return this.getEntryRowCount(entryKey);
    }

    public DynamicObject[] getFilterEntryRows(String entryKey, int startRowIndex, int endRowIndex) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().getFilterEntryRows(entryKey, startRowIndex, endRowIndex);
        }
        boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            return this.entryFilterHandler.getFilterEntryRows(entryKey, startRowIndex, endRowIndex, this.getEntry(entryKey));
        }
        return this.getEntry(entryKey, startRowIndex, endRowIndex);
    }

    public List<Integer> getFilterEntryRowKeys(String entryKey, int startRowIndex, int endRowIndex) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().getFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
        }
        return this.entryFilterHandler.getFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
    }

    public List<Integer> getFilterIndexByRowKeys(String entryKey, List<Integer> rowkeyList) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().getFilterIndexByRowKeys(entryKey, rowkeyList);
        }
        boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            return this.entryFilterHandler.getFilterIndexByRowKeys(entryKey, rowkeyList);
        }
        return rowkeyList;
    }

    public List<Integer> filterSortByRowKeys(String entryKey, List<Integer> rowkeyList) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().filterSortByRowKeys(entryKey, rowkeyList);
        }
        boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            return this.entryFilterHandler.filterSortByRowKeys(entryKey, rowkeyList);
        }
        return rowkeyList;
    }

    public boolean isFilterAndSortModel(String entryKey) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().isFilterAndSortModel(entryKey);
        }
        return this.entryFilterHandler.isFilterAndSortModel(entryKey);
    }

    public EntryQueryParam getEntryQueryParam(String entryKey) {
        if (this.getCacheRepository().isTableCache()) {
            return this.getCacheRepository().getEntryQueryParam(entryKey);
        }
        return this.entryFilterHandler.getEntryQueryParam(entryKey);
    }
}

