/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.entity.property.entryfilter.EntrySortItemInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class EntryFilterHandler {
    private static final Log log = LogFactory.getLog(EntryFilterHandler.class);
    private AbstractFormDataModel model;
    private static final String TYPE_NAME = "EntryFilterHandler";
    private static final String SPAN_QUERYPARAM = "queryParam";
    private static final String SPAN_ENTRYKEY = "entrykey";
    private static final String SPAN_SORTCOLUMN = "sortcolumn";
    private static final String SPAN_SORTSTYLE = "sortstyle";
    private static final String SPAN_FILTERSCRIPT = "filterScript";
    private static final String SPAN_PARENTINDEX = "parentIndex";
    private static final String ENTRY_FILTER_RK_LIST = "filterRk";
    private static final String ENTRY_QUERYPARAM = "entryQueryParam";
    private static final String ENTRY_ISFILTER = "entryIsFilter";
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private ArrayList<Integer> filterRKList;
    private RowDataModel rowDataModel;

    public EntryFilterHandler(AbstractFormDataModel model) {
        this.model = model;
    }

    public void setDataModel(IDataModel model) {
        this.model = (AbstractFormDataModel)model;
    }

    public void appendRK(String entryKey, int rowIndex) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        this.filterRKList.add(rowIndex);
    }

    public void removeRK(String entryKey, int[] rows) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(rows.length);
        for (int row : rows) {
            list.add(row);
        }
        Iterator<Integer> iterator = this.filterRKList.iterator();
        int minIndex = this.filterRKList.size() - 1;
        int index = 0;
        while (iterator.hasNext()) {
            Integer val = iterator.next();
            if (list.contains(val)) {
                iterator.remove();
                if (index < minIndex) {
                    minIndex = index;
                }
            }
            ++index;
        }
        for (int i = 0; i < this.filterRKList.size(); ++i) {
            int val = this.filterRKList.get(i);
            int count = 0;
            for (int row : rows) {
                if (val < row) continue;
                ++count;
            }
            this.filterRKList.set(i, val - count);
        }
    }

    public void insertRkBefore(String entryKey, int rowIndex) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        int insertIndex = -1;
        for (int i = 0; i < this.filterRKList.size(); ++i) {
            int val = this.filterRKList.get(i);
            if (val >= rowIndex) {
                this.filterRKList.set(i, val + 1);
            }
            if (val != rowIndex) continue;
            insertIndex = i;
        }
        if (insertIndex > -1) {
            this.filterRKList.add(insertIndex, rowIndex);
        }
    }

    public void insertRkAfter(String entryKey, int[] rows) {
        int i;
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return;
        }
        if (rows == null || rows.length == 0) {
            return;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        int index = rows[0] - 1;
        int insertIndex = -1;
        for (i = 0; i < this.filterRKList.size(); ++i) {
            int val = this.filterRKList.get(i);
            if (val > index) {
                this.filterRKList.set(i, val + rows.length);
            }
            if (val != index) continue;
            insertIndex = i + 1;
        }
        if (insertIndex > -1) {
            for (i = 0; i < rows.length; ++i) {
                this.filterRKList.add(insertIndex, rows[i]);
            }
        }
    }

    public void clearFilterRKList(String entryKey) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        if (this.filterRKList != null) {
            this.filterRKList.clear();
        }
    }

    public ArrayList<Integer> getFilterRkList(String entryKey) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return null;
        }
        Map<String, Object> entryState = this.model.getEntryState(entryKey);
        if (entryState.get(ENTRY_FILTER_RK_LIST) == null) {
            entryState.put(ENTRY_FILTER_RK_LIST, new ArrayList());
        }
        this.filterRKList = (ArrayList)entryState.get(ENTRY_FILTER_RK_LIST);
        return this.filterRKList;
    }

    public void setFilterRkList(String entryKey, ArrayList<Integer> filterRKListTemp) {
        Map<String, Object> entryState = this.model.getEntryState(entryKey);
        entryState.put(ENTRY_FILTER_RK_LIST, filterRKListTemp);
        this.filterRKList = filterRKListTemp;
    }

    private void setEntryQueryParam(String entryKey, EntryQueryParam queryParam) {
        this.model.getEntryState(entryKey).put(ENTRY_QUERYPARAM, SerializationUtils.toJsonString((Object)queryParam));
        this.model.getEntryState(entryKey).put(ENTRY_ISFILTER, queryParam.needFilterAndSort());
    }

    private void sort(List<DynamicObject> list, final String fieldName, final boolean isAsc) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"sort");){
            span.addTag(SPAN_SORTCOLUMN, fieldName);
            span.addTag(SPAN_SORTSTYLE, String.valueOf(isAsc));
            Collections.sort(list, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject a, DynamicObject b) {
                    int ret = 0;
                    try {
                        ret = EntryFilterHandler.this.compareObject(fieldName, isAsc, a, b);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    return ret;
                }
            });
        }
    }

    private int compareObject(String fieldName, boolean isAsc, DynamicObject a, DynamicObject b) {
        Object value1 = this.getValue(a, fieldName);
        Object value2 = this.getValue(b, fieldName);
        String str1 = null;
        String str2 = null;
        if (value1 != null) {
            str1 = value1.toString();
        }
        if (value2 != null) {
            str2 = value2.toString();
        }
        boolean isNegative = false;
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = this.addZero2Str((Number)value1, maxlen);
            str2 = this.addZero2Str((Number)value2, maxlen);
            if (str1.startsWith("-") && str2.startsWith("-")) {
                isNegative = true;
            }
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = this.addZero2Str(time1, maxlen);
            str2 = this.addZero2Str(time2, maxlen);
        } else if (value1 instanceof OrmLocaleValue && value2 instanceof OrmLocaleValue) {
            str1 = ((OrmLocaleValue)value1).getLocaleValue();
            str2 = ((OrmLocaleValue)value2).getLocaleValue();
        }
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        int ret = isAsc ? str1.compareTo(str2) : str2.compareTo(str1);
        if (isNegative) {
            return -ret;
        }
        return ret;
    }

    private String addZero2Str(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    private Object getValue(DynamicObject entryRow, String fieldName) {
        RowDataModel rowDataModel = this.getRowDataModel(entryRow);
        rowDataModel.setRowContext(entryRow);
        OutValue ref = new OutValue();
        if (rowDataModel.tryGetValue(fieldName, ref).booleanValue()) {
            Object item = ref.get();
            if (item instanceof String) {
                item = ((String)item).trim();
            } else if (item instanceof OrmLocaleValue) {
                item = ((OrmLocaleValue)item).getLocaleValue();
            }
            return item;
        }
        return null;
    }

    private RowDataModel getRowDataModel(DynamicObject entryRow) {
        if (this.rowDataModel == null) {
            IDataEntityType entryType = entryRow.getDataEntityType();
            IDataEntityType dt = entryType.getParent();
            if (dt instanceof EntryType) {
                dt = dt.getParent();
            }
            this.rowDataModel = new RowDataModel(entryType.getName(), (MainEntityType)dt);
        }
        return this.rowDataModel;
    }

    public void filterEntry(String entryKey, EntryQueryParam queryParam, DynamicObjectCollection entryCollection) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"filterEntry");){
            if (span.isRealtime()) {
                span.addTag(SPAN_ENTRYKEY, entryKey);
                span.addTag(SPAN_PARENTINDEX, String.valueOf(queryParam.getParentIndex()));
                span.addLocaleTag(SPAN_QUERYPARAM, (Object)SerializationUtils.toJsonString((Object)queryParam));
            }
            if (entryCollection == null) {
                return;
            }
            this.setEntryQueryParam(entryKey, queryParam);
            if (!queryParam.needFilterAndSort()) {
                return;
            }
            List<DynamicObject> filterDataEntities = this.filterHandle(entryKey, queryParam, entryCollection, span);
            filterDataEntities = this.sortHandle(filterDataEntities, queryParam, entryCollection);
            this.clearFilterRKList(entryKey);
            if (filterDataEntities == null) {
                return;
            }
            ArrayList<Integer> filterRKList = new ArrayList<Integer>(filterDataEntities.size());
            for (int i = 0; i < filterDataEntities.size(); ++i) {
                filterRKList.add(filterDataEntities.get(i).getInt("seq") - 1);
            }
            this.setFilterRkList(entryKey, filterRKList);
            return;
        }
    }

    private List<DynamicObject> filterHandle(String entryKey, EntryQueryParam queryParam, DynamicObjectCollection entryCollection, EntityTraceSpan span) {
        RowDataModel rowModel;
        ExpressionParameter parameter;
        if (CollectionUtils.isEmpty((Collection)queryParam.getFilterItems()) && CollectionUtils.isEmpty((Collection)queryParam.getDefaultFilterRows())) {
            return null;
        }
        FilterBuilder builder = new FilterBuilder(this.model.getMainEntityType(), queryParam.buildFilterCondition());
        String[] filterScripts = builder.buildFilterScript();
        if (filterScripts == null || filterScripts.length == 0 || StringUtils.isEmpty((CharSequence)filterScripts[0])) {
            return null;
        }
        ArrayList<DynamicObject> entryFilterDataEntities = new ArrayList<DynamicObject>(128);
        String preCondition = filterScripts[0];
        if (span.isRealtime()) {
            span.addTag(SPAN_FILTERSCRIPT, preCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)(parameter = new ExpressionParameter(preCondition, rowModel = new RowDataModel(entryKey, (IDataModel)this.model))).getBOSExpression().getErrMessage())) {
            if (span.isRealtime()) {
                span.addTag("ExpressionErrMessage", parameter.getBOSExpression().getErrMessage());
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u503c\u4e2d\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"EntryFilterHandler_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        }
        for (int i = 0; i < entryCollection.size(); ++i) {
            DynamicObject dataEntity = (DynamicObject)entryCollection.get(i);
            parameter.setActiveRow((Object)dataEntity);
            parameter.setRowIndex(i);
            Object expValue = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
            if (expValue == null || !((Boolean)expValue).booleanValue()) continue;
            entryFilterDataEntities.add(dataEntity);
        }
        return entryFilterDataEntities;
    }

    private List<DynamicObject> sortHandle(List<DynamicObject> entryFilterDataEntities, EntryQueryParam queryParam, DynamicObjectCollection entryCollection) {
        List itemInfoList = queryParam.getSortItems();
        if (CollectionUtils.isEmpty((Collection)itemInfoList)) {
            return entryFilterDataEntities;
        }
        EntrySortItemInfo entrySortItemInfo = (EntrySortItemInfo)itemInfoList.get(0);
        String sortColumnName = entrySortItemInfo.getSortColumnName();
        if (StringUtils.isBlank((CharSequence)sortColumnName) || entrySortItemInfo.getSortStyle() == 0) {
            return entryFilterDataEntities;
        }
        if (StringUtils.isNotBlank((CharSequence)entrySortItemInfo.getRealFieldName())) {
            sortColumnName = entrySortItemInfo.getRealFieldName();
        } else {
            String[] displayProps = entrySortItemInfo.getDisplayProps();
            if (displayProps != null && displayProps.length > 0) {
                sortColumnName = sortColumnName + "." + displayProps[0];
            }
        }
        if (entryFilterDataEntities == null) {
            entryFilterDataEntities = new ArrayList<DynamicObject>(entryCollection.size());
            for (int i = 0; i < entryCollection.size(); ++i) {
                entryFilterDataEntities.add((DynamicObject)entryCollection.get(i));
            }
        }
        boolean isAsc = entrySortItemInfo.getSortStyle() == 1;
        this.sort(entryFilterDataEntities, sortColumnName, isAsc);
        return entryFilterDataEntities;
    }

    public int getFilterEntryRowCount(String entryKey, DynamicObjectCollection entryCollection) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRowCount");){
            span.addTag(SPAN_ENTRYKEY, entryKey);
            EntryQueryParam queryParam = this.model.getEntryQueryParam(entryKey);
            this.subEntryIsNeedReFilter(entryKey, entryCollection, queryParam);
            int n = this.getFilterRkList(entryKey).size();
            return n;
        }
    }

    public DynamicObject[] getFilterEntryRows(String entryKey, int startRowIndex, int endRowIndex, DynamicObjectCollection entryCollection) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRows");){
            span.addTag(SPAN_ENTRYKEY, entryKey);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            EntryQueryParam queryParam = this.model.getEntryQueryParam(entryKey);
            this.subEntryIsNeedReFilter(entryKey, entryCollection, queryParam);
            ArrayList<Integer> filterRkList = this.getFilterRkList(entryKey);
            ArrayList<Object> dynamicObjects = new ArrayList<Object>(endRowIndex - startRowIndex);
            for (int i = startRowIndex; i < endRowIndex; ++i) {
                dynamicObjects.add(entryCollection.get(filterRkList.get(i).intValue()));
            }
            DynamicObject[] dynamicObjectArray = dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
            return dynamicObjectArray;
        }
    }

    public List<Integer> getFilterEntryRowKeys(String entryKey, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRowKeys");){
            span.addTag(SPAN_ENTRYKEY, entryKey);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            boolean isFilterAndSortModel = this.model.isFilterAndSortModel(entryKey);
            if (isFilterAndSortModel) {
                ArrayList<Integer> filterRkList = this.getFilterRkList(entryKey);
                endRowIndex = Math.min(filterRkList.size(), endRowIndex);
                ArrayList<Integer> rowKeys = new ArrayList<Integer>(endRowIndex - startRowIndex);
                for (int i = startRowIndex; i < endRowIndex; ++i) {
                    rowKeys.add(filterRkList.get(i));
                }
                ArrayList<Integer> i = rowKeys;
                return i;
            }
            int rowCount = this.model.getFilterEntryRowCount(entryKey);
            endRowIndex = Math.min(rowCount, endRowIndex);
            ArrayList<Integer> rowKeys = new ArrayList<Integer>(endRowIndex - startRowIndex);
            for (int row = startRowIndex; row < endRowIndex; ++row) {
                rowKeys.add(row);
            }
            ArrayList<Integer> arrayList = rowKeys;
            return arrayList;
        }
    }

    public List<Integer> getFilterIndexByRowKeys(String entryKey, List<Integer> rowkeyList) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return null;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(rowkeyList.size());
        for (int i = 0; i < this.filterRKList.size(); ++i) {
            int val = this.filterRKList.get(i);
            if (rowkeyList.contains(val)) {
                indexList.add(i);
            }
            if (indexList.size() == rowkeyList.size()) break;
        }
        return indexList;
    }

    public List<Integer> filterSortByRowKeys(String entryKey, List<Integer> rowkeyList) {
        if (!this.model.isFilterAndSortModel(entryKey)) {
            return null;
        }
        if (this.filterRKList == null) {
            this.getFilterRkList(entryKey);
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(rowkeyList.size());
        HashMap<Integer, Integer> tempMap = new HashMap<Integer, Integer>(rowkeyList.size());
        for (int i = 0; i < this.filterRKList.size(); ++i) {
            int val = this.filterRKList.get(i);
            if (rowkeyList.contains(val)) {
                tempMap.put(i, val);
                indexList.add(i);
            }
            if (tempMap.size() == rowkeyList.size()) break;
        }
        ArrayList<Integer> resultList = new ArrayList<Integer>(indexList.size());
        for (int i = 0; i < indexList.size(); ++i) {
            resultList.add((Integer)tempMap.get(indexList.get(i)));
        }
        return resultList;
    }

    public boolean isFilterAndSortModel(String entryKey) {
        Map<String, Object> entryState = this.model.getEntryState(entryKey);
        return entryState == null || entryState.get(ENTRY_ISFILTER) == null ? false : (Boolean)entryState.get(ENTRY_ISFILTER);
    }

    public EntryQueryParam getEntryQueryParam(String entryKey) {
        String str;
        Map<String, Object> entryState = this.model.getEntryState(entryKey);
        String string = str = entryState.get(ENTRY_QUERYPARAM) == null ? null : (String)entryState.get(ENTRY_QUERYPARAM);
        if (str == null) {
            return new EntryQueryParam();
        }
        return (EntryQueryParam)SerializationUtils.fromJsonString((String)str, EntryQueryParam.class);
    }

    private void subEntryIsNeedReFilter(String entryKey, DynamicObjectCollection entryCollection, EntryQueryParam queryParam) {
        IDataEntityProperty prop = this.model.getProperty(entryKey);
        if (prop.getParent() instanceof EntryType) {
            String parentName = prop.getParent().getName();
            int parentIndex = this.model.getEntryCurrentRowIndex(parentName);
            if (queryParam.getParentIndex() != parentIndex) {
                queryParam.setParentIndex(parentIndex);
                this.filterEntry(entryKey, queryParam, entryCollection);
                this.setEntryQueryParam(entryKey, queryParam);
            }
        }
    }
}

