/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TableValueSetter {
    private List<String> flds = new ArrayList<String>();
    private Map<String, List<Object>> values = new HashMap<String, List<Object>>();

    public TableValueSetter(String ... fields) {
        for (String fld : fields) {
            this.createEmptyField(fld);
        }
    }

    private void createEmptyField(String fld) {
        if (!this.values.containsKey(fld)) {
            this.flds.add(fld);
            this.values.put(fld, new ArrayList());
        }
    }

    @SdkInternal
    public List<String> getFields() {
        return this.flds;
    }

    public TableValueSetter addField(String fld, Object ... values) {
        this.createEmptyField(fld);
        this.values.get(fld).addAll(Arrays.asList(values));
        return this;
    }

    @SdkInternal
    public TableValueSetter removeRow(int index) {
        return this;
    }

    public TableValueSetter set(String fld, Object v, int row) {
        if (!this.values.containsKey(fld)) {
            this.createEmptyField(fld);
        }
        this.ensureFieldValueLength(fld, row);
        this.values.get(fld).set(row, v);
        return this;
    }

    @SdkInternal
    public Object get(String fld, int row) {
        List<Object> fld_values;
        if (this.values.containsKey(fld) && (fld_values = this.values.get(fld)).size() > row) {
            return fld_values.get(row);
        }
        return null;
    }

    private void ensureFieldValueLength(String fld, int row) {
        int start;
        for (int i = start = this.values.get(fld).size(); i <= row; ++i) {
            this.values.get(fld).add(null);
        }
    }

    public TableValueSetter addRow(Object ... values) {
        this.alignAllRows();
        for (int i = 0; i < values.length; ++i) {
            String fld = this.flds.get(i);
            this.values.get(fld).add(values[i]);
        }
        return this;
    }

    private void alignAllRows() {
        int count = this.getCount();
        for (String f : this.flds) {
            for (int i = this.values.get(f).size(); i < count; ++i) {
                this.values.get(f).add(null);
            }
        }
    }

    @SdkInternal
    public int getCount() {
        int count = 0;
        for (String fld : this.flds) {
            int len = this.values.get(fld).size();
            if (count >= len) continue;
            count = len;
        }
        return count;
    }
}

