/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel.events;

import kd.bos.dataentity.RefObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.datamodel.events.PropChangedContainer;
import kd.bos.entity.datamodel.events.PropChangedTask;
import kd.bos.entity.datamodel.events.PropChangedTaskCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;

public class DefaultPropChangedContainer
implements PropChangedContainer {
    private IDataModel model;
    private ModelEventProxy modelEventProxy;
    private PropChangedTaskCollection _suspendTasks;
    private int _initLevel;

    public IDataModel getModel() {
        return this.model;
    }

    public ModelEventProxy getModelEventProxy() {
        return this.modelEventProxy;
    }

    public void setModelEventProxy(ModelEventProxy modelEventProxy) {
        this.modelEventProxy = modelEventProxy;
    }

    public DefaultPropChangedContainer(IDataModel model, ModelEventProxy modelEventProxy) {
        this.model = model;
        this.modelEventProxy = modelEventProxy;
    }

    public void suspend() {
        ++this._initLevel;
        if (this._suspendTasks == null) {
            this._suspendTasks = new PropChangedTaskCollection();
        }
    }

    public boolean isSuspend() {
        return this._initLevel > 0;
    }

    public void raise(PropertyChangedArgs raiseSource) {
        if (raiseSource == null) {
            throw new IllegalArgumentException("raiseSource");
        }
        try {
            this.suspend();
            PropChangedTaskCollection taskContext = this._suspendTasks;
            taskContext.add(new PropChangedTask(raiseSource));
        }
        finally {
            this.resume();
        }
    }

    public void resume() {
        try {
            if (this._initLevel == 1 && this._suspendTasks != null) {
                if (this._suspendTasks.size() > 0) {
                    this.execute(this._suspendTasks);
                }
                this._suspendTasks.clear();
                this._suspendTasks = null;
            }
        }
        catch (KDBizException bizexp) {
            this.doFailRecoder((Exception)((Object)bizexp));
            throw bizexp;
        }
        catch (Exception exp) {
            this.doFailRecoder(exp);
            throw new RuntimeException(exp);
        }
        finally {
            --this._initLevel;
        }
    }

    private void execute(PropChangedTaskCollection tasks) {
        RefObject task = new RefObject(null);
        while (tasks.dequeue((RefObject<PropChangedTask>)task)) {
            if (((PropChangedTask)task.getValue()).getChangeSet().isEmpty()) continue;
            PropertyChangedArgs eventArgs = new PropertyChangedArgs(((PropChangedTask)task.getValue()).getProperty(), ((PropChangedTask)task.getValue()).getChangeSet().toArray(new ChangeData[0]));
            this.modelEventProxy.firePopertyChanged(eventArgs);
        }
    }

    private void doFailRecoder(Exception exp) {
        if (this._suspendTasks != null) {
            this._suspendTasks.clear();
            this._suspendTasks = null;
        }
    }

    private String buildErrContext() {
        return null;
    }
}

