/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;

public class OperateProgressCache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
    private static final String CACHE_TYPE = "OperateExecuter";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_FINISH = "finish";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMESSAGE = "errormsg";
    private static final String CACHEKEY_RESULT = "result";
    private static final String CACHEKEY_FORMACTIONS = "formactions";

    private static String buildCacheType(String taskId) {
        return "OperateExecuter_" + taskId;
    }

    public static boolean isError(String taskId) {
        String error = (String)cache.get(OperateProgressCache.buildCacheType(taskId), CACHEKEY_ERROR);
        if (StringUtils.isBlank((CharSequence)error)) {
            return false;
        }
        return Boolean.parseBoolean(error);
    }

    public static String getErrorMsg(String taskId) {
        return (String)cache.get(OperateProgressCache.buildCacheType(taskId), CACHEKEY_ERRORMESSAGE);
    }

    public static void setError(String taskId, boolean error, String errMsg) {
        String type = OperateProgressCache.buildCacheType(taskId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CACHEKEY_ERROR, String.valueOf(error));
        if (errMsg != null) {
            map.put(CACHEKEY_ERRORMESSAGE, errMsg);
        }
        cache.put(type, map);
    }

    public static boolean isFinished(String taskId) {
        String type = OperateProgressCache.buildCacheType(taskId);
        String finish = (String)cache.get(type, CACHEKEY_FINISH);
        if (StringUtils.isNotBlank((CharSequence)finish)) {
            return Boolean.parseBoolean(finish);
        }
        Map map = cache.getAll(type);
        return map.isEmpty();
    }

    public static void setFinished(String taskId, boolean finisih) {
        cache.put(OperateProgressCache.buildCacheType(taskId), CACHEKEY_FINISH, (Object)String.valueOf(finisih));
    }

    public static void setProgressTip(String taskId, String tip) {
        cache.put(OperateProgressCache.buildCacheType(taskId), CACHEKEY_TIP, (Object)tip);
    }

    public static String getProgressTip(String taskId) {
        return (String)cache.get(OperateProgressCache.buildCacheType(taskId), CACHEKEY_TIP);
    }

    public static OperationResult getOperationResult(String taskId) {
        String resultStr = (String)cache.get(OperateProgressCache.buildCacheType(taskId), CACHEKEY_RESULT);
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            return null;
        }
        return (OperationResult)DataEntitySerializer.deSerializerFromString((String)resultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
    }

    public static void setOperationResult(String taskId, OperationResult opResult) {
        String result = "";
        if (opResult != null) {
            result = OperateProgressCache.serializeOperationResult(opResult);
        }
        cache.put(OperateProgressCache.buildCacheType(taskId), CACHEKEY_RESULT, (Object)result);
    }

    public static List<Object> getFormActions(String taskId) {
        String resultStr = (String)cache.get(OperateProgressCache.buildCacheType(taskId), CACHEKEY_FORMACTIONS);
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            return new ArrayList<Object>();
        }
        return (List)SerializationUtils.fromJsonString((String)resultStr, List.class);
    }

    public static void setFormActions(String taskId, List<Object> formActions) {
        String result = "";
        if (formActions != null) {
            result = SerializationUtils.toJsonString(formActions);
        }
        cache.put(OperateProgressCache.buildCacheType(taskId), CACHEKEY_FORMACTIONS, (Object)result);
    }

    private static String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        return serialResult;
    }

    public static void clearCache(String taskId) {
        cache.removeType(OperateProgressCache.buildCacheType(taskId));
    }
}

