/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.lang3.StringUtils;

public class ImportLogger
implements Serializable {
    private static final long serialVersionUID = -3725263491218497131L;
    private int LIMIT_FOR_ERROR_MESSAGE = 5000;
    private static final int LIMIT_FIELD_NUM = 50;
    private static final long LIMIT_CHAR_SIZE = 5000000L;
    private static final long LIMIT_CHAR_ROW_SIZE = 32767L;
    private int rowIndex;
    private int lastRowIndex;
    private int totalRow;
    private int total;
    private int failed;
    private List<int[]> delRows = new ArrayList<int[]>(0);
    private String srcFile;
    private String errFile;
    private Map<Integer, List<ImportLog>> logCache = new HashMap<Integer, List<ImportLog>>(10000);
    private boolean rowLimitFlag = false;
    private long charSize;
    private boolean charSizeLimitFlag = false;
    private Map<Integer, Long> charSizeByRow = new HashMap<Integer, Long>(8);

    public Map<Integer, List<ImportLog>> getLogCache() {
        return this.logCache;
    }

    public void setLogCache(Map<Integer, List<ImportLog>> logCache) {
        this.logCache = logCache;
    }

    public ImportLogger() {
    }

    public ImportLogger(String url) {
        this.srcFile = url;
    }

    public ImportLogger tick() {
        this.setTotal(this.getTotal() + 1);
        return this;
    }

    public ImportLogger fail() {
        this.setFailed(this.getFailed() + 1);
        return this;
    }

    public ImportLogger fail(int n) {
        this.setFailed(this.getFailed() + n);
        return this;
    }

    public ImportLogger log(Integer row, String msg) {
        this.log(row, null, msg);
        return this;
    }

    public ImportLogger log(Integer row, Throwable e) {
        this.log(row, null, ImportLogger.formatException(e));
        return this;
    }

    public ImportLogger log(Integer row, String src, String msg) {
        this.logAll(row, new ImportLog(src, msg));
        return this;
    }

    public ImportLogger logAll(Integer row, String ... msg) {
        if (msg != null && msg.length > 0) {
            ImportLog[] logs = new ImportLog[msg.length];
            for (int i = 0; i < msg.length; ++i) {
                logs[i] = new ImportLog(msg[i]);
            }
            this.logAll(row, logs);
        }
        return this;
    }

    public ImportLogger logAll(Integer row, ImportLog ... msg) {
        if (msg != null && msg.length > 0) {
            List<ImportLog> importLogs = Arrays.stream(msg).collect(Collectors.toList());
            this.logAll(row, importLogs);
        }
        return this;
    }

    public ImportLogger logAll(Integer row, List<ImportLog> msg) {
        if (this.charSize >= 5000000L) {
            if (!this.charSizeLimitFlag) {
                this.charSizeLimitFlag = true;
                ArrayList<ImportLog> importLogs = new ArrayList<ImportLog>();
                ImportLog importLog2 = new ImportLog(ResManager.loadKDString((String)"\u7531\u4e8e\u9519\u8bef\u4fe1\u606f\u8fc7\u5927\uff0c\u5df2\u505c\u6b62\u52a0\u8f7d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u6570\u636e\u5e93\u6216monitor\u3002", (String)"ImportLogger_1", (String)"bos-entity-core", (Object[])new Object[0]));
                importLogs.add(importLog2);
                this.logCache.put(row, importLogs);
            }
            return this;
        }
        List<ImportLog> logs = this.logCache.get(row);
        if (logs == null && this.logCache.size() >= this.LIMIT_FOR_ERROR_MESSAGE) {
            if (!this.rowLimitFlag) {
                this.rowLimitFlag = true;
                ArrayList<ImportLog> importLogs = new ArrayList<ImportLog>();
                ImportLog importLog3 = new ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u5806\u6808\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u8d85\u957f\uff0c\u5df2\u505a\u622a\u65ad\u5904\u7406\uff0c\u5982\u9700\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u67e5\u770bmonitor\u3002", (String)"ImportLogger_2", (String)"bos-entity-core", (Object[])new Object[0]));
                importLogs.add(importLog3);
                this.logCache.put(row, importLogs);
            }
            return this;
        }
        List importLogs = msg.stream().limit(50L).collect(Collectors.toList());
        if (logs == null && this.logCache.size() < this.LIMIT_FOR_ERROR_MESSAGE) {
            logs = new ArrayList<ImportLog>(importLogs.size() + 1);
            this.logCache.put(row, logs);
        }
        if (this.charSizeByRow.computeIfAbsent(row, i -> 0L) > 32767L) {
            return this;
        }
        if (logs != null) {
            logs.addAll(importLogs);
        }
        long sum = importLogs.stream().mapToLong(importLog -> importLog.msg.length()).sum();
        this.charSizeByRow.put(row, this.charSizeByRow.get(row) + sum);
        this.charSize += sum;
        return this;
    }

    public String getErrFile() {
        return this.errFile;
    }

    public void setErrFile(String errFile) {
        this.errFile = errFile;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public List<int[]> getDelRows() {
        return this.delRows;
    }

    public void setDelRows(List<int[]> delRows) {
        this.delRows = delRows;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(int totalRow) {
        this.totalRow = totalRow;
    }

    public void signTotalRow(int completeRows) {
        this.setTotalRow(this.getTotalRow() + completeRows);
    }

    public void setLimitForErrorMessage(int limitForErrorMessage) {
        this.LIMIT_FOR_ERROR_MESSAGE = limitForErrorMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20000);
        boolean isFirst = true;
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(this.logCache.keySet());
        rowIndexes.sort(Comparator.naturalOrder());
        for (Integer i : rowIndexes) {
            List<ImportLog> logs;
            if (!isFirst) {
                sb.append("\r\n");
            } else {
                isFirst = false;
            }
            if ((logs = this.logCache.get(i)) == null || logs.isEmpty()) continue;
            if (i >= 0) {
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"ImportLogger_0", (String)"bos-entity-core", (Object[])new Object[0]), i + 1);
                sb.append(tempStr).append(" ");
            }
            int logsCount = 0;
            for (ImportLog log : logs) {
                sb.append(logsCount++ == 0 ? "" : "\r\n\t").append(log.toString());
            }
        }
        return sb.append("\r\n").toString();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setLastRowIndex(int lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    /*
     * Exception decompiling
     */
    public static String formatException(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ImportLog
    implements Serializable {
        private static final long serialVersionUID = -7388967998268723393L;
        public String src;
        public String msg;

        public ImportLog() {
        }

        public ImportLog(Throwable throwable) {
            this.msg = ImportLogger.formatException(throwable);
        }

        public ImportLog(String msg) {
            this.msg = msg;
        }

        public ImportLog(String src, String msg) {
            this.src = src;
            this.msg = msg;
        }

        public String toString() {
            return StringUtils.isBlank((CharSequence)this.src) ? this.msg : this.src + " - " + this.msg;
        }
    }
}

