/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.plugin.KDOperationPlugIn;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.IReportListDataServiceExt;
import kd.bos.event.AfterQueryEvent;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptExecutor;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public class ReportServiceProxyPlugin {
    private static final String TRACETYPE_PLUGIN = "reportopplugin";
    protected List<IReportListDataServiceExt> plugIns = new ArrayList<IReportListDataServiceExt>();
    private ScriptExecutor scriptExecutor;
    private OperateLog operateLog = OperateLog.get((boolean)false);
    protected static final long WARN_EXECUTE_TIME = 10L;

    public OperateLog getOperateLog() {
        return this.operateLog;
    }

    public ReportServiceProxyPlugin(List<Plugin> plugins) {
        if (!CollectionUtils.isEmpty(plugins)) {
            for (int i = 0; i < plugins.size(); ++i) {
                IReportListDataServiceExt splugin;
                String pluginStr = SerializationUtils.toJsonString((Object)plugins.get(i));
                Plugin plugin = (Plugin)SerializationUtils.fromJsonString((String)pluginStr, Plugin.class);
                int type = plugin.getType();
                String className = plugin.getClassName();
                if (0 == type) {
                    this.plugIns.add((IReportListDataServiceExt)TypesContainer.createInstance((String)className));
                    continue;
                }
                if (1 == type) {
                    try {
                        splugin = this.createScriptPlugin(className);
                        if (splugin == null) continue;
                        this.plugIns.add(splugin);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (4 != type || !Plugin.enableRunKingScript()) continue;
                try {
                    splugin = (IReportListDataServiceExt)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(className, scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)));
                    if (splugin == null) continue;
                    this.plugIns.add(splugin);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private IReportListDataServiceExt createScriptPlugin(String scriptName) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptName);
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{KDOperationPlugIn.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (IReportListDataServiceExt)this.scriptExecutor.getContext().get("plugin");
    }

    public void fireAfterQuery(AfterQueryEvent e) {
        this.invokeMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.afterQuery", plugin.getClass().getName(), EntityTraceHint.getHintLinkAPM()));){
                plugin.afterQuery(e);
            }
        }, "afterQuery", AfterQueryEvent.class);
    }

    private void invokeMethod(Consumer<IReportListDataServiceExt> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IReportListDataServiceExt pl : this.plugIns) {
            long beginTime = System.currentTimeMillis();
            String mothedName = pl.getClass().getName() + "." + methodName;
            this.getOperateLog().beginMothed(mothedName, null);
            consumer.accept(pl);
            long costTime = System.currentTimeMillis() - beginTime;
            if (costTime > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
                continue;
            }
            this.getOperateLog().removeMothed(mothedName);
        }
    }
}

