/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportBatchQueryResult;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportTreeBatchLoadInfo;

public class ReportTreeByBatchTaskResult
extends ReportByBatchTaskResult {
    private static final String SPAN_TYPE = "ReportTreeByBatchTaskResult";

    @Override
    public ReportTreeBatchLoadInfo getBatchLoadInfo() {
        return (ReportTreeBatchLoadInfo)super.getBatchLoadInfo();
    }

    public ReportTreeByBatchTaskResult(String pageId, String firstBatchDataSetCacheId, List<AbstractReportColumn> reportColumns, ReportBatchQueryInfo batchQueryInfo, ReportTreeBatchLoadInfo batchInfo) {
        super(pageId, firstBatchDataSetCacheId, reportColumns, batchQueryInfo, batchInfo);
    }

    @Override
    public Tuple<Integer, Boolean> addBatchData(int start, int limit, int batchIndex, String parentId, Integer currentSeq, ReportBatchQueryResult result) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"addBatchData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("rootCounts", (Object)result.getRootCounts());
            this.getBatchLoadInfo().getBatchIndex2RootRowCount().put(batchIndex, result.getRootCounts());
            Tuple<Integer, Boolean> tuple = super.addBatchData(start, limit, batchIndex, parentId, currentSeq, result);
            return tuple;
        }
    }

    @Override
    protected Tuple<Boolean, List<Integer>> enoughLoaded(int start, int limit, String parentId, Integer currentSeq) {
        ArrayList<Integer> batchIndexs = new ArrayList<Integer>(10);
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return super.enoughLoaded(start, limit, parentId, currentSeq);
        }
        if (!StringUtils.equals((CharSequence)parentId, (CharSequence)"0")) {
            return new Tuple((Object)true, batchIndexs);
        }
        int batchIndex = this.parseBatchIndex(start, limit, parentId, currentSeq);
        if (batchIndex < 0) {
            batchIndexs.add(-1);
            return new Tuple((Object)false, batchIndexs);
        }
        int rowCount = 0;
        boolean enough = false;
        for (Map.Entry<Integer, Integer> entry : this.getBatchLoadInfo().getBatchIndex2RootRowCount().entrySet()) {
            Integer k = entry.getKey();
            if ((rowCount += entry.getValue().intValue()) >= start) {
                batchIndexs.add(k);
            }
            if (rowCount < start + limit) continue;
            enough = true;
            break;
        }
        if (!enough || batchIndexs.size() == 0) {
            batchIndexs.clear();
            batchIndexs.add(-1);
            return new Tuple((Object)false, batchIndexs);
        }
        ArrayList<Integer> needLoadBatchIndexs = new ArrayList<Integer>(10);
        for (Integer index : batchIndexs) {
            if (this.getBatchLoadInfo().getBatchIndex2CachedDataSetIds().containsKey(index)) continue;
            needLoadBatchIndexs.add(index);
        }
        if (needLoadBatchIndexs.size() > 0) {
            return new Tuple((Object)false, needLoadBatchIndexs);
        }
        return new Tuple((Object)true, batchIndexs);
    }

    @Override
    protected int parseBatchIndex(int start, int limit, String parentId, Integer currentSeq) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return super.parseBatchIndex(start, limit, parentId, currentSeq);
        }
        if (currentSeq != null) {
            return super.parseBatchIndex(currentSeq, limit, parentId, currentSeq);
        }
        if (!StringUtils.equals((CharSequence)parentId, (CharSequence)"0")) {
            return 0;
        }
        int rowCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.getBatchLoadInfo().getBatchIndex2RootRowCount().entrySet()) {
            Integer batchIndex = entry.getKey();
            if ((rowCount += entry.getValue().intValue()) < start) continue;
            return batchIndex;
        }
        return -1;
    }

    @Override
    protected int parseStartIndex(int start, int limit, String parentId, Integer currentSeq) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return super.parseStartIndex(start, limit, null, null);
        }
        if (currentSeq != null) {
            return super.parseStartIndex(currentSeq, limit, null, null);
        }
        if (!StringUtils.equals((CharSequence)parentId, (CharSequence)"0")) {
            return start;
        }
        int rowCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.getBatchLoadInfo().getBatchIndex2RootRowCount().entrySet()) {
            Integer count = entry.getValue();
            if ((rowCount += count.intValue()) < start) continue;
            return start - (rowCount - count);
        }
        return -1;
    }

    @Override
    protected List<Row> getAllRowByParentId(int startIndexOfThisBatch, int limit, CachedDataSet cachedDataSet, String parentId, Integer currentSeq) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return cachedDataSet.getList(startIndexOfThisBatch, limit);
        }
        int startIndex = startIndexOfThisBatch;
        int realLimit = limit;
        if (currentSeq == null) {
            startIndex = 0;
            realLimit = startIndexOfThisBatch + limit;
        }
        List<Row> allRows = this.getRowByParentId(startIndex, limit, realLimit, parentId, cachedDataSet);
        if (currentSeq != null) {
            startIndexOfThisBatch = 0;
        }
        if (allRows.size() < startIndexOfThisBatch) {
            return Collections.emptyList();
        }
        if (allRows.size() > realLimit) {
            return allRows.subList(startIndexOfThisBatch, realLimit);
        }
        return allRows.subList(startIndexOfThisBatch, allRows.size());
    }

    private List<Row> getRowByParentId(int startIndex, int limit, int realLimit, String parentId, CachedDataSet cachedDataSet) {
        int readCount = 1000;
        if (limit > readCount) {
            readCount = limit;
        }
        ArrayList<Row> allRows = new ArrayList<Row>(realLimit);
        HashSet<String> allPIds = new HashSet<String>(realLimit);
        int rowCount = cachedDataSet.getRowCount();
        while (allRows.size() < realLimit && startIndex < rowCount) {
            List list = cachedDataSet.getList(startIndex, readCount);
            for (Row row : list) {
                if (allRows.size() == 0 && !StringUtils.equals((CharSequence)parentId, (CharSequence)row.getString("pid"))) continue;
                if (StringUtils.equals((CharSequence)parentId, (CharSequence)row.getString("pid"))) {
                    allRows.add(row);
                } else if (!allPIds.contains(row.getString("pid"))) {
                    return allRows;
                }
                if (!row.getBoolean("isgroupnode").booleanValue()) continue;
                allPIds.add(row.getString("rowid"));
            }
            startIndex += readCount;
        }
        return allRows;
    }

    @Override
    public void close() {
        super.close();
        this.getBatchLoadInfo().getBatchIndex2RootRowCount().clear();
    }

    @Override
    protected boolean isAddNextBatch(String parentId, int currentCount, int limit, int currBatchIndex) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return super.isAddNextBatch(parentId, currentCount, limit, currBatchIndex);
        }
        if (currBatchIndex + 1 < this.batchQueryInfo.getBatchCount()) {
            if (StringUtils.equals((CharSequence)parentId, (CharSequence)"0") && currentCount < limit) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)parentId, (CharSequence)"0") && currentCount == 0) {
                return true;
            }
        }
        return false;
    }
}

