/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ds.AbstractDataSource;
import kd.bos.entity.report.ds.DSHelper;
import kd.bos.entity.report.ds.JoinField;
import kd.bos.entity.report.ds.JoinSelectField;
import kd.bos.entity.report.ds.SelectField;
import kd.bos.fs.util.StringUtils;

public class JoinDS
extends AbstractDataSource {
    private boolean groupBy = false;
    private String clientDS;
    private String supplierDS;
    private String joinType = "left";
    private List<JoinSelectField> selectFieldList = new ArrayList<JoinSelectField>();
    private List<JoinField> joinFieldList = new ArrayList<JoinField>();

    public boolean isGroupBy() {
        return this.groupBy;
    }

    public String getClientDS() {
        return this.clientDS;
    }

    public String getSupplierDS() {
        return this.supplierDS;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public List<JoinSelectField> getSelectFieldList() {
        return this.selectFieldList;
    }

    public List<JoinField> getJoinFieldList() {
        return this.joinFieldList;
    }

    @Override
    protected void init(DynamicObject dsObj, List<AbstractDataSource> dsList, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        super.init(dsObj, dsList, queryParam, selectedObj, reportName);
        String data = dsObj.getString("data");
        if (!StringUtils.isEmpty((String)data)) {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"ide_joinds");
            DynamicObject obj = DSHelper.toDynamicObject(data, entity);
            this.groupBy = obj.getBoolean("groupquery");
            this.clientDS = obj.getString("clientds");
            this.supplierDS = obj.getString("supplierds");
            this.joinType = obj.getString("jointype");
            this.initSelectField(queryParam, obj);
            this.initJoinField(obj);
        }
    }

    protected void initSelectField(ReportQueryParam queryParam, DynamicObject obj) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("selectentry");
        for (DynamicObject f : dsColl) {
            JoinSelectField sf = new JoinSelectField();
            sf.setFieldName(f.getString("fieldname"));
            sf.setDisplayname(f.getString("displayname"));
            String queryField = f.getString("queryfield");
            if (!StringUtils.isEmpty((String)queryField)) {
                queryField = DSHelper.calQueryField(queryParam, queryField);
            }
            sf.setQueryfield(queryField);
            sf.setFieldType(f.getString("datatype"));
            sf.setGroupType(f.getString("grouptpye"));
            sf.setQueryDS(f.getString("queryds"));
            this.addSelectField(sf);
        }
    }

    protected void initJoinField(DynamicObject obj) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("joinentry");
        for (DynamicObject f : dsColl) {
            JoinField sf = new JoinField();
            sf.setClientField(f.getString("clientfield"));
            sf.setSupplierField(f.getString("supplierfield"));
            this.addJoinField(sf);
        }
    }

    private void addSelectField(JoinSelectField field) {
        this.selectFieldList.add(field);
    }

    private void addJoinField(JoinField field) {
        this.joinFieldList.add(field);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataSet createDataSet() {
        AbstractDataSource clientDS = this.getDS(this.clientDS);
        AbstractDataSource supplierDS = this.getDS(this.supplierDS);
        DataSet clientDataSet = null;
        DataSet supplierDataSet = null;
        if (clientDS != null) {
            clientDataSet = clientDS.getDataSet();
        }
        if (supplierDS != null) {
            supplierDataSet = supplierDS.getDataSet();
        }
        DataSet ds = null;
        if (clientDataSet != null && supplierDataSet != null) {
            JoinType type = this.joinFieldList.isEmpty() ? JoinType.CROSS : ("inner".equals(this.joinType) ? JoinType.INNER : JoinType.LEFT);
            JoinDataSet joinDataSet = clientDataSet.join(supplierDataSet, type);
            for (JoinField joinField : this.joinFieldList) {
                joinDataSet = joinDataSet.on(joinField.getClientField(), joinField.getSupplierField());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (JoinSelectField field : this.selectFieldList) {
                if (field.getQueryDS().equals(clientDS.getNumber())) {
                    arrayList.add(field.getQueryfield() + " as " + field.getFieldName());
                    continue;
                }
                if (!field.getQueryDS().equals(supplierDS.getNumber())) continue;
                arrayList2.add(field.getQueryfield() + " as " + field.getFieldName());
            }
            ds = joinDataSet.select(arrayList.toArray(new String[0]), arrayList2.toArray(new String[0])).finish();
        } else if (clientDataSet != null) {
            ArrayList<String> fields = new ArrayList<String>(20);
            for (JoinSelectField joinSelectField : this.selectFieldList) {
                fields.add(joinSelectField.getQueryfield() + " as " + joinSelectField.getFieldName());
            }
            ds = clientDataSet.select(fields.toArray(new String[0]));
        }
        if (this.isGroupBy() && ds != null) {
            void var8_14;
            HashMap<String, String> spf = new HashMap<String, String>();
            ArrayList<String> gpf = new ArrayList<String>();
            for (SelectField selectField : this.selectFieldList) {
                String gpType = selectField.getGroupType();
                if (StringUtils.isEmpty((String)gpType)) {
                    gpf.add(selectField.getFieldName());
                    continue;
                }
                spf.put(selectField.getFieldName(), gpType);
            }
            GroupbyDataSet groupbyDataSet = ds.groupBy(gpf.toArray(new String[0]));
            for (Map.Entry entry : spf.entrySet()) {
                String fName = (String)entry.getKey();
                String gpType = (String)entry.getValue();
                if ("1".equals(gpType)) {
                    GroupbyDataSet groupbyDataSet2 = var8_14.sum(fName);
                    continue;
                }
                if ("2".equals(gpType)) {
                    GroupbyDataSet groupbyDataSet3 = var8_14.count(fName);
                    continue;
                }
                if ("3".equals(gpType)) {
                    GroupbyDataSet groupbyDataSet4 = var8_14.max(fName);
                    continue;
                }
                if ("4".equals(gpType)) {
                    GroupbyDataSet groupbyDataSet5 = var8_14.min(fName);
                    continue;
                }
                if (!"5".equals(gpType)) continue;
                GroupbyDataSet groupbyDataSet6 = var8_14.avg(fName);
            }
            ds = var8_14.finish();
        }
        return ds;
    }

    private AbstractDataSource getDS(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        for (AbstractDataSource ds : this.getDSList()) {
            if (!ds.getNumber().equals(number)) continue;
            return ds;
        }
        return null;
    }
}

