/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.util.HttpClientUtils;

public class AISystemTokenService {
    private static final int TOKEN_CACHE_TIMEOUT = 10800;
    private static final Log log = LogFactory.getLog(AISystemTokenService.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai_token_cache", new DistributeCacheHAPolicy());
    public static final String KEY_APPID = "appid";
    public static final String KEY_TS = "ts";
    public static final String KEY_NONCE = "nonce";
    public static final String AI_SERVER = "aiserver";
    public static final String AI_APPID = "aiappid";
    public static final String AI_PRIVATE_KEY = "aiprivatekey";
    public static final String AI_TIME_OUT = "aitimeout";
    private static final String PROJECTNAME = "bos-business-dao";

    public static String getToken(boolean regen) {
        Token tokenObj = null;
        String token = (String)cache.get(AISystemTokenService.getTokenStoreKey());
        boolean requireRefreshToken = true;
        if (!regen && StringUtils.isNotBlank((CharSequence)token) && (tokenObj = (Token)SerializationUtils.fromJsonString((String)token, Token.class)).isValidToken()) {
            requireRefreshToken = false;
        }
        if (regen || requireRefreshToken) {
            String aiServer = AISystemTokenService.getPublicParameter(AI_SERVER);
            String authUrl = String.format("%s/oauth/auth", aiServer);
            String appId = AISystemTokenService.getPublicParameter(AI_APPID);
            String privateKey = AISystemTokenService.getPublicParameter(AI_PRIVATE_KEY);
            if (StringUtils.isBlank((CharSequence)authUrl) || StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)privateKey)) {
                log.warn("\u7cfb\u7edf\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)ParameterReader.loadPublicParameterFromCache()));
                return ResManager.loadKDString((String)"ai \u5e73\u53f0\u5bf9\u5e94\u53c2\u6570\u672a\u914d\u7f6e", (String)"AISystemTokenService_1", (String)PROJECTNAME, (Object[])new Object[0]);
            }
            tokenObj = AISystemTokenService.getTokenByHttp(authUrl, appId, privateKey);
            if (tokenObj == null) {
                log.warn("\u83b7\u53d6ai\u5e73\u53f0token\u5931\u8d25\uff0c\u7cfb\u7edf\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)ParameterReader.loadPublicParameterFromCache()));
                return String.format(ResManager.loadKDString((String)"\u8bbf\u95eeai\u5e73\u53f0\u65e0\u6cd5\u8bbf\u95ee,\u53c2\u6570\u5982\u4e0b\uff1aauthUrl :%1$s, appId: %2$s, prvateKey: %3$s", (String)"AISystemTokenService_2", (String)PROJECTNAME, (Object[])new Object[0]), authUrl, appId, privateKey);
            }
            cache.put(AISystemTokenService.getTokenStoreKey(), (Object)SerializationUtils.toJsonString((Object)tokenObj), 10800);
        }
        return tokenObj != null ? tokenObj.getToken() : "";
    }

    private static String getTokenStoreKey() {
        return CacheKeyUtil.getAcctId() + "aitoken";
    }

    public static String getPublicParameter(String key) {
        Map paramData = ParameterReader.loadPublicParameterFromCache();
        if (paramData == null || !paramData.containsKey(key)) {
            return "";
        }
        Object value = paramData.get(key);
        return StringUtils.isBlank(value) ? "" : String.valueOf(value);
    }

    protected static Token getTokenByHttp(String authUrl, String appId, String privateKey) {
        String aiTimeOut = StringUtils.isBlank((CharSequence)AISystemTokenService.getPublicParameter(AI_TIME_OUT)) ? "10000" : AISystemTokenService.getPublicParameter(AI_TIME_OUT);
        int timeOut = Integer.parseInt(aiTimeOut);
        long timestamp = System.currentTimeMillis();
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put(KEY_APPID, appId);
        postData.put(KEY_TS, String.valueOf(timestamp));
        postData.put(KEY_NONCE, AISystemTokenService.getSHA256Str(appId, privateKey, timestamp));
        try {
            String resultStr = HttpClientUtils.post((String)authUrl, null, postData, (int)timeOut, (int)timeOut);
            if (StringUtils.isNotBlank((CharSequence)resultStr)) {
                return (Token)SerializationUtils.fromJsonString((String)resultStr, Token.class);
            }
            log.info("\u8bf7\u6c42AI \u5e73\u53f0token \u5931\u8d25\uff0c\u8fde\u63a5\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u8bbf\u95eeai\u5e73\u53f0\u6545\u969c", (String)"AISystemTokenService_3", (String)PROJECTNAME, (Object[])new Object[0]), (Throwable)e);
        }
        return null;
    }

    protected static String getSHA256Str(String appid, String privateKey, long timestamp) {
        String hashVal = appid + privateKey + timestamp;
        return Hashing.sha256().hashString((CharSequence)hashVal, Charsets.UTF_8).toString();
    }

    public static class Token {
        private long expireTime;
        private int code;
        private String aiToken;

        public Token() {
        }

        public Token(long expireTime, int code, String token) {
            this.expireTime = expireTime;
            this.code = code;
            this.aiToken = token;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getToken() {
            return this.aiToken;
        }

        public void setToken(String token) {
            this.aiToken = token;
        }

        public boolean isValidToken() {
            return 0 == this.code && StringUtils.isNotBlank((CharSequence)this.aiToken) && this.expireTime - 10800000L > System.currentTimeMillis();
        }
    }
}

