/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.domaindefine;

import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class DMImpExpUtil {
    private static Log log = LogFactory.getLog(DMImpExpUtil.class);

    public String toExportXml(DynamicObject data) {
        try {
            DynamicObjectType exportType = this.convertExportModelType((IDataEntityType)data.getDynamicObjectType());
            DynamicObject exportObject = this.toExportObject(data, exportType);
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(exportType);
            binder.setOnlyDbProperty(false);
            DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
            ser.setNewlines(true);
            return ser.serializeToString((Object)exportObject, null);
        }
        catch (CloneNotSupportedException | NoSuchFieldException e) {
            log.error("\u751f\u6210\u5f15\u51faxml\u9519\u8bef\u3002", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public DynamicObject fromExportXml(DynamicObjectType type, String xml) {
        try {
            DynamicObjectType exportType = this.convertExportModelType((IDataEntityType)type);
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(exportType);
            DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
            ser.setNewlines(true);
            DynamicObject exportData = new DynamicObject(exportType);
            ser.deserializeFromString(xml, (Object)exportData);
            return this.toImportData(exportData, type);
        }
        catch (CloneNotSupportedException | NoSuchFieldException e) {
            log.error("\u751f\u6210\u5f15\u5165\u6570\u636e\u9519\u8bef\u3002", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private DynamicObject toImportData(DynamicObject exportData, DynamicObjectType type) throws NoSuchFieldException {
        DynamicObject data = new DynamicObject(type);
        for (IDataEntityProperty property : exportData.getDynamicObjectType().getProperties()) {
            if (property instanceof DynamicCollectionProperty) {
                if (property instanceof DynamicLocaleProperty) {
                    this.setMultiLangeData(exportData, data, property);
                    continue;
                }
                this.setCollectionData(exportData, type, data, property);
                continue;
            }
            DynamicProperty dp = data.getDynamicObjectType().getProperty(property.getName());
            if (dp != null) {
                this.setSimplePropertyData(exportData, data, property, (IDataEntityProperty)dp);
                continue;
            }
            this.setComplexData(exportData, data, property);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setComplexData(DynamicObject exportData, DynamicObject data, IDataEntityProperty property) throws NoSuchFieldException {
        if (!property.getName().contains("_")) throw new NoSuchFieldException(property.getName());
        String[] s = property.getName().split("_");
        if (s.length != 2) throw new IndexOutOfBoundsException(property.getName());
        if (!"number".equals(s[1])) return;
        String number = exportData.getString(property.getName());
        DynamicProperty dp = data.getDynamicObjectType().getProperty(s[0]);
        if (!(dp instanceof DynamicComplexProperty)) throw new NoSuchFieldException(property.getName());
        data.set(s[0] + "_id", this.getBaseDataByNumber((IDataEntityProperty)dp, number));
    }

    private Object getBaseDataByNumber(IDataEntityProperty dp, String number) {
        DynamicObjectType baseDataType = ((DynamicComplexProperty)dp).getDynamicComplexPropertyType();
        Map map = BusinessDataReader.loadFromCache((String)baseDataType.getName(), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (map == null || map.size() == 0) {
            if (dp instanceof BasedataProp && ((BasedataProp)dp).isMustInput()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s:%3$s\u4e0d\u5b58\u5728\u3002", (String)"DMImpExpUtil_0", (String)"bos-business-dao", (Object[])new Object[0]), BosErrorCode.conversionFailed, dp.getName(), number));
            }
            return null;
        }
        return ((DynamicObject)map.values().iterator().next()).get("id");
    }

    private void setSimplePropertyData(DynamicObject exportData, DynamicObject data, IDataEntityProperty property, IDataEntityProperty dp) {
        OrmLocaleValue value;
        Object o = exportData.get(property.getName());
        if (dp instanceof FieldProp && ((FieldProp)dp).isMustInput() && (dp instanceof MuliLangTextProp ? (value = (OrmLocaleValue)o) == null || StringUtils.isBlank((CharSequence)value.getLocaleValue()) : o == null || StringUtils.isBlank((Object)o))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s:\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMImpExpUtil_1", (String)"bos-business-dao", (Object[])new Object[0]), BosErrorCode.conversionFailed, dp.getDisplayName().getLocaleValue()));
        }
        data.set(property.getName(), exportData.get(property.getName()));
    }

    private void setCollectionData(DynamicObject exportData, DynamicObjectType type, DynamicObject data, IDataEntityProperty property) throws NoSuchFieldException {
        DynamicObjectCollection entrys = exportData.getDynamicObjectCollection(property.getName());
        DynamicObjectCollection newEntry = data.getDynamicObjectCollection(property.getName());
        for (DynamicObject entry : entrys) {
            DynamicObject rowData = this.toImportData(entry, ((DynamicCollectionProperty)type.getProperty(property.getName())).getDynamicCollectionItemPropertyType());
            newEntry.add((Object)rowData);
        }
    }

    private void setMultiLangeData(DynamicObject exportData, DynamicObject data, IDataEntityProperty property) {
        DynamicObjectCollection entrys = exportData.getDynamicObjectCollection(property.getName());
        for (DynamicObject entry : entrys) {
            entry.set("pkid", null);
            entry.getDataEntityState().setDirty(true);
        }
        Object o = exportData.get(property.getName());
        if ((o == null || StringUtils.isBlank((Object)o)) && property instanceof FieldProp && ((FieldProp)property).isMustInput()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s:\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMImpExpUtil_1", (String)"bos-business-dao", (Object[])new Object[0]), BosErrorCode.conversionFailed, property.getDisplayName().getLocaleValue()));
        }
        data.set(property.getName(), exportData.get(property.getName()));
    }

    private DynamicObject toExportObject(DynamicObject data, DynamicObjectType exportType) throws NoSuchFieldException {
        DynamicObject exportData = new DynamicObject(exportType);
        for (IDataEntityProperty property : exportType.getProperties()) {
            if (property instanceof DynamicCollectionProperty) {
                this.setExportCollectionData(data, property, exportData);
                continue;
            }
            DynamicProperty dp = data.getDynamicObjectType().getProperty(property.getName());
            if (dp != null) {
                exportData.set(property.getName(), data.get(property.getName()));
                continue;
            }
            this.checkPropertyName(property.getName(), data);
            String[] s = property.getName().split("_");
            dp = data.getDynamicObjectType().getProperty(s[0]);
            DynamicObject baseData = data.getDynamicObject((IDataEntityProperty)dp);
            if (baseData == null) continue;
            exportData.set(property.getName(), baseData.get(s[1]));
        }
        return exportData;
    }

    private void checkPropertyName(String propertyName, DynamicObject data) throws NoSuchFieldException {
        if (propertyName.contains("_")) {
            String[] s = propertyName.split("_");
            if (s.length != 2) {
                throw new IndexOutOfBoundsException(propertyName);
            }
            DynamicProperty dp = data.getDynamicObjectType().getProperty(s[0]);
            if (!(dp instanceof DynamicComplexProperty)) {
                throw new NoSuchFieldException(propertyName);
            }
        } else {
            throw new NoSuchFieldException(propertyName);
        }
    }

    private void setExportCollectionData(DynamicObject data, IDataEntityProperty property, DynamicObject exportData) throws NoSuchFieldException {
        if (property instanceof DynamicLocaleProperty) {
            exportData.set(property.getName(), data.get(property.getName()));
        } else {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection(property.getName());
            DynamicObjectCollection exportEntrys = exportData.getDynamicObjectCollection(property.getName());
            for (DynamicObject entry : entrys) {
                DynamicObject rowData = this.toExportObject(entry, exportEntrys.getDynamicObjectType());
                exportEntrys.add((Object)rowData);
            }
        }
    }

    private DynamicObjectType convertExportModelType(IDataEntityType type) throws CloneNotSupportedException {
        DynamicObjectType newType = new DynamicObjectType(type.getName());
        for (IDataEntityProperty property : type.getProperties()) {
            if (property instanceof DynamicComplexProperty) {
                this.registerComplexProperty(newType, property);
                continue;
            }
            if (property instanceof DynamicCollectionProperty) {
                this.registerCollectionProperty(newType, property);
                continue;
            }
            if (this.containId(property)) continue;
            newType.addProperty((DynamicProperty)property.clone());
        }
        this.fillMuliLangTextProp(newType);
        return newType;
    }

    private void fillMuliLangTextProp(DynamicObjectType type) {
        DynamicCollectionProperty prop = type.getLocaleProperty();
        if (prop != null) {
            for (IDataEntityProperty p : prop.getItemType().getProperties()) {
                DynamicProperty mp = type.getProperty(p.getName());
                if (!(mp instanceof MuliLangTextProp)) continue;
                ((MuliLangTextProp)mp).setLocaleProperty((IDataEntityProperty)prop, (DynamicSimpleProperty)p);
            }
        }
    }

    private void registerComplexProperty(DynamicObjectType newType, IDataEntityProperty property) {
        for (IDataEntityProperty dataEntityProperty : ((DynamicComplexProperty)property).getDynamicComplexPropertyType().getProperties()) {
            if (dataEntityProperty.getName().equals("id")) continue;
            String key = property.getName() + "_" + dataEntityProperty.getName();
            DynamicSimpleProperty simpleProperty = new DynamicSimpleProperty(key, dataEntityProperty.getPropertyType(), null);
            newType.registerSimpleProperty(simpleProperty);
        }
    }

    private void registerCollectionProperty(DynamicObjectType newType, IDataEntityProperty property) throws CloneNotSupportedException {
        if (property instanceof DynamicLocaleProperty) {
            newType.addProperty((DynamicProperty)property.clone());
        } else {
            DynamicCollectionProperty collectionProperty = null;
            DynamicObjectType ret = this.convertExportModelType((IDataEntityType)((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType());
            ret.setName(property.getName());
            collectionProperty = new DynamicCollectionProperty(property.getName(), ret);
            newType.registerCollectionProperty(collectionProperty);
        }
    }

    private boolean containId(IDataEntityProperty property) {
        return property.getName().equals("id") || property.getName().endsWith("_id");
    }
}

