/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

public class EntityObjectReader {
    public static final String ENTITY_NUMBER_ENTITY_OBJECT = "bos_entityobject";

    public static Map<Object, DynamicObject> loadEntityObjectsFromCache(Collection<String> selectFields, Object[] numbers) {
        MainEntityType subMainType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)ENTITY_NUMBER_ENTITY_OBJECT, selectFields);
        return BusinessDataReader.loadFromCache((Object[])numbers, (DynamicObjectType)subMainType);
    }

    public static Map<Object, DynamicObject> loadEntityObjectsFromCache(Collection<String> selectFields, QFilter[] qFilters) {
        MainEntityType subMainType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)ENTITY_NUMBER_ENTITY_OBJECT, selectFields);
        Object[] numbers = EntityObjectReader.loadEntityNumbersFromCache(qFilters);
        return BusinessDataReader.loadFromCache((Object[])numbers, (DynamicObjectType)subMainType);
    }

    public static Map<Object, DynamicObject> loadEntityObjectsInApp(String appId, Collection<String> selectFields, QFilter[] qFilters) {
        Object[] numbers = EntityObjectReader.loadEntityNumbersInApp(appId, qFilters);
        return EntityObjectReader.loadEntityObjectsFromCache(selectFields, numbers);
    }

    public static Map<Object, DynamicObject> loadEntityObjectsInCloud(String cloudId, Collection<String> selectFields, QFilter[] qFilters) {
        Object[] numbers = EntityObjectReader.loadEntityNumbersInCloud(cloudId, qFilters);
        return EntityObjectReader.loadEntityObjectsFromCache(selectFields, numbers);
    }

    public static Object[] loadEntityNumbers(QFilter[] qFilters) {
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("EntityObjectReader.loadEntityNumbersFromCache", ENTITY_NUMBER_ENTITY_OBJECT, "id", qFilters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return idList.toArray();
    }

    public static Object[] loadEntityNumbersFromCache(QFilter[] qFilters) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)ENTITY_NUMBER_ENTITY_OBJECT);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)mainType);
        Object[] numbers = cacheManager.getCachePks(qFilters);
        if (numbers == null) {
            numbers = EntityObjectReader.loadEntityNumbers(qFilters);
            cacheManager.putCachePks(qFilters, numbers);
        }
        return numbers;
    }

    public static Object[] loadEntityNumbersInApp(String appId, QFilter[] qFilters) {
        String sql = "SELECT FID FROM t_meta_bizapp WHERE FMasterId = ? AND FType = ? ";
        Object[] param = new SqlParameter[]{new SqlParameter(":FMasterId", 12, (Object)appId), new SqlParameter(":FType", 12, (Object)"2")};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
        appIds.add(appId);
        QFilter appFilter = new QFilter("bizappid", "in", (Object)appIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(qFilters == null ? 1 : qFilters.length + 1);
        if (qFilters != null) {
            for (QFilter filter : qFilters) {
                filters.add(filter);
            }
        }
        filters.add(appFilter);
        return EntityObjectReader.loadEntityNumbersFromCache(filters.toArray(new QFilter[0]));
    }

    public static Object[] loadEntityNumbersInCloud(String cloudId, QFilter[] qFilters) {
        String sql = "SELECT B.FID FROM t_meta_bizcloud A INNER JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID WHERE A.FID = ? ";
        Object[] param = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
        QFilter appFilter = new QFilter("bizappid", "in", (Object)appIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(qFilters == null ? 1 : qFilters.length + 1);
        if (qFilters != null) {
            for (QFilter filter : qFilters) {
                filters.add(filter);
            }
        }
        filters.add(appFilter);
        return EntityObjectReader.loadEntityNumbersFromCache(filters.toArray(new QFilter[0]));
    }

    public static List<TreeNode> buildBillNodesInApp(String appId, QFilter[] qFilters) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("id");
        selectFields.add("number");
        selectFields.add("name");
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(10);
        Map<Object, DynamicObject> entityInfos = EntityObjectReader.loadEntityObjectsInApp(appId, selectFields, qFilters);
        for (Map.Entry<Object, DynamicObject> entryItem : entityInfos.entrySet()) {
            DynamicObject entityInfo = entryItem.getValue();
            String nodeId = entityInfo.getString("id");
            String name = entityInfo.getLocaleString("name").toString();
            String data = entityInfo.getString("number");
            TreeNode node = new TreeNode(appId, nodeId, name, (Object)data);
            billNodes.add(node);
        }
        return billNodes;
    }
}

