/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareInputType;
import kd.bos.filter.CompareTypeModel;
import kd.bos.filter.CompareTypeModelCollection;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class CompareTypeQuery {
    private static final String FIELDNUMBER = "field.number";

    private CompareTypeQuery() {
    }

    public static CompareTypeModelCollection getCompareTypeModelCollection() {
        CompareTypeModelCollection compareTypeModelCollection = new CompareTypeModelCollection();
        ORM orm = ORM.create();
        QFilter[] qfilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        try (DataSet queryDataSet = orm.queryDataSet(CompareTypeQuery.class.getName(), "bos_comparetype", "id,name,field.number,contantclass,needinput,inputtype", qfilters);){
            for (Row row : queryDataSet) {
                Row perRow = RowUtil.persist((Row)row);
                String fieldType = perRow.getString(FIELDNUMBER) == null ? "" : perRow.getString(FIELDNUMBER);
                CompareTypeModel compareTypeModel = new CompareTypeModel(perRow.getString("id"), new LocaleString(Lang.get().toString(), perRow.getString("name")), fieldType.toLowerCase(), perRow.getString("contantclass"));
                compareTypeModel.setNeedInput(perRow.getBoolean("needinput"));
                String inputType = perRow.getString("inputtype");
                if (StringUtils.isNotBlank((CharSequence)inputType)) {
                    compareTypeModel.setCompareInputType(CompareInputType.valueOf((String)perRow.getString("inputtype")));
                }
                compareTypeModelCollection.add(compareTypeModel);
            }
        }
        return compareTypeModelCollection;
    }

    public static CompareTypeModelCollection getCompareTypeModelCollection(Object[] ids) {
        CompareTypeModelCollection compareTypeModelCollection = new CompareTypeModelCollection();
        ORM orm = ORM.create();
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        try (DataSet queryDataSet = orm.queryDataSet(CompareTypeQuery.class.getName(), "bos_comparetype", "id,name,field.number,contantclass,needinput,inputtype", qfilters);){
            for (Row row : queryDataSet) {
                Row perRow = RowUtil.persist((Row)row);
                String fieldType = perRow.getString(FIELDNUMBER) == null ? "" : perRow.getString(FIELDNUMBER);
                CompareTypeModel compareTypeModel = new CompareTypeModel(perRow.getString("id"), new LocaleString(Lang.get().toString(), perRow.getString("name")), fieldType.toLowerCase(), perRow.getString("contantclass"));
                compareTypeModel.setNeedInput(perRow.getBoolean("needinput"));
                String inputType = perRow.getString("inputtype");
                if (StringUtils.isNotBlank((CharSequence)inputType)) {
                    compareTypeModel.setCompareInputType(CompareInputType.valueOf((String)perRow.getString("inputtype")));
                }
                compareTypeModelCollection.add(compareTypeModel);
            }
        }
        return compareTypeModelCollection;
    }
}

