/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pushservice;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.AsynMessage;
import kd.bos.entity.api.IAsynMessageHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.pushservice.PushMessagePublisher;

public class AsynMessageConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(AsynMessageConsumer.class);
    private static final String ASYN_MESSAGE_CONSUMER_KEY = "bos.asynmessage.handlers";
    private static Map<String, IAsynMessageHandler> handlers = new HashMap<String, IAsynMessageHandler>();
    private static Map<String, String> handlerInfos = new HashMap<String, String>();

    public static void registerHandler(String type, IAsynMessageHandler handler) {
        Objects.requireNonNull(type, ResManager.loadKDString((String)"type \u4e0d\u80fd\u4e3a\u7a7a", (String)"AsynMessageConsumer_0", (String)"bos-business-dao", (Object[])new Object[0]));
        Objects.requireNonNull(handler, ResManager.loadKDString((String)"handler \u4e0d\u80fd\u4e3a\u7a7a", (String)"AsynMessageConsumer_1", (String)"bos-business-dao", (Object[])new Object[0]));
        log.info(String.format("\u6ce8\u518c AsynMessage - handler : type:%s handler:%s", type, handler.getClass().getSimpleName()));
        handlers.put(type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean isResend, MessageAcker acker) {
        try {
            log.info("\u4eceMQ\u4e2d\u63a5\u6536\u5230\u4e86AsynMessage\u6d88\u606f" + body + " \u51c6\u5907\u8fdb\u884c\u5904\u7406\uff01");
            AsynMessage message = (AsynMessage)SerializationUtils.fromJsonString((String)String.valueOf(body), AsynMessage.class);
            this.process(message);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            acker.ack(messageId);
        }
    }

    public void process(AsynMessage message) {
        ArrayList msgList = new ArrayList();
        IAsynMessageHandler iAsynFormMessageHandler = handlers.get(message.getMessageType());
        if (iAsynFormMessageHandler == null) {
            log.info("AsynMessage\u6d88\u606f\u7c7b\u578b\uff1a" + message.getMessageType() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684handler");
        } else {
            IAsynMessageHandler handler = handlers.get(message.getMessageType());
            msgList.addAll(handler.handle(message));
        }
        msgList.forEach(PushMessagePublisher::sendPushMessage);
    }

    private static void initByConfig() {
        String content = ConfigurationFactory.getGlobalConfiguration().getProperty(ASYN_MESSAGE_CONSUMER_KEY);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(content));
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.configParseException, new Object[]{ASYN_MESSAGE_CONSUMER_KEY});
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (name == null || name.trim().length() == 0 || value == null || value.trim().length() == 0) continue;
                name = name.trim();
                value = value.trim();
                try {
                    Class<?> handleClass = Class.forName(value);
                    IAsynMessageHandler handler = (IAsynMessageHandler)handleClass.newInstance();
                    handlers.put(name, handler);
                }
                catch (Exception e) {
                    log.error("type:" + name + "class:" + value, (Throwable)e);
                }
            }
        }
    }

    static {
        handlerInfos.put("ai", "kd.bos.portal.ai.AICommandMessageHandler");
        handlerInfos.forEach((type, handlerString) -> {
            try {
                IAsynMessageHandler handler = (IAsynMessageHandler)TypesContainer.createInstance((String)handlerString);
                handlers.put((String)type, handler);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        });
        AsynMessageConsumer.initByConfig();
    }
}

