/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sqlscript;

import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sqlscript.KSQLDataType;
import kd.bos.sqlscript.PKCol;
import kd.bos.sqlscript.PreInsLongTextData;
import kd.bos.sqlscript.PreInsLongTextDataCollection;

public class PreInsDataScriptWriter {
    private static Log log = LogFactory.getLog(PreInsDataScriptWriter.class);

    public void insertPreInsData(InputStream stream) throws JAXBException {
        JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{PreInsLongTextDataCollection.class});
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xif.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        Unmarshaller unmarshaller = cont.createUnmarshaller();
        try {
            PreInsLongTextDataCollection longTextDatas = (PreInsLongTextDataCollection)unmarshaller.unmarshal(xif.createXMLStreamReader(stream));
            this.deployXmlData(longTextDatas);
        }
        catch (XMLStreamException e) {
            throw new KDException(e.getMessage());
        }
    }

    public void insertPreInsData(String content) throws JAXBException {
        JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{PreInsLongTextDataCollection.class});
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xif.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        Unmarshaller unmarshaller = cont.createUnmarshaller();
        try (StringReader sr = new StringReader(content);){
            PreInsLongTextDataCollection longTextDatas = (PreInsLongTextDataCollection)unmarshaller.unmarshal(xif.createXMLStreamReader(sr));
            this.deployXmlData(longTextDatas);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException(e.getMessage());
        }
    }

    private void deployXmlData(PreInsLongTextDataCollection longTextDatas) {
        for (PreInsLongTextData longTextData : longTextDatas) {
            if (longTextData.getPkCols() == null || longTextData.getPkCols().isEmpty()) {
                throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\uff0c\u68c0\u67e5xml\u7684PKCol\u8282\u70b9\uff0c\u662f\u5426\u5b9a\u4e49name\u3002", (String)"PreInsDataScriptWriter_0", (String)"bos-business-dao", (Object[])new Object[0])});
            }
            List<PKCol> listPk = longTextData.getPkCols();
            ArrayList<Object> sqlParams = new ArrayList<Object>(16);
            String data = longTextData.getData();
            if ("blob".equals(longTextData.getTexttype())) {
                log.info("blob\u6570\u636e\u9884\u63d2" + longTextData.getTextencode());
                String val = data;
                if (val.startsWith("<![CDATA[")) {
                    val = StringUtils.substring((String)data, (int)9);
                }
                if (val.endsWith("]]>")) {
                    val = StringUtils.substring((String)val, (int)0, (int)(val.length() - 3));
                }
                SqlParameter param = new SqlParameter();
                if ("Base64".equals(longTextData.getTextencode())) {
                    param.setValue(PreInsDataScriptWriter.decodeBase64(val));
                } else {
                    param.setValue((Object)val.getBytes(StandardCharsets.UTF_8));
                }
                sqlParams.add(param);
            } else {
                sqlParams.add(data);
            }
            StringBuilder strWhere = new StringBuilder();
            for (PKCol pkCol : listPk) {
                if (strWhere.length() != 0) {
                    strWhere.append(" and ");
                }
                SqlParameter param = new SqlParameter(pkCol.getName(), KSQLDataType.getJavaSQLType(pkCol.getType()), (Object)pkCol.getValue());
                sqlParams.add(param.getValue());
                strWhere.append(pkCol.getName()).append(" = ?");
            }
            String sql = String.format("update %s set %s = ? where %s ", longTextData.getTable(), longTextData.getColname(), strWhere);
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                DB.execute((DBRoute)DBRoute.of((String)longTextData.getDbKey()), (String)sql, (Object[])sqlParams.toArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Object decodeBase64(String data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

