/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.user.cache;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;

public class UserCacheMrg {
    private static final String BS_USER_REGION = "USER";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("USER", new DistributeCacheHAPolicy());
    private static final String BS_USER = "BS_USER_";
    public static final String DATA_USER_MAIN_ORG_ID = "BS_USER_MAIN_ORG_ID";
    public static final String LOADED = "DATA_LOADED";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a.", (String)"UserCacheMrg_0", (String)"bos-business-dao", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4UserMainOrgId() {
        return "BS_USER_MAIN_ORG_ID_" + UserCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
        cache.removeType(UserCacheMrg.getType4UserMainOrgId());
    }

    public static void clearCache(String type) {
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        Map kvs = cache.getAll(type);
        if (kvs != null && kvs.size() > 0) {
            for (String key : kvs.keySet()) {
                if (!key.startsWith(keyPrefix)) continue;
                cache.remove(type, key);
            }
        }
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        cache.put(type, key, (Object)LOADED);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }
}

