/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userbehavior.service.cloudplatform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cloudplatformApi.UserLogUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.userbehavior.UserBehaviorLog;
import kd.bos.userbehavior.service.ProductInfoReader;
import kd.bos.userbehavior.service.UserBehaviorLogService;
import kd.bos.userbehavior.service.cloudplatform.CPAppConfig;

public class CPUserBehaviorLogService
extends UserBehaviorLogService {
    public CPUserBehaviorLogService(ProductInfoReader reader) {
        super(reader);
    }

    @Override
    public void sendLog(List<UserBehaviorLog> logs) {
        Map<String, String> productInfo = this.getProductInfoReader().getInfo();
        String softwarecode = productInfo.get("softwareCode");
        String productid = productInfo.get("productID");
        String productinstanceid = productInfo.get("prodInstCode");
        String productno = productInfo.get("productNo");
        ArrayList datas = new ArrayList(16);
        for (UserBehaviorLog log : logs) {
            HashMap<String, String> data = new HashMap<String, String>(16);
            log.setProductid(productid);
            log.setSoftwarecode(softwarecode);
            log.setProductinstanceid(productinstanceid);
            log.setProductno(productno);
            data.put("logtype", "kdcc");
            data.put("message", (String)log);
            datas.add(data);
        }
        HashMap<String, Object> body = new HashMap<String, Object>(16);
        body.put("logType", "kdcc");
        body.put("data", datas);
        String request_body = SerializationUtils.toJsonString(body);
        CPAppConfig appConfig = CPAppConfig.get();
        Integer client_id = appConfig.getClient_id();
        String client_secret = appConfig.getClient_secret();
        UserLogUtils.sendLog((Integer)client_id, (String)client_secret, (String)request_body);
    }
}

