/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userfavorite;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.userconfig.UserFavorite;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.userfavorite.UserFavoriteQuery;
import kd.bos.userfavorite.UserFavoriteWriter;
import kd.bos.utils.DbTypeConverter;

public class UserFavoriteDAO {
    private static final String FBINDDINGNUM = ":FBINDDINGNUM";
    private static final String FUSERID = ":FUSERID";
    private static final Log log = LogFactory.getLog(UserFavoriteDAO.class);

    public int addUserFavorites(List<UserFavorite> userFavorites, int total) {
        int count = 0;
        StringBuilder errorMessage = new StringBuilder();
        UserFavoriteWriter userFavoriteWriter = new UserFavoriteWriter();
        for (UserFavorite userFavorite : userFavorites) {
            if (total >= 1000) break;
            UserFavorite temp = this.isExist(userFavorite);
            int status = temp.getStatus();
            if (status == 0) continue;
            if (status == 1) {
                ++count;
                ++total;
                userFavorite.setId(temp.getId());
                userFavoriteWriter.updateUserFavorite(userFavorite, errorMessage);
            } else {
                ++count;
                ++total;
                userFavoriteWriter.insertUserFavorite(userFavorite, errorMessage);
            }
            if (errorMessage.length() <= 0) continue;
            log.info(errorMessage.insert(0, "\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u6211\u7684\u6536\u85cf\u9519\u8bef\uff1a").toString());
        }
        return count;
    }

    public void removeUserFavorites(List<UserFavorite> userFavorites) {
        StringBuilder errorMessage = new StringBuilder();
        UserFavoriteWriter userFavoriteWriter = new UserFavoriteWriter();
        for (UserFavorite userFavorite : userFavorites) {
            userFavorite.setStatus(1);
            userFavoriteWriter.removeUserFavorite(userFavorite, errorMessage);
            if (errorMessage.length() <= 0) continue;
            log.info(errorMessage.insert(0, "\u57fa\u7840\u8d44\u6599\u79fb\u9664\u6211\u7684\u6536\u85cf\u9519\u8bef\uff1a").toString());
        }
    }

    public List<String> getUserFavoriteData(UserFavorite userFavorite) {
        List<String> valueList = null;
        UserFavoriteQuery userFavoriteQuery = new UserFavoriteQuery();
        valueList = userFavoriteQuery.getUserFavoriteData(userFavorite);
        return valueList;
    }

    public List<UserFavorite> getUserFavorites(long userId, String binddingNum, List<String> ids) {
        List<UserFavorite> list = null;
        UserFavoriteQuery userFavoriteQuery = new UserFavoriteQuery();
        list = userFavoriteQuery.getUserFavorites(userId, binddingNum, ids);
        return list;
    }

    private UserFavorite isExist(UserFavorite userFavorite) {
        Object[] params = new SqlParameter[]{new SqlParameter(FUSERID, -5, (Object)userFavorite.getUserId()), new SqlParameter(FBINDDINGNUM, 12, (Object)userFavorite.getBinddingNum()), new SqlParameter(":FDATAID", 12, (Object)userFavorite.getDataId())};
        String sql = "SELECT FSTATUS, FID FROM T_BAS_BASEDATAMYFAVORITE WHERE FUSERID=? AND FBINDDINGNUM=? AND FDATAID=?";
        return (UserFavorite)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            UserFavorite favorite = new UserFavorite();
            favorite.setStatus(-1);
            if (rs.next()) {
                favorite.setStatus(rs.getInt("FSTATUS"));
                favorite.setId(rs.getString("FID"));
            }
            return favorite;
        });
    }

    public int countUserFavorite(UserFavorite userFavorite) {
        Object[] params = new SqlParameter[]{new SqlParameter(FUSERID, -5, (Object)userFavorite.getUserId()), new SqlParameter(FBINDDINGNUM, 12, (Object)userFavorite.getBinddingNum()), new SqlParameter(":FSTATUS", 1, (Object)Character.valueOf('0'))};
        String sql = "SELECT FDATAID FROM T_BAS_BASEDATAMYFAVORITE WHERE FUSERID=? AND FBINDDINGNUM=? AND FSTATUS=?";
        List idList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            ArrayList<String> tempList = new ArrayList<String>(10);
            while (rs.next()) {
                tempList.add(rs.getString(1));
            }
            return tempList;
        });
        if (idList.size() < 20) {
            return idList.size();
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)userFavorite.getBinddingNum());
        int dbType = entityType.getPrimaryKey().getDbType();
        List ids = idList.stream().map(obj -> DbTypeConverter.safeConvert((int)dbType, (Object)obj)).collect(Collectors.toList());
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        String selectFields = "id";
        DynamicObjectCollection collection = orm.query(entityType.getName(), selectFields, filters, null);
        ArrayList<Object> list = new ArrayList<Object>(10);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            list.add(dynamicObject.getPkValue());
        }
        for (Object id : ids) {
            if (!list.contains(id)) continue;
            idList.remove(id.toString());
        }
        if (!idList.isEmpty()) {
            this.deleteFromUserFavorite(userFavorite.getUserId(), userFavorite.getBinddingNum(), idList);
        }
        return list.size();
    }

    private void deleteFromUserFavorite(long userId, String binddingNum, List<String> dataIds) {
        Object[] params = new SqlParameter[]{new SqlParameter(FUSERID, -5, (Object)userId), new SqlParameter(FBINDDINGNUM, 12, (Object)binddingNum), new SqlParameter(":FSTATUS", 1, (Object)Character.valueOf('0'))};
        String sql = "SELECT FDATAID, FID FROM T_BAS_BASEDATAMYFAVORITE WHERE FUSERID=? AND FBINDDINGNUM=? AND FSTATUS=?";
        List ids = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            ArrayList<String> temps = new ArrayList<String>(10);
            while (rs.next()) {
                if (!dataIds.contains(rs.getString("FDATAID"))) continue;
                temps.add(rs.getString("FID"));
            }
            return temps;
        });
        DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(UserFavorite.class);
        BusinessDataWriter.delete((IDataEntityType)dataEntityType, (Object[])ids.toArray());
    }
}

