/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web;

import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.WebSocketObject;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class WebSocketIdRecorder
implements WebSocketListener {
    private static final String WEBSOCKET_TARGET = "websocetRecord";
    private static final Log log = LogFactory.getLog(WebSocketIdRecorder.class);
    private static final String ACCOUNT_ID = "accountId";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, false));
    private static boolean logDetail = Boolean.getBoolean("websocket.logdetail.enable");
    private static final int CACHE_TIMEOUT_S;

    public static void addWebSocket(String accountId, String globalSessionId, String webSocketSessionId) {
        if (logDetail) {
            log.info(String.format("websocket session open, accountId=%s", accountId));
        }
        cache.addToSet(WebSocketIdRecorder.buildKey(globalSessionId), new String[]{webSocketSessionId});
        Map<String, String> sessionInfo = WebSocketIdRecorder.getSessionInfoBySessionId(globalSessionId);
        if (WebSocketIdRecorder.isLegalSession(sessionInfo)) {
            cache.addToSet(WebSocketIdRecorder.buildUserIdKey(sessionInfo.get(ACCOUNT_ID), sessionInfo.get("userId")), new String[]{globalSessionId}, CACHE_TIMEOUT_S);
            cache.put(WebSocketIdRecorder.buildSocketSessionKey(sessionInfo.get(ACCOUNT_ID)), webSocketSessionId, (Object)globalSessionId);
            cache.put(WebSocketIdRecorder.buildSessionUserIdKey(sessionInfo.get(ACCOUNT_ID)), globalSessionId, (Object)sessionInfo.get("userId"));
        }
    }

    private static boolean isLegalSession(Map<String, String> sessionInfo) {
        if (sessionInfo == null || sessionInfo.size() == 0) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)sessionInfo.get("userId"))) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)sessionInfo.get(ACCOUNT_ID));
    }

    private static String buildUserIdKey(String accountId, String userId) {
        return "websocetRecord_user_" + accountId + "." + userId;
    }

    public static void removeWebSocket(String accountId, String globalSessionId, String webSocketSessionId) {
        if (logDetail) {
            log.info(String.format("websocket session close, accountId=%s", accountId));
        }
        cache.removeSetValues(WebSocketIdRecorder.buildKey(globalSessionId), new String[]{webSocketSessionId});
        Map<String, String> sessionInfo = WebSocketIdRecorder.getSessionInfoBySessionId(globalSessionId);
        if (WebSocketIdRecorder.isLegalSession(sessionInfo)) {
            cache.removeSetValues(WebSocketIdRecorder.buildUserIdKey(sessionInfo.get(ACCOUNT_ID), sessionInfo.get("userId")), new String[]{globalSessionId});
            cache.remove(WebSocketIdRecorder.buildSessionUserIdKey(sessionInfo.get(ACCOUNT_ID)), globalSessionId);
            cache.remove(WebSocketIdRecorder.buildSocketSessionKey(sessionInfo.get(ACCOUNT_ID)), webSocketSessionId);
        }
    }

    public static void removeWebSockets(String accountId, String globalSessionId) {
        Map<String, String> sessionInfo;
        if (logDetail) {
            log.info(String.format("websocket session timeout, accountId=%s", accountId));
        }
        if (WebSocketIdRecorder.isLegalSession(sessionInfo = WebSocketIdRecorder.getSessionInfoBySessionId(globalSessionId))) {
            cache.removeSetValues(WebSocketIdRecorder.buildUserIdKey(sessionInfo.get(ACCOUNT_ID), sessionInfo.get("userId")), new String[]{globalSessionId});
            cache.remove(WebSocketIdRecorder.buildSessionUserIdKey(sessionInfo.get(ACCOUNT_ID)), globalSessionId);
            String[] socketIds = cache.getSetValues(WebSocketIdRecorder.buildKey(globalSessionId));
            cache.remove(WebSocketIdRecorder.buildKey(globalSessionId));
            if (socketIds != null && socketIds.length > 0) {
                cache.remove(WebSocketIdRecorder.buildSocketSessionKey(sessionInfo.get(ACCOUNT_ID)), socketIds);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)accountId) || StringUtils.isBlank((CharSequence)globalSessionId)) {
            cache.remove(WebSocketIdRecorder.buildKey(globalSessionId));
            return;
        }
        try {
            String userId = (String)cache.get(WebSocketIdRecorder.buildSessionUserIdKey(accountId), globalSessionId);
            if (StringUtils.isBlank((CharSequence)userId)) {
                return;
            }
            cache.removeSetValues(WebSocketIdRecorder.buildUserIdKey(accountId, userId), new String[]{globalSessionId});
            cache.remove(WebSocketIdRecorder.buildSessionUserIdKey(accountId), globalSessionId);
            String[] socketIds = cache.getSetValues(WebSocketIdRecorder.buildKey(globalSessionId));
            cache.remove(WebSocketIdRecorder.buildKey(globalSessionId));
            if (socketIds != null && socketIds.length > 0) {
                cache.remove(WebSocketIdRecorder.buildSocketSessionKey(accountId), socketIds);
            }
        }
        catch (Exception e) {
            log.error("removeWebSockets error:" + e.getMessage());
        }
    }

    public static void removeWebSocketWithUserId(String accountId, String userId, String globalSessionId) {
        if (logDetail) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            WebSocketIdRecorder.removeWebSockets(accountId, globalSessionId);
        } else {
            String realUserId = userId;
            Map<String, String> sessionInfo = WebSocketIdRecorder.getSessionInfoBySessionId(globalSessionId);
            if (WebSocketIdRecorder.isLegalSession(sessionInfo)) {
                realUserId = sessionInfo.get("userId");
            }
            cache.removeSetValues(WebSocketIdRecorder.buildUserIdKey(accountId, realUserId), new String[]{globalSessionId});
            cache.remove(WebSocketIdRecorder.buildSessionUserIdKey(accountId), globalSessionId);
            String[] socketIds = cache.getSetValues(WebSocketIdRecorder.buildKey(globalSessionId));
            cache.remove(WebSocketIdRecorder.buildKey(globalSessionId));
            if (socketIds != null && socketIds.length > 0) {
                cache.remove(WebSocketIdRecorder.buildSocketSessionKey(accountId), socketIds);
            }
        }
    }

    private static Map<String, String> getSessionInfoBySessionId(String sessionId) {
        Objects.requireNonNull(sessionId, ResManager.loadKDString((String)"sessionId \u4e0d\u80fd\u4e3a\u7a7a", (String)"WebSocketIdRecorder_0", (String)"bos-webactions", (Object[])new Object[0]));
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        return sessionDAO.getAttributesAsMap(new String[]{"userId", ACCOUNT_ID});
    }

    public static String getAccountIdBySessionId(String sessionId) {
        String accountId = null;
        SessionDAO sessionDAO = null;
        Map sessionInfo = null;
        Objects.requireNonNull(sessionId, ResManager.loadKDString((String)"sessionId \u4e0d\u80fd\u4e3a\u7a7a", (String)"WebSocketIdRecorder_0", (String)"bos-webactions", (Object[])new Object[0]));
        sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "userId", "userName", "userOpenId", "orgId", ACCOUNT_ID});
        if (sessionInfo != null && sessionInfo.size() > 0) {
            accountId = (String)sessionInfo.get(ACCOUNT_ID);
        }
        return accountId;
    }

    private static String buildKey(String sessionId) {
        return "websocetRecord:" + sessionId;
    }

    private static String buildSessionUserIdKey(String account) {
        return "websocetRecord:" + account + "_session_user";
    }

    private static String buildSocketSessionKey(String account) {
        return "websocetRecord:" + account + "_socket_session";
    }

    public void onConnect(WebSocketObject object) {
        String identifyType = object.getIdentifyType();
        String sessionId = object.getSessionId();
        WebSocketIdRecorder.addWebSocket(null, sessionId, identifyType);
    }

    public void onMessage(WebSocketObject object, String msg) {
    }

    public void onClose(WebSocketObject object) {
        String identifyType = object.getIdentifyType();
        String sessionId = object.getSessionId();
        WebSocketIdRecorder.removeWebSocket(null, sessionId, identifyType);
    }

    static {
        ConfigurationUtil.observeChange((String)"websocket.logdetail.enable", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                logDetail = Boolean.parseBoolean(String.valueOf(newValue));
            }
        });
        CACHE_TIMEOUT_S = Integer.parseInt(System.getProperty("websocket.keytimeout", "8")) * 60 * 60;
    }
}

