/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.VersionManageUtil;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.web.DispatchServiceHelper;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNManagerAction {
    private static final String FILE_ALREADY_EXISTS = "File already exists";
    private static final String SVN_PATH = "svnpath";
    private static final String SVN_MSG = "svnmsg";
    private static final String A_PAGE = "apage";
    private static final String FILENAME = "filename";
    private static final String CONTENT = "content";
    private static final String SCRIPT = "script";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String FILE_CONTENT = "filecontent";
    private static final String CLOUD = "cloud";
    private static final String BIZ_SCRIPT_SERVICE = "BizScriptService";
    private static final String METADATA = "/metadata/";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String CACHE_REGIONINFO = "SVN_LOGININFO";
    private static final String SUCCESS = "success";
    private static final String SUBMIT_INFO = "submitinfo";
    private static final String SVN_MANAGER_ACTION_0 = "SVNManagerAction_0";
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String BIZ_APP_SERVICE = "BizAppService";
    private static final String GET_APP_ID_BY_FORM_ID = "getAppIdByFormId";
    private static final String GET_APP_NUMBER_BY_APP_ID = "getAppNumberByAppId";
    private static final String USER_HOME = "user.home";
    private static final String METADATA1 = "metadata";
    private static final String GET_SVN_PATH_BY_APP_ID = "getSVNPathByAppId";
    private static final String ERROR = "error";
    private static final String FORMAT = "%s/metadata/%s";
    private static final String FILE_NAME = "fileName";
    private static final String KS_PATH = ".ks";
    private static Log log = LogFactory.getLog(SVNManagerAction.class);
    private static final String DEFAUT_UUID_SVNDIFF = "d12ca300-34fc-4f55-a975-75f42d7b4ec6";
    private static String delErrMsg = "delete file fail";

    public void getScriptContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object svnVersionContent;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        String id = request.getParameter("id");
        String type = request.getParameter("type");
        String svnPath = request.getParameter(SVN_PATH);
        String oldVersion = request.getParameter("oldversion");
        String newVersion = request.getParameter("newversion");
        String sessionId = request.getParameter(SVN_MSG);
        Map<String, Object> fileInfo = this.getFileInfo(id, type);
        String fileName = A_PAGE.equalsIgnoreCase(type) ? request.getParameter(FILENAME) : (String)fileInfo.get(FILENAME);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if ("locale".equals(oldVersion)) {
            result.put("localecontent", fileInfo.get(CONTENT));
            result.put("localename", "Revision locale");
        } else {
            svnVersionContent = this.getSvnVersionContent(id, type, fileName, SVNRevision.parse((String)oldVersion), svnPath, sessionId);
            result.put("localecontent", svnVersionContent);
            result.put("localename", "Revision " + oldVersion);
        }
        if ("head".equals(newVersion)) {
            Object svnContent = this.getSvnVersionContent(id, type, fileName, null, svnPath, sessionId);
            result.put("svncontent", svnContent);
            result.put("svnname", "Revision head");
        } else {
            svnVersionContent = this.getSvnVersionContent(id, type, fileName, SVNRevision.parse((String)newVersion), svnPath, sessionId);
            result.put("svncontent", svnVersionContent);
            result.put("svnname", "Revision " + newVersion);
        }
        this.setReturnData(response, result);
    }

    private Map<String, Object> getFileInfo(String id, String type) {
        HashMap<String, Object> fileInfo = new HashMap<String, Object>();
        if (SCRIPT.equalsIgnoreCase(type)) {
            LinkedHashMap<String, Object> scriptInfo = this.getScriptDynamicObject(id);
            fileInfo.put(CONTENT, scriptInfo.get("txt_scriptcontext_tag"));
            fileInfo.put(FILENAME, scriptInfo.get(TXT_SCRIPT_NUMBER) + KS_PATH);
        } else if ("page".equalsIgnoreCase(type)) {
            LinkedHashMap<String, Object> pageInfo = this.getPageDynamicObject(id);
            fileInfo.put(CONTENT, (ArrayList)pageInfo.get(FILE_CONTENT));
            fileInfo.put(FILENAME, pageInfo.get(FILENAME));
        } else if ("app".equalsIgnoreCase(type)) {
            LinkedHashMap<String, Object> pageInfo = this.getAppDynamicObject(id);
            fileInfo.put(CONTENT, (ArrayList)pageInfo.get(FILE_CONTENT));
            fileInfo.put(FILENAME, pageInfo.get(FILENAME));
        } else if (CLOUD.equalsIgnoreCase(type)) {
            LinkedHashMap<String, Object> pageInfo = this.getCloudDynamicObject(id);
            fileInfo.put(CONTENT, (ArrayList)pageInfo.get(FILE_CONTENT));
            fileInfo.put(FILENAME, pageInfo.get(FILENAME));
        }
        return fileInfo;
    }

    private LinkedHashMap<String, Object> getPageDynamicObject(String formId) {
        String pageObjectString = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getPageContentByID", formId);
        Map ret = (Map)SerializationUtils.fromJsonString((String)pageObjectString, Map.class);
        LinkedHashMap pageInfo = (LinkedHashMap)ret.get("pageobject");
        return pageInfo;
    }

    private LinkedHashMap<String, Object> getScriptDynamicObject(String scriptId) {
        String scriptObjectString = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getScriptContentByID", scriptId);
        Map ret = (Map)SerializationUtils.fromJsonString((String)scriptObjectString, Map.class);
        LinkedHashMap scriptInfo = (LinkedHashMap)ret.get("scriptobject");
        return scriptInfo;
    }

    private LinkedHashMap<String, Object> getAppDynamicObject(String appId) {
        String appObjectString = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getAppContentByID", appId);
        Map ret = (Map)SerializationUtils.fromJsonString((String)appObjectString, Map.class);
        LinkedHashMap appInfo = (LinkedHashMap)ret.get("appobject");
        return appInfo;
    }

    private LinkedHashMap<String, Object> getCloudDynamicObject(String cloudId) {
        String cloudObjectString = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getCloudContentByID", cloudId);
        Map ret = (Map)SerializationUtils.fromJsonString((String)cloudObjectString, Map.class);
        LinkedHashMap cloudInfo = (LinkedHashMap)ret.get("cloudobject");
        return cloudInfo;
    }

    private Object getSvnVersionContent(String id, String type, String fileName, SVNRevision oldVersion, String svnPath, String sessionId) throws Exception {
        if ("page".equalsIgnoreCase(type)) {
            return this.getPageSvnVersionContent(id, oldVersion, svnPath, sessionId);
        }
        if ("app".equalsIgnoreCase(type)) {
            return this.getAppSvnVersionContent(id, oldVersion, svnPath, sessionId);
        }
        if (CLOUD.equals(type)) {
            return this.getCloudSvnVersionContent(id, oldVersion, svnPath, sessionId);
        }
        HashMap map = new HashMap(2);
        if (!VersionManageUtil.checkFileType((String)fileName, map)) {
            return null;
        }
        String svnFilePath = svnPath + METADATA + fileName;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JSONObject userInfo = this.getSvnUserInfo(svnPath, sessionId);
        String userName = userInfo.getString(USERNAME);
        String passWord = userInfo.getString(P);
        passWord = Encrypters.decode((String)passWord);
        SVNClientManager clientManager = this.authSvn(svnFilePath, userName, passWord);
        this.doGetFileContent(clientManager, oldVersion, svnFilePath, output);
        byte[] byteArr = output.toByteArray();
        String content = new String(byteArr, StandardCharsets.UTF_8);
        if (SCRIPT.equalsIgnoreCase(type)) {
            if (StringUtils.isBlank((CharSequence)content)) {
                return content;
            }
            return (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getScriptContentByFile", content);
        }
        if (A_PAGE.equalsIgnoreCase(type)) {
            return content;
        }
        return null;
    }

    private Object getPageSvnVersionContent(String formId, SVNRevision oldVersion, String svnPath, String sessionId) throws Exception {
        LinkedHashMap<String, Object> pageInfo = this.getPageDynamicObject(formId);
        ArrayList files = (ArrayList)pageInfo.get(FILE_CONTENT);
        ArrayList svnFiles = new ArrayList();
        for (int i = 0; i < files.size(); ++i) {
            Map file = (Map)files.get(i);
            String fileName = (String)file.get(FILENAME);
            String fileContent = (String)this.getSvnVersionContent(formId, A_PAGE, fileName, oldVersion, svnPath, sessionId);
            HashMap<String, String> svnFile = new HashMap<String, String>();
            svnFile.put(FILENAME, fileName);
            svnFile.put(FILE_CONTENT, fileContent);
            svnFiles.add(svnFile);
        }
        return svnFiles;
    }

    private Object getAppSvnVersionContent(String formId, SVNRevision oldVersion, String svnPath, String sessionId) throws Exception {
        LinkedHashMap<String, Object> appInfo = this.getAppDynamicObject(formId);
        ArrayList files = (ArrayList)appInfo.get(FILE_CONTENT);
        ArrayList svnFiles = new ArrayList();
        for (int i = 0; i < files.size(); ++i) {
            Map file = (Map)files.get(i);
            String fileName = (String)file.get(FILENAME);
            String fileContent = (String)this.getSvnVersionContent(formId, A_PAGE, fileName, oldVersion, svnPath, sessionId);
            HashMap<String, String> svnFile = new HashMap<String, String>();
            svnFile.put(FILENAME, fileName);
            svnFile.put(FILE_CONTENT, fileContent);
            svnFiles.add(svnFile);
        }
        return svnFiles;
    }

    private Object getCloudSvnVersionContent(String formId, SVNRevision oldVersion, String svnPath, String sessionId) throws Exception {
        LinkedHashMap<String, Object> cloudInfo = this.getCloudDynamicObject(formId);
        ArrayList files = (ArrayList)cloudInfo.get(FILE_CONTENT);
        ArrayList svnFiles = new ArrayList();
        for (int i = 0; i < files.size(); ++i) {
            Map file = (Map)files.get(i);
            String fileName = (String)file.get(FILENAME);
            String fileContent = (String)this.getSvnVersionContent(formId, A_PAGE, fileName, oldVersion, svnPath, sessionId);
            HashMap<String, String> svnFile = new HashMap<String, String>();
            svnFile.put(FILENAME, fileName);
            svnFile.put(FILE_CONTENT, fileContent);
            svnFiles.add(svnFile);
        }
        return svnFiles;
    }

    private void setReturnData(HttpServletResponse response, Map<String, Object> result) throws IOException {
        String resultToString = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resultToString);
    }

    public void submitToSvn(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bizAppId;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        Map<String, Object> result = new HashMap<String, Object>();
        String isChanged = request.getParameter("ischanged");
        if ("true".equals(isChanged)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            this.setReturnData(response, result);
            return;
        }
        String annotation = request.getParameter("annotation");
        String id = request.getParameter("id");
        String content = request.getParameter(CONTENT);
        String type = request.getParameter("type");
        String fileName = request.getParameter(FILENAME);
        String sessionId = request.getParameter(SVN_MSG);
        String svnPath = request.getParameter(SVN_PATH);
        map.clear();
        if (!VersionManageUtil.checkFileType((String)fileName, map)) {
            this.setReturnData(response, map);
            return;
        }
        JSONObject userInfo = this.getSvnUserInfo(svnPath, sessionId);
        String userName = userInfo.getString(USERNAME);
        String passWord = userInfo.getString(P);
        passWord = Encrypters.decode((String)passWord);
        String lockUser = null;
        if (CLOUD.equals(type)) {
            bizAppId = request.getParameter(BIZ_APP_ID);
            lockUser = this.getSVNLockUser(bizAppId, type, userName, passWord, fileName);
        } else {
            lockUser = this.getSVNLockUser(id, type, userName, passWord, fileName);
        }
        if (lockUser != null) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.FALSE);
            result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5df2\u88ab%s\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u5148\u627e\u4ed6\u89e3\u9501\uff01", (String)"SVNManagerAction_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]), lockUser));
            this.setReturnData(response, result);
            return;
        }
        if (SCRIPT.equalsIgnoreCase(type)) {
            result = this.submitScriptToSvn(id, type, content, userName, passWord, annotation);
        } else if ("page".equalsIgnoreCase(type) || A_PAGE.equalsIgnoreCase(type)) {
            result = this.submitPageToSvn(id, type, fileName, content, userName, passWord, annotation);
        } else if ("app".equalsIgnoreCase(type)) {
            result = this.submitAppToSvn(id, type, fileName, content, userName, passWord, annotation);
        } else if (CLOUD.equalsIgnoreCase(type)) {
            bizAppId = request.getParameter(BIZ_APP_ID);
            result = this.submitCloudToSvn(id, bizAppId, type, fileName, content, userName, passWord, annotation);
        }
        this.setReturnData(response, result);
    }

    private Map<String, Object> submitPageToSvn(String id, String type, String fileName, String content, String userName, String passWord, String annotation) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (content != null && !content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.FALSE);
            result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u6587\u672c\u5934\u5305\u542b\u975e\u6b63\u5e38\u5b57\u7b26\uff0c\u8bf7\u9a8c\u8bc1\u540e\u518d\u8fc1\u5165%s", (String)"SVNManagerAction_3", (String)BOS_WEBACTIONS, (Object[])new Object[0]), fileName));
            return result;
        }
        String message = (String)DispatchServiceHelper.invokeBOSService("UnitTestService", "checkInStatus", id);
        JSONObject jsonMsg = (JSONObject)JSONObject.parse((String)message);
        String msg = jsonMsg.getString("msg");
        String code = jsonMsg.getString("code");
        if (!"0".equals(code)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.FALSE);
            result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u8fc1\u5165\u5931\u8d25\uff0c\u9875\u9762\u672a\u7ed1\u5b9a\u5355\u5143\u6d4b\u8bd5\uff0c\u539f\u56e0\uff1a%s", (String)"SVNManagerAction_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]), msg));
            return result;
        }
        String bizAppId = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_ID_BY_FORM_ID, id);
        String bizAppNumber = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_NUMBER_BY_APP_ID, bizAppId);
        String localPath = System.getProperty(USER_HOME) + File.separator + METADATA1 + File.separator + bizAppNumber + File.separator + RequestContext.get().getTraceId();
        String svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, bizAppId);
        String fileContent = this.getNewFileContent(type, svnPath, fileName, content, userName, passWord, id);
        if (fileContent != null && fileContent.equals(content)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        this.exportNewFile(fileName, "page", localPath, content);
        File file = new File(this.getMetadataPath(localPath));
        File[] listFile = file.listFiles();
        Map<String, Object> checkoutMap = this.checkoutAppMetadata(file, this.getMetadataPath(svnPath), listFile, userName, passWord);
        if (checkoutMap.get(ERROR) == null) {
            Map<String, Object> commitMap = this.commitAppMetadata(file, this.getMetadataPath(svnPath), userName, passWord, annotation);
            this.showCommitMsg(commitMap, result);
        } else {
            result.put(SUBMIT_INFO, checkoutMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
        this.deleteFile(localPath);
        return result;
    }

    private Map<String, Object> submitAppToSvn(String id, String type, String fileName, String content, String userName, String passWord, String annotation) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String bizAppNumber = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_NUMBER_BY_APP_ID, id);
        String localPath = System.getProperty(USER_HOME) + File.separator + METADATA1 + File.separator + bizAppNumber + File.separator + RequestContext.get().getTraceId();
        String svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, id);
        String fileContent = this.getNewFileContent(type, svnPath, fileName, content, userName, passWord, id);
        if (fileContent != null && fileContent.equals(content)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        this.exportNewFile(fileName, "app", localPath, content);
        File file = new File(this.getMetadataPath(localPath));
        File[] listFile = file.listFiles();
        Map<String, Object> checkoutMap = this.checkoutAppMetadata(file, this.getMetadataPath(svnPath), listFile, userName, passWord);
        if (checkoutMap.get(ERROR) == null) {
            Map<String, Object> commitMap = this.commitAppMetadata(file, this.getMetadataPath(svnPath), userName, passWord, annotation);
            this.showCommitMsg(commitMap, result);
        } else {
            result.put(SUBMIT_INFO, checkoutMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
        this.deleteFile(localPath);
        return result;
    }

    private Map<String, Object> submitCloudToSvn(String bizCloudId, String bizAppId, String type, String fileName, String content, String userName, String passWord, String annotation) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String cloudStr = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, "getCloudInfoById", bizCloudId);
        JSONObject cloudObj = (JSONObject)JSONObject.parse((String)cloudStr);
        String bizCloudNumber = cloudObj.getString("number").toLowerCase();
        String localPath = System.getProperty(USER_HOME) + File.separator + METADATA1 + File.separator + bizCloudNumber + File.separator + RequestContext.get().getTraceId();
        String svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, bizAppId);
        String fileContent = this.getNewFileContent(type, svnPath, fileName, content, userName, passWord, bizCloudId);
        if (fileContent != null && fileContent.equals(content)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        this.exportNewFile(fileName, CLOUD, localPath, content);
        File file = new File(this.getMetadataPath(localPath));
        File[] listFile = file.listFiles();
        Map<String, Object> checkoutMap = this.checkoutAppMetadata(file, this.getMetadataPath(svnPath), listFile, userName, passWord);
        if (checkoutMap.get(ERROR) == null) {
            Map<String, Object> commitMap = this.commitAppMetadata(file, this.getMetadataPath(svnPath), userName, passWord, annotation);
            this.showCommitMsg(commitMap, result);
        } else {
            result.put(SUBMIT_INFO, checkoutMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
        this.deleteFile(localPath);
        return result;
    }

    private Map<String, Object> submitScriptToSvn(String id, String type, String content, String userName, String passWord, String annotation) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashMap<String, Object> scriptInfo = this.getScriptDynamicObject(id);
        String scriptNumber = (String)scriptInfo.get(TXT_SCRIPT_NUMBER);
        String bizAppId = (String)scriptInfo.get(BIZ_APP_ID);
        String bizAppNumber = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_NUMBER_BY_APP_ID, bizAppId);
        String localPath = System.getProperty(USER_HOME) + File.separator + METADATA1 + File.separator + bizAppNumber + File.separator + RequestContext.get().getTraceId();
        String svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, bizAppId);
        String fileContent = this.getNewFileContent(type, svnPath, scriptNumber, content, userName, passWord, id);
        if ("nochange".equals(fileContent)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        this.exportNewFile(scriptNumber, SCRIPT, localPath, fileContent);
        File file = new File(this.getMetadataPath(localPath));
        File[] listFile = file.listFiles();
        Map<String, Object> checkoutMap = this.checkoutAppMetadata(file, this.getMetadataPath(svnPath), listFile, userName, passWord);
        if (checkoutMap.get(ERROR) == null) {
            Map<String, Object> commitMap = this.commitAppMetadata(file, this.getMetadataPath(svnPath), userName, passWord, annotation);
            this.showCommitMsg(commitMap, result);
        } else {
            result.put(SUBMIT_INFO, checkoutMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
        this.deleteFile(localPath);
        return result;
    }

    private String getNewFileContent(String type, String svnPath, String fileName, String content, String userName, String passWord, String id) throws UnsupportedEncodingException {
        String svnFilePath = null;
        if (SCRIPT.equalsIgnoreCase(type)) {
            svnFilePath = svnPath + METADATA + fileName + KS_PATH;
        } else if ("page".equalsIgnoreCase(type) || A_PAGE.equalsIgnoreCase(type)) {
            svnFilePath = svnPath + METADATA + fileName;
        } else if ("app".equalsIgnoreCase(type) || CLOUD.equalsIgnoreCase(type)) {
            svnFilePath = svnPath + METADATA + fileName;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SVNClientManager clientManager = this.authSvn(svnFilePath, userName, passWord);
        this.doGetFileContent(clientManager, null, svnFilePath, output);
        byte[] byteArr = output.toByteArray();
        String svnFilecontent = new String(byteArr, StandardCharsets.UTF_8);
        if (SCRIPT.equalsIgnoreCase(type)) {
            String newSvnFileContent = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getNewScriptFileContent", id, content);
            if (svnFilecontent != null && svnFilecontent.equals(newSvnFileContent)) {
                return "nochange";
            }
            return newSvnFileContent;
        }
        if ("page".equalsIgnoreCase(type) || A_PAGE.equalsIgnoreCase(type) || "app".equalsIgnoreCase(type) || CLOUD.equalsIgnoreCase(type)) {
            return svnFilecontent;
        }
        return null;
    }

    private String getMetadataPath(String path) {
        return String.format("%s/metadata", path);
    }

    private File exportNewFile(String fileName, String type, String localPath, String content) throws IOException {
        String filePath = "";
        if (SCRIPT.equals(type)) {
            filePath = localPath + File.separator + METADATA1 + File.separator + fileName + KS_PATH;
        } else if ("page".equals(type) || A_PAGE.equals(type)) {
            filePath = localPath + File.separator + METADATA1 + File.separator + fileName;
        } else if ("app".equals(type) || CLOUD.equals(type)) {
            filePath = localPath + File.separator + METADATA1 + File.separator + fileName;
        }
        File file = new File(this.checkFilePath(filePath));
        File fileAbovePath = file.getParentFile();
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        if (file.exists()) {
            Files.delete(Paths.get(file.getPath(), new String[0]));
        }
        if (!file.createNewFile()) {
            throw new IOException(FILE_ALREADY_EXISTS);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            writer.write(content);
        }
        return file;
    }

    public void updateToLocale(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        String id = request.getParameter("id");
        String content = request.getParameter(CONTENT);
        String type = request.getParameter("type");
        String svnmsg = request.getParameter(SVN_MSG);
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        if (SCRIPT.equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updateScriptContent", id, content, svnmsg);
            result.put(SUCCESS, flag);
        } else if ("page".equalsIgnoreCase(type) || A_PAGE.equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updatePageContent", id, content);
            result.put(SUCCESS, flag);
        } else if ("app".equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updateAppContent", id, content);
            result.put(SUCCESS, flag);
        }
        this.setReturnData(response, result);
    }

    private SVNClientManager authSvn(String svnRoot, String username, String password) {
        this.setupLibrary();
        SVNRepository repository = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnRoot));
        }
        catch (SVNException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        if (repository != null) {
            repository.setAuthenticationManager(authManager);
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        return clientManager;
    }

    private void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private void doGetFileContent(SVNClientManager clientManager, SVNRevision revision, String svnuri, OutputStream output) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            SvnCat cat = client.getOperationsFactory().createCat();
            if (revision == null) {
                revision = SVNRevision.HEAD;
            }
            SVNURL uri = SVNURL.parseURIEncoded((String)svnuri);
            cat.setSingleTarget(SvnTarget.fromURL((SVNURL)uri));
            cat.setRevision(revision);
            cat.setOutput(output);
            cat.run();
        }
        catch (SVNException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> checkoutAppMetadata(File localPath, String originSvnUrl, File[] files, String username, String password) {
        Map<String, Object> retMap = new HashMap<String, Object>();
        try {
            SVNClientManager clientManager = this.authSvn(originSvnUrl, username, password);
            SVNURL srcURL = SVNURL.parseURIEncoded((String)originSvnUrl);
            retMap = this.checkout(clientManager, srcURL, SVNRevision.HEAD, localPath, SVNDepth.EMPTY, true);
            if (retMap.get(ERROR) != null) {
                return retMap;
            }
            retMap = this.update(clientManager, files, SVNRevision.HEAD, SVNDepth.EMPTY, true);
        }
        catch (SVNException e) {
            retMap.put(ERROR, "svn checkoutAppMetadata error:" + e.getMessage());
        }
        return retMap;
    }

    private Map<String, Object> checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File destPath, SVNDepth depth, boolean allowUnversionedObstructions) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            updateClient.doCheckout(url, destPath, revision, revision, depth, allowUnversionedObstructions);
        }
        catch (SVNException e) {
            retMap.put(ERROR, "svn checkout error:" + e.getMessage());
        }
        return retMap;
    }

    private Map<String, Object> update(SVNClientManager clientManager, File[] files, SVNRevision updateToRevision, SVNDepth depth, boolean allowUnversionedObstructions) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            updateClient.doUpdate(files, updateToRevision, depth, allowUnversionedObstructions, false);
        }
        catch (SVNException e) {
            retMap.put(ERROR, "svn update error:" + e.getMessage());
        }
        return retMap;
    }

    private Map<String, Object> commitAppMetadata(File localPath, String dstSvnUrl, String username, String password, String commitMessage) {
        HashMap<String, Object> retMap = new HashMap();
        SVNClientManager clientManager = this.authSvn(dstSvnUrl, username, password);
        boolean keepLocks = true;
        retMap = this.addEntry(clientManager, localPath);
        retMap = this.commit(clientManager, localPath, keepLocks, commitMessage);
        return retMap;
    }

    private Map<String, Object> addEntry(SVNClientManager clientManager, File wcPath) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            clientManager.getWCClient().doAdd(new File[]{wcPath}, true, false, false, SVNDepth.INFINITY, false, false, true);
        }
        catch (SVNException e) {
            retMap.put(ERROR, "svn addEntry error:" + e.getMessage());
        }
        return retMap;
    }

    private Map<String, Object> commit(SVNClientManager clientManager, File wcPath, boolean keepLocks, String commitMessage) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            clientManager.getCommitClient().doCommit(new File[]{wcPath}, keepLocks, commitMessage, null, null, false, false, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            retMap.put(ERROR, "svn commit error:" + e.getMessage());
        }
        return retMap;
    }

    public static String getSessionKey(String svnPath, String uuid) {
        String substring;
        String[] split2;
        String re = "((http|https|svn|file)://)(([a-zA-Z0-9._-]+)|([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}))(([a-zA-Z]{2,6})|(:[0-9]{1,4})?)";
        String sessionKey = "";
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(svnPath);
        sessionKey = matcher.matches() ? svnPath : ((split2 = svnPath.split(re)).length > 1 ? (substring = svnPath.substring(0, svnPath.length() - split2[1].length())) : split2[0]);
        String userId = RequestContext.get().getUserId();
        return sessionKey + uuid + userId;
    }

    public static String getSessionKeyForSvnDiff(String svnPath, String uuid) {
        return SVNManagerAction.getSessionKey(svnPath, uuid) + "_SvnDiff";
    }

    public static String getSessionIdForSvnDiff(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return DEFAUT_UUID_SVNDIFF;
        }
        return sessionId;
    }

    private String getSVNLockUser(String id, String type, String userName, String passWord, String fileName) throws SVNException {
        String svnPath;
        String svnFilePath = null;
        String bizAppId = null;
        if ("page".equals(type)) {
            bizAppId = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_ID_BY_FORM_ID, id);
            svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, bizAppId);
            svnFilePath = String.format(FORMAT, svnPath, fileName);
        } else if (SCRIPT.equals(type)) {
            LinkedHashMap<String, Object> scriptInfo = this.getScriptDynamicObject(id);
            String scriptNumber = (String)scriptInfo.get(TXT_SCRIPT_NUMBER);
            bizAppId = (String)scriptInfo.get(BIZ_APP_ID);
            String svnPath2 = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, bizAppId);
            svnFilePath = String.format("%s/metadata/%s.ks", svnPath2, scriptNumber);
        } else if ("app".equalsIgnoreCase(type) || CLOUD.equalsIgnoreCase(type)) {
            svnPath = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_SVN_PATH_BY_APP_ID, id);
            svnFilePath = svnPath + METADATA + fileName;
        }
        SVNClientManager clientManager = this.authSvn(svnFilePath, userName, passWord);
        SVNURL svnurl = null;
        try {
            svnurl = SVNURL.parseURIEncoded(svnFilePath);
        }
        catch (SVNException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String lockUser = null;
        SVNInfo doInfo = this.doInfo(clientManager, svnurl);
        if (doInfo != null && doInfo.getLock() != null) {
            lockUser = doInfo.getLock().getOwner();
        }
        return lockUser;
    }

    private SVNInfo doInfo(SVNClientManager clientManager, SVNURL url) throws SVNException {
        SVNWCClient client = clientManager.getWCClient();
        try {
            return client.doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNException e) {
            if (e.getMessage().indexOf("non-existent") != -1) {
                return null;
            }
            throw e;
        }
    }

    private void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                log.warn(delErrMsg);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    log.warn(delErrMsg);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                this.deleteKd(fileList[i]);
            }
            if (file.delete()) {
                log.warn(delErrMsg);
            }
        }
    }

    private void deleteFile(String deletePath) {
        File file = new File(deletePath);
        this.deleteKd(file);
    }

    public void saveCurrentContentToLocaleFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sourceId = request.getParameter("id");
        String sourceContent = request.getParameter(CONTENT);
        String sourceType = request.getParameter("type");
        String traceIdPath = request.getParameter("traceidpath");
        String sourceName = request.getParameter(FILENAME);
        if (StringUtils.isBlank((CharSequence)sourceName) && SCRIPT.equals(sourceType)) {
            LinkedHashMap<String, Object> scriptInfo = this.getScriptDynamicObject(sourceId);
            String scriptNumber = (String)scriptInfo.get(TXT_SCRIPT_NUMBER);
            sourceName = scriptNumber + KS_PATH;
        }
        map.clear();
        if (!VersionManageUtil.checkFileType((String)sourceName, map)) {
            this.setReturnData(response, map);
            return;
        }
        File sourceFile = new File(this.checkFilePath(traceIdPath + File.separator + sourceName));
        if (sourceFile.exists()) {
            Files.delete(Paths.get(sourceFile.getPath(), new String[0]));
        }
        if (!sourceFile.createNewFile()) {
            throw new IOException(FILE_ALREADY_EXISTS);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(sourceFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            writer.write(sourceContent);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        result.put(SUCCESS, Boolean.TRUE);
        this.setReturnData(response, result);
    }

    public void saveAllContentToLocaleFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sourceContent = request.getParameter(CONTENT);
        String traceIdPath = request.getParameter("traceidpath");
        JSONArray contents = (JSONArray)JSON.parse((String)sourceContent);
        map.clear();
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentObject = contents.getJSONObject(i);
            String fileName = contentObject.getString(FILE_NAME);
            String content = (String)contentObject.get((Object)CONTENT);
            if (!VersionManageUtil.checkFileType((String)fileName, map)) {
                this.setReturnData(response, map);
                return;
            }
            File sourceFile = new File(this.checkFilePath(traceIdPath + File.separator + fileName));
            if (sourceFile.exists()) {
                Files.delete(Paths.get(sourceFile.getPath(), new String[0]));
            }
            if (!sourceFile.createNewFile()) {
                throw new IOException(FILE_ALREADY_EXISTS);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(sourceFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                writer.write(sourceContent);
                continue;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        result.put(SUCCESS, Boolean.TRUE);
        this.setReturnData(response, result);
    }

    public void allsubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bizAppId;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String isChanged = request.getParameter("ischanged");
        if ("true".equals(isChanged)) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.TRUE);
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u4e0esvn\u5185\u5bb9\u4e00\u81f4\uff0c\u65e0\u9700\u63d0\u4ea4\uff01", (String)SVN_MANAGER_ACTION_0, (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            this.setReturnData(response, result);
            return;
        }
        String id = request.getParameter("id");
        String type = request.getParameter("type");
        String sourceContent = request.getParameter(CONTENT);
        String annotation = request.getParameter("annotation");
        JSONArray contents = (JSONArray)JSON.parse((String)sourceContent);
        map.clear();
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentObject = contents.getJSONObject(i);
            String tempFileName = contentObject.getString(FILE_NAME);
            if (!VersionManageUtil.checkFileType((String)tempFileName, map)) {
                this.setReturnData(response, map);
                return;
            }
            String content = (String)contentObject.get((Object)CONTENT);
            if (content == null || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) continue;
            result.put("type", "info");
            result.put(SUCCESS, Boolean.FALSE);
            result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u6587\u672c\u5934\u5305\u542b\u975e\u6b63\u5e38\u5b57\u7b26\uff0c\u8bf7\u9a8c\u8bc1\u540e\u518d\u8fc1\u5165%s", (String)"SVNManagerAction_3", (String)BOS_WEBACTIONS, (Object[])new Object[0]), tempFileName));
            this.setReturnData(response, result);
            return;
        }
        String fileName = contents.getJSONObject(0).getString(FILE_NAME);
        String sessionId = request.getParameter(SVN_MSG);
        String svnPath = request.getParameter(SVN_PATH);
        JSONObject userInfo = this.getSvnUserInfo(svnPath, sessionId);
        String userName = userInfo.getString(USERNAME);
        String passWord = userInfo.getString(P);
        passWord = Encrypters.decode((String)passWord);
        String lockUser = null;
        if (CLOUD.equals(type)) {
            bizAppId = request.getParameter(BIZ_APP_ID);
            lockUser = this.getSVNLockUser(bizAppId, type, userName, passWord, fileName);
        } else {
            lockUser = this.getSVNLockUser(id, type, userName, passWord, fileName);
        }
        if (lockUser != null) {
            result.put("type", "info");
            result.put(SUCCESS, Boolean.FALSE);
            result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5df2\u88ab%s\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u5148\u627e\u4ed6\u89e3\u9501\uff01", (String)"SVNManagerAction_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]), lockUser));
            this.setReturnData(response, result);
            return;
        }
        bizAppId = "";
        if (!CLOUD.equals(type)) {
            String message = (String)DispatchServiceHelper.invokeBOSService("UnitTestService", "checkInStatus", id);
            JSONObject jsonMsg = (JSONObject)JSONObject.parse((String)message);
            String msg = jsonMsg.getString("msg");
            String code = jsonMsg.getString("code");
            if (!"0".equals(code)) {
                result.put("type", "info");
                result.put(SUCCESS, Boolean.FALSE);
                result.put(SUBMIT_INFO, String.format(ResManager.loadKDString((String)"\u8fc1\u5165\u5931\u8d25\uff0c\u9875\u9762\u672a\u7ed1\u5b9a\u5355\u5143\u6d4b\u8bd5\uff0c\u539f\u56e0\uff1a%s", (String)"SVNManagerAction_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]), msg));
                this.setReturnData(response, result);
                return;
            }
            bizAppId = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_ID_BY_FORM_ID, id);
        } else {
            bizAppId = request.getParameter(BIZ_APP_ID);
        }
        String bizAppNumber = (String)DispatchServiceHelper.invokeBOSService(BIZ_APP_SERVICE, GET_APP_NUMBER_BY_APP_ID, bizAppId);
        String localPath = System.getProperty(USER_HOME) + File.separator + METADATA1 + File.separator + bizAppNumber + File.separator + RequestContext.get().getTraceId();
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentObject = contents.getJSONObject(i);
            String tempFileName = contentObject.getString(FILE_NAME);
            String content = (String)contentObject.get((Object)CONTENT);
            this.exportNewFile(tempFileName, "page", localPath, content);
        }
        File file = new File(this.getMetadataPath(localPath));
        File[] listFile = file.listFiles();
        Map<String, Object> checkoutMap = this.checkoutAppMetadata(file, this.getMetadataPath(svnPath), listFile, userName, passWord);
        if (checkoutMap.get(ERROR) == null) {
            Map<String, Object> commitMap = this.commitAppMetadata(file, this.getMetadataPath(svnPath), userName, passWord, annotation);
            this.showCommitMsg(commitMap, result);
        } else {
            result.put(SUBMIT_INFO, checkoutMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
        this.deleteFile(localPath);
        this.setReturnData(response, result);
    }

    public void allupdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String id = request.getParameter("id");
        String sourceContent = request.getParameter(CONTENT);
        JSONArray contents = (JSONArray)JSON.parse((String)sourceContent);
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentObject = contents.getJSONObject(i);
            String content = (String)contentObject.get((Object)CONTENT);
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updatePageContent", id, content);
            result.put(SUCCESS, flag);
        }
        result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u5df2\u5c06\u6240\u6709\u9875\u7b7e\u7684\u5de6\u4fa7\u5185\u5bb9\u66f4\u65b0\u5230\u672c\u5730\uff01", (String)"SVNManagerAction_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        result.put(SUCCESS, Boolean.TRUE);
        this.setReturnData(response, result);
    }

    private void showCommitMsg(Map<String, Object> commitMap, Map<String, Object> result) {
        if (commitMap.get(ERROR) == null) {
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5c06\u53f3\u4fa7\u5185\u5bb9\u63d0\u4ea4\u5230svn\uff01", (String)"SVNManagerAction_6", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            result.put(SUCCESS, Boolean.TRUE);
        } else if (commitMap.get(ERROR).toString().indexOf("locked in") != -1) {
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"svn\u4e0a\u9875\u9762\u5143\u6570\u636e\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5230svn\uff0c\u8bf7\u627e\u9501\u5b9a\u4eba\u5148\u89e3\u9501\uff01", (String)"SVNManagerAction_7", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            result.put(SUCCESS, Boolean.FALSE);
        } else if (commitMap.get(ERROR).toString().indexOf("Authentication required") != -1 || commitMap.get(ERROR).toString().indexOf("403 Forbidden") != -1) {
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"svn\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6216\u8d26\u6237\u6ca1\u6709\u5199\u6743\u9650\uff0c\u8bf7\u5c1d\u8bd5\u6e05\u7406\u6d4f\u89c8\u5668\u7f13\u5b58\u91cd\u65b0\u767b\u5f55\uff01", (String)"SVNManagerAction_8", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            result.put(SUCCESS, Boolean.FALSE);
        } else if (commitMap.get(ERROR).toString().indexOf("Commit must be written comments") != -1) {
            result.put(SUBMIT_INFO, ResManager.loadKDString((String)"\u8bf7\u586b\u5199SVN\u6ce8\u91ca\uff01", (String)"SVNManagerAction_9", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            result.put(SUCCESS, Boolean.FALSE);
        } else {
            result.put(SUBMIT_INFO, commitMap.get(ERROR));
            result.put(SUCCESS, Boolean.FALSE);
        }
    }

    private String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    private JSONObject getSvnUserInfo(String svnPath, String sessionId) {
        DistributeSessionlessCache loginInfoCache;
        JSONObject userInfo = null;
        try {
            String sessionIdForSvnDiff = SVNManagerAction.getSessionIdForSvnDiff(sessionId);
            String sessionKey = SVNManagerAction.getSessionKeyForSvnDiff(svnPath, sessionIdForSvnDiff);
            SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)sessionIdForSvnDiff);
            String info = sessionDao.getAttribute(sessionKey);
            if (info == null) {
                sessionKey = SVNManagerAction.getSessionKey(svnPath, sessionIdForSvnDiff);
                info = sessionDao.getAttribute(sessionKey);
            }
            userInfo = JSONObject.parseObject((String)info);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (userInfo == null) {
            userInfo = new JSONObject();
        }
        if ((StringUtils.isBlank((Object)userInfo.get((Object)USERNAME)) || StringUtils.isBlank((Object)userInfo.get((Object)P))) && (loginInfoCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGIONINFO, new DistributeCacheHAPolicy())) != null) {
            userInfo.put(USERNAME, loginInfoCache.get(USERNAME));
            userInfo.put(P, loginInfoCache.get(P));
            log.warn((String)loginInfoCache.get(P));
        }
        return userInfo;
    }

    private boolean verifyInterface(Map<String, Object> result) {
        VersionManageUtil.checkPermission(result, (boolean)false);
        return result.get(SUCCESS) == null;
    }
}

