/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.ctsy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.StringUtils;
import kd.bos.web.DispatchServiceHelper;

@ApiController(value="ctform", desc="\u8de8\u79df\u6237\u534f\u4f5c\u8868\u5355\u670d\u52a1")
@ApiMapping(value="/ctform")
public class CTFormController {
    private static Log log = LogFactory.getLog(CTFormController.class);
    private static final String TYPE_NAME = "CTFormController";
    private static final String FORM_SERVICE = "FormService";
    private static final String FORM_ID = "formId";
    private static final String PARAMS = "params";
    private static final String RESULT = "result";
    private static final String BOS_WEBACTIONS = "bos-webactions";

    /*
     * Loose catch block
     */
    @ApiPostMapping(value="/handle", desc="\u5904\u7406\u8868\u5355\u8bf7\u6c42")
    public CustomApiResult<String> handle(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) @ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) Map<String, Object> params) {
        Throwable throwable = null;
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"handle");){
            span.addLocaleTag(PARAMS, params);
            Object result = null;
            try {
                String method = params.get("method") == null ? "" : (String)params.get("method");
                log.info("\u5904\u7406\u8de8\u79df\u6237\u534f\u4f5c\u8868\u5355\u7684\u8c03\u7528\u8bf7\u6c42\u53c2\u6570:{}.", (Object)SerializationUtils.toJsonString(params));
                result = "batchInvokeAction".equals(method) ? this.batchInvokeAction(params) : ("getConfig".equals(method) ? this.getConfig(params) : ("getCtsyMetadata".equals(method) ? this.getCtsyMetadata(params) : ("postChildFormStates".equals(method) ? this.postChildFormStates(params) : ("getListSelectedRows".equals(method) ? this.getListSelectedRows(params) : ("getConfigByPageId".equals(method) ? this.getConfigByPageId(params) : CustomApiResult.fail((String)"101", (String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65b9\u6cd5\u201c%1$s\u201d\u7684\u8bf7\u6c42\u3002", (String)"CTFormController_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]), method)))))));
                log.info("\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}.", (Object)SerializationUtils.toJsonString(result));
                span.addLocaleTag(RESULT, result);
                CustomApiResult customApiResult = result;
                return customApiResult;
            }
            catch (Exception e) {
                CustomApiResult customApiResult;
                block18: {
                    block19: {
                        if (span != null) {
                            span.throwException((Throwable)e);
                        }
                        log.error("Accepting a remote tenant's call request exception: {}", (Throwable)e);
                        customApiResult = CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u5904\u7406\u8de8\u79df\u6237\u534f\u4f5c\u8868\u5355\u7684\u8c03\u7528\u8bf7\u6c42\u5f02\u5e38\u3002", (String)"CTFormController_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                        if (span == null) break block18;
                        if (throwable == null) break block19;
                        try {
                            span.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block18;
                    }
                    span.close();
                }
                return customApiResult;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private CustomApiResult<String> batchInvokeAction(Map<String, Object> params) {
        try {
            String pageId = params.get("pageId") == null ? "" : (String)params.get("pageId");
            String appId = params.get("appId") == null ? "" : (String)params.get("appId");
            String dataParams = params.get("dataParams") == null ? "" : (String)params.get("dataParams");
            JSONObject actionParamsStr = (JSONObject)params.get("actionParams");
            Map actionParams = (Map)JSONObject.toJavaObject((JSON)actionParamsStr, Map.class);
            String data = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "batchInvokeAction", pageId, dataParams, actionParams);
            return CustomApiResult.success((Object)data);
        }
        catch (Exception e) {
            log.error("Accept call requests from remote tenants,call batchInvokeAction request exception\uff1a {}", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u8c03\u7528batchInvokeAction\u8bf7\u6c42\u5931\u8d25\u3002", (String)"CTFormController_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private CustomApiResult<String> getConfig(Map<String, Object> params) {
        try {
            String formId = (String)params.get(FORM_ID);
            String type = (String)params.get("type");
            if ("list".equals(type)) {
                formId = (String)params.get("billFormId");
            }
            String appId = "bos";
            try {
                appId = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getAppId", formId);
            }
            catch (KDException e) {
                log.error("Accept call requests from remote tenants,appId exception to get interface configuration information for the form: {}", (Throwable)e);
            }
            String config = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "getConfig", params);
            return CustomApiResult.success((Object)config);
        }
        catch (Exception e) {
            log.error("Accept call requests from remote tenants,Error retrieving interface configuration information for the form: {}", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u8868\u5355\u7684\u754c\u9762\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\u3002", (String)"CTFormController_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private CustomApiResult<String> getCtsyMetadata(Map<String, Object> params) {
        try {
            String id;
            String string = id = params.get(FORM_ID) == null ? "" : (String)params.get(FORM_ID);
            if (StringUtils.isNotEmpty((String)id)) {
                String appId = "bos";
                try {
                    appId = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getAppId", id);
                }
                catch (KDException e) {
                    log.error("Receive a call request from a remote tenant,appId exception to get interface configuration information for the form: {}", (Object)e.getMessage());
                }
                String metadata = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, "MetadataService", "loadClientFormMeta", id);
                return CustomApiResult.success((Object)metadata);
            }
            return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CTFormController_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("Get the client metadata exception for the remote tenant\uff1a {}", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"CTFormController_6", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private CustomApiResult<String> postChildFormStates(Map<String, Object> params) {
        try {
            String pageId = params.get("pageId") == null ? "" : (String)params.get("pageId");
            String serviceAppId = params.get("serviceAppId") == null ? "" : (String)params.get("serviceAppId");
            List postDatas = params.get("postDatas") == null ? null : (List)params.get("postDatas");
            DispatchServiceHelper.invokeBOSServiceByAppId(serviceAppId, FORM_SERVICE, "postChildFormStates", pageId, postDatas);
            return CustomApiResult.success((Object)"");
        }
        catch (Exception e) {
            log.error("Interface data entry data back to the back-end exception: {}", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u5f55\u5165\u6570\u636e\u56de\u4f20\u7ed9\u540e\u7aef\u5931\u8d25\u3002", (String)"CTFormController_7", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private CustomApiResult<String> getConfigByPageId(Map<String, Object> params) {
        try {
            String pageId = params.get("pageId") == null ? "" : (String)params.get("pageId");
            String config = (String)DispatchServiceHelper.invokeBOSService(FORM_SERVICE, "getConfigByPageId", pageId);
            return CustomApiResult.success((Object)config);
        }
        catch (Exception e) {
            log.error("Accept the remote tenant's call request to obtain the configByPageId exception: ", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u6839\u636e\u9875\u9762id\u83b7\u53d6\u5ba2\u6237\u7aef\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"CTFormController_8", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }

    private CustomApiResult<String> getListSelectedRows(Map<String, Object> params) {
        try {
            String appId;
            String pageId = params.get("pageId") == null ? "" : (String)params.get("pageId");
            String string = appId = params.get("appId") == null ? "" : (String)params.get("appId");
            if (StringUtils.isNotEmpty((String)pageId) && StringUtils.isNotEmpty((String)appId)) {
                String datas = (String)DispatchServiceHelper.invokeBOSServiceByAppId(appId, FORM_SERVICE, "getListSelectedRows", pageId);
                return CustomApiResult.success((Object)datas);
            }
            return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CTFormController_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("Accept the remote tenant's call request to obtain the selected row exception: ", (Throwable)e);
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u9009\u4e2d\u884c\u5931\u8d25\u3002", (String)"CTFormController_3", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        }
    }
}

