/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.report;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.mservice.report.CacheDataFilter;

class CacheDataXFilter
extends CacheDataFilter {
    CacheDataXFilter() {
    }

    @Override
    protected DataSet doFilter(DataSet dataSet, String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return dataSet;
        }
        String algoKey = this.getClass().getName() + "#doFilter";
        JobSession session = AlgoX.createSession((String)algoKey, (String)"doFilter");
        DataSetInput input = new DataSetInput(dataSet);
        DataSetX datasetX = session.fromInput((Input)input);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            datasetX = datasetX.filter((FilterFunction)new FormulaFilter(filter));
        }
        DataSetOutput output = new DataSetOutput(dataSet.getRowMeta());
        String outputId = output.getId();
        datasetX.output((Output)output);
        DataSet outDataSet = null;
        session.commit(90, TimeUnit.SECONDS);
        outDataSet = session.readDataSet(outputId);
        return outDataSet;
    }

    static class FormulaFilter
    extends FilterFunction
    implements Serializable {
        private String filter;
        private transient BOSExpression expression;
        private transient Map<String, Integer> fieldIndexs = null;

        public FormulaFilter(String filter) {
            this.filter = filter;
        }

        public boolean test(RowX rowX) {
            if (this.getExpression().getExpr() == null) {
                return true;
            }
            Map<String, Object> ctx = this.getVarVals(rowX);
            return (Boolean)FormulaEngine.execExcelFormula((Expr)this.getExpression().getExpr(), ctx);
        }

        private Map<String, Object> getVarVals(RowX rowX) {
            Map<String, Integer> indexs = this.getFieldIndexs();
            HashMap<String, Object> varValues = new HashMap<String, Object>(indexs.size());
            for (Map.Entry<String, Integer> var : indexs.entrySet()) {
                varValues.put(var.getKey(), rowX.get(var.getValue().intValue()));
            }
            return varValues;
        }

        private BOSExpression getExpression() {
            if (this.expression == null) {
                this.expression = new BOSExpression(this.filter);
            }
            return this.expression;
        }

        private Map<String, Integer> getFieldIndexs() {
            BOSExpression expr = this.getExpression();
            if (this.fieldIndexs == null) {
                if (expr.getVars() == null || expr.getVars().isEmpty()) {
                    this.fieldIndexs = new HashMap<String, Integer>(0);
                } else {
                    this.fieldIndexs = new HashMap<String, Integer>(expr.getVars().size());
                    RowMeta rowMeta = this.getSourceRowMeta();
                    for (String var : expr.getVars()) {
                        this.fieldIndexs.put(var, rowMeta.getFieldIndex(var));
                    }
                }
            }
            return this.fieldIndexs;
        }
    }
}

