/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.bizlog;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.log.api.EntityModifyInfo;
import kd.bos.log.api.FieldModifyInfo;
import kd.bos.log.api.IBizModifyDirtyManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class BizModifyDirtyManager
implements IBizModifyDirtyManager {
    private static Log log = LogFactory.getLog(BizModifyDirtyManager.class);
    private MainEntityType _mainEntityType;
    private DynamicObject[] _successObjs;
    protected Map<String, String[]> _modifyFields = new HashMap<String, String[]>();
    protected String[] _monitorFields = null;
    private Map<String, Tuple<String, String>> _modifyContent = new HashMap<String, Tuple<String, String>>();
    private Map<String, EntityModifyInfo> _modifyInfos = new HashMap<String, EntityModifyInfo>();
    private Map<String, String> _modifyFlag = new HashMap<String, String>();
    private String _operate;
    private FormatObject _format;
    private Map<String, List<IDataEntityProperty>> _monitorFieldsByEntity = new HashMap<String, List<IDataEntityProperty>>(8);

    public void init(DynamicObjectType dynamicObjectType, DynamicObject[] successObjs, String operate) {
        this._mainEntityType = (MainEntityType)dynamicObjectType;
        this._successObjs = successObjs;
        this._operate = operate;
        this._modifyFields = new HashMap<String, String[]>();
        this._monitorFields = null;
        this._modifyContent = new HashMap<String, Tuple<String, String>>();
        this._modifyInfos = new HashMap<String, EntityModifyInfo>();
        this._modifyFlag = new HashMap<String, String>();
        try {
            String[] monitorFields = this.getMonitorFields();
            if (monitorFields.length > 0) {
                this._format = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
                this.build();
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Object)e);
        }
    }

    public String[] getModifyFieldsFullNameInMonitor(String pkValue) {
        EntityModifyInfo info = this._modifyInfos.get(pkValue);
        if (info == null) {
            return new String[0];
        }
        List modifyFields = info.getModifyFields();
        if (modifyFields == null || modifyFields.size() == 0) {
            return new String[0];
        }
        return modifyFields.toArray(new String[0]);
    }

    private String[] getMonitorFields() {
        List<String> ruleFields = this.getMonitorRule();
        HashSet<String> set = new HashSet<String>(16);
        for (String ruleField : ruleFields) {
            String[] oldArr = ruleField.split(",");
            for (int i = 1; i < oldArr.length; ++i) {
                set.add(oldArr[i].substring(oldArr[i].lastIndexOf("(") + 1, oldArr[i].length() - 1));
            }
        }
        String[] array = new String[set.size()];
        set.toArray(array);
        this._monitorFields = array;
        return this._monitorFields;
    }

    public Tuple<String, String> getModifyContent(String pkValue) {
        return this._modifyContent.get(pkValue);
    }

    public EntityModifyInfo getEntityModifyInfo(String pkValue) {
        return this._modifyInfos.get(pkValue);
    }

    public String getModifyFlag(String pkValue) {
        String r = this._modifyFlag.get(pkValue);
        if (r == null) {
            r = "";
        }
        return r;
    }

    private void build() {
        Map cacheObjs;
        DynamicObject mainObj;
        if (this._successObjs == null || this._successObjs.length == 0) {
            return;
        }
        boolean isDelete_MainObj = this.isDeleteOperate();
        ArrayList<Boolean> isNew_MainObjList = new ArrayList<Boolean>(this._successObjs.length);
        if (isDelete_MainObj) {
            ArrayList<Object> pkValList = new ArrayList<Object>(this._successObjs.length);
            for (int i = 0; i < this._successObjs.length; ++i) {
                mainObj = this._successObjs[i];
                Object pkValObj = mainObj.getPkValue();
                isNew_MainObjList.add(Boolean.FALSE);
                if (pkValObj == null) continue;
                pkValList.add(pkValObj);
            }
            cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])pkValList.toArray(), (String)this._mainEntityType.getName());
        } else {
            DynamicObjectType dynamicObjectType;
            cacheObjs = new HashMap(this._successObjs.length);
            HashMap dObjTypePkMap = new HashMap(6);
            for (int i = 0; i < this._successObjs.length; ++i) {
                mainObj = this._successObjs[i];
                dynamicObjectType = mainObj.getDynamicObjectType();
                ArrayList<Object> pkKist = (ArrayList<Object>)dObjTypePkMap.get(dynamicObjectType);
                if (pkKist == null) {
                    pkKist = new ArrayList<Object>(6);
                    dObjTypePkMap.put(dynamicObjectType, pkKist);
                }
                Object pkValObj = mainObj.getPkValue();
                boolean isNew_MainObj = !mainObj.getDataEntityState().getFromDatabase();
                isNew_MainObjList.add(isNew_MainObj);
                if (pkValObj == null) continue;
                pkKist.add(pkValObj);
            }
            for (Map.Entry entry : dObjTypePkMap.entrySet()) {
                dynamicObjectType = (DynamicObjectType)entry.getKey();
                List pkList = (List)entry.getValue();
                if (pkList.isEmpty()) continue;
                Map entryCacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])pkList.toArray(), (DynamicObjectType)dynamicObjectType);
                cacheObjs.putAll(entryCacheObjs);
            }
        }
        for (int i = 0; i < this._successObjs.length; ++i) {
            DynamicObject mainObj2 = this._successObjs[i];
            Object pkValObj = mainObj2.getPkValue();
            if (pkValObj == null) continue;
            boolean isNew_MainObj = (Boolean)isNew_MainObjList.get(i);
            DynamicObject cacheObj = (DynamicObject)cacheObjs.get(pkValObj);
            EntityModifyInfo info = this.buildMainEntry(mainObj2, cacheObj, isDelete_MainObj, isNew_MainObj);
            String pkValStr = pkValObj.toString();
            this.buildContent(pkValStr, info);
        }
    }

    public void buildContent(String pkValStr, EntityModifyInfo info) {
        if (info != null) {
            ObjectMapper mapper = new ObjectMapper();
            String modifyContentStr = null;
            try {
                modifyContentStr = mapper.writeValueAsString((Object)info);
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            this._modifyFlag.put(pkValStr, info.getFlag());
            this._modifyContent.put(pkValStr, (Tuple<String, String>)new Tuple((Object)info.toString(), (Object)modifyContentStr));
            this._modifyInfos.put(pkValStr, info);
        }
    }

    private EntityModifyInfo buildMainEntry(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDelete_MainObj, boolean isNew_MainObj) {
        FieldModifyInfo fieldModifyInfo;
        IDataEntityType mainEntityType = mainObj.getDataEntityType();
        String pkValueStr = mainObj.getPkValue().toString();
        ArrayList<IDataEntityProperty> maimDirtyProps = new ArrayList<IDataEntityProperty>();
        boolean isUpdateMainObj = !isDelete_MainObj && !isNew_MainObj;
        EntityModifyInfo mainModifyInfo = new EntityModifyInfo();
        mainModifyInfo.setKeyID(pkValueStr);
        String billNo = this.getBillNo(mainObj);
        if (!StringUtils.isBlank((CharSequence)billNo)) {
            mainModifyInfo.setCaption(billNo);
        }
        if (isDelete_MainObj) {
            this.parseDirtyProp(oldMainObj, maimDirtyProps, null, false);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("-");
        } else if (isNew_MainObj) {
            this.parseDirtyProp(mainObj, maimDirtyProps, null, false);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("+");
        } else {
            this.parseDirtyProp(mainObj, maimDirtyProps, null, true);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
        }
        if (isDelete_MainObj) {
            mainEntityType = oldMainObj.getDataEntityType();
        }
        for (ICollectionProperty subEntryProperty : mainEntityType.getProperties().getCollectionProperties(false)) {
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty || subEntryProperty instanceof MulBasedataProp) continue;
            if (isDelete_MainObj) {
                DynamicObjectCollection oldSubObjs = oldMainObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj) : null;
                if (oldSubObjs == null) continue;
                for (int index = 0; index < oldSubObjs.size(); ++index) {
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, index, null, oldSubObj, subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                continue;
            }
            if (!this.isEntryInMonitor(subEntryName)) continue;
            DynamicObjectCollection subObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
            DynamicObjectCollection oldSubObjs = oldMainObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj) : null;
            LinkedHashMap<Object, DynamicObject> oldSubObjMap = new LinkedHashMap<Object, DynamicObject>(oldSubObjs == null ? 8 : oldSubObjs.size());
            if (oldSubObjs != null) {
                for (DynamicObject dObj : oldSubObjs) {
                    oldSubObjMap.put(dObj.getPkValue(), dObj);
                }
            }
            if (subObjs != null) {
                for (int index = 0; index < subObjs.size(); ++index) {
                    EntityModifyInfo subModifyInfo;
                    DynamicObject subObj = (DynamicObject)subObjs.get(index);
                    Object subObjPkValue = subObj.getPkValue();
                    if (subObjPkValue == null) continue;
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjMap.get(subObjPkValue);
                    boolean isNewRow = false;
                    if (oldSubObj == null) {
                        isNewRow = true;
                    }
                    if ((subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, isNewRow, false, subEntryProperty, index, subObj, oldSubObj, subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
            }
            if (!isUpdateMainObj || oldSubObjs == null || this._monitorFields == null) continue;
            ArrayList<DynamicObject> deletedSubObjs = new ArrayList<DynamicObject>(8);
            LinkedHashMap<Object, DynamicObject> subObjMap = new LinkedHashMap<Object, DynamicObject>(oldSubObjs == null ? 8 : subObjs.size());
            for (DynamicObject subObj : subObjs) {
                subObjMap.put(subObj.getPkValue(), subObj);
            }
            for (DynamicObject oldSubObj : oldSubObjs) {
                if (subObjMap.containsKey(oldSubObj.getPkValue())) continue;
                deletedSubObjs.add(oldSubObj);
            }
            if (deletedSubObjs == null) continue;
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                mainModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return mainModifyInfo;
    }

    private EntityModifyInfo buildSubEntry(boolean isDelete_MainObj, boolean isNew_MainObj, boolean isNewRow, boolean isDeleteRow, ICollectionProperty collectionProperty, int indexOfEntry, DynamicObject obj, DynamicObject oldObj, String parentPropertyPath) {
        FieldModifyInfo fieldModifyInfo;
        IDataEntityProperty entrySeq;
        String pkValueStr;
        Object newRowPkValue = obj != null ? obj.getPkValue() : null;
        String oldRowPkValue = oldObj != null ? oldObj.getPkValue().toString() : "";
        String string = pkValueStr = newRowPkValue != null ? newRowPkValue.toString() : oldRowPkValue;
        if (StringUtils.isBlank((CharSequence)pkValueStr)) {
            return null;
        }
        String entryDisplayName = collectionProperty.getDisplayName().getLocaleValue();
        DynamicObjectType subObjectType = obj != null ? obj.getDynamicObjectType() : oldObj.getDynamicObjectType();
        String seqStr = Integer.toString(indexOfEntry + 1);
        if (subObjectType instanceof IEntryType && (entrySeq = ((IEntryType)subObjectType).getSeqProperty()) != null) {
            try {
                Object seqVal = entrySeq.getValue((Object)(obj != null ? obj : oldObj));
                if (seqVal != null) {
                    seqStr = seqVal.toString();
                }
            }
            catch (ORMArgInvalidException e) {
                log.debug(e.getMessage());
            }
        }
        String caption = entryDisplayName + "." + seqStr;
        EntityModifyInfo entityModifyInfo = new EntityModifyInfo(pkValueStr, caption);
        ArrayList<IDataEntityProperty> dirtyProps = new ArrayList<IDataEntityProperty>();
        if (isDelete_MainObj) {
            this.parseDirtyProp(oldObj, dirtyProps, collectionProperty.getName(), false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDelete_MainObj);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("-");
        } else if (isNew_MainObj) {
            this.parseDirtyProp(obj, dirtyProps, collectionProperty.getName(), false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("+");
        } else {
            if (isDeleteRow) {
                this.parseDirtyProp(oldObj, dirtyProps, collectionProperty.getName(), false);
            } else {
                this.parseDirtyProp(obj, dirtyProps, collectionProperty.getName(), true);
            }
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
        }
        if (isDeleteRow || isDelete_MainObj) {
            entityModifyInfo.setFlag("-");
        } else if (isNew_MainObj || isNewRow) {
            entityModifyInfo.setFlag("+");
        }
        if (isDelete_MainObj) {
            subObjectType = oldObj.getDynamicObjectType();
        }
        for (ICollectionProperty subEntryProperty : subObjectType.getProperties().getCollectionProperties(false)) {
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty) continue;
            if (subEntryProperty instanceof MulBasedataProp) {
                FieldModifyInfo fieldModifyInfo2;
                String mulBasedataPropValue;
                MulBasedataProp mulbdProp = (MulBasedataProp)subEntryProperty;
                if (isDeleteRow) {
                    mulBasedataPropValue = this.getBaseDataFieldDisplayValue(oldObj, (IDataEntityProperty)mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                if (isNewRow) {
                    mulBasedataPropValue = this.getBaseDataFieldDisplayValue(obj, (IDataEntityProperty)mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                mulBasedataPropValue = this.getBaseDataFieldDisplayValue(obj, (IDataEntityProperty)mulbdProp);
                String mulBasedataPropValue_Old = this.getBaseDataFieldDisplayValue(oldObj, (IDataEntityProperty)mulbdProp);
                if ((StringUtils.isBlank((CharSequence)mulBasedataPropValue) || mulBasedataPropValue.equals(mulBasedataPropValue_Old)) && (StringUtils.isBlank((CharSequence)mulBasedataPropValue_Old) || mulBasedataPropValue_Old.equals(mulBasedataPropValue))) continue;
                FieldModifyInfo fieldModifyInfo3 = new FieldModifyInfo((Object)mulBasedataPropValue_Old, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo3);
                continue;
            }
            if (isDelete_MainObj) {
                DynamicObjectCollection oldSubObjs;
                if (!this.isEntryInMonitor(subEntryName) || (oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null) == null) continue;
                for (int index = 0; index < oldSubObjs.size(); ++index) {
                    int i = index;
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, false, subEntryProperty, index, null, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    entityModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                continue;
            }
            if (!this.isEntryInMonitor(subEntryName) || obj == null) continue;
            DynamicObjectCollection subObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)obj);
            DynamicObjectCollection oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null;
            LinkedHashMap<Object, DynamicObject> oldSubObjMap = new LinkedHashMap<Object, DynamicObject>(oldSubObjs == null ? 8 : oldSubObjs.size());
            if (oldSubObjs != null) {
                for (DynamicObject dObj : oldSubObjs) {
                    oldSubObjMap.put(dObj.getPkValue(), dObj);
                }
            }
            for (int index = 0; index < subObjs.size(); ++index) {
                EntityModifyInfo subModifyInfo;
                int i = index;
                DynamicObject subObj = (DynamicObject)subObjs.get(index);
                Object subObjPkValue = subObj.getPkValue();
                if (subObjPkValue == null) continue;
                DynamicObject oldSubObj = (DynamicObject)oldSubObjMap.get(subObjPkValue);
                boolean isSubObjNewRow = false;
                if (oldSubObj == null) {
                    isSubObjNewRow = true;
                }
                if ((subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, isSubObjNewRow, false, subEntryProperty, index, subObj, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subModifyInfo);
            }
            if (isNew_MainObj || oldSubObjs == null) continue;
            ArrayList<DynamicObject> deletedSubObjs = new ArrayList<DynamicObject>(8);
            LinkedHashMap<Object, DynamicObject> subObjMap = new LinkedHashMap<Object, DynamicObject>(oldSubObjs == null ? 8 : subObjs.size());
            for (DynamicObject subObj : subObjs) {
                subObjMap.put(subObj.getPkValue(), subObj);
            }
            for (DynamicObject oldSubObj : oldSubObjs) {
                if (subObjMap.containsKey(oldSubObj.getPkValue())) continue;
                deletedSubObjs.add(oldSubObj);
            }
            if (deletedSubObjs == null) continue;
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return entityModifyInfo;
    }

    private FieldModifyInfo buildFieldModifyInfo(DynamicObject obj, DynamicObject oldObj, IDataEntityProperty property, boolean isDelete) {
        LocaleString name = property.getDisplayName();
        String displayName = null;
        displayName = name != null ? name.toString() : property.getName();
        String newValue = null;
        if (obj != null && !isDelete) {
            newValue = this.getPropertyValue(obj, property);
        }
        String oldValue = null;
        if (oldObj != null) {
            oldValue = this.getPropertyValue(oldObj, property);
        }
        return new FieldModifyInfo((Object)oldValue, (Object)newValue, displayName);
    }

    private void parseDirtyProp(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName, boolean isUpdate) {
        List<IDataEntityProperty> monitorProps = this.getDirtyPropByMonitor(obj, entityPropName);
        if (monitorProps.size() == 0) {
            return;
        }
        if (isUpdate) {
            ArrayList<IDataEntityProperty> dirtyStateProps = new ArrayList<IDataEntityProperty>();
            this.parseDirtyPropByState(obj, dirtyStateProps, entityPropName);
            if (dirtyStateProps.size() == 0) {
                return;
            }
            for (IDataEntityProperty dirtyStateProp : dirtyStateProps) {
                if (!monitorProps.contains(dirtyStateProp)) continue;
                dirtyProps.add(dirtyStateProp);
            }
        } else {
            dirtyProps.addAll(monitorProps);
        }
        dirtyProps.sort((m1, m2) -> Integer.compare(m1.getOrdinal(), m2.getOrdinal()));
    }

    private List<IDataEntityProperty> getDirtyPropByMonitor(DynamicObject obj, String entityPropName) {
        String key = entityPropName;
        List<IDataEntityProperty> ret = this._monitorFieldsByEntity.get(key);
        if (ret == null) {
            ArrayList<IDataEntityProperty> monitorProps = new ArrayList<IDataEntityProperty>();
            this.parseDirtyPropByMonitor(obj, monitorProps, entityPropName);
            ret = monitorProps;
            this._monitorFieldsByEntity.put(key, ret);
        }
        return ret;
    }

    private void parseDirtyPropByMonitor(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName) {
        if (this._monitorFields == null || this._monitorFields.length == 0) {
            return;
        }
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        String[] stringArray = this._monitorFields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty prop;
            String monitorField;
            String theField = monitorField = stringArray[i];
            if (entityPropName == null && monitorField.indexOf(46) > 0) continue;
            if (entityPropName != null) {
                theField = theField.replace(entityPropName + ".", "");
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)theField)) == null) continue;
            dirtyProps.add(prop);
        }
    }

    private void parseDirtyPropByState(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName) {
        Iterator iterator = obj.getDataEntityState().GetDirtyProperties().iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property;
            IDataEntityProperty realProperty = property = (IDataEntityProperty)iterator.next();
            if (property instanceof PKFieldProp && property.getName().endsWith("_id")) {
                String bdPropName = property.getName().substring(0, property.getName().length() - 3);
                realProperty = (IDataEntityProperty)property.getParent().getProperties().get((Object)bdPropName);
                if (realProperty == null) {
                    realProperty = property;
                }
            }
            dirtyProps.add(realProperty);
        }
    }

    private List<String> getMonitorRule() {
        if (this._successObjs == null || this._successObjs.length <= 0) {
            return new ArrayList<String>();
        }
        String pkValue = this._successObjs[0].getDataEntityType().getName();
        Map rulesMap = BusinessDataServiceHelper.loadFromCache((String)"al_rule_setting", (String)"modifyfields", (QFilter[])new QFilter[]{new QFilter("bizobj", "=", (Object)pkValue), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (rulesMap.size() == 0) {
            return new ArrayList<String>();
        }
        return rulesMap.values().stream().map(v -> v.get("modifyfields").toString()).collect(Collectors.toList());
    }

    private boolean isEntryInMonitor(String entryPropertyName) {
        if (this._monitorFields == null || this._monitorFields.length == 0 || entryPropertyName == null) {
            return false;
        }
        for (String monitorField : this._monitorFields) {
            if (!monitorField.toLowerCase(Locale.ENGLISH).startsWith(entryPropertyName.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private String getPropertyValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof IFieldHandle) {
            if (dynamicProperty instanceof TimeProp) {
                TimeProp timeProp = (TimeProp)dynamicProperty;
                Object timePropObj = timeProp.getBasePropDisplayValue((Object)dynamicObject);
                return timePropObj != null ? timePropObj.toString() : null;
            }
            try {
                Object[] val;
                if (dynamicProperty instanceof IBasedataField) {
                    return this.getBaseDataFieldDisplayValue(dynamicObject, dynamicProperty);
                }
                if (dynamicProperty instanceof DecimalProp) {
                    Object valueObj = dynamicProperty.getValue((Object)dynamicObject);
                    if (StringUtils.isNotBlank((Object)valueObj)) {
                        BigDecimal decimal = new BigDecimal(valueObj.toString());
                        return decimal.stripTrailingZeros().toPlainString();
                    }
                    return null;
                }
                IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                ListField listField = new ListField(dynamicProperty.getName());
                listField.setSrcFieldProp(dynamicProperty);
                listField.setFieldProp(dynamicProperty);
                AbstractColumnDesc listColumnDesc = fldHandle.getListColumnDesc(listField);
                listColumnDesc.setUserFormat(this._format);
                listColumnDesc.setFormaType(2);
                Object valueObj = listColumnDesc.getValue(dynamicObject);
                if (StringUtils.isBlank((Object)valueObj) && listColumnDesc instanceof ComboColumnDesc) {
                    valueObj = this.getValueFromDT(dynamicProperty, dynamicObject);
                }
                if (valueObj instanceof Object[] && (val = (Object[])valueObj).length > 0) {
                    Object o = val[0];
                    return o != null ? o.toString() : null;
                }
                return valueObj != null ? valueObj.toString() : null;
            }
            catch (Exception e1) {
                IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                Object dispValueObj = fldHandle.getBasePropDisplayValue((Object)dynamicObject);
                return dispValueObj != null ? dispValueObj.toString() : null;
            }
        }
        if (dynamicProperty instanceof DynamicComplexProperty) {
            DynamicObject obj = null;
            try {
                if (dynamicProperty instanceof FlexProp) {
                    List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dynamicObject, (FlexProp)((FlexProp)dynamicProperty), (String)((FlexProp)dynamicProperty).getBasePropertyKey());
                    ArrayList<String> displayValues = new ArrayList<String>();
                    for (Map item : flexValues) {
                        String alias = (String)item.get("alias");
                        if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                        displayValues.add(alias);
                    }
                    return String.join((CharSequence)"; ", displayValues);
                }
                obj = dynamicObject.getDynamicObject(dynamicProperty);
                return Optional.ofNullable(obj).map(s -> s.getString("name")).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dynamicObject.getString(dynamicProperty.getName());
    }

    private Object getValueFromDT(IDataEntityProperty dynamicProperty, DynamicObject dynamicObject) {
        Object valueFast;
        if (dynamicProperty == null || dynamicObject == null) {
            return "";
        }
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        if (dataEntityType.getProperties().get((Object)dynamicProperty.getName()) != null && (valueFast = dynamicProperty.getValueFast((Object)dynamicObject)) != null) {
            return this.trimHeadTailElement(valueFast.toString(), ",");
        }
        return "";
    }

    private String trimHeadTailElement(String content, String element) {
        int entIndex;
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        int beginIndex = content.indexOf(element);
        if (beginIndex == 0) {
            content = content.substring(beginIndex + 1);
        }
        if ((entIndex = content.lastIndexOf(element)) == content.length() - 1) {
            content = content.substring(0, entIndex);
        }
        return content;
    }

    private String getBaseDataFieldDisplayValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicObject == null) {
            return null;
        }
        IBasedataField basedataProp = (IBasedataField)dynamicProperty;
        if (dynamicProperty instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)dynamicProperty;
            DynamicObjectType dType = prop.getDynamicCollectionItemPropertyType();
            basedataProp = (BasedataProp)dType.getProperties().get((Object)"fbasedataid");
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)prop.getValueFast((Object)dynamicObject);
            if (basedataProp != null) {
                ArrayList<String> displayValueList = new ArrayList<String>();
                for (DynamicObject obj : dynamicObjectCollection) {
                    DynamicObject basedataObj = (DynamicObject)((IDataEntityProperty)basedataProp).getValueFast((Object)obj);
                    if (basedataObj == null) continue;
                    Object[] bindingBasedataValue = (Object[])((BasedataProp)basedataProp).getBindingBasedataValue((Object)basedataObj, prop.getDisplayProp());
                    String str = bindingBasedataValue[0] + "/" + bindingBasedataValue[1];
                    if ("/".equals(str) && basedataObj != null) {
                        str = "id:" + basedataObj.getPkValue();
                    }
                    displayValueList.add(str);
                }
                return String.join((CharSequence)";", displayValueList);
            }
            return null;
        }
        DynamicObject dynamicObject2 = (DynamicObject)((IDataEntityProperty)basedataProp).getValue((Object)dynamicObject);
        if (dynamicProperty instanceof FlexProp) {
            try {
                Object value = dynamicObject2.get("value");
                if (value != null) {
                    return value.toString();
                }
            }
            catch (Exception e) {
                log.error("get flex value error", (Throwable)e);
            }
        }
        if (dynamicObject2 != null) {
            Object[] bindingBasedataValue = (Object[])((BasedataProp)basedataProp).getBindingBasedataValue((Object)dynamicObject2, basedataProp.getDisplayProp());
            String str = bindingBasedataValue[0] + "/" + bindingBasedataValue[1];
            if ("/".equals(str) && dynamicObject2 != null) {
                str = "id:" + dynamicObject2.getPkValue();
            }
            return str;
        }
        return null;
    }

    @Deprecated
    private String getMulBasedataPropValue(DynamicObjectCollection mulSelObjs, MulBasedataProp mulbdProp) {
        if (mulSelObjs == null || mulSelObjs.size() == 0 || mulbdProp == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject mulSelObj : mulSelObjs) {
            String value;
            IComplexProperty refBaseProp = mulbdProp.getRefBaseProp();
            DynamicObject refBaseObj = (DynamicObject)refBaseProp.getValue((Object)mulSelObj);
            Object displayPropObj = refBaseObj.get(mulbdProp.getDisplayProp());
            if (displayPropObj == null || StringUtils.isBlank((CharSequence)(value = displayPropObj.toString()))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private boolean isDeleteOperate() {
        return "delete".equals(this._operate);
    }

    private String getBillNo(DynamicObject dynamicObject) {
        IDataEntityProperty billNoProp = null;
        if (this._mainEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this._mainEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this._mainEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this._mainEntityType instanceof BillEntityType) {
            billNoProp = this._mainEntityType.findProperty(((BillEntityType)this._mainEntityType).getBillNo());
        }
        if (billNoProp != null) {
            return (String)billNoProp.getValue((Object)dynamicObject);
        }
        return "";
    }
}

