/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ForbiddenRunService;

class ForbiddenRunMCInfo
implements Serializable {
    private static Log log = LogFactory.getLog(ForbiddenRunService.class);
    private static final long serialVersionUID = 7224363358936610879L;
    @JsonProperty(value="f")
    private String formId;
    @JsonProperty(value="st")
    private String startTime;
    @JsonProperty(value="et")
    private String endTime;
    @JsonProperty(value="k")
    private String key;
    @JsonProperty(value="m")
    private String methodName;
    @JsonProperty(value="a")
    private List args;
    @JsonProperty(value="e")
    private boolean enable;

    ForbiddenRunMCInfo() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List getArgs() {
        return this.args;
    }

    public void setArgs(List args) {
        this.args = args;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isEquals(ForbiddenRunMCInfo param) {
        if (StringUtils.isBlank((CharSequence)this.formId) || !this.formId.equals(param.getFormId()) || !this.isEnable()) {
            return false;
        }
        try {
            if (StringUtils.isBlank((CharSequence)this.startTime) || StringUtils.isBlank((CharSequence)this.endTime)) {
                return false;
            }
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startDateTime = LocalDateTime.parse(this.startTime, dateTimeFormatter);
            LocalDateTime endDateTime = LocalDateTime.parse(this.endTime, dateTimeFormatter);
            if (startDateTime.compareTo(LocalDateTime.now()) > 0 || endDateTime.compareTo(LocalDateTime.now()) < 0) {
                return false;
            }
        }
        catch (Exception px) {
            log.error("\u7981\u6b62\u8fd0\u884c\u529f\u80fd\u914d\u7f6e\u7684MC\u4fe1\u606f\u683c\u5f0f\u5316\u65e5\u671f\u5f02\u5e38", (Throwable)px);
            return false;
        }
        String paramKey = param.getKey();
        String paramMethodName = param.getMethodName();
        List paramArgs = param.getArgs();
        if (this.key == null || this.methodName == null || this.args == null) {
            return false;
        }
        return this.key.equals(paramKey) && this.methodName.equals(paramMethodName) && this.args.equals(paramArgs);
    }
}

