/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.metatemplate.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mservice.metatemplate.page.MetaTemplate;
import kd.bos.mservice.metatemplate.page.MetaTemplateGroupTreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetaPageTemplateServiceImpl {
    private static final String BOS_METATEMPLATECATEGORY = "bos_metatemplatecategory";
    private static final String ID_NUMBER_NAME = "id,number,name,";
    private static final String SELECT_FIELDS = "longnumber,level,isleaf,parent.number,order";
    private static final String ENABLE = "enable";
    private static final String LEVEL = "level";
    private static final String SELECT_FIELDS_2 = "id,number,name,group.number,";
    private static final String LONGNUMBER = "longnumber";
    private static final String BOS_METATEMPLATE = "bos_metatemplate";
    private static final String SELECT_FIELDS_3 = "page.number,src,description,prevpaths,order";
    private static final String PAGE_MODELTYPE = "page.modeltype";
    private static Map<String, Supplier<DynamicObjectCollection[]>> loadTemplateStrategy = null;

    private void initLoadTemplateStrategy() {
        if (loadTemplateStrategy != null) {
            return;
        }
        HashMap<String, Supplier<DynamicObjectCollection[]>> loadTemplateStrategyTemp = new HashMap<String, Supplier<DynamicObjectCollection[]>>(3);
        loadTemplateStrategyTemp.put("MobileFormAp", this::load4MobileForm);
        loadTemplateStrategyTemp.put("MobileUserGuideFormAp", this::load4MobileForm);
        loadTemplateStrategyTemp.put("MobileBillFormAp", this::load4MobileBillForm);
        loadTemplateStrategyTemp.put("MobileListFormAp", this::load4MobileListForm);
        loadTemplateStrategy = loadTemplateStrategyTemp;
    }

    private DynamicObjectCollection[] load4MobileForm() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)BOS_METATEMPLATECATEGORY, (String)"id,number,name,longnumber,level,isleaf,parent.number,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")}, (String)LEVEL);
        List list = categories.stream().filter(s -> this.equalsOrStartWithPlusDot("MobMeta", s.getString(LONGNUMBER))).collect(Collectors.toList());
        categories.clear();
        categories.addAll(list);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)BOS_METATEMPLATE, (String)"id,number,name,group.number,page.number,src,description,prevpaths,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1"), new QFilter(PAGE_MODELTYPE, "=", (Object)"MobileFormModel")});
        return new DynamicObjectCollection[]{categories, templates};
    }

    private DynamicObjectCollection[] load4MobileBillForm() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)BOS_METATEMPLATECATEGORY, (String)"id,number,name,longnumber,level,isleaf,parent.number,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")}, (String)LEVEL);
        List list = categories.stream().filter(s -> this.equalsOrStartWithPlusDot("MobMeta", s.getString(LONGNUMBER))).collect(Collectors.toList());
        categories.clear();
        categories.addAll(list);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)BOS_METATEMPLATE, (String)"id,number,name,group.number,page.number,src,description,prevpaths,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1"), new QFilter(PAGE_MODELTYPE, "=", (Object)"BillFormModel")});
        return new DynamicObjectCollection[]{categories, templates};
    }

    private DynamicObjectCollection[] load4MobileListForm() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)BOS_METATEMPLATECATEGORY, (String)"id,number,name,longnumber,level,isleaf,parent.number,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")}, (String)LEVEL);
        List list = categories.stream().filter(s -> this.equalsOrStartWithPlusDot("MobListMeta", s.getString(LONGNUMBER))).collect(Collectors.toList());
        categories.clear();
        categories.addAll(list);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)BOS_METATEMPLATE, (String)"id,number,name,group.number,page.number,src,description,prevpaths,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1"), new QFilter(PAGE_MODELTYPE, "=", (Object)"BillFormModel")});
        return new DynamicObjectCollection[]{categories, templates};
    }

    public String getTemplates(String templateType) {
        this.initLoadTemplateStrategy();
        DynamicObjectCollection[] result = Optional.ofNullable(templateType).map(s -> loadTemplateStrategy.get(s)).map(Supplier::get).orElseGet(this::loadAll);
        List<DynamicObject> categories = this.sortOrder(result[0]);
        List<DynamicObject> templates = this.sortOrder(result[1]);
        List nodes = categories.stream().map(MetaTemplateGroupTreeNode::of).collect(Collectors.toList());
        Map<String, MetaTemplateGroupTreeNode> nodeMap = nodes.stream().collect(Collectors.toMap(MetaTemplateGroupTreeNode::getGroupId, item -> item));
        MetaTemplateGroupTreeNode root = new MetaTemplateGroupTreeNode();
        for (int i = 0; i < nodes.size(); ++i) {
            int level = categories.get(i).getInt(LEVEL);
            if (level == 1) {
                root.createOrGetChildren().add((MetaTemplateGroupTreeNode)nodes.get(i));
                continue;
            }
            MetaTemplateGroupTreeNode node = nodeMap.get(categories.get(i).getString("parent.number"));
            if (node == null) continue;
            node.createOrGetChildren().add((MetaTemplateGroupTreeNode)nodes.get(i));
        }
        List metaTemplates = templates.stream().map(MetaTemplate::of).collect(Collectors.toList());
        for (int i = 0; i < metaTemplates.size(); ++i) {
            String groupId = templates.get(i).getString("group.number");
            MetaTemplateGroupTreeNode node = nodeMap.get(groupId);
            if (node == null) continue;
            node.createOrGetPages().add((MetaTemplate)metaTemplates.get(i));
        }
        return SerializationUtils.toJsonString(root.getChildren());
    }

    private boolean equalsOrStartWithPlusDot(String regex, String content) {
        return regex.equals(content) || content.startsWith(regex + ".");
    }

    private DynamicObjectCollection[] loadAll() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)BOS_METATEMPLATECATEGORY, (String)"id,number,name,longnumber,level,isleaf,parent.number,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")}, (String)LEVEL);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)BOS_METATEMPLATE, (String)"id,number,name,group.number,page.number,src,description,prevpaths,order", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        return new DynamicObjectCollection[]{categories, templates};
    }

    List<DynamicObject> sortOrder(DynamicObjectCollection dynamicObjects) {
        List<DynamicObject> list = dynamicObjects.stream().sorted((a, b) -> {
            Integer orderA = (Integer)a.get("order");
            Integer orderB = (Integer)b.get("order");
            if (orderA == null || orderA.equals(0)) {
                return 1;
            }
            if (orderB == null || orderB.equals(0)) {
                return -1;
            }
            return orderA - orderB;
        }).collect(Collectors.toList());
        return list;
    }
}

