/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.runmode;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.runmode.BlacklistLocalCache;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RunModeServiceImpl
implements RunModeService {
    private static Log log = LogFactory.getLog(RunModeServiceImpl.class);
    public static final int PRODUCT_CODE_STANDARD = 1;
    public static final int PRODUCT_CODE_GALAXY = 2;
    public static final String INDUSTRY_GALAXY = "Galaxy";
    public static final String FILED_INDUSTRY = "industry";
    public static final String ENTITY_LIC = "lic_license";
    public static final String PRODUCT_BLACKLIST = "product";
    public static final String CLOUD_BLACKLIST = "cloud";
    public static final String APP_BLACKLIST = "app";
    public static final String ENTITY_BLACKLIST = "entity";
    public static final String APPENTITY_BLACKLIST = "appentity";
    private static final String BIZ_APP_ENTITY = "bos_devportal_bizapp";
    private static final String SPAN_TYPE_NAME = "runmode";
    private static final String SPAN_TAG_CLOUD_CACHE = "cloud_cache";
    private static final String SPAN_TAG_CLOUD_RESULT = "cloud_from_cloudblacklist";
    private static final String SPAN_TAG_APP_CACHE = "app_cache";
    private static final String SPAN_TAG_APP_RESULT = "app_from_appblacklist";
    private static final String SPAN_TAG_APP_RESULT1 = "app_from_cloudblacklist";
    private static final String SPAN_TAG_APP_RESULT2 = "app_from_blacklistAndExtend";
    private static final String SPAN_TAG_ENTITY_CACHE = "entity_cache";
    private static final String SPAN_TAG_ENTITY_RESULT = "entity_from_entityblacklist";
    private static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    private static final String NOCODE_CLOUD_NUMBER = "nocode";

    public int getRunModeCode() {
        try {
            Object cacheCode = BlacklistLocalCache.getCache(PRODUCT_BLACKLIST);
            if (cacheCode != null) {
                return (Integer)cacheCode;
            }
            QFilter filterGalaxy = new QFilter(FILED_INDUSTRY, "=", (Object)INDUSTRY_GALAXY);
            int modeCode = QueryServiceHelper.exists((String)ENTITY_LIC, (QFilter[])new QFilter[]{filterGalaxy}) ? 2 : 1;
            BlacklistLocalCache.putCache(PRODUCT_BLACKLIST, modeCode);
            return modeCode;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8bb8\u53ef\u5b57\u6bb5INDUSTRY \u83b7\u53d6\u5f53\u524d\u7684\u4ea7\u54c1\u7801\u6709\u8bef\uff01: ", (Throwable)e);
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> loadAppBlacklist(int product) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"RunModeServiceImpl.loadAppBlacklist");){
            Object cache = BlacklistLocalCache.getCache(APP_BLACKLIST);
            if (cache != null) {
                HashMap<String, String> appBlackList = new HashMap<String, String>(16);
                appBlackList.putAll((Map)cache);
                if (span.isRealtime()) {
                    span.addLocaleTag(SPAN_TAG_APP_CACHE, appBlackList);
                }
                HashMap<String, String> hashMap = appBlackList;
                return hashMap;
            }
            String sql = String.format("SELECT FAPPID,FAPPNUM FROM T_META_AppBlackList WHERE FPRODUCT = %d", product);
            final Map result = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    while (rs.next()) {
                        dataMap.put(rs.getString("FAPPID"), rs.getString("FAPPNUM"));
                    }
                    return dataMap;
                }
            });
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_APP_RESULT, (Object)result);
            }
            String sql1 = String.format("SELECT FID,FNUMBER FROM T_META_BIZAPP WHERE FBIZCLOUDID IN (SELECT FCLOUDID FROM T_META_CLOUDBLACKLIST WHERE FPRODUCT = %d) ", product);
            Map result1 = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql1, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    Map dataMap = result;
                    while (rs.next()) {
                        dataMap.put(rs.getString("FID"), rs.getString("FNUMBER"));
                    }
                    return dataMap;
                }
            });
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_APP_RESULT1, (Object)result1);
            }
            Set<String> bizAppIds = result1.keySet();
            String selectFields = "id,number";
            Set<String> masterIds = RunModeServiceImpl.getMasterId(bizAppIds);
            QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", masterIds)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BIZ_APP_ENTITY, (String)selectFields, (QFilter[])filters);
            Map result2 = result1;
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String id = dynamicObject.getString("id");
                    String number = dynamicObject.getString("number");
                    if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)number)) continue;
                    result2.put(id, number);
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_APP_RESULT2, (Object)result2);
            }
            BlacklistLocalCache.putCache(APP_BLACKLIST, result2);
            Map map = result2;
            return map;
        }
        catch (Exception e) {
            log.error(String.format("\u52a0\u8f7d\u5e94\u7528\u9ed1\u540d\u5355\u6839\u636e\u5f53\u524d\u4ea7\u54c1\u8fd0\u884c\u6a21\u5f0f{%d}\u6709\u8bef\uff01: ", product), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    private static Set<String> getMasterId(Set<String> bizAppIds) {
        HashSet<String> masterIds = new HashSet<String>(bizAppIds);
        String selectFields = "id,masterid,type";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", bizAppIds)};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)BIZ_APP_ENTITY, (String)selectFields, (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            for (DynamicObject object : doc) {
                if (object == null || !"2".equals(object.getString("type")) || !StringUtils.isNotBlank((CharSequence)object.getString("masterid"))) continue;
                masterIds.add(object.getString("masterid"));
            }
        }
        return masterIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> loadCloudBlacklist(int product) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"RunModeServiceImpl.loadCloudBlacklist");){
            Object cache = BlacklistLocalCache.getCache(CLOUD_BLACKLIST);
            if (cache != null) {
                HashMap<String, String> cloudBlackList = new HashMap<String, String>(16);
                cloudBlackList.putAll((Map)cache);
                if (span.isRealtime()) {
                    span.addLocaleTag(SPAN_TAG_CLOUD_CACHE, cloudBlackList);
                }
                HashMap<String, String> hashMap = cloudBlackList;
                return hashMap;
            }
            String sql = String.format("SELECT FCLOUDID,FCLOUDNUM FROM T_META_CloudBlackList WHERE FPRODUCT = %d", product);
            Map result = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    while (rs.next()) {
                        dataMap.put(rs.getString("FCLOUDID"), rs.getString("FCLOUDNUM"));
                    }
                    return dataMap;
                }
            });
            result.put(NOCODE_CLOUD_ID, NOCODE_CLOUD_NUMBER);
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_CLOUD_RESULT, (Object)result);
            }
            BlacklistLocalCache.putCache(CLOUD_BLACKLIST, result);
            Map map = result;
            return map;
        }
        catch (Exception e) {
            log.error(String.format("\u52a0\u8f7d\u4e91\u9ed1\u540d\u5355\u6839\u636e\u5f53\u524d\u4ea7\u54c1\u8fd0\u884c\u6a21\u5f0f{%d}\u6709\u8bef\uff01: ", product), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> loadEntityBlacklist(int product) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"RunModeServiceImpl.loadEntityBlacklist");){
            Object cache = BlacklistLocalCache.getCache(ENTITY_BLACKLIST);
            if (cache != null) {
                HashMap<String, String> entityBlackList = new HashMap<String, String>(16);
                entityBlackList.putAll((Map)cache);
                if (span.isRealtime()) {
                    span.addLocaleTag(SPAN_TAG_ENTITY_CACHE, entityBlackList);
                }
                HashMap<String, String> hashMap = entityBlackList;
                return hashMap;
            }
            String sql = String.format("SELECT FENTITYID,FENTITYNUM FROM T_META_EntityBlackList WHERE FPRODUCT = %d", product);
            Map result = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    while (rs.next()) {
                        dataMap.put(rs.getString("FENTITYID"), rs.getString("FENTITYNUM"));
                    }
                    return dataMap;
                }
            });
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_ENTITY_RESULT, (Object)result);
            }
            BlacklistLocalCache.putCache(ENTITY_BLACKLIST, result);
            Map map = result;
            return map;
        }
        catch (Exception e) {
            log.error(String.format("\u52a0\u8f7d\u8868\u5355\u5b9e\u4f53\u9ed1\u540d\u5355\u6839\u636e\u5f53\u524d\u4ea7\u54c1\u8fd0\u884c\u6a21\u5f0f{%d}\u6709\u8bef\uff01: ", product), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public List<String> loadEntityBlacklistByAppNumber(int product, String appNumber) {
        try {
            ArrayList<String> result = new ArrayList<String>(10);
            Object cache = BlacklistLocalCache.getCache(APPENTITY_BLACKLIST);
            HashMap<String, List> entityBlacklist = null;
            if (cache != null) {
                entityBlacklist = (HashMap<String, List>)cache;
            }
            if (entityBlacklist != null && !entityBlacklist.isEmpty() && entityBlacklist.get(appNumber) != null) {
                result.addAll((Collection)entityBlacklist.get(appNumber));
                return result;
            }
            Object[] params = new SqlParameter[]{new SqlParameter(":FPRODUCT", 4, (Object)product), new SqlParameter(":FAPPNUM", 12, (Object)appNumber)};
            String sql = "SELECT FENTITYID,FENTITYNUM FROM T_META_EntityBlackList WHERE FPRODUCT = ? AND FAPPNUM = ?";
            List blackList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> list = new ArrayList<String>(10);
                    while (rs.next()) {
                        list.add(rs.getString("FENTITYNUM"));
                    }
                    return list;
                }
            });
            result.addAll(blackList);
            if (entityBlacklist == null) {
                entityBlacklist = new HashMap<String, List>();
            }
            entityBlacklist.put(appNumber, blackList);
            BlacklistLocalCache.putCache(APPENTITY_BLACKLIST, entityBlacklist);
            return result;
        }
        catch (Exception e) {
            log.error(String.format("\u52a0\u8f7d\u8868\u5355\u5b9e\u4f53\u9ed1\u540d\u5355\u6839\u636e\u5f53\u524d\u4ea7\u54c1\u8fd0\u884c\u6a21\u5f0f{%d}\u548c\u5e94\u7528APP{%s}\u6709\u8bef\uff01: ", product, appNumber), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public void removeCache(String type) {
        try {
            if ("all".equalsIgnoreCase(type)) {
                BlacklistLocalCache.remove(PRODUCT_BLACKLIST, CLOUD_BLACKLIST, APP_BLACKLIST, APPENTITY_BLACKLIST, ENTITY_BLACKLIST);
            } else if (ENTITY_BLACKLIST.equalsIgnoreCase(type)) {
                BlacklistLocalCache.remove(APPENTITY_BLACKLIST, ENTITY_BLACKLIST);
            } else {
                BlacklistLocalCache.remove(type);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u79fb\u9664 {%s} \u9ed1\u540d\u5355\u6709\u8bef\uff01: ", type), (Throwable)e);
        }
    }
}

