/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.mservice.form.ExceptionHandler;

class BalanceRuleBuilder
implements Callable<Tuple<Boolean, String>> {
    boolean forceRebuild = true;
    private String ruleNumber;
    private RequestContext requestContext;

    public BalanceRuleBuilder(String ruleNumber, boolean forceRebuild, RequestContext rc) {
        this.requestContext = rc;
        this.ruleNumber = ruleNumber;
        this.forceRebuild = forceRebuild;
    }

    @Override
    public Tuple<Boolean, String> call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        boolean success = true;
        String message = "";
        long ts = System.currentTimeMillis();
        try {
            BalanceUpdateRuleWriter.rebuildRuntimeMetaByNumber((String)this.ruleNumber);
            message = String.format("%s: BUILD SUCCESSFUL! cost: %s ms", this.ruleNumber, System.currentTimeMillis() - ts);
        }
        catch (Exception e) {
            success = false;
            message = String.format("%s  error: BUILD FAILED, %s\u3002", this.ruleNumber, ExceptionHandler.HandlerErr(e, this.ruleNumber));
        }
        return Tuple.create((Object)success, (Object)message);
    }
}

