/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.IConvertRuleCacheProxy;
import kd.bos.entity.botp.IWriteBackRuleCacheProxy;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.metadata.DebugMetadataService;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;

public class DebugMetadataServiceImpl
implements DebugMetadataService {
    private static final String MOB_META = "MobMeta";
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String LANGUAGE = "language";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static Log log = LogFactory.getLog(DebugMetadataServiceImpl.class);
    private boolean isDebug = Boolean.parseBoolean(System.getProperty(METADATADEBUG, "false"));
    private static String METADATADEBUG = "metadata.debug";

    public DebugMetadataServiceImpl() {
        ConfigurationUtil.observeChange((String)METADATADEBUG, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                DebugMetadataServiceImpl.this.isDebug = Boolean.parseBoolean(System.getProperty(METADATADEBUG));
            }
        });
    }

    private String convertDesignerMetaType(String templateType) {
        String result = templateType;
        switch (templateType) {
            case "MobileFormAp": 
            case "MobileBillFormAp": {
                result = MOB_META;
                break;
            }
            case "MobileListFormAp": {
                result = "MobListMeta";
                break;
            }
        }
        return result;
    }

    @Deprecated
    public String getDesignerMetadata(String formId, String designerMetaType, String lang) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        String propertyName = this.convertDesignerMetaType(designerMetaType);
        MetadataReader reader = new MetadataReader(false, lang);
        AbstractMetadata metadata = reader.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class));
        Map content = metadata.buildDesignMeta(lang);
        if (MOB_META.equals(propertyName) && "MobileFormModel".equals(content.get("modelType"))) {
            return SerializationUtils.toJsonString((Object)content);
        }
        Map formMeta = (Map)content.get(FORM_META);
        Map entityMeta = (Map)content.get(ENTITY_META);
        List items = (List)formMeta.get(ITEMS);
        Map formAp = (Map)items.get(0);
        String itemId = (String)formAp.get("Id");
        HashMap param = new HashMap(2);
        param.put(VALUE, formAp.get(propertyName));
        param.put(LANGUAGE, content.get(LANGUAGE));
        if (MOB_META.equals(propertyName)) {
            ArrayList<List<Object>> context = new ArrayList<List<Object>>(2);
            items = (List)formMeta.get(ITEMS);
            context.add(items);
            context.add((List<Object>)entityMeta.get(ITEMS));
            param.put(CONTEXT, context);
        } else {
            param.put(CONTEXT, entityMeta.get(ITEMS));
        }
        Map<String, Object> tMap = MOB_META.equals(propertyName) ? this.loadDataMobMeta(param.get(CONTEXT), propertyName, param.get(VALUE), param.get(LANGUAGE).toString()) : this.loadDataMobListMeta(param.get(CONTEXT), propertyName, param.get(VALUE), param.get(LANGUAGE).toString());
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("itemId", itemId);
        params.put("metaType", FORM_META);
        tMap.put("designerparams", params);
        tMap.put("designer", propertyName);
        tMap.put(ENTITY_META, entityMeta);
        return SerializationUtils.toJsonString(tMap);
    }

    private Map<String, Object> loadDataMobMeta(Object context, String propertyName, Object value, String lang) {
        Map<String, Object> tMap;
        if (context instanceof List) {
            HashMap<String, Object> entityMeta = new HashMap<String, Object>();
            entityMeta.put(ITEMS, ((List)context).get(1));
            entityMeta.put("_Type_", "EntityMetadata");
            Map formmeta = null;
            if (value instanceof Map) {
                formmeta = (Map)value;
            }
            Map item = (Map)((List)((List)context).get(0)).get(0);
            String id = (String)item.get("Id");
            String key = item.get("Key") + "_mob";
            tMap = this.createMobFormMetadataMobBill(id, key, formmeta, entityMeta, lang);
        } else {
            tMap = new HashMap<String, Object>();
        }
        return tMap;
    }

    private Map<String, Object> createMobFormMetadataMobBill(String id, String key, Map<String, Object> srcFormmeta, Map<String, Object> srcEntityMeta, String lang) {
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"MobileBillFormModel"));
        FormMetadata formMeta = null;
        Objects.requireNonNull(srcFormmeta);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        formMeta = (FormMetadata)ser.deserializeFromMap(srcFormmeta, null);
        formMeta.setId(id);
        formMeta.setKey(key);
        formMeta.getRootAp().setLanguage(lang);
        EntityMetadata entityMeta = (EntityMetadata)ser.deserializeFromMap(srcEntityMeta, null);
        entityMeta.setId(entityMeta.getRootEntity().getId());
        formMeta.setEntityId(entityMeta.getRootEntity().getId());
        formMeta.bindEntityMetadata(entityMeta);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", entityMeta.buildDesgnerTree());
        tMap.put("id", formMeta.getId());
        binder.setWriteInheritFlag(true);
        tMap.put(ENTITY_META, ser.serializeToMap((Object)entityMeta, null));
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put(FORM_META, ser.serializeToMap((Object)formMeta, null));
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        return tMap;
    }

    private Map<String, Object> loadDataMobListMeta(Object context, String propertyName, Object value, String lang) {
        Map formmeta = null;
        boolean isMob = "MobListMeta".equals(propertyName);
        Map<String, Object> tMap = new HashMap<String, Object>();
        if (value instanceof Map) {
            if (!isMob) {
                Map mapName = (Map)value;
                String billName = (String)((Map)((List)context).get(0)).get("Name");
                ((Map)((List)mapName.get(ITEMS)).get(0)).put("Name", billName);
                formmeta = mapName;
            } else {
                formmeta = (Map)value;
            }
        }
        if (isMob) {
            tMap = this.createMobFormMetadataMobList(formmeta, (List)context, lang);
        }
        return tMap;
    }

    private Map<String, Object> createMobFormMetadataMobList(Map<String, Object> srcFormmeta, List<Map<String, Object>> context, String lang) {
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"MobileListModel"));
        FormMetadata formMeta = null;
        String name = "";
        String entityId = null;
        if (context != null && !context.isEmpty()) {
            Map<String, Object> curItem = context.get(0);
            name = (String)curItem.get("Name");
            entityId = (String)curItem.get("Id");
        }
        Objects.requireNonNull(srcFormmeta);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        formMeta = (FormMetadata)ser.deserializeFromMap(srcFormmeta, null);
        formMeta.createIndex();
        formMeta.getRootAp().setLanguage(lang);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", EntityMetadataUtil.getlistFieldTree(context));
        tMap.put("id", formMeta.getId());
        tMap.put("ui", formMeta.builderDesgnerControls());
        binder.setWriteInheritFlag(true);
        tMap.put(FORM_META, ser.serializeToMap((Object)formMeta, null));
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        return tMap;
    }

    public String getEntityMetadata(String entiyId) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String id = MetadataDao.getIdByNumber((String)entiyId, (MetaCategory)MetaCategory.Entity);
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        return serializer.buildDiffXml((Object)metadata, null, false);
    }

    public String getFormMetadata(String formId) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        return serializer.buildDiffXml((Object)metadata, null, false);
    }

    public String getEntityOperateFromCache(String number, String operKey) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        if (StringUtils.isBlank((CharSequence)operKey)) {
            return SerializationUtils.toJsonString((Object)EntityMetadataCache.getDataEntityOperate((String)number));
        }
        return SerializationUtils.toJsonString((Object)EntityMetadataCache.getDataEntityOperate((String)number, (String)operKey));
    }

    public String getJarInfo(String jarname) {
        String ret;
        block18: {
            if (!this.hasRight()) {
                return this.getUnauthorizedMsg();
            }
            ret = null;
            try {
                String[] jarArray;
                String findJarname = null;
                String jars = System.getProperty("java.class.path");
                String spit = System.getProperty("path.separator");
                for (String jarFileName : jarArray = jars.split(spit)) {
                    if (!jarFileName.contains(jarname)) continue;
                    findJarname = jarFileName;
                    break;
                }
                if (jarname == null || findJarname == null) break block18;
                try (JarFile jarFile = new JarFile(findJarname);){
                    Enumeration<JarEntry> jarEntrys = jarFile.entries();
                    while (jarEntrys.hasMoreElements()) {
                        JarEntry jarEntry = jarEntrys.nextElement();
                        if (jarEntry.isDirectory() || !"META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                        InputStream in = jarFile.getInputStream(jarEntry);
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        String s = "";
                        StringBuilder sb = new StringBuilder();
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                        }
                        sb.append("<br>").append("p:").append(findJarname.replaceAll("\\\\", "**")).append("<br>");
                        ret = sb.toString();
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Instance.getAppName() + ":" + ret;
    }

    public String getClassUrl(String className) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (className != null && className.length() > 0) {
                String classPath = className.replaceAll("\\.", "/");
                classPath = classPath.endsWith("class") ? classPath.replaceAll("/class", ".class") : classPath + ".class";
                ClassLoader cl = null;
                Class<?> clazz = Class.forName(className);
                if (clazz != null) {
                    cl = clazz.getClassLoader();
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    sb.append("Class Loader: ").append(cl).append(" <br>");
                    URL url = cl.getResource(classPath);
                    if (url != null) {
                        sb.append("p: ").append(url.toString().replaceAll("/", "**")).append(" <br>");
                    }
                }
                if (sb.length() > 0) {
                    return String.format("%s:%s", Instance.getAppName(), sb.toString());
                }
            }
        }
        catch (Throwable e) {
            log.error(e);
        }
        return "";
    }

    public String getMetaByLocalCache(String methodName, Object[] params) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String ret = "";
        try {
            Method method;
            Class<?> metaLocalCache = null;
            metaLocalCache = this.isFormMethodName(methodName) ? Class.forName("kd.bos.form.FormMetadataLocalCache") : Class.forName("kd.bos.entity.EntityMetadataLocalCache");
            if ("getDataEntityOperate".equals(methodName)) {
                method = metaLocalCache.getDeclaredMethod(methodName, String.class, String.class);
                method.setAccessible(true);
                Map map = (Map)method.invoke(null, params[0], params[1]);
                ret = SerializationUtils.toJsonString((Object)map);
            }
            if ("getDataEntityType".equals(methodName) || "getRefDataEntityType".equals(methodName)) {
                method = metaLocalCache.getDeclaredMethod(methodName, String.class);
                method.setAccessible(true);
                IDataEntityType type = (IDataEntityType)method.invoke(null, params[0]);
                if (type != null) {
                    ret = EntityItemTypes.toJsonString((IDataEntityType)type);
                }
            } else {
                method = metaLocalCache.getDeclaredMethod(methodName, String.class);
                method.setAccessible(true);
                ret = (String)method.invoke(null, params[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{msg});
        }
        return ret;
    }

    public String getMetaByRedisCache(String method, Object[] params) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String ret = "";
        switch (method) {
            case "getFormConfig": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)((String)params[0]), (int)RuntimeMetaType.Config.getValue());
                break;
            }
            case "getRootControl": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)((String)params[0]), (int)RuntimeMetaType.Form.getValue());
                break;
            }
            case "getAllEntityRules": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)"_formrules", (int)RuntimeMetaType.Rule.getValue());
                break;
            }
            case "getDataEntityType": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)((String)params[0]), (int)RuntimeMetaType.Entity.getValue());
                break;
            }
            case "getRefDataEntityType": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)((String)params[0]), (int)RuntimeMetaType.Entity.getValue());
                break;
            }
            case "getPermissionControlType": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)"CtrlType", (int)RuntimeMetaType.PermissionControlType.getValue());
                break;
            }
            case "getPermissionItems": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), null, (int)RuntimeMetaType.PermissionItems.getValue());
                break;
            }
            case "getNetCtrlOperate": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)"netCtrl", (int)RuntimeMetaType.NetCtrlOperate.getValue());
                break;
            }
            case "getDataEntityOperate": {
                ret = MetaCacheUtils.getDistributeCache((String)((String)params[0]), (String)((String)params[1]), (int)RuntimeMetaType.Operate.getValue());
                break;
            }
        }
        return ret;
    }

    private boolean isFormMethodName(String methodName) {
        ArrayList<String> forms = new ArrayList<String>();
        forms.add("getFormConfig");
        forms.add("getRootControl");
        forms.add("getAllEntityRules");
        return forms.contains(methodName);
    }

    public String getCheckFormInfoList(String appnumbers) {
        try {
            MetadataReader reader = new MetadataReader();
            List infos = reader.doReadCheckFormInfoList(appnumbers);
            return SerializationUtils.toJsonString((Object)infos);
        }
        catch (Exception e) {
            Map<String, Object> action = ExceptionHandler.HandlerErr(e, "getCheckFormInfoList");
            return SerializationUtils.toJsonString(action);
        }
    }

    private List<Map<String, Object>> getFormAndEntityMetadataDiff(FormMetadata formmeta) {
        ArrayList<Map<String, Object>> lstInfo = new ArrayList<Map<String, Object>>();
        EntityMetadata entitymeta = null;
        try {
            entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formmeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        List formItems = formmeta.getItems();
        for (ControlAp formItem : formItems) {
            if (!(formItem instanceof FieldAp)) continue;
            String id = ((FieldAp)formItem).getFieldId();
            String key = ((FieldAp)formItem).getKey();
            EntityItem entityitem = entitymeta.getItemById(id);
            if (entityitem != null) continue;
            HashMap<String, String> itemInfo = new HashMap<String, String>();
            itemInfo.put("key", key);
            itemInfo.put("id", id);
            itemInfo.put("message", String.format(ResManager.loadKDString((String)"%1$s\u7684\u5b9e\u4f53\u5143\u6570\u636e\u4e2d\u4e22\u5931\u4e86\u5b57\u6bb5\u5c5e\u6027(%2$s),\u53ef\u80fd\u88ab\u5199\u5165\u5230\u539f\u5355\u4e86", (String)"DebugMetadataServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formmeta.getKey(), key));
            lstInfo.add(itemInfo);
        }
        List entityItems = entitymeta.getItems();
        for (EntityItem entityItem : entityItems) {
            if (!(entityItem instanceof Field)) continue;
            String id = ((Field)entityItem).getId();
            String key = ((Field)entityItem).getKey();
            ControlAp formitem = formmeta.getItem(id);
            if (formitem != null) continue;
            HashMap<String, String> itemInfo = new HashMap<String, String>();
            itemInfo.put("key", key);
            itemInfo.put("id", id);
            itemInfo.put("message", String.format(ResManager.loadKDString((String)"%1$s\u7684\u8868\u5355\u5143\u6570\u636e\u4e2d\u4e22\u5931\u4e86\u5b57\u6bb5\u63a7\u4ef6(%2$s)", (String)"DebugMetadataServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formmeta.getKey(), key));
            lstInfo.add(itemInfo);
        }
        return lstInfo;
    }

    public String getFormAndEntityMetadataDiff(String number, String type, String day) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        ArrayList ret = new ArrayList();
        List forms = null;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String[] array = StringUtils.split((String)number, (String)",");
            forms = Arrays.asList(array);
        } else {
            List<String> types = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                String[] arraytype = StringUtils.split((String)type, (String)",");
                types = Arrays.asList(arraytype);
            } else {
                types.add("2");
            }
            forms = MetadataDao.getAllExts(types, (String)day);
        }
        for (String form : forms) {
            if (!StringUtils.isNotBlank((CharSequence)form)) continue;
            HashMap<String, Object> mapInfo = new HashMap<String, Object>();
            String formId = MetadataDao.getIdByNumber((String)form, (MetaCategory)MetaCategory.Form);
            FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
            List<Map<String, Object>> lstInfo = this.getFormAndEntityMetadataDiff(formmeta);
            if (lstInfo.isEmpty()) continue;
            mapInfo.put("error", lstInfo);
            mapInfo.put("number", form);
            mapInfo.put("masterid", formmeta.getMasterId());
            mapInfo.put("id", formmeta.getId());
            ret.add(mapInfo);
        }
        return SerializationUtils.toJsonString(ret);
    }

    public String getBotpRule(String ruleId, String type, String cacheType) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"cr")) {
            return ((IConvertRuleCacheProxy)BOTPServiceFactory.getSingletonService(IConvertRuleCacheProxy.class)).loadDebugRule(ruleId, cacheType);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"wr")) {
            return ((IWriteBackRuleCacheProxy)BOTPServiceFactory.getSingletonService(IWriteBackRuleCacheProxy.class)).loadDebugRule(ruleId, cacheType);
        }
        return "type only can be 'cr' or 'wr'";
    }

    @Deprecated
    public String getAppMetadataByID(String appID) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        AppMetadata appMetadataById = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appID, (boolean)true);
        String appMetadata = AppMetaServiceHelper.serializeToJSONString((AppMetadata)appMetadataById, null);
        return appMetadata;
    }

    public String getAppMetaByLocalCache(String methodName, Object[] params) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String ret = "";
        try {
            Class<?> metaLocalCache = Class.forName("kd.bos.entity.AppMetadataCache");
            Method method = metaLocalCache.getDeclaredMethod(methodName, String.class);
            method.setAccessible(true);
            Object appInfo = method.invoke(null, params[0]);
            ret = SerializationUtils.toJsonString((Object)appInfo);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{msg});
        }
        return ret;
    }

    public String getAppMetaByRedisCache(String method, Object[] params) {
        if (!this.hasRight()) {
            return this.getUnauthorizedMsg();
        }
        String ret = "";
        switch (method) {
            case "getAppInfo": {
                ret = MetaCacheUtils.getAppmetaDistributeCache((String)((String)params[0]), (String)((String)params[0]), (int)RuntimeMetaType.App.getValue());
                break;
            }
            case "getAppMenusInfoByAppId": {
                String key = (String)params[0] + ".menus";
                ret = MetaCacheUtils.getAppmetaDistributeCache((String)((String)params[0]), (String)key, (int)RuntimeMetaType.AppMenu.getValue());
                break;
            }
        }
        return ret;
    }

    private boolean hasRight() {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()));
        return this.isDebug || isAdmin;
    }

    private String getUnauthorizedMsg() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error:", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"DebugMetadataServiceImpl_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        return SerializationUtils.toJsonString(map);
    }
}

