/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.HttpClientKeepCookiesUtils;

public class HttpUtils {
    public static final Log logger = LogFactory.getLog(HttpUtils.class);

    public static boolean doLogin(HttpClientKeepCookiesUtils httpObj, String url, String appId, String appSecuret, String tenantId, String accountId, String user, String usertype, String appLang) throws IOException {
        String apptoken = HttpUtils.doGetAppToken(httpObj, url, appId, appSecuret, tenantId, accountId, appLang);
        boolean bRet = false;
        if (apptoken != null) {
            String strLoginCheckApiUrl = url + "api/login.do";
            HashMap<String, String> body = new HashMap<String, String>();
            if (tenantId != null) {
                body.put("tenantid", tenantId);
            }
            if (user != null) {
                body.put("user", user);
            }
            if (accountId != null) {
                body.put("accountId", accountId);
            }
            if (apptoken != null) {
                body.put("apptoken", apptoken);
            }
            if (usertype != null) {
                body.put("usertype", usertype);
            } else {
                body.put("usertype", "Mobile");
            }
            String loginBody = SerializationUtils.toJsonString(body);
            bRet = httpObj.login(strLoginCheckApiUrl, loginBody);
            logger.debug("\u51c6\u5907\u767b\u5f55\u670d\u52a1(ApiUrl:" + strLoginCheckApiUrl + ")," + loginBody + " \u767b\u5f55\u670d\u52a1\u8fd4\u56de\u81f3\uff1a" + httpObj.getLoginResult());
        }
        if (!bRet) {
            logger.error(httpObj.getLoginResult());
        }
        return bRet;
    }

    public static String doGetAppToken(HttpClientKeepCookiesUtils httpObj, String url, String appId, String appSecuret, String tenantId, String accountId, String appLang) throws IOException {
        String strApiUrl = url + "api/getAppToken.do";
        HashMap<String, String> body = new HashMap<String, String>();
        if (appId != null) {
            body.put("appId", appId);
        } else {
            body.put("appId", "unittest");
        }
        if (appSecuret != null) {
            body.put("appSecuret", appSecuret);
        } else {
            body.put("appSecuret", Encrypters.decode((String)System.getProperty("kd.bos.lymx.service.metadata.appSecuret")));
        }
        if (tenantId != null) {
            body.put("tenantid", tenantId);
        }
        if (accountId != null) {
            body.put("accountId", accountId);
        }
        if (appLang != null) {
            body.put("language", appLang);
        } else {
            body.put("language", "zh_CN");
        }
        String loginBody = SerializationUtils.toJsonString(body);
        String bRet = httpObj.postJson(strApiUrl, null, loginBody);
        logger.debug("\u51c6\u5907\u767b\u5f55\u670d\u52a1\u524d\u83b7\u53d6AppToken.(ApiUrl:" + strApiUrl + ")," + loginBody + " \u83b7\u53d6AppToken\u8fd4\u56de\u503c\uff1a" + bRet);
        String app_token = null;
        try {
            Map mapRet = (Map)SerializationUtils.fromJsonString((String)bRet, Map.class);
            if (mapRet.get("state").equals("success")) {
                Map mapRetData = (Map)mapRet.get("data");
                app_token = (String)mapRetData.get("app_token");
            } else {
                logger.error("\u83b7\u53d6AppToken\u5931\u8d25\uff0c\u8fd4\u56de\u503c\uff1a" + bRet);
            }
        }
        catch (Exception e) {
            logger.error("getAppToken.do\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u503c\uff1a" + bRet);
            throw new RuntimeException(e);
        }
        return app_token;
    }
}

