/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.balance.RuntimeRuleMetaType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.service.metadata.BalanceRuleBuilder;
import kd.bos.threads.ThreadPools;

class MetadataServiceBalanceReader {
    private static final String FNUMBER = ":FNUMBER";
    private static final String ERROR_S = "Error:%s";
    private static int MAX_Threads = 5;
    private static ExecutorService es = ThreadPools.newExecutorService((String)"balanceupdaterulebuilder", (int)MAX_Threads);

    MetadataServiceBalanceReader() {
    }

    public static String loadBalanceRle(String ruleNumber) {
        String ruleString = BalanceRuleCacheUtils.getRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue());
        if (ruleString == null) {
            ruleString = MetadataServiceBalanceReader.queryRuntimeMeta(ruleNumber, ruleNumber, RuntimeRuleMetaType.UpdateRule);
            if (ruleString == null) {
                BalanceUpdateRuleWriter.rebuildRuntimeMetaByNumber((String)ruleNumber);
                ruleString = MetadataServiceBalanceReader.queryRuntimeMeta(ruleNumber, ruleNumber, RuntimeRuleMetaType.UpdateRule);
            }
            BalanceRuleCacheUtils.putRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue(), (String)ruleString);
        }
        return ruleString;
    }

    public static List<String> loadBalanceRuleByBill(String sourceEntityNumber) {
        ArrayList<String> rules = new ArrayList<String>();
        String ruleListString = BalanceRuleCacheUtils.getBillRuleListDistributeCache((String)sourceEntityNumber);
        List ruleNumbers = new ArrayList<String>();
        if (ruleListString != null) {
            if (StringUtils.isNotBlank((CharSequence)ruleListString)) {
                ruleNumbers = (List)SerializationUtils.fromJsonString((String)ruleListString, List.class);
            }
        } else {
            ruleNumbers.addAll(MetadataServiceBalanceReader.queryNumbersByBill(sourceEntityNumber));
            ruleListString = SerializationUtils.toJsonString(ruleNumbers);
            BalanceRuleCacheUtils.putBillRuleListDistributeCache((String)sourceEntityNumber, (String)ruleListString);
        }
        ArrayList<String> noCacheRuleNumbers = new ArrayList<String>();
        for (String ruleNumber : ruleNumbers) {
            String ruleString = BalanceRuleCacheUtils.getRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue());
            if (ruleString == null) {
                noCacheRuleNumbers.add(ruleNumber);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)ruleString)) continue;
            rules.add(ruleString);
        }
        if (!noCacheRuleNumbers.isEmpty()) {
            Map<String, String> ruleMap = MetadataServiceBalanceReader.queryRuntimeMeta(noCacheRuleNumbers.toArray(new String[noCacheRuleNumbers.size()]));
            for (String ruleNumber : noCacheRuleNumbers) {
                String ruleString = ruleMap.get(ruleNumber);
                if (StringUtils.isBlank((CharSequence)ruleString)) {
                    BalanceUpdateRuleWriter.rebuildRuntimeMetaByNumber((String)ruleNumber);
                    ruleString = MetadataServiceBalanceReader.queryRuntimeMeta(ruleNumber, ruleNumber, RuntimeRuleMetaType.UpdateRule);
                }
                rules.add(ruleString);
                BalanceRuleCacheUtils.putRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue(), (String)ruleString);
            }
        }
        return rules;
    }

    public static List<String> loadBalanceRuleByBalTable(String balanceTableNumber) {
        ArrayList<String> rules = new ArrayList<String>();
        String ruleListString = BalanceRuleCacheUtils.getTableRuleListDistributeCache((String)balanceTableNumber);
        List ruleNumbers = new ArrayList<String>();
        if (ruleListString != null) {
            if (StringUtils.isNotBlank((CharSequence)ruleListString)) {
                ruleNumbers = (List)SerializationUtils.fromJsonString((String)ruleListString, List.class);
            }
        } else {
            ruleNumbers.addAll(MetadataServiceBalanceReader.queryNumbersByBalTable(balanceTableNumber));
            ruleListString = SerializationUtils.toJsonString(ruleNumbers);
            BalanceRuleCacheUtils.putTableRuleListDistributeCache((String)balanceTableNumber, (String)ruleListString);
        }
        ArrayList<String> noCacheRuleNumbers = new ArrayList<String>();
        for (String ruleNumber : ruleNumbers) {
            String ruleString = BalanceRuleCacheUtils.getRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue());
            if (ruleString == null) {
                noCacheRuleNumbers.add(ruleNumber);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)ruleString)) continue;
            rules.add(ruleString);
        }
        if (!noCacheRuleNumbers.isEmpty()) {
            Map<String, String> ruleMap = MetadataServiceBalanceReader.queryRuntimeMeta(noCacheRuleNumbers.toArray(new String[noCacheRuleNumbers.size()]));
            for (String ruleNumber : noCacheRuleNumbers) {
                String ruleString = ruleMap.get(ruleNumber);
                if (StringUtils.isBlank((CharSequence)ruleString)) {
                    BalanceUpdateRuleWriter.rebuildRuntimeMetaByNumber((String)ruleNumber);
                    ruleString = MetadataServiceBalanceReader.queryRuntimeMeta(ruleNumber, ruleNumber, RuntimeRuleMetaType.UpdateRule);
                }
                rules.add(ruleString);
                BalanceRuleCacheUtils.putRuleDistributeCache((String)ruleNumber, (String)ruleNumber, (int)RuntimeRuleMetaType.UpdateRule.getValue(), (String)ruleString);
            }
        }
        return rules;
    }

    public static Map<String, Object> rebuildAllRuntimeRules(boolean forceRebuild) {
        Set<String> ruleNumbers = MetadataServiceBalanceReader.queryAllDesignRuleNumbers();
        return MetadataServiceBalanceReader.rebuildRunctionRules(forceRebuild, ruleNumbers);
    }

    public static Map<String, Object> rebuildAppRuntimeRules(boolean forceRebuild, String appNumber) {
        ArrayList<String> appNumbers = new ArrayList<String>();
        appNumbers.add(appNumber);
        return MetadataServiceBalanceReader.rebuildAppRuntimeRules(forceRebuild, appNumbers);
    }

    public static Map<String, Object> rebuildAppRuntimeRules(boolean forceRebuild, List<String> appNumbers) {
        List<String> rebuildAppNumbers = MetadataServiceBalanceReader.getExtBizAppNumber(appNumbers);
        rebuildAppNumbers.addAll(appNumbers);
        Set<String> ruleNumbers = MetadataServiceBalanceReader.queryAppDesignRuleNumbers(rebuildAppNumbers);
        return MetadataServiceBalanceReader.rebuildRunctionRules(forceRebuild, ruleNumbers);
    }

    private static Map<String, Object> rebuildRunctionRules(boolean forceRebuild, Set<String> ruleNumbers) {
        List successResult = Collections.synchronizedList(new ArrayList());
        List failedResult = Collections.synchronizedList(new ArrayList());
        ArrayList<BalanceRuleBuilder> tasks = new ArrayList<BalanceRuleBuilder>(10);
        for (String ruleNumber : ruleNumbers) {
            BalanceRuleBuilder builder = new BalanceRuleBuilder(ruleNumber, forceRebuild, RequestContext.get());
            tasks.add(builder);
        }
        try {
            List<Future<Future>> results = es.invokeAll(tasks);
            results.forEach(result -> {
                try {
                    Tuple r = (Tuple)result.get(MetadataServiceBalanceReader.getBuildTimeOut(), TimeUnit.MINUTES);
                    if (((Boolean)r.item1).booleanValue()) {
                        successResult.add(r.item2);
                    } else {
                        failedResult.add(r.item2);
                    }
                }
                catch (Exception e) {
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u5931\u8d25\uff1a%s", (String)"MetadataServiceBalanceReader_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
                }
            });
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("BOS_META", e.getMessage());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("count", ruleNumbers.size());
        result2.put("failed", failedResult);
        result2.put("success", successResult);
        return result2;
    }

    private static Map<String, String> queryRuntimeMeta(String[] ruleNumbers) {
        if (ruleNumbers == null || ruleNumbers.length == 0) {
            return new HashMap<String, String>();
        }
        String sql = "select FNumber, FDATA from T_BAL_UpdateRule where FNUMBER in (%s) and FTYPE = ?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            numbers.add("?");
            params.add(new SqlParameter(FNUMBER + String.valueOf(i), 12, (Object)ruleNumbers[i]));
        }
        sql = String.format(sql, StringUtils.join((Object[])numbers.toArray(), (String)","));
        params.add(new SqlParameter(":FTYPE", 5, (Object)RuntimeRuleMetaType.UpdateRule.getValue()));
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> datas = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    String number = rs.getString(1);
                    String data = rs.getString(2);
                    datas.put(number, data);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return datas;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)callBackHanlder);
    }

    private static String queryRuntimeMeta(String ruleNumber, String ctlKey, RuntimeRuleMetaType type) {
        String sql = "select FNumber, FDATA from T_BAL_UpdateRule where FNUMBER = ? and FKEY = ? and FTYPE = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)ruleNumber), new SqlParameter(":FKEY", 12, (Object)ctlKey), new SqlParameter(":FTYPE", 5, (Object)type.getValue())};
        ResultSetHandler callBackHanlder = rs -> {
            String data = null;
            try {
                if (rs.next()) {
                    data = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            if (type == RuntimeRuleMetaType.UpdateRule) {
                return data;
            }
            if (data == null) {
                return "";
            }
            return data;
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private static Set<String> queryNumbersByBill(String sourceEntityNumber) {
        String sql = "select FNumber from T_BAL_UpdateRuleDesign where FSourceEntityNumber = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FSourceEntityNumber", 12, (Object)sourceEntityNumber)};
        ResultSetHandler callBackHanlder = rs -> {
            HashSet<String> numbers = new HashSet<String>();
            try {
                while (rs.next()) {
                    numbers.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return numbers;
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private static Set<String> queryNumbersByBalTable(String balanceTableNumber) {
        String sql = "select FNumber from T_BAL_UpdateRuleDesign where FBalanceTableNumber = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FBalanceTableNumber", 12, (Object)balanceTableNumber)};
        ResultSetHandler callBackHanlder = rs -> {
            HashSet<String> numbers = new HashSet<String>();
            try {
                while (rs.next()) {
                    numbers.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return numbers;
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private static Set<String> queryAllDesignRuleNumbers() {
        String sql = "SELECT FNumber from t_Bal_UpdateRuleDesign WHERE FType='0'";
        ResultSetHandler<Set<String>> action = new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> ids = new HashSet<String>(16);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    private static Set<String> queryAppDesignRuleNumbers(List<String> appNumbers) {
        if (appNumbers == null || appNumbers.isEmpty()) {
            return new HashSet<String>();
        }
        String sql = "select a.FNumber from t_bal_UpdateRuleDesign a inner join t_meta_bizapp b on a.FBIZAPPID = b.FID where b.FNUMBER in (%s) ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        ArrayList<String> apps = new ArrayList<String>(10);
        for (int i = 0; i < appNumbers.size(); ++i) {
            params.add(new SqlParameter(FNUMBER + String.valueOf(i), 12, (Object)appNumbers.get(i)));
            apps.add("?");
        }
        sql = String.format(sql, StringUtils.join((Object[])apps.toArray(), (String)","));
        ResultSetHandler callBackHanlder = rs -> {
            HashSet<String> ids = new HashSet<String>();
            try {
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return ids;
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)callBackHanlder);
    }

    private static long getBuildTimeOut() {
        int timeout = 120;
        String buildTimeout = System.getProperty("build.timeout");
        if (!StringUtils.isEmpty((CharSequence)buildTimeout)) {
            timeout = Integer.parseInt(buildTimeout);
        }
        return timeout;
    }

    private static List<String> getExtBizAppNumber(List<String> numbers) {
        ArrayList<String> params = new ArrayList<String>(2);
        params.addAll(numbers);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fnumber from t_meta_bizapp where fmasterid in (select fid from t_meta_bizapp where ", new Object[0]).appendIn("fnumber", params).append(");", new Object[0]);
        ArrayList<String> appIds = new ArrayList<String>(2);
        try {
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
                while (rs.next()) {
                    appIds.add(rs.getString(1));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return appIds;
    }
}

