/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.service.metadata.AppMetadataServiceReader;
import kd.bos.service.metadata.TableUseRecord;

class MetadataServiceReader {
    private static final String ERROR_S = "Error:%s";
    private static final String FNUMBER = ":FNUMBER";
    private static final String FTYPE = ":FTYPE";
    private static final String T_META_FORM = "T_META_FORM";
    private static Log log = LogFactory.getLog(MetadataServiceReader.class);
    private static final String SQL_READPERMISSIONITEMS = "select fpermitemid from t_perm_functionperm where fentitytypeid = ? ";

    MetadataServiceReader() {
    }

    public String loadEntityMeta(String number) {
        return this.queryAndRebuildMeta(number, number, RuntimeMetaType.Entity, "T_META_ENTITY");
    }

    Map<String, String> loadEntityMetas(String[] numbers) {
        ArrayList<String> noCacheNumberList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>(numbers.length);
        List list = MetaCacheUtils.getEntityDistributeCache((String[])numbers);
        for (int i = 0; i < numbers.length; ++i) {
            if (list.size() == 0 || list.get(i) == null) {
                noCacheNumberList.add(numbers[i]);
                continue;
            }
            map.put(numbers[i], (String)list.get(i));
        }
        if (noCacheNumberList.size() > 0) {
            Map<String, String> noCacheEntityTypes = this.doQueryEntityTypeDatas(noCacheNumberList.toArray(new String[0]));
            ArrayList<String> rebuildNumberList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : noCacheEntityTypes.entrySet()) {
                String number = entry.getKey();
                if (entry.getValue() != null) continue;
                this.rebuildRuntimeMeta(number);
                rebuildNumberList.add(number);
            }
            HashMap<String, String> entityTypeMap = new HashMap<String, String>(16);
            if (rebuildNumberList.size() > 0) {
                Map<String, String> rebuildEntityTypes = this.doQueryEntityTypeDatas(rebuildNumberList.toArray(new String[0]));
                noCacheEntityTypes.putAll(rebuildEntityTypes);
            }
            for (Map.Entry<String, String> entry : noCacheEntityTypes.entrySet()) {
                if (StringUtils.isNotBlank((CharSequence)entry.getValue())) {
                    entityTypeMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                entry.setValue("");
            }
            MetaCacheUtils.putEntityDistributeCache(entityTypeMap);
            map.putAll(noCacheEntityTypes);
        }
        return map;
    }

    public String loadEntityOperationMeta(String number, String operKey) {
        return this.queryEntityMetaCache(number, operKey, RuntimeMetaType.Operate);
    }

    public List<String> loadEntityAllOperationMeta(String number) {
        List<String> vals = this.doQueryMetas(number, RuntimeMetaType.Operate, this.getGrayTableName("T_META_ENTITY"));
        if (vals.isEmpty() && this.isGrayGroup()) {
            vals = this.doQueryMetas(number, RuntimeMetaType.Operate, "T_META_ENTITY");
        }
        return vals;
    }

    public Map<String, List<String>> getDataEntityOperationKeys(Collection<String> nums) {
        if (nums == null || nums.isEmpty()) {
            return Collections.emptyMap();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select FKEY,FNUMBER from T_META_ENTITY where FTYPE = ?", new Object[]{new SqlParameter(FTYPE, 5, (Object)RuntimeMetaType.Operate.getValue())});
        builder.append(" and ", new Object[0]).appendIn("FNUMBER", nums.toArray());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap result = new HashMap(10);
            try {
                while (rs.next()) {
                    String opkey = rs.getString(1);
                    String num = rs.getString(2);
                    if (result.get(num) == null) {
                        result.put(num, new ArrayList(10));
                    }
                    ((List)result.get(num)).add(opkey);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return result;
        };
        Map listMeta = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, (ResultSetHandler)callBackHanlder);
        return listMeta;
    }

    public List<String> loadEntityNetCtrlOperationMeta(String number) {
        String val = MetaCacheUtils.getDistributeCache((String)number, (String)"netCtrl", (int)RuntimeMetaType.NetCtrlOperate.getValue());
        List<String> netCtrlOperationMeta = null;
        if (StringUtils.isBlank((CharSequence)val)) {
            netCtrlOperationMeta = this.doQueryMetas(number, RuntimeMetaType.NetCtrlOperate, this.getGrayTableName("T_META_ENTITY"));
            val = SerializationUtils.toJsonString(netCtrlOperationMeta);
            MetaCacheUtils.putDistributeCache((String)number, (String)"netCtrl", (int)RuntimeMetaType.NetCtrlOperate.getValue(), (String)val);
        } else {
            netCtrlOperationMeta = (List<String>)SerializationUtils.fromJsonString((String)val, List.class);
        }
        return netCtrlOperationMeta;
    }

    public String loadEntityPrincipalRelationMeta(String number) {
        String principalRelation = MetaCacheUtils.getDistributeCache((String)number, (String)"principalRelation", (int)RuntimeMetaType.PrincipalRelation.getValue());
        if (StringUtils.isBlank((CharSequence)principalRelation)) {
            principalRelation = this.loadEntityRuntimeMeta(number, RuntimeMetaType.PrincipalRelation.getValue(), number);
            MetaCacheUtils.putDistributeCache((String)number, (String)"principalRelation", (int)RuntimeMetaType.PrincipalRelation.getValue(), (String)principalRelation);
        }
        return principalRelation;
    }

    public Set<String> loadPermissionItems(String number) {
        Set<String> permItemIds = new HashSet<String>();
        String val = MetaCacheUtils.getDistributeCache((String)number, null, (int)RuntimeMetaType.PermissionItems.getValue());
        if (val != null) {
            String[] itemIds;
            for (String itemId : itemIds = StringUtils.split((String)val, (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)itemId)) continue;
                permItemIds.add(itemId);
            }
        } else {
            Object[] parameters = new SqlParameter[]{new SqlParameter(":FEntityTypeId", 12, (Object)number)};
            ResultSetHandler action = rs -> {
                HashSet<String> itemIds = new HashSet<String>();
                while (rs.next()) {
                    String itemId = rs.getString("fpermitemid");
                    if (!StringUtils.isNotBlank((CharSequence)itemId)) continue;
                    itemIds.add(itemId);
                }
                return itemIds;
            };
            permItemIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)SQL_READPERMISSIONITEMS, (Object[])parameters, (ResultSetHandler)action);
            val = StringUtils.join((Object[])permItemIds.toArray(), (String)",");
            MetaCacheUtils.putDistributeCache((String)number, null, (int)RuntimeMetaType.PermissionItems.getValue(), (String)val);
        }
        return permItemIds;
    }

    public String loadTableDefine(String entityNumber, String entityKey) {
        String val = MetaCacheUtils.getDistributeCache((String)entityNumber, (String)entityKey, (int)RuntimeMetaType.TableDefine.getValue());
        if (val == null) {
            Object[] parameters = new SqlParameter[2];
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT FId, FEntityKey, FTableId ");
            sBuilder.append("FROM T_META_EntityInfo ");
            sBuilder.append("WHERE FId = ? and FEntityKey = ? ");
            parameters[0] = new SqlParameter(":FId", 12, (Object)entityNumber);
            parameters[1] = new SqlParameter(":FEntityKey", 12, (Object)entityKey);
            ResultSetHandler action = rs -> {
                ArrayList<Long> list = new ArrayList<Long>(1);
                while (rs.next()) {
                    Long tableId = rs.getLong("FTableId");
                    if (tableId == null || Long.compare(0L, tableId) == 0) continue;
                    list.add(tableId);
                }
                return list;
            };
            List tableIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
            Long tableId = TableUseRecord.getTableIdByHistory(entityNumber, entityKey, tableIds);
            if (tableId != null) {
                TableDefine tableDefine = new TableDefine();
                tableDefine.setEntityNumber(entityNumber);
                tableDefine.setEntityKey(entityKey);
                tableDefine.setTableId(tableId);
                val = SerializationUtils.toJsonString((Object)tableDefine);
                MetaCacheUtils.putDistributeCache((String)entityNumber, (String)entityKey, (int)RuntimeMetaType.TableDefine.getValue(), (String)val);
            }
        }
        return val;
    }

    public String loadTableDefine(Long tableId) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FTableId = ? ");
        parameters[0] = new SqlParameter(":FTableId", -5, (Object)tableId);
        ResultSetHandler action = rs -> {
            TableDefine tableDefine = null;
            if (rs.next()) {
                tableDefine = new TableDefine();
                tableDefine.setEntityNumber(rs.getString("FId"));
                tableDefine.setEntityKey(rs.getString("FEntityKey"));
                tableDefine.setTableId(tableId);
            }
            return tableDefine;
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        if (tableDefine == null) {
            return null;
        }
        return SerializationUtils.toJsonString((Object)tableDefine);
    }

    public String loadBaseDataFieldFilterMeta(String number, String operKey) {
        return this.queryEntityMetaCache(number, operKey, RuntimeMetaType.BaseDataFieldFilter);
    }

    public String loadEntityRuntimeMeta(String entityNumber, int entityMetaType, String key) {
        return this.queryAndRebuildMeta(entityNumber, key, RuntimeMetaType.valueOf((int)entityMetaType), "T_META_ENTITY");
    }

    public String loadFormConfig(String number) {
        return this.queryAndRebuildMeta(number, number, RuntimeMetaType.Config, T_META_FORM);
    }

    public String loadDataEntityTypeMeta(String dbId, String entityTypeId) {
        return MetaCacheUtils.getDistributeCache((String)entityTypeId, (String)entityTypeId, (int)0);
    }

    Map<String, String> getAppNumberByEntityNumbers(List<Object> entityNumbers) {
        if (entityNumbers.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FID, FAPPID from t_meta_mainentityinfo  where ", new Object[0]).appendIn("FID", entityNumbers);
        try {
            return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(16);
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String appid = rs.getString(2);
                        map.put(id, appid);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return map;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s; sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private String queryEntityMetaCache(String number, String fieldKey, RuntimeMetaType type) {
        return this.queryAndPutMetaCache(number, fieldKey, type, "T_META_ENTITY");
    }

    private String queryAndRebuildMeta(String number, String key, RuntimeMetaType type, String tableName) {
        String val = MetaCacheUtils.getDistributeCache((String)number, (String)key, (int)type.getValue());
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return val;
        }
        val = this.queryMeta(number, key, type, tableName);
        if (val == null && this.isRebuildType(type, key)) {
            this.rebuildRuntimeMeta(number);
            val = this.queryMeta(number, key, type, tableName);
        }
        if (val == null) {
            val = "";
        }
        MetaCacheUtils.putDistributeCache((String)number, (String)key, (int)type.getValue(), (String)val);
        return val;
    }

    private String queryAndPutMetaCache(String number, String key, RuntimeMetaType type, String tableName) {
        String val = MetaCacheUtils.getDistributeCache((String)number, (String)key, (int)type.getValue());
        if (val != null) {
            return val;
        }
        val = this.queryMeta(number, key, type, tableName);
        if (val == null) {
            val = "";
        }
        MetaCacheUtils.putDistributeCache((String)number, (String)key, (int)type.getValue(), (String)val);
        return val;
    }

    private String queryMeta(String number, String key, RuntimeMetaType type, String tableName) {
        String val = this.doQueryMetaData(number, key, type, this.getGrayTableName(tableName));
        if (val == null && this.isGrayGroup()) {
            val = this.doQueryMetaData(number, key, type, tableName);
        }
        return val;
    }

    private String doQueryMetaData(String number, String ctlKey, RuntimeMetaType type, String table) {
        SqlParameter[] params;
        String sql;
        if (StringUtils.isNotEmpty((CharSequence)ctlKey)) {
            sql = String.format("select FDATA from %s where FNUMBER = ? and FKEY = ? and FTYPE = ?", table);
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter("FKEY", 12, (Object)ctlKey), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        } else {
            sql = String.format("select FDATA from %s where FNUMBER = ? and FTYPE = ?", table);
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        }
        return this.queryDB(sql, params);
    }

    private Map<String, String> doQueryRuntimeFormMetaVersion(Collection<String> numbers) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("SELECT FNUMBER,FDATA FROM T_META_FORM WHERE ", new Object[0]).append(" FTYPE = ?", (Object[])new SqlParameter[]{new SqlParameter(FTYPE, 5, (Object)RuntimeMetaType.Version.getValue())}).append(" AND ", new Object[0]).appendIn("FNUMBER", numbers.toArray());
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            HashMap<String, String> vers = new HashMap<String, String>(10);
            while (rs.next()) {
                vers.put(rs.getString("FNUMBER"), rs.getString("FDATA"));
            }
            return vers;
        });
    }

    private List<String> doQueryMetas(String number, RuntimeMetaType type, String tableName) {
        String sql = String.format("select FDATA from %s where FNUMBER = ? and FTYPE = ?", tableName);
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        ResultSetHandler callBackHanlder = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return list;
        };
        List listMeta = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        return listMeta;
    }

    private Map<String, String> doQueryEntityTypeDatas(String[] numbers) {
        HashMap<String, String> entityTypeMap = new HashMap<String, String>(numbers.length);
        for (String number : numbers) {
            entityTypeMap.put(number, null);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FNUMBER, FDATA from T_META_ENTITY where ", new Object[0]).appendIn("FNUMBER", (Object[])numbers).append(" and FTYPE = 11", new Object[0]);
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            try {
                while (rs.next()) {
                    String number = rs.getString(1);
                    entityTypeMap.put(number, rs.getString(2));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return null;
        });
        return entityTypeMap;
    }

    private String doQueryScriptMeta(String ctlKey, RuntimeMetaType type) {
        String jsonStr = "";
        if (StringUtils.isNotEmpty((CharSequence)ctlKey)) {
            String sql = "select FSCRIPTCONTEXT_TAG from t_meta_pluginscript where FCLASSNAME = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FKEY", 12, (Object)ctlKey)};
            ResultSetHandler callBackHanlder = rs -> {
                String sFdata = null;
                try {
                    if (rs.next()) {
                        sFdata = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return sFdata;
            };
            jsonStr = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        }
        return jsonStr;
    }

    public static String getCacheKey(String key, Class<?> type) {
        String dbId = CacheKeyUtil.getAcctId();
        return String.format("%s_%s_%s", dbId, type.getName(), key);
    }

    public String loadFormPluginScript(String number, String key) {
        RuntimeMetaType type = RuntimeMetaType.FormPluginScript;
        String val = MetaCacheUtils.getDistributeCache((String)key, (String)key, (int)type.getValue());
        if (val == null) {
            val = this.doQueryScriptMeta(key, type);
            MetaCacheUtils.putDistributeCache((String)key, (String)key, (int)type.getValue(), (String)val);
        }
        return val;
    }

    public String loadFormRuntimeMeta(String number, short type, String key) {
        return this.queryAndRebuildMeta(number, key, RuntimeMetaType.valueOf((short)type), T_META_FORM);
    }

    public String loadLis(String number, String key) {
        return this.queryAndRebuildMeta(number, key, RuntimeMetaType.List, T_META_FORM);
    }

    public String getRuntimeFormMetaVersion(String number) {
        return (String)ThreadCache.get((Object)("FV." + number), () -> {
            String redisMetaVer = MetaCacheUtils.getFormMetaVersion((String)number);
            if (StringUtils.isBlank((CharSequence)redisMetaVer)) {
                redisMetaVer = this.queryAndRebuildMeta(number, number, RuntimeMetaType.Version, T_META_FORM);
                MetaCacheUtils.setFormMetaVersion((String)number, (String)redisMetaVer);
            }
            return redisMetaVer == null ? "" : redisMetaVer;
        });
    }

    public Map<String, String> batchLoadRuntimeFormMetaVersion(Collection<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(numbers.size());
        HashSet<String> notFounds = new HashSet<String>(10);
        for (String number : numbers) {
            Object ver = ThreadCache.get((Object)("DBMETA.FV." + number));
            if (ver == null) {
                notFounds.add(number);
                continue;
            }
            result.put(number, ver.toString());
        }
        if (!notFounds.isEmpty()) {
            Map<String, String> datas = this.doQueryRuntimeFormMetaVersion(numbers);
            for (Map.Entry<String, String> it : datas.entrySet()) {
                ThreadCache.put((Object)("DBMETA.FV." + it.getKey()), (Object)it.getValue());
            }
            result.putAll(datas);
        }
        return result;
    }

    private void rebuildRuntimeMeta(String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        try {
            mr.rebuildRuntimeMetaByNumber(number);
        }
        catch (KDException e) {
            if (e.getErrorCode().getCode().equals(BosErrorCode.metaNotFound.getCode()) && this.isGrayGroup()) {
                mr = new MetaRebuilder("defaultGroup");
                mr.rebuildRuntimeMetaByNumber(number);
            }
            throw e;
        }
    }

    private boolean isRebuildType(RuntimeMetaType type, String key) {
        if (type == RuntimeMetaType.MobList && "Config".equals(key)) {
            return true;
        }
        return type == RuntimeMetaType.Version || type == RuntimeMetaType.Config || type == RuntimeMetaType.Form || type == RuntimeMetaType.Entity || type == RuntimeMetaType.List || type == RuntimeMetaType.Client;
    }

    public String loadBilltypeCtlInfo(String number, String key) {
        return this.queryEntityMetaCache(number, key, RuntimeMetaType.BilltypeCtlInfo);
    }

    private String getGrayTableName(String tabName) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (this.isGrayGroup()) {
            return String.format("%s_%s", tabName, appGroup);
        }
        return tabName;
    }

    private boolean isGrayGroup() {
        return AppGroupUtils.isGrayGroup();
    }

    private String queryDB(String sql, SqlParameter[] params) {
        ResultSetHandler callBackHanlder = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return sFdata;
        };
        String sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        return sRet;
    }

    public Map<String, List<String>> getEnabledControlsMap(String formId) {
        String val = MetaCacheUtils.getDistributeCache((String)formId, (String)"lockfields", (int)RuntimeMetaType.lockFields.getValue());
        if (StringUtils.isBlank((CharSequence)val)) {
            HashMap<String, ArrayList<String>> lockedControlsMap = new HashMap<String, ArrayList<String>>(16);
            FormRoot rootControl = FormMetadataCache.getRootControl((String)formId);
            ArrayList<String> submitFields = (ArrayList<String>)lockedControlsMap.get("submit");
            ArrayList<String> auditFields = (ArrayList<String>)lockedControlsMap.get("audit");
            if (submitFields == null) {
                submitFields = new ArrayList<String>(10);
            }
            if (auditFields == null) {
                auditFields = new ArrayList<String>(10);
            }
            this.getEnabledControlsMap(rootControl.getItems(), submitFields, auditFields);
            lockedControlsMap.put("submit", submitFields);
            lockedControlsMap.put("audit", auditFields);
            val = SerializationUtils.toJsonString(lockedControlsMap);
            MetaCacheUtils.putDistributeCache((String)formId, (String)"lockfields", (int)RuntimeMetaType.lockFields.getValue(), (String)val);
        }
        return (Map)SerializationUtils.fromJsonString((String)val, Map.class);
    }

    private void getEnabledControlsMap(List<Control> controls, List<String> submitFields, List<String> auditFields) {
        for (Control ctl : controls) {
            if (ctl instanceof Container) {
                this.getEnabledControlsMap(((Container)ctl).getItems(), submitFields, auditFields);
                continue;
            }
            if (!(ctl instanceof FieldEdit) || ObjectUtils.isEmpty((Object)ctl.getLockIntegerVal())) continue;
            this.addLockField(submitFields, auditFields, ctl);
        }
    }

    private void addLockField(List<String> submitFields, List<String> auditFields, Control ctl) {
        Integer lock = ctl.getLockIntegerVal();
        if ((lock & 0x10) != 16) {
            this.addLockField(submitFields, ctl, "submit");
        }
        if ((lock & 0x20) != 32) {
            this.addLockField(auditFields, ctl, "audit");
        }
    }

    private void addLockField(List<String> lockFields, Control ctl, String lockTypeKey) {
        lockFields.add(((FieldEdit)ctl).getFieldKey());
    }

    public String loadAppInfo(String number) {
        return this.loadAppInfo(AppGroupUtils.getCurrentAppGroup(), number);
    }

    String loadAppInfo(String appGroup, String number) {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.loadAppInfo(appGroup, number);
    }

    public String getAppMenusInfoByAppId(String number) {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.loadAppMenuInfo(AppGroupUtils.getCurrentAppGroup(), number);
    }
}

