/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.TipLinkTitle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.ItemClass;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.operation.NetCtrlOperation;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.service.metadata.util.MultilingualTranslationUtil;

public class MultiLangMetadataLoad
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataLoad.class);
    public static final String NUMBER = "number";
    public static final String LOAD_DETAILS = "loadDetails";
    private boolean ignoreDirtyLocale = true;

    public ApiResult doCustomService(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String id = MetadataDao.getIdByNumber((String)params.get(NUMBER).toString(), (MetaCategory)MetaCategory.Form);
            this.ignoreDirtyLocale = Boolean.parseBoolean(String.valueOf(params.getOrDefault("ignoreDirtyLocale", "true")));
            if (Boolean.parseBoolean(String.valueOf(params.get(LOAD_DETAILS)))) {
                return ApiResult.success(this.getDetailData(params.get(NUMBER).toString()));
            }
            Map<String, Object> localeItems = this.readMeta(id);
            result.put("id", params.get(NUMBER).toString());
            result.put("ver", Long.valueOf(System.currentTimeMillis()).toString());
            result.put(LOAD_DETAILS, false);
            ArrayList list = new ArrayList(10);
            result.put("localeList", list);
            for (Map.Entry<String, Object> entry : localeItems.entrySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                list.add(map);
                map.put("type", entry.getKey());
                List localeItemsList = (List)entry.getValue();
                HashMap data = new HashMap(16);
                map.put("data", data);
                for (Map localeItemsMap : localeItemsList) {
                    for (Map.Entry stringILocaleValueEntry : localeItemsMap.entrySet()) {
                        ILocaleValue localeitem = (ILocaleValue)stringILocaleValueEntry.getValue();
                        data.put(stringILocaleValueEntry.getKey(), (LocaleString)localeitem);
                    }
                }
            }
        }
        catch (KDException e) {
            if ("MetaInheritPathError".equalsIgnoreCase(e.getErrorCode().getCode())) {
                return ApiResult.fail((String)e.getMessage(), (String)e.getErrorCode().getCode());
            }
            if ("bos.metaNotFound".equalsIgnoreCase(e.getErrorCode().getCode())) {
                return ApiResult.fail((String)e.getMessage(), (String)"MetaInheritPathError");
            }
            log.error("MultiLangMetadataLoad fail: ", (Throwable)e);
            return ApiResult.fail((String)"MultiLangMetadataLoad fail.", (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("MultiLangMetadataLoad fail: ", (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25%s", (String)"MultiLangMetadataLoad_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success((Object)SerializationUtils.toJsonString(result));
    }

    private AbstractMetadata readMeta(String id, MetaCategory category) {
        return MultilingualTranslationUtil.readMeta(id, category, this.ignoreDirtyLocale);
    }

    private Map<String, Object> getDetailData(String num) {
        String id = MetadataDao.getIdByNumber((String)num, (MetaCategory)MetaCategory.Form);
        AbstractMetadata formMeta = this.readMeta(id, MetaCategory.Form);
        DomainModelType domainModel = DomainModelType.getDomainModelType((String)formMeta.getModelType(), (boolean)false);
        LangItemsBuilder builder = new LangItemsBuilder((DcBinder)new DomainModelBinder(domainModel), false);
        builder.build(num);
        return builder.getAllRes();
    }

    private Map<String, Object> readMeta(String id) {
        AbstractMetadata metadata = this.readMeta(id, MetaCategory.Form);
        if (metadata instanceof PrintMetadata) {
            return (Map)((PrintMetadata)metadata).getLocaleItems();
        }
        if (metadata instanceof FormMetadata) {
            EntityMetadata entityMetaData;
            FormMetadata formMetadata = (FormMetadata)metadata;
            if (StringUtils.isNotBlank((CharSequence)MetadataDao.getEntityNumberById((String)id)) && (entityMetaData = (EntityMetadata)this.readMeta(id, MetaCategory.Entity)) != null) {
                formMetadata.bindEntityMetadata(entityMetaData);
            }
            return (Map)formMetadata.getLocaleItems();
        }
        return new HashMap<String, Object>();
    }

    class LangItemsBuilder {
        private DcBinder binder;
        private Map<String, MetaLocaleItem> formLocaleItemMap;
        private Map<String, MetaLocaleItem> entityLocaleItemMap;
        private Map<String, AbstractMetadata> formMetas;
        private Map<String, EntityMetadata> entityMetas;
        private String currentNum = "";
        private String baseNum = "";

        public LangItemsBuilder(DcBinder binder, boolean buildDetail) {
            this.binder = binder;
            this.formLocaleItemMap = new HashMap<String, MetaLocaleItem>();
            this.entityLocaleItemMap = new HashMap<String, MetaLocaleItem>();
            this.formMetas = new LinkedHashMap<String, AbstractMetadata>();
            this.entityMetas = new LinkedHashMap<String, EntityMetadata>();
        }

        public void build(String formNum) {
            String id = MetadataDao.getIdByNumber((String)formNum, (MetaCategory)MetaCategory.Form);
            AbstractMetadata formMeta = MultiLangMetadataLoad.this.readMeta(id, MetaCategory.Form);
            String inheritPath = formMeta.getInheritPath();
            String[] parentIds = null;
            if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
                for (String oid : parentIds = inheritPath.split(",")) {
                    if (StringUtils.isBlank((CharSequence)oid)) continue;
                    this.formMetas.put(oid, (AbstractMetadata)((FormMetadata)MultiLangMetadataLoad.this.readMeta(oid, MetaCategory.Form)));
                }
            }
            this.formMetas.put(id, formMeta);
            if (StringUtils.isNotBlank((CharSequence)MetadataDao.getEntityNumberById((String)id))) {
                EntityMetadata entityMeta = (EntityMetadata)MultiLangMetadataLoad.this.readMeta(id, MetaCategory.Entity);
                if (StringUtils.isNotBlank((CharSequence)entityMeta.getInheritPath())) {
                    for (String oid : parentIds = entityMeta.getInheritPath().split(",")) {
                        if (StringUtils.isBlank((CharSequence)oid)) continue;
                        this.entityMetas.put(oid, (EntityMetadata)MultiLangMetadataLoad.this.readMeta(oid, MetaCategory.Entity));
                    }
                }
                this.entityMetas.put(id, entityMeta);
            }
            this.buildFormItems();
            this.buildEntityItems();
        }

        public Map getAllRes() {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(4);
            HashMap extInfo = new HashMap(10);
            HashMap<String, LocaleString> formNameMapping = new HashMap<String, LocaleString>(10);
            for (Map.Entry<String, AbstractMetadata> row : this.formMetas.entrySet()) {
                if (row.getValue() instanceof FormMetadata) {
                    formNameMapping.put(((FormMetadata)row.getValue()).getKey(), ((FormMetadata)row.getValue()).getName());
                    continue;
                }
                if (!(row.getValue() instanceof PrintMetadata)) continue;
                formNameMapping.put(((PrintMetadata)row.getValue()).getKey(), ((PrintMetadata)row.getValue()).getName());
            }
            extInfo.put("formNameMapping", formNameMapping);
            map.put("extInfo", extInfo);
            map.put(MultiLangMetadataLoad.LOAD_DETAILS, Boolean.valueOf(true));
            if (this.formLocaleItemMap != null && !this.formLocaleItemMap.isEmpty()) {
                ArrayList<Map> form = new ArrayList<Map>(10);
                map.put("form", form);
                for (Map.Entry<String, MetaLocaleItem> row : this.formLocaleItemMap.entrySet()) {
                    form.add(row.getValue().getData());
                }
            }
            if (this.entityLocaleItemMap != null && !this.entityLocaleItemMap.isEmpty()) {
                ArrayList<Map> entity = new ArrayList<Map>(10);
                map.put("entity", entity);
                for (Map.Entry<String, MetaLocaleItem> row : this.entityLocaleItemMap.entrySet()) {
                    entity.add(row.getValue().getData());
                }
            }
            return map;
        }

        private void buildFormItems() {
            if (this.formMetas == null || this.formMetas.isEmpty()) {
                return;
            }
            for (Map.Entry<String, AbstractMetadata> meta : this.formMetas.entrySet()) {
                if (null != meta.getValue()) continue;
                throw new KDException(new ErrorCode("MetaInheritPathError", "Meta inheritpath has exception, key is " + meta.getKey()), new Object[0]);
            }
            int maxTimes = this.formMetas.size() - 1;
            ArrayList<AbstractMetadata> formList = new ArrayList<AbstractMetadata>(this.formMetas.values());
            boolean isFormMeta = formList.get(0) instanceof FormMetadata;
            if (maxTimes == 0) {
                this.currentNum = isFormMeta ? ((FormMetadata)formList.get(0)).getKey() : ((PrintMetadata)formList.get(0)).getKey();
                this.buildResources((AbstractMetadata)formList.get(0), null, this.formLocaleItemMap);
            } else {
                for (int i = 1; i <= maxTimes; ++i) {
                    this.baseNum = isFormMeta ? ((FormMetadata)formList.get(i - 1)).getKey() : ((PrintMetadata)formList.get(i - 1)).getKey();
                    this.currentNum = isFormMeta ? ((FormMetadata)formList.get(i)).getKey() : ((PrintMetadata)formList.get(i)).getKey();
                    this.buildResources((AbstractMetadata)formList.get(i), (AbstractMetadata)formList.get(i - 1), this.formLocaleItemMap);
                }
            }
            this.baseNum = "";
            this.currentNum = "";
        }

        private void buildEntityItems() {
            if (this.entityMetas == null || this.entityMetas.isEmpty()) {
                return;
            }
            int maxTimes = this.entityMetas.size() - 1;
            ArrayList<EntityMetadata> formList = new ArrayList<EntityMetadata>(this.entityMetas.values());
            if (maxTimes == 0) {
                this.currentNum = ((EntityMetadata)formList.get(0)).getKey();
                this.buildResources((AbstractMetadata)formList.get(0), null, this.entityLocaleItemMap);
            } else {
                for (int i = 1; i <= maxTimes; ++i) {
                    this.baseNum = ((EntityMetadata)formList.get(i - 1)).getKey();
                    this.currentNum = ((EntityMetadata)formList.get(i)).getKey();
                    this.buildResources((AbstractMetadata)formList.get(i), (AbstractMetadata)formList.get(i - 1), this.entityLocaleItemMap);
                }
            }
        }

        private void buildFormItemsEx() {
            if (this.formMetas == null || this.formMetas.isEmpty()) {
                return;
            }
            int maxTimes = this.formMetas.size();
            ArrayList<AbstractMetadata> formList = new ArrayList<AbstractMetadata>(this.formMetas.values());
            boolean isFormMeta = formList.get(0) instanceof FormMetadata;
            for (int i = 0; i < maxTimes; ++i) {
                this.baseNum = isFormMeta ? ((FormMetadata)formList.get(i)).getKey() : ((PrintMetadata)formList.get(i)).getKey();
                this.buildResources((AbstractMetadata)formList.get(i), (AbstractMetadata)formList.get(i), this.formLocaleItemMap);
            }
            this.baseNum = "";
            this.currentNum = "";
        }

        private void buildEntityItemsEx() {
            if (this.entityMetas == null || this.entityMetas.isEmpty()) {
                return;
            }
            int maxTimes = this.entityMetas.size();
            ArrayList<EntityMetadata> formList = new ArrayList<EntityMetadata>(this.entityMetas.values());
            for (int i = 0; i < maxTimes; ++i) {
                this.baseNum = ((EntityMetadata)formList.get(i)).getKey();
                this.buildResources((AbstractMetadata)formList.get(i), (AbstractMetadata)formList.get(i), this.entityLocaleItemMap);
            }
        }

        private void buildResources(AbstractMetadata currentEntity, AbstractMetadata baseEntity, Map<String, MetaLocaleItem> map) {
            this.buildResources(currentEntity, currentEntity.getClass().getSimpleName(), baseEntity, null, map);
        }

        private void buildResources(Object currentEntity, String parentId, Object baseEntity, AbstractElement element, Map<String, MetaLocaleItem> map) {
            IDataEntityType currentEntityType = this.binder.getDataEntityType(currentEntity);
            if (currentEntity == null) {
                return;
            }
            this.buildRes(currentEntity, parentId, baseEntity, currentEntityType, element, map);
        }

        private boolean isLocaleProp(IDataEntityProperty p) {
            if (p == null) {
                return false;
            }
            return p.getPropertyType() != null && ILocaleValue.class.isAssignableFrom(p.getPropertyType());
        }

        private boolean isLocaleValueChanged(ILocaleValue<?> current, ILocaleValue<?> base) {
            Set baseKeys;
            if (current == null && base == null) {
                return false;
            }
            if (current == null || base == null) {
                return true;
            }
            Set cureentKeys = current.keySet();
            if (!cureentKeys.containsAll(baseKeys = base.keySet()) || cureentKeys.size() != baseKeys.size()) {
                return true;
            }
            for (String key : cureentKeys) {
                if (String.valueOf(current.get((Object)key)).equals(String.valueOf(base.get((Object)key)))) continue;
                return true;
            }
            return false;
        }

        private void markSrcNum(MetaLocaleItemDetail current, Map<String, MetaLocaleItem> map) {
            MetaLocaleItemDetail target = (MetaLocaleItemDetail)map.get(current.getId());
            MetaLocaleSrcItem targetSrcItem = null;
            if (target == null) {
                map.put(current.getId(), current);
            } else {
                target.setElement(current.getElement());
                target.setDataEntity(current.getDataEntity());
                target.setProperty(current.getProperty());
                if (current.isValueChange()) {
                    target.setSrcNum(current.getSrcNum());
                    target.setValueChange(true);
                }
                for (Map.Entry<String, MetaLocaleSrcItem> entity : current.getPropertyDetail().entrySet()) {
                    targetSrcItem = target.getPropertyDetail().get(entity.getKey());
                    if (targetSrcItem == null) {
                        target.getPropertyDetail().put(entity.getKey(), entity.getValue());
                        continue;
                    }
                    if (targetSrcItem.getLocaleValue() != null && targetSrcItem.getLocaleValue().equals(entity.getValue().getLocaleValue())) continue;
                    targetSrcItem.setLocaleValue(entity.getValue() == null ? "" : entity.getValue().getLocaleValue());
                    targetSrcItem.setSrcNum(current.getSrcNum());
                }
            }
        }

        public void buildRes(Object currentEntity, String parentId, Object baseEntity, IDataEntityType currentEntityType, AbstractElement element, Map<String, MetaLocaleItem> map) {
            for (IDataEntityProperty p : currentEntityType.getProperties()) {
                String Id = parentId == null ? p.getName() : parentId + "." + p.getName();
                Object val = p.getValue(currentEntity);
                if (ControlAp.class.isAssignableFrom(currentEntity.getClass())) {
                    element = (ControlAp)currentEntity;
                }
                if (EntityItem.class.isAssignableFrom(currentEntity.getClass())) {
                    element = (EntityItem)currentEntity;
                }
                if (p instanceof ISimpleProperty) {
                    if (baseEntity == null) {
                        if (!this.isLocaleProp(p)) continue;
                        ILocaleValue currentLValue = (ILocaleValue)val;
                        MetaLocaleItemDetail item = new MetaLocaleItemDetail();
                        item.setId(Id);
                        item.setElement(element);
                        item.setValueChange(true);
                        item.setDataEntity(currentEntity);
                        item.setProperty((ISimpleProperty)p);
                        item.setPropertyDetail(this.buildSrcItemValue(currentLValue, currentLValue));
                        item.setSrcNum(this.currentNum);
                        map.put(Id, item);
                        continue;
                    }
                    if (!this.isLocaleProp(p)) continue;
                    ILocaleValue baseLValue = (ILocaleValue)p.getValue(baseEntity);
                    ILocaleValue currentLValue = (ILocaleValue)val;
                    MetaLocaleItemDetail item = new MetaLocaleItemDetail();
                    item.setId(Id);
                    item.setElement(element);
                    item.setDataEntity(currentEntity);
                    item.setProperty((ISimpleProperty)p);
                    if (this.isLocaleValueChanged(baseLValue, currentLValue)) {
                        item.setSrcNum(this.currentNum);
                        item.setValueChange(true);
                    } else {
                        item.setSrcNum(this.baseNum);
                        item.setValueChange(false);
                    }
                    item.setPropertyDetail(this.buildSrcItemValue(currentLValue, baseLValue));
                    this.markSrcNum(item, map);
                    continue;
                }
                if (p instanceof IComplexProperty) {
                    if (baseEntity == null) {
                        this.buildResources(val, Id, null, element, map);
                        continue;
                    }
                    Object baseVal = p.getValue(baseEntity);
                    this.buildResources(val, Id, baseVal, element, map);
                    continue;
                }
                if (!(p instanceof ICollectionProperty)) continue;
                this.buildCollectionRes((ICollectionProperty)p, currentEntityType, currentEntity, baseEntity, parentId, element, map);
            }
        }

        private Map<String, MetaLocaleSrcItem> buildSrcItemValue(ILocaleValue<?> currentObj, ILocaleValue<?> baseObj) {
            HashMap<String, MetaLocaleSrcItem> result = new HashMap<String, MetaLocaleSrcItem>();
            MetaLocaleSrcItem srcItem = null;
            if (currentObj != null) {
                Set baseKeys = new LocaleString().keySet();
                if (baseObj != null) {
                    baseKeys = baseObj.keySet();
                }
                Set cureentKeys = currentObj.keySet();
                for (String key : cureentKeys) {
                    srcItem = new MetaLocaleSrcItem();
                    srcItem.setLocaleValue(currentObj.get((Object)key).toString());
                    if (baseObj == null) {
                        srcItem.setSrcNum(this.currentNum);
                    } else if (baseKeys.contains(key) && currentObj.get((Object)key).toString().equalsIgnoreCase(baseObj.get((Object)key).toString()) && currentObj != baseObj) {
                        srcItem.setSrcNum(this.baseNum);
                    } else {
                        srcItem.setSrcNum(this.currentNum);
                    }
                    result.put(key, srcItem);
                }
            }
            return result;
        }

        private Map<String, MetaLocaleSrcItem> buildSrcItem(ISimpleProperty p, Object currentEntity) {
            HashMap<String, MetaLocaleSrcItem> result = new HashMap<String, MetaLocaleSrcItem>();
            MetaLocaleSrcItem srcItem = null;
            ILocaleValue obj = (ILocaleValue)p.getValue(currentEntity);
            if (obj != null) {
                Set cureentKeys = obj.keySet();
                for (String key : cureentKeys) {
                    srcItem = new MetaLocaleSrcItem();
                    srcItem.setLocaleValue(obj.get((Object)key).toString());
                    srcItem.setSrcNum(this.baseNum);
                    result.put(key, srcItem);
                }
            }
            return result;
        }

        private void buildCollectionRes(ICollectionProperty property, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, String parentId, AbstractElement element, Map<String, MetaLocaleItem> map) {
            Object currentValue = property.getValue(currentEntity);
            Object baseValue = null;
            if (baseEntity != null) {
                baseValue = property.getValue(baseEntity);
            }
            if (currentValue == null) {
                return;
            }
            if (baseEntity == null || baseValue == null) {
                List listValue = (List)currentValue;
                for (Object objVal : listValue) {
                    String entryId = this.generateId(objVal, parentId);
                    this.buildResources(objVal, entryId, null, element, map);
                }
            } else {
                List currentList = (List)currentValue;
                List baseList = (List)baseValue;
                for (Object objVal : currentList) {
                    Object baseVal = this.getBaseObject(baseList, objVal);
                    String entryId = this.generateId(objVal, parentId);
                    this.buildResources(objVal, entryId, baseVal, element, map);
                }
            }
        }

        public Object getBaseObject(List<?> baseList, Object curentObject) {
            if (baseList == null) {
                return null;
            }
            Object sPk = this.getPk(curentObject);
            for (Object baseObject : baseList) {
                Object tPk = this.getPk(baseObject);
                if (!tPk.equals(sPk)) continue;
                return baseObject;
            }
            return null;
        }

        private String generateId(Object obj, String parentId) {
            String pk = this.getPk(obj).toString();
            if (obj instanceof ComboItem || obj instanceof StatusItem || obj instanceof NetCtrlOperation || obj instanceof DropdownItem || obj instanceof ItemClass || obj instanceof TipLinkTitle) {
                pk = parentId + "." + pk;
            }
            return pk;
        }

        private Object getPk(Object obj) {
            ISimpleProperty pkProp = this.binder.getDataEntityType(obj).getPrimaryKey();
            if (pkProp == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", (String)"MultiLangMetadataLoad_1", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), this.binder.getDataEntityType(obj).getName()));
            }
            Object pk = pkProp.getValue(obj);
            if (pk == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b\u4e3b\u952e\u4e3a\u7a7a\u3002", (String)"MultiLangMetadataLoad_2", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), new Object[0]));
            }
            return pk;
        }

        class MetaLocaleItemDetail
        extends MetaLocaleItem {
            private Map<String, MetaLocaleSrcItem> propertyDetail;
            private String name;
            private boolean valueChange;

            MetaLocaleItemDetail() {
                this.propertyDetail = new HashMap<String, MetaLocaleSrcItem>(10);
            }

            public boolean isValueChange() {
                return this.valueChange;
            }

            public void setValueChange(boolean valueChange) {
                this.valueChange = valueChange;
            }

            public Map<String, MetaLocaleSrcItem> getPropertyDetail() {
                return this.propertyDetail;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setPropertyDetail(Map<String, MetaLocaleSrcItem> propertyDetail) {
                this.propertyDetail = propertyDetail;
            }

            private List<Map<String, String>> genResults() {
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
                HashMap<String, String> srcumMap = new HashMap<String, String>(10);
                HashMap<String, String> valueMap = new HashMap<String, String>(10);
                for (Map.Entry<String, MetaLocaleSrcItem> entity : this.getPropertyDetail().entrySet()) {
                    valueMap.put(entity.getKey(), entity.getValue().localeValue);
                    srcumMap.put(entity.getKey(), entity.getValue().srcNum);
                }
                result.add(valueMap);
                result.add(srcumMap);
                return result;
            }

            @Override
            public Map getData() {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("id", this.getId());
                map.put("propname", this.getProperty().getName());
                List<Map<String, String>> result = this.genResults();
                map.put("value", result.get(0).isEmpty() ? null : result.get(0));
                map.put("srcnum", this.getSrcNum());
                if (this.getElement() == null) {
                    map.put("srcitemkey", "");
                    map.put("itemtype", "");
                } else {
                    map.put("srcitemkey", this.getElement().getKey());
                    map.put("itemtype", this.getElement().getClass().getSimpleName());
                }
                map.put("langsrcnum", result.get(1));
                return map;
            }
        }

        class MetaLocaleSrcItem {
            private String localeValue = "";
            private String srcNum = "";

            MetaLocaleSrcItem() {
            }

            public String getLocaleValue() {
                return this.localeValue;
            }

            public void setLocaleValue(String localeValue) {
                this.localeValue = localeValue;
            }

            public String getSrcNum() {
                return this.srcNum;
            }

            public void setSrcNum(String srcNum) {
                this.srcNum = srcNum;
            }
        }

        class MetaLocaleItem {
            private String id;
            private boolean inherited;
            private Object dataEntity;
            private ISimpleProperty property;
            private AbstractElement element;
            private String srcNum;
            private int metaType;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public boolean isInherited() {
                return this.inherited;
            }

            public void setInherited(boolean value) {
                this.inherited = value;
            }

            public Object getDataEntity() {
                return this.dataEntity;
            }

            public void setDataEntity(Object currentEntity) {
                this.dataEntity = currentEntity;
            }

            public ISimpleProperty getProperty() {
                return this.property;
            }

            public void setProperty(ISimpleProperty prop) {
                this.property = prop;
            }

            public AbstractElement getElement() {
                return this.element;
            }

            public void setElement(AbstractElement element) {
                this.element = element;
            }

            public String getSrcNum() {
                return this.srcNum;
            }

            public void setSrcNum(String srcNum) {
                this.srcNum = srcNum;
            }

            public int getMetaType() {
                return this.metaType;
            }

            public void setMetaType(int metaType) {
                this.metaType = metaType;
            }

            public Map getData() {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("id", this.id);
                map.put("propname", this.property.getName());
                map.put("value", this.property.getValue(this.dataEntity));
                map.put("srcnum", this.srcNum);
                if (this.element == null) {
                    map.put("srcitemkey", "");
                    map.put("itemtype", "");
                } else {
                    map.put("srcitemkey", this.element.getKey());
                    map.put("itemtype", this.element.getClass().getSimpleName());
                }
                return map;
            }
        }
    }
}

