/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.service.metadata.util.MultiParam;
import kd.bos.service.metadata.util.MultilingualTranslationUtil;

public class MultiLangMetadataUpdate
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataUpdate.class);
    private static final String ENTITY = "entity";
    private MetadataSerializer serializer;
    private List<String> tlangs;
    private String slang = "zh_CN";
    private String curFormId = "";
    private boolean ignoreDirtyLocale = true;
    private Boolean cancelRebuild = Boolean.FALSE;
    private Long version = 0L;

    private AbstractMetadata convertTo(AbstractMetadata meta, List<Map<String, Map<String, Object>>> localeItemMap) {
        String modelType = meta.getModelType();
        this.serializer = new MetadataSerializer(modelType);
        this.restoreLang(meta, localeItemMap);
        return meta;
    }

    public ApiResult doCustomService(Map<String, Object> localeDataMap) {
        try {
            String formId = (String)localeDataMap.get("id");
            this.tlangs = (List)localeDataMap.get("tlangs");
            this.cancelRebuild = Boolean.parseBoolean(String.valueOf(localeDataMap.get("cancelRebuild")));
            this.ignoreDirtyLocale = Boolean.parseBoolean(String.valueOf(localeDataMap.getOrDefault("ignoreDirtyLocale", "true")));
            if (localeDataMap.get("version") != null) {
                this.version = Long.parseLong(String.valueOf(localeDataMap.get("version")));
            }
            Boolean isEncrypt = Boolean.valueOf(String.valueOf(localeDataMap.get("isEncrypt")));
            if (this.tlangs == null || this.tlangs.isEmpty()) {
                this.tlangs = new ArrayList<String>();
                this.tlangs.add("en_US");
            }
            this.curFormId = formId;
            String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
            log.info("begin update localevalue , formid = " + formId + ",data :" + SerializationUtils.toJsonString(localeDataMap));
            List list = null;
            list = isEncrypt != false ? (List)SerializationUtils.fromJsonString((String)GzipUtils.uncompress(localeDataMap.get("localeList").toString(), "utf-8"), List.class) : (List)localeDataMap.get("localeList");
            HashMap<String, Object> localeItemMap = new HashMap<String, Object>();
            for (Map locales : list) {
                Map localeItems = (Map)locales.get("data");
                if (locales.get("type").toString().equals("form")) {
                    localeItemMap.put("form", localeItems);
                    continue;
                }
                localeItemMap.put(ENTITY, localeItems);
            }
            this.updateLocaleMeta(id, localeItemMap);
        }
        catch (Exception e) {
            log.error("apply localevalue fail, formId : {}, data : {}, \u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25\uff1a{}", new Object[]{this.curFormId, SerializationUtils.toJsonString(localeDataMap), e.getMessage()});
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25%s", (String)"MultiLangMetadataUpdate_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u6210\u529f", (String)"MultiLangMetadataUpdate_1", (String)"bos-mservice-form", (Object[])new Object[0]));
    }

    private void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), (Object)metadata, localeItems);
        writer.setLoaceValue(this.tlangs);
        for (String tlang : this.tlangs) {
            writer.setNullLoaceValue(tlang, this.slang);
        }
    }

    private AbstractMetadata readMeta(String id, MetaCategory category) {
        return MultilingualTranslationUtil.readMeta(id, category, this.ignoreDirtyLocale);
    }

    public void updateLocaleMeta(String id, Map<String, Object> localeItemMap) {
        block15: {
            AbstractMetadata abstractMetadata;
            block14: {
                Map itemdatas;
                ArrayList<Map<String, Map<String, Object>>> items;
                abstractMetadata = this.readMeta(id, MetaCategory.Form);
                if (!(abstractMetadata instanceof FormMetadata)) break block14;
                FormMetadata formMetaData = (FormMetadata)abstractMetadata;
                if (StringUtils.isNotBlank((CharSequence)MetadataDao.getEntityNumberById((String)id))) {
                    EntityMetadata entityMetaData = (EntityMetadata)this.readMeta(id, MetaCategory.Entity);
                    formMetaData.bindEntityMetadata(entityMetaData);
                }
                if (localeItemMap.get("form") != null) {
                    items = new ArrayList<Map<String, Map<String, Object>>>();
                    itemdatas = (Map)localeItemMap.get("form");
                    this.buildLocaleItem(itemdatas, items);
                    this.convertTo((AbstractMetadata)formMetaData, items);
                }
                if (formMetaData.getId().equals(formMetaData.getEntityId()) && localeItemMap.get(ENTITY) != null && formMetaData.getEntityMetadata() != null) {
                    items = new ArrayList();
                    itemdatas = (Map)localeItemMap.get(ENTITY);
                    this.buildLocaleItem(itemdatas, items);
                    this.convertTo((AbstractMetadata)formMetaData.getEntityMetadata(), items);
                }
                MultiParam param = new MultiParam(this.version, this.tlangs);
                MultilingualTranslationUtil.LocaleMetadataWriter writer = MultilingualTranslationUtil.getLocaleMetadataWriter(param, formMetaData.getModelType());
                if (!this.cancelRebuild.booleanValue()) {
                    if (formMetaData.getEntityMetadata() != null) {
                        writer.save(new AbstractMetadata[]{formMetaData, formMetaData.getEntityMetadata()});
                    } else {
                        writer.save(new AbstractMetadata[]{formMetaData});
                    }
                } else {
                    ArrayList designeMetas = new ArrayList(2);
                    if (formMetaData.getEntityMetadata() != null) {
                        designeMetas.addAll(writer.convertToDesignMeta(new AbstractMetadata[]{formMetaData, formMetaData.getEntityMetadata()}));
                    } else {
                        designeMetas.addAll(writer.convertToDesignMeta(new AbstractMetadata[]{formMetaData}));
                    }
                    for (AbstractDesignMeta dmeta : designeMetas) {
                        this.saveDesignToDB(writer, dmeta);
                    }
                }
                break block15;
            }
            if (!(abstractMetadata instanceof PrintMetadata)) break block15;
            PrintMetadata printMetaData = (PrintMetadata)abstractMetadata;
            if (localeItemMap.get("form") != null) {
                ArrayList<Map<String, Map<String, Object>>> items = new ArrayList<Map<String, Map<String, Object>>>();
                Map itemdatas = (Map)localeItemMap.get("form");
                this.buildLocaleItem(itemdatas, items);
                this.convertTo((AbstractMetadata)printMetaData, items);
            }
            MetadataWriter writer = new MetadataWriter(printMetaData.getModelType());
            if (!this.cancelRebuild.booleanValue()) {
                writer.save(new AbstractMetadata[]{printMetaData});
            } else {
                List designeMetas = writer.convertToDesignMeta(new AbstractMetadata[]{printMetaData});
                for (AbstractDesignMeta dmeta : designeMetas) {
                    this.saveDesignToDB(writer, dmeta);
                }
            }
        }
    }

    private void saveDesignToDB(MetadataWriter writer, AbstractDesignMeta dmeta) {
        if (dmeta instanceof DesignMetaL) {
            for (String lan : this.tlangs) {
                if (!lan.equalsIgnoreCase(((DesignMetaL)dmeta).getLocaleId())) continue;
                MetadataWriter.delFormMetadataLang((DesignMetaL)((DesignMetaL)dmeta));
                IDataEntityType metadataType = OrmUtils.getDataEntityType(dmeta.getClass());
                BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])new Object[]{dmeta});
            }
        }
    }

    private void buildLocaleItem(Map<String, Map<String, Object>> itemdatas, List<Map<String, Map<String, Object>>> items) {
        for (Map.Entry<String, Map<String, Object>> item : itemdatas.entrySet()) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            map.put(item.getKey(), item.getValue());
            items.add(map);
        }
    }
}

