/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

final class TableUseRecord {
    private static final Log log = LogFactory.getLog(TableUseRecord.class);
    private static final String SQL_READER = "select ftableid from t_botp_tableuserecord where fentitynumber = ? and fentrykey = ? order by ffirstusetime desc";
    private static final String SQL_INSERT = "insert into t_botp_tableuserecord (fid, fentitynumber, fentrykey, ftableid, ffirstusetime) values (?,?,?,?,?)";

    private TableUseRecord() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getTableIdByHistory(String entityNumber, String entryKey, List<Long> tableids) {
        try (TXHandle h = TX.notSupported((String)(TableDefine.class.getName() + ".getTableIdByHistory"));){
            if (tableids == null || tableids.isEmpty()) {
                Long l = null;
                return l;
            }
            List<Long> historyTableIds = TableUseRecord.loadTableUseRecords(entityNumber, entryKey);
            boolean existHistory = false;
            Long tableId = null;
            for (Long historyTableId : historyTableIds) {
                if (!tableids.contains(historyTableId)) continue;
                tableId = historyTableId;
                existHistory = true;
                break;
            }
            if (tableId == null) {
                tableId = tableids.get(0);
            }
            if (!existHistory && tableId != null) {
                TableUseRecord.insertTableUseRecord(entityNumber, entryKey, tableId);
            }
            Iterator<Long> iterator = tableId;
            return iterator;
        }
        catch (RuntimeException ex) {
            log.error((Throwable)ex);
            if (tableids == null) return null;
            if (tableids.isEmpty()) return null;
            return tableids.get(0);
        }
    }

    private static List<Long> loadTableUseRecords(String entityNumber, String entryKey) {
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FEntityNumber", 12, (Object)entityNumber), new SqlParameter(":FEntryKey", 12, (Object)entryKey)};
        ResultSetHandler action = rs -> {
            ArrayList<Long> list = new ArrayList<Long>(4);
            while (rs.next()) {
                Long tableId = rs.getLong("ftableid");
                if (tableId == null || Long.compare(0L, tableId) == 0) continue;
                list.add(tableId);
            }
            return list;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_READER, (Object[])parameters, (ResultSetHandler)action);
    }

    private static void insertTableUseRecord(String entityNumber, String entryKey, Long tableId) {
        try (TXHandle h = TX.requiresNew((String)(TableUseRecord.class.getName() + ".insertTableUseRecord"));){
            try {
                Object[] parameters = new Object[]{new SqlParameter("FID", -5, (Object)DB.genGlobalLongId()), new SqlParameter(":FEntityNumber", 12, (Object)entityNumber), new SqlParameter(":FEntryKey", 12, (Object)entryKey), new SqlParameter(":FTableId", -5, (Object)tableId), new SqlParameter(":FTableId", 91, (Object)KDDateUtils.now())};
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
                paramsList.add(parameters);
                DB.executeBatch((DBRoute)DBRoute.meta, (String)SQL_INSERT, paramsList);
            }
            catch (RuntimeException ex) {
                h.markRollback();
                throw ex;
            }
        }
    }
}

