/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.design;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.service.CoreLicenseService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

class DomainModelTypeRewriteHandler {
    private static final String SHOW_HIDDEN_PROPERTY_KEY = "bos_domainmodel_showhiddenproperty";
    private static final String SHOW_TABLAYOUT_PROPERTY_KEY = "bos_tablayout_enable";

    DomainModelTypeRewriteHandler() {
    }

    private static Map<String, String> getCustomParameterMap() {
        CustomParam customParam = new CustomParam();
        HashSet<String> keys = new HashSet<String>();
        keys.add(SHOW_HIDDEN_PROPERTY_KEY);
        keys.add(SHOW_TABLAYOUT_PROPERTY_KEY);
        customParam.setSearchKeySet(keys);
        return SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
    }

    private static boolean getShowHiddenPropertyConfig(Map<String, String> parameterMap) {
        return Boolean.TRUE.toString().equals(parameterMap.get(SHOW_HIDDEN_PROPERTY_KEY));
    }

    private static boolean getTablayoutPropertyConfig(Map<String, String> parameterMap) {
        return Boolean.TRUE.toString().equals(parameterMap.get(SHOW_TABLAYOUT_PROPERTY_KEY));
    }

    static void rewriteDomainModelType(DomainModelType modelType) {
        if (modelType == null || modelType.getElementTypes() == null) {
            return;
        }
        Map<String, String> parameterMap = DomainModelTypeRewriteHandler.getCustomParameterMap();
        DomainModelTypeRewriteHandler.rewriteHiddenProperty(modelType, parameterMap);
        DomainModelTypeRewriteHandler.rewriteTablayoutProperty(modelType, parameterMap);
        DomainModelTypeRewriteHandler.rewriteVoucherEditorProperty(modelType);
    }

    private static void rewriteHiddenProperty(DomainModelType modelType, Map<String, String> parameterMap) {
        if (!DomainModelTypeRewriteHandler.getShowHiddenPropertyConfig(parameterMap)) {
            return;
        }
        for (Map.Entry stringElementTypeEntry : modelType.getElementTypes().entrySet()) {
            if (stringElementTypeEntry.getValue() == null) continue;
            for (Property property : ((ElementType)stringElementTypeEntry.getValue()).getProperties()) {
                if (!"Hidden".equalsIgnoreCase(property.getPropertyName())) continue;
                String actionConfig = "{\"items\":[{\"condition\":\"is('Hidden',true)\",\"action\":{\"name\":\"hideproperty\",\"args\":[\"Width\",\"Height\",\"Lock\",\"Visible\",\"Style\"]}}]}";
                Map action = (Map)SerializationUtils.fromJsonString((String)actionConfig, Map.class);
                property.setAction(action);
            }
        }
    }

    private static void rewriteTablayoutProperty(DomainModelType modelType, Map<String, String> parameterMap) {
        try {
            if (DomainModelTypeRewriteHandler.getTablayoutPropertyConfig(parameterMap)) {
                return;
            }
            if (DomainModelTypeRewriteHandler.isXK()) {
                // empty if block
            }
            for (Map.Entry stringElementTypeEntry : modelType.getElementTypes().entrySet()) {
                if (stringElementTypeEntry.getValue() == null) continue;
                for (Property property : ((ElementType)stringElementTypeEntry.getValue()).getProperties()) {
                    if (!"TabLayout".equalsIgnoreCase(property.getPropertyName())) continue;
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(10);
                    map.put("hide", true);
                    property.setHide(map);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void rewriteVoucherEditorProperty(DomainModelType modelType) {
        if (Lang.zh_CN == Lang.get() || Lang.zh_TW == Lang.get()) {
            return;
        }
        for (Map.Entry elementTypeEntry : modelType.getElementTypes().entrySet()) {
            if (elementTypeEntry.getValue() == null) continue;
            for (Property property : ((ElementType)elementTypeEntry.getValue()).getProperties()) {
                if (!"VoucherEditor".equalsIgnoreCase(property.getPropertyName())) continue;
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                map.put("hide", true);
                property.setHide(map);
            }
        }
    }

    private static boolean isXK() {
        int modelType = CoreLicenseService.getModelType();
        return 2 == modelType || 4 == modelType;
    }
}

