/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.encrypt.EncrypterFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GzipUtils {
    private GzipUtils() {
    }

    public static String compress(String str, String inEncoding) throws IOException {
        return GzipUtils.compress(str, inEncoding, true);
    }

    public static String compress(String str, String inEncoding, boolean isHighEncrypt) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(str.getBytes(inEncoding));
        }
        String result = out.toString("ISO-8859-1");
        if (isHighEncrypt) {
            result = EncrypterFactory.getEncrypter().encode(result);
        }
        return result;
    }

    public static String uncompress(String str, String outEncoding) throws IOException {
        return GzipUtils.uncompress(str, outEncoding, true);
    }

    public static String uncompress(String str, String outEncoding, boolean isHighEncrypt) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (isHighEncrypt) {
            str = EncrypterFactory.getEncrypter().decode(str);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(StandardCharsets.ISO_8859_1));
        try (GZIPInputStream gunzip = new GZIPInputStream(in);){
            int n;
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        return out.toString(outEncoding);
    }
}

