/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.util.MultiParam;
import org.dom4j.Element;

public class MultilingualTranslationUtil {
    public static AbstractMetadata readMeta(String id, MetaCategory metaCategory, boolean ignoreDirtyLocale) {
        if (ignoreDirtyLocale) {
            return new LocaleMetadataReader().readMeta(id, metaCategory);
        }
        return MetadataDao.readMeta((String)id, (MetaCategory)metaCategory);
    }

    public static LocaleMetadataWriter getLocaleMetadataWriter(MultiParam param, String modelTypeId) {
        LocaleMetadataWriter localeMetadataWriter = new LocaleMetadataWriter(modelTypeId);
        localeMetadataWriter.setParam(param);
        return localeMetadataWriter;
    }

    static class LocaleMetadataWriter
    extends MetadataWriter {
        private MultiParam param;

        public LocaleMetadataWriter() {
        }

        public LocaleMetadataWriter(String modelTypeId) {
            super(modelTypeId);
        }

        public List<AbstractDesignMeta> convertToDesignMeta(AbstractMetadata ... metadatas) {
            ArrayList<AbstractDesignMeta> dms = new ArrayList<AbstractDesignMeta>(10);
            for (AbstractMetadata metadata : metadatas) {
                AbstractMetadata baseMetadata = null;
                if (StringUtils.isNotBlank((CharSequence)metadata.getParentId())) {
                    baseMetadata = this.readBaseMetadata(metadata);
                    if ("2".equals(metadata.getDevType()) && metadata instanceof EntityMetadata) {
                        String dbRoute = ((EntityMetadata)baseMetadata).getDBRouteKey();
                        ((EntityMetadata)metadata).getRootEntity().setdbRoute(dbRoute);
                    }
                }
                this.plugIn.clearRootChildenParentId(metadata);
                if (baseMetadata != null) {
                    this.plugIn.clearRootChildenParentId(baseMetadata);
                }
                this.serializer.getBinder().setLCId("zh_CN");
                String formXml = this.serializer.buildDiffXml((Object)metadata, (Object)baseMetadata, false);
                DesignMeta designMeta = metadata.convertToDesignMeta(formXml);
                dms.add((AbstractDesignMeta)designMeta);
                this.plugIn.setDesignMeta(metadata, designMeta);
                AbstractMetadata formLangBase = (AbstractMetadata)this.serializer.deserializeFromXml(formXml, (Object)baseMetadata);
                this.plugIn.clearRootChildenParentId(formLangBase);
                IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
                List languages = inteService.getEnabledLang();
                List<String> supportLanguages = new ArrayList<String>();
                if (null != languages && !languages.isEmpty()) {
                    for (EnabledLang lang : languages) {
                        if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                        supportLanguages.add(lang.getNumber());
                    }
                }
                if (null == supportLanguages || supportLanguages.isEmpty()) {
                    supportLanguages = Arrays.asList("zh_CN", "zh_TW", "en_US");
                }
                for (String language : supportLanguages) {
                    this.serializer.getBinder().setLCId(language);
                    String formLangXml = this.serializer.buildDiffXml((Object)metadata, (Object)formLangBase, true);
                    DesignMetaL designMetaL = metadata.convertToDesignMetaL(language, formLangXml);
                    if (designMetaL instanceof DesignFormMetaL && this.getParam() != null && this.getParam().getTlangs().contains(language) && this.getParam().getVersion() != 0L) {
                        ((DesignFormMetaL)designMetaL).setVersion(this.getParam().getVersion());
                    }
                    dms.add((AbstractDesignMeta)designMetaL);
                }
            }
            return dms;
        }

        public MultiParam getParam() {
            return this.param;
        }

        public void setParam(MultiParam param) {
            this.param = param;
        }
    }

    static class LocaleMetadataReader
    extends MetadataReader {
        LocaleMetadataReader() {
        }

        protected DcBinder getBinder() {
            DomainModelType domainModel = DomainModelType.getDomainModelType((String)this.getModelType(), (boolean)false);
            return new LocaleDelegateDcBinder(domainModel);
        }
    }

    static class LocaleDelegateDcBinder
    extends DomainModelBinder {
        private String mainLcid = null;
        private transient Set<String> cachedCollectPropPaths = new HashSet<String>(10);

        public LocaleDelegateDcBinder(DomainModelType type) {
            super(type);
        }

        private String getMainLcid() {
            if (this.mainLcid == null) {
                this.mainLcid = this.getLCId();
            }
            return this.mainLcid;
        }

        public Object createInstance(IDataEntityType dt) {
            if (!this.shouldCreateInstance(dt)) {
                return null;
            }
            return super.createInstance(dt);
        }

        public boolean readSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
            if (this.isLocaleDeserialization() && entity == null) {
                return true;
            }
            return super.readSimpleProperty(property, propElement, entity);
        }

        private boolean isLocaleDeserialization() {
            return !StringUtils.equalsIgnoreCase((CharSequence)this.getMainLcid(), (CharSequence)this.getLCId());
        }

        private boolean shouldCreateInstance(IDataEntityType dt) {
            if (!this.isLocaleDeserialization()) {
                return true;
            }
            if (dt == null || dt.getParent() == null) {
                return false;
            }
            if (this.cachedCollectPropPaths.contains(dt.getName())) {
                return true;
            }
            List collectProps = dt.getParent().getProperties().getCollectionProperties(true);
            for (ICollectionProperty collectProp : collectProps) {
                if (!StringUtils.equals((CharSequence)collectProp.getItemType().getName(), (CharSequence)dt.getName())) continue;
                this.cachedCollectPropPaths.add(this.getDTFullPath(dt));
                return true;
            }
            return false;
        }

        private String getDTFullPath(IDataEntityType dt) {
            if (dt == null) {
                return null;
            }
            String path = dt.getName();
            for (IDataEntityType parent = dt.getParent(); parent != null; parent = parent.getParent()) {
                path = parent.getName() + "." + path;
            }
            return path;
        }
    }
}

